"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { return function () { var Super = _getPrototypeOf(Derived), result; if (_isNativeReflectConstruct()) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var __importStar = void 0 && (void 0).__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) {
    if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
  }
  result["default"] = mod;
  return result;
};

var __importDefault = void 0 && (void 0).__importDefault || function (mod) {
  return mod && mod.__esModule ? mod : {
    "default": mod
  };
};

Object.defineProperty(exports, "__esModule", {
  value: true
});

var React = __importStar(require("react"));

var react_dom_1 = __importDefault(require("react-dom"));

var warning_1 = __importDefault(require("rc-util/lib/warning"));

var mini_store_1 = require("mini-store");

var react_lifecycles_compat_1 = require("react-lifecycles-compat");

var classnames_1 = __importDefault(require("classnames"));

var TableCell_1 = __importDefault(require("./TableCell"));

var TableRow = /*#__PURE__*/function (_React$Component) {
  _inherits(TableRow, _React$Component);

  var _super = _createSuper(TableRow);

  function TableRow() {
    var _this;

    _classCallCheck(this, TableRow);

    _this = _super.apply(this, arguments);
    _this.state = {};

    _this.onTriggerEvent = function (rowPropFunc, legacyFunc, additionalFunc) {
      var _this$props = _this.props,
          record = _this$props.record,
          index = _this$props.index;
      return function () {
        // Additional function like trigger `this.onHover` to handle self logic
        if (additionalFunc) {
          additionalFunc();
        } // [Legacy] Some legacy function like `onRowClick`.


        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
          args[_key] = arguments[_key];
        }

        var event = args[0];

        if (legacyFunc) {
          legacyFunc(record, index, event);
        } // Pass to the function from `onRow`


        if (rowPropFunc) {
          rowPropFunc.apply(void 0, args);
        }
      };
    };

    _this.onMouseEnter = function () {
      var _this$props2 = _this.props,
          onHover = _this$props2.onHover,
          rowKey = _this$props2.rowKey;
      onHover(true, rowKey);
    };

    _this.onMouseLeave = function () {
      var _this$props3 = _this.props,
          onHover = _this$props3.onHover,
          rowKey = _this$props3.rowKey;
      onHover(false, rowKey);
    };

    return _this;
  }

  _createClass(TableRow, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      if (this.state.shouldRender) {
        this.saveRowRef();
      }
    }
  }, {
    key: "shouldComponentUpdate",
    value: function shouldComponentUpdate(nextProps) {
      return !!(this.props.visible || nextProps.visible);
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      if (this.state.shouldRender && !this.rowRef) {
        this.saveRowRef();
      }
    }
  }, {
    key: "setExpandedRowHeight",
    value: function setExpandedRowHeight() {
      var _this$props4 = this.props,
          store = _this$props4.store,
          rowKey = _this$props4.rowKey;

      var _store$getState = store.getState(),
          expandedRowsHeight = _store$getState.expandedRowsHeight;

      var _this$rowRef$getBound = this.rowRef.getBoundingClientRect(),
          height = _this$rowRef$getBound.height;

      expandedRowsHeight = _objectSpread({}, expandedRowsHeight, _defineProperty({}, rowKey, height));
      store.setState({
        expandedRowsHeight: expandedRowsHeight
      });
    }
  }, {
    key: "setRowHeight",
    value: function setRowHeight() {
      var _this$props5 = this.props,
          store = _this$props5.store,
          rowKey = _this$props5.rowKey;

      var _store$getState2 = store.getState(),
          fixedColumnsBodyRowsHeight = _store$getState2.fixedColumnsBodyRowsHeight;

      var _this$rowRef$getBound2 = this.rowRef.getBoundingClientRect(),
          height = _this$rowRef$getBound2.height;

      store.setState({
        fixedColumnsBodyRowsHeight: _objectSpread({}, fixedColumnsBodyRowsHeight, _defineProperty({}, rowKey, height))
      });
    }
  }, {
    key: "getStyle",
    value: function getStyle() {
      var _this$props6 = this.props,
          height = _this$props6.height,
          visible = _this$props6.visible;

      if (height && height !== this.style.height) {
        this.style = _objectSpread({}, this.style, {
          height: height
        });
      }

      if (!visible && !this.style.display) {
        this.style = _objectSpread({}, this.style, {
          display: 'none'
        });
      }

      return this.style;
    }
  }, {
    key: "saveRowRef",
    value: function saveRowRef() {
      this.rowRef = react_dom_1.default.findDOMNode(this);
      var _this$props7 = this.props,
          isAnyColumnsFixed = _this$props7.isAnyColumnsFixed,
          fixed = _this$props7.fixed,
          expandedRow = _this$props7.expandedRow,
          ancestorKeys = _this$props7.ancestorKeys;

      if (!isAnyColumnsFixed || !this.rowRef) {
        return;
      }

      if (!fixed && expandedRow) {
        this.setExpandedRowHeight();
      }

      if (!fixed && ancestorKeys.length >= 0) {
        this.setRowHeight();
      }
    }
  }, {
    key: "render",
    value: function render() {
      if (!this.state.shouldRender) {
        return null;
      }

      var _this$props8 = this.props,
          prefixCls = _this$props8.prefixCls,
          columns = _this$props8.columns,
          record = _this$props8.record,
          rowKey = _this$props8.rowKey,
          index = _this$props8.index,
          onRow = _this$props8.onRow,
          indent = _this$props8.indent,
          indentSize = _this$props8.indentSize,
          hovered = _this$props8.hovered,
          height = _this$props8.height,
          visible = _this$props8.visible,
          components = _this$props8.components,
          hasExpandIcon = _this$props8.hasExpandIcon,
          renderExpandIcon = _this$props8.renderExpandIcon,
          renderExpandIconCell = _this$props8.renderExpandIconCell,
          onRowClick = _this$props8.onRowClick,
          onRowDoubleClick = _this$props8.onRowDoubleClick,
          onRowMouseEnter = _this$props8.onRowMouseEnter,
          onRowMouseLeave = _this$props8.onRowMouseLeave,
          onRowContextMenu = _this$props8.onRowContextMenu;
      var BodyRow = components.body.row;
      var BodyCell = components.body.cell;
      var className = this.props.className;

      if (hovered) {
        className += " ".concat(prefixCls, "-hover");
      }

      var cells = [];
      renderExpandIconCell(cells);

      for (var i = 0; i < columns.length; i += 1) {
        var column = columns[i];
        warning_1.default(column.onCellClick === undefined, 'column[onCellClick] is deprecated, please use column[onCell] instead.');
        cells.push(React.createElement(TableCell_1.default, {
          prefixCls: prefixCls,
          record: record,
          indentSize: indentSize,
          indent: indent,
          index: index,
          column: column,
          key: column.key || column.dataIndex,
          expandIcon: hasExpandIcon(i) && renderExpandIcon(),
          component: BodyCell
        }));
      }

      var _ref = onRow(record, index) || {},
          customClassName = _ref.className,
          customStyle = _ref.style,
          rowProps = _objectWithoutProperties(_ref, ["className", "style"]);

      var style = {
        height: height
      };

      if (!visible) {
        style.display = 'none';
      }

      style = _objectSpread({}, style, {}, customStyle);
      var rowClassName = classnames_1.default(prefixCls, className, "".concat(prefixCls, "-level-").concat(indent), customClassName);
      return React.createElement(BodyRow, Object.assign({}, rowProps, {
        onClick: this.onTriggerEvent(rowProps.onClick, onRowClick),
        onDoubleClick: this.onTriggerEvent(rowProps.onDoubleClick, onRowDoubleClick),
        onMouseEnter: this.onTriggerEvent(rowProps.onMouseEnter, onRowMouseEnter, this.onMouseEnter),
        onMouseLeave: this.onTriggerEvent(rowProps.onMouseLeave, onRowMouseLeave, this.onMouseLeave),
        onContextMenu: this.onTriggerEvent(rowProps.onContextMenu, onRowContextMenu),
        className: rowClassName,
        style: style,
        "data-row-key": rowKey
      }), cells);
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps, prevState) {
      if (prevState.visible || !prevState.visible && nextProps.visible) {
        return {
          shouldRender: true,
          visible: nextProps.visible
        };
      }

      return {
        visible: nextProps.visible
      };
    }
  }]);

  return TableRow;
}(React.Component);

TableRow.defaultProps = {
  onRow: function onRow() {},
  onHover: function onHover() {},
  hasExpandIcon: function hasExpandIcon() {},
  renderExpandIcon: function renderExpandIcon() {},
  renderExpandIconCell: function renderExpandIconCell() {}
};

function getRowHeight(state, props) {
  var expandedRowsHeight = state.expandedRowsHeight,
      fixedColumnsBodyRowsHeight = state.fixedColumnsBodyRowsHeight;
  var fixed = props.fixed,
      rowKey = props.rowKey;

  if (!fixed) {
    return null;
  }

  if (expandedRowsHeight[rowKey]) {
    return expandedRowsHeight[rowKey];
  }

  if (fixedColumnsBodyRowsHeight[rowKey]) {
    return fixedColumnsBodyRowsHeight[rowKey];
  }

  return null;
}

react_lifecycles_compat_1.polyfill(TableRow);
exports.default = mini_store_1.connect(function (state, props) {
  var currentHoverKey = state.currentHoverKey,
      _state$expandedRowKey = state.expandedRowKeys,
      expandedRowKeys = _state$expandedRowKey === void 0 ? [] : _state$expandedRowKey;
  var rowKey = props.rowKey,
      ancestorKeys = props.ancestorKeys;
  var visible = ancestorKeys.length === 0 || ancestorKeys.every(function (k) {
    return expandedRowKeys.includes(k);
  });
  return {
    visible: visible,
    hovered: currentHoverKey === rowKey,
    height: getRowHeight(state, props)
  };
})(TableRow);