"use strict";

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var __importStar = void 0 && (void 0).__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) {
    if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
  }
  result["default"] = mod;
  return result;
};

var __importDefault = void 0 && (void 0).__importDefault || function (mod) {
  return mod && mod.__esModule ? mod : {
    "default": mod
  };
};

Object.defineProperty(exports, "__esModule", {
  value: true
});

var React = __importStar(require("react"));

var PropTypes = __importStar(require("prop-types"));

var classnames_1 = __importDefault(require("classnames"));

var utils_1 = require("./utils");

var BaseTable_1 = __importDefault(require("./BaseTable"));

function HeadTable(props, _ref) {
  var table = _ref.table;
  var _table$props = table.props,
      prefixCls = _table$props.prefixCls,
      scroll = _table$props.scroll,
      showHeader = _table$props.showHeader;
  var columns = props.columns,
      fixed = props.fixed,
      tableClassName = props.tableClassName,
      handleBodyScrollLeft = props.handleBodyScrollLeft,
      expander = props.expander;
  var saveRef = table.saveRef;
  var useFixedHeader = table.props.useFixedHeader;
  var headStyle = {};
  var scrollbarWidth = utils_1.measureScrollbar({
    direction: 'vertical'
  });

  if (scroll.y) {
    useFixedHeader = true; // https://github.com/ant-design/ant-design/issues/17051

    var scrollbarWidthOfHeader = utils_1.measureScrollbar({
      direction: 'horizontal',
      prefixCls: prefixCls
    }); // Add negative margin bottom for scroll bar overflow bug

    if (scrollbarWidthOfHeader > 0 && !fixed) {
      headStyle.marginBottom = "-".concat(scrollbarWidthOfHeader, "px");
      headStyle.paddingBottom = '0px'; // https://github.com/ant-design/ant-design/pull/19986

      headStyle.minWidth = "".concat(scrollbarWidth, "px"); // https://github.com/ant-design/ant-design/issues/17051

      headStyle.overflowX = 'scroll';
      headStyle.overflowY = scrollbarWidth === 0 ? 'hidden' : 'scroll';
    }
  }

  if (!useFixedHeader || !showHeader) {
    return null;
  }

  return React.createElement("div", {
    key: "headTable",
    ref: fixed ? null : saveRef('headTable'),
    className: classnames_1.default("".concat(prefixCls, "-header"), _defineProperty({}, "".concat(prefixCls, "-hide-scrollbar"), scrollbarWidth > 0)),
    style: headStyle,
    onScroll: handleBodyScrollLeft
  }, React.createElement(BaseTable_1.default, {
    tableClassName: tableClassName,
    hasHead: true,
    hasBody: false,
    fixed: fixed,
    columns: columns,
    expander: expander
  }));
}

exports.default = HeadTable;
HeadTable.contextTypes = {
  table: PropTypes.any
};