"use strict";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var __importStar = void 0 && (void 0).__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) {
    if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
  }
  result["default"] = mod;
  return result;
};

var __importDefault = void 0 && (void 0).__importDefault || function (mod) {
  return mod && mod.__esModule ? mod : {
    "default": mod
  };
};

Object.defineProperty(exports, "__esModule", {
  value: true
});

var React = __importStar(require("react"));

var PropTypes = __importStar(require("prop-types"));

var utils_1 = require("./utils");

var BaseTable_1 = __importDefault(require("./BaseTable"));

function BodyTable(props, _ref) {
  var table = _ref.table;
  var _table$props = table.props,
      prefixCls = _table$props.prefixCls,
      scroll = _table$props.scroll;
  var columns = props.columns,
      fixed = props.fixed,
      tableClassName = props.tableClassName,
      getRowKey = props.getRowKey,
      handleBodyScroll = props.handleBodyScroll,
      handleWheel = props.handleWheel,
      expander = props.expander,
      isAnyColumnsFixed = props.isAnyColumnsFixed;
  var saveRef = table.saveRef;
  var useFixedHeader = table.props.useFixedHeader;

  var bodyStyle = _objectSpread({}, table.props.bodyStyle);

  var innerBodyStyle = {};

  if (scroll.x || fixed) {
    bodyStyle.overflowX = bodyStyle.overflowX || 'scroll'; // Fix weird webkit render bug
    // https://github.com/ant-design/ant-design/issues/7783

    bodyStyle.WebkitTransform = 'translate3d (0, 0, 0)';
  }

  if (scroll.y) {
    // maxHeight will make fixed-Table scrolling not working
    // so we only set maxHeight to body-Table here
    if (fixed) {
      innerBodyStyle.maxHeight = bodyStyle.maxHeight || scroll.y;
      innerBodyStyle.overflowY = bodyStyle.overflowY || 'scroll';
    } else {
      bodyStyle.maxHeight = bodyStyle.maxHeight || scroll.y;
    }

    bodyStyle.overflowY = bodyStyle.overflowY || 'scroll';
    useFixedHeader = true; // Add negative margin bottom for scroll bar overflow bug

    var scrollbarWidth = utils_1.measureScrollbar({
      direction: 'vertical'
    });

    if (scrollbarWidth > 0 && fixed) {
      bodyStyle.marginBottom = "-".concat(scrollbarWidth, "px");
      bodyStyle.paddingBottom = '0px';
    }
  }

  var baseTable = React.createElement(BaseTable_1.default, {
    tableClassName: tableClassName,
    hasHead: !useFixedHeader,
    hasBody: true,
    fixed: fixed,
    columns: columns,
    expander: expander,
    getRowKey: getRowKey,
    isAnyColumnsFixed: isAnyColumnsFixed
  });

  if (fixed && columns.length) {
    var refName;

    if (columns[0].fixed === 'left' || columns[0].fixed === true) {
      refName = 'fixedColumnsBodyLeft';
    } else if (columns[0].fixed === 'right') {
      refName = 'fixedColumnsBodyRight';
    }

    delete bodyStyle.overflowX;
    delete bodyStyle.overflowY;
    return React.createElement("div", {
      key: "bodyTable",
      className: "".concat(prefixCls, "-body-outer"),
      style: _objectSpread({}, bodyStyle)
    }, React.createElement("div", {
      className: "".concat(prefixCls, "-body-inner"),
      style: innerBodyStyle,
      ref: saveRef(refName),
      onWheel: handleWheel,
      onScroll: handleBodyScroll
    }, baseTable));
  } // Should provides `tabIndex` if use scroll to enable keyboard scroll


  var useTabIndex = scroll && (scroll.x || scroll.y);
  return React.createElement("div", {
    tabIndex: useTabIndex ? -1 : undefined,
    key: "bodyTable",
    className: "".concat(prefixCls, "-body"),
    style: bodyStyle,
    ref: saveRef('bodyTable'),
    onWheel: handleWheel,
    onScroll: handleBodyScroll
  }, baseTable);
}

exports.default = BodyTable;
BodyTable.contextTypes = {
  table: PropTypes.any
};