import * as React from 'react';
import * as PropTypes from 'prop-types';
import ColumnManager from './ColumnManager';
import ColumnGroup from './ColumnGroup';
import { ExpandableTableProps } from './ExpandableTable';
import { ColumnType, GetRowKey, GetComponentProps, LegacyFunction, TableComponents, TableStore, DefaultValueType, ScrollPosition, Expander } from './interface';
export interface TableProps<ValueType> extends Omit<ExpandableTableProps<ValueType>, 'prefixCls' | 'children'> {
    data?: ValueType[];
    useFixedHeader?: boolean;
    columns?: ColumnType[];
    prefixCls?: string;
    bodyStyle?: React.CSSProperties;
    className?: string;
    style?: React.CSSProperties;
    rowKey?: string | GetRowKey<ValueType>;
    rowClassName?: string | ((record: ValueType, index: number, indent: number) => string);
    onRow?: GetComponentProps<ValueType>;
    onHeaderRow?: GetComponentProps<ColumnType[]>;
    onRowClick?: LegacyFunction<ValueType>;
    onRowDoubleClick?: LegacyFunction<ValueType>;
    onRowContextMenu?: LegacyFunction<ValueType>;
    onRowMouseEnter?: LegacyFunction<ValueType>;
    onRowMouseLeave?: LegacyFunction<ValueType>;
    showHeader?: boolean;
    title?: (data: ValueType[]) => React.ReactNode;
    id?: string;
    footer?: (data: ValueType[]) => React.ReactNode;
    emptyText?: React.ReactNode | (() => React.ReactNode);
    scroll?: {
        x?: number | true | string;
        y?: number;
    };
    rowRef?: (record: ValueType, index: number, indent: number) => React.Ref<React.ReactElement>;
    getBodyWrapper?: (body: React.ReactElement) => React.ReactElement;
    children?: React.ReactNode;
    components?: TableComponents;
    tableLayout?: 'fixed';
}
interface TableState {
    columns?: ColumnType[];
    children?: React.ReactNode;
}
declare class Table<ValueType> extends React.Component<TableProps<ValueType>, TableState> {
    static childContextTypes: {
        table: PropTypes.Requireable<any>;
        components: PropTypes.Requireable<any>;
    };
    static Column: React.FC<import("./Column").ColumnProps>;
    static ColumnGroup: typeof ColumnGroup;
    static defaultProps: {
        data: any[];
        useFixedHeader: boolean;
        rowKey: string;
        rowClassName: () => string;
        onRow(): void;
        onHeaderRow(): void;
        prefixCls: string;
        bodyStyle: {};
        style: {};
        showHeader: boolean;
        scroll: {};
        rowRef: () => any;
        emptyText: () => string;
    };
    constructor(props: TableProps<ValueType>);
    state: TableState;
    columnManager: ColumnManager;
    store: TableStore;
    debouncedWindowResize: Function & {
        cancel: Function;
    };
    resizeEvent: {
        remove: Function;
    };
    headTable: HTMLDivElement;
    bodyTable: HTMLDivElement;
    tableNode: HTMLDivElement;
    scrollPosition: ScrollPosition;
    lastScrollLeft: number;
    lastScrollTop: number;
    fixedColumnsBodyLeft: HTMLDivElement;
    fixedColumnsBodyRight: HTMLDivElement;
    expander: Expander;
    getChildContext(): {
        table: {
            props: Readonly<TableProps<ValueType>> & Readonly<{
                children?: React.ReactNode;
            }>;
            columnManager: ColumnManager;
            saveRef: (name: string) => (node: HTMLElement) => void;
            components: any;
        };
    };
    static getDerivedStateFromProps(nextProps: TableProps<DefaultValueType>, prevState: TableState): {
        columns: ColumnType<Record<string, any>>[];
        children: any;
    } | {
        columns: any;
        children: React.ReactNode;
    };
    componentDidMount(): void;
    componentDidUpdate(prevProps: any): void;
    componentWillUnmount(): void;
    getRowKey: (record: ValueType, index: number) => any;
    setScrollPosition(position: ScrollPosition): void;
    setScrollPositionClassName(): void;
    isTableLayoutFixed(): boolean;
    handleWindowResize: () => void;
    syncFixedTableRowHeight: () => void;
    resetScrollX(): void;
    hasScrollX(): boolean;
    handleBodyScrollLeft: React.UIEventHandler<HTMLDivElement>;
    handleBodyScrollTop: React.UIEventHandler<HTMLDivElement>;
    handleBodyScroll: React.UIEventHandler<HTMLDivElement>;
    handleWheel: React.WheelEventHandler<HTMLDivElement>;
    saveRef: (name: string) => (node: HTMLElement) => void;
    saveTableNodeRef: (node: HTMLDivElement) => void;
    renderMainTable(): JSX.Element | (JSX.Element | JSX.Element[])[];
    renderLeftFixedTable(): JSX.Element;
    renderRightFixedTable(): JSX.Element;
    renderTable(options: any): JSX.Element[];
    renderTitle(): JSX.Element;
    renderFooter(): JSX.Element;
    renderEmptyText(): JSX.Element;
    render(): JSX.Element;
}
export default Table;
