"use strict";

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var __importStar = this && this.__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) {
    if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
  }
  result["default"] = mod;
  return result;
};

Object.defineProperty(exports, "__esModule", {
  value: true
});
/* eslint-disable no-underscore-dangle */

var React = __importStar(require("react"));

var ColumnManager = /*#__PURE__*/function () {
  function ColumnManager(columns, elements) {
    _classCallCheck(this, ColumnManager);

    this._cached = {};
    this.columns = columns || this.normalize(elements);
  }

  _createClass(ColumnManager, [{
    key: "isAnyColumnsFixed",
    value: function isAnyColumnsFixed() {
      var _this = this;

      return this._cache('isAnyColumnsFixed', function () {
        return _this.columns.some(function (column) {
          return !!column.fixed;
        });
      });
    }
  }, {
    key: "isAnyColumnsLeftFixed",
    value: function isAnyColumnsLeftFixed() {
      var _this2 = this;

      return this._cache('isAnyColumnsLeftFixed', function () {
        return _this2.columns.some(function (column) {
          return column.fixed === 'left' || column.fixed === true;
        });
      });
    }
  }, {
    key: "isAnyColumnsRightFixed",
    value: function isAnyColumnsRightFixed() {
      var _this3 = this;

      return this._cache('isAnyColumnsRightFixed', function () {
        return _this3.columns.some(function (column) {
          return column.fixed === 'right';
        });
      });
    }
  }, {
    key: "leftColumns",
    value: function leftColumns() {
      var _this4 = this;

      return this._cache('leftColumns', function () {
        return _this4.groupedColumns().filter(function (column) {
          return column.fixed === 'left' || column.fixed === true;
        });
      });
    }
  }, {
    key: "rightColumns",
    value: function rightColumns() {
      var _this5 = this;

      return this._cache('rightColumns', function () {
        return _this5.groupedColumns().filter(function (column) {
          return column.fixed === 'right';
        });
      });
    }
  }, {
    key: "leafColumns",
    value: function leafColumns() {
      var _this6 = this;

      return this._cache('leafColumns', function () {
        return _this6._leafColumns(_this6.columns);
      });
    }
  }, {
    key: "leftLeafColumns",
    value: function leftLeafColumns() {
      var _this7 = this;

      return this._cache('leftLeafColumns', function () {
        return _this7._leafColumns(_this7.leftColumns());
      });
    }
  }, {
    key: "rightLeafColumns",
    value: function rightLeafColumns() {
      var _this8 = this;

      return this._cache('rightLeafColumns', function () {
        return _this8._leafColumns(_this8.rightColumns());
      });
    } // add appropriate rowspan and colspan to column

  }, {
    key: "groupedColumns",
    value: function groupedColumns() {
      var _this9 = this;

      return this._cache('groupedColumns', function () {
        var _groupColumns = function _groupColumns(columns) {
          var currentRow = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
          var parentColumn = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
          var rows = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : [];

          /* eslint-disable no-param-reassign */
          // track how many rows we got
          rows[currentRow] = rows[currentRow] || [];
          var grouped = [];

          var setRowSpan = function setRowSpan(column) {
            var rowSpan = rows.length - currentRow;

            if (column && !column.children && // parent columns are supposed to be one row
            rowSpan > 1 && (!column.rowSpan || column.rowSpan < rowSpan)) {
              column.rowSpan = rowSpan;
            }
          };

          columns.forEach(function (column, index) {
            var newColumn = _objectSpread({}, column);

            rows[currentRow].push(newColumn);
            parentColumn.colSpan = parentColumn.colSpan || 0;

            if (newColumn.children && newColumn.children.length > 0) {
              newColumn.children = _groupColumns(newColumn.children, currentRow + 1, newColumn, rows);
              parentColumn.colSpan += newColumn.colSpan;
            } else {
              parentColumn.colSpan += 1;
            } // update rowspan to all same row columns


            for (var i = 0; i < rows[currentRow].length - 1; i += 1) {
              setRowSpan(rows[currentRow][i]);
            } // last column, update rowspan immediately


            if (index + 1 === columns.length) {
              setRowSpan(newColumn);
            }

            grouped.push(newColumn);
          });
          return grouped;
          /* eslint-enable no-param-reassign */
        };

        return _groupColumns(_this9.columns);
      });
    }
  }, {
    key: "normalize",
    value: function normalize(elements) {
      var _this10 = this;

      var columns = [];
      React.Children.forEach(elements, function (element) {
        if (!React.isValidElement(element)) {
          return;
        }

        var column = _objectSpread({}, element.props);

        if (element.key) {
          column.key = element.key;
        }

        if (element.type.isTableColumnGroup) {
          column.children = _this10.normalize(column.children);
        }

        columns.push(column);
      });
      return columns;
    }
  }, {
    key: "reset",
    value: function reset(columns, elements) {
      this.columns = columns || this.normalize(elements);
      this._cached = {};
    }
  }, {
    key: "_cache",
    value: function _cache(name, fn) {
      if (name in this._cached) {
        return this._cached[name];
      }

      this._cached[name] = fn();
      return this._cached[name];
    }
  }, {
    key: "_leafColumns",
    value: function _leafColumns(columns) {
      var _this11 = this;

      var leafColumns = [];
      columns.forEach(function (column) {
        if (!column.children) {
          leafColumns.push(column);
        } else {
          leafColumns.push.apply(leafColumns, _toConsumableArray(_this11._leafColumns(column.children)));
        }
      });
      return leafColumns;
    }
  }]);

  return ColumnManager;
}();

exports.default = ColumnManager;
/* eslint-enable */