const isAliEnv = require('is-ali-env');
const spawn = require('child_process').spawn;
const join = require('path').join;

isAliEnv().then(function(_isAliEnv) {
  if (!_isAliEnv) {
    return;
  }

  // ref: https://stackoverflow.com/questions/37459717/error-spawn-enoent-on-windows
  let bin = 'tnpm';
  let params = ['i', '@alipay/satori-client'];
  
  // windows
  if (/^win/.test(process.platform)) {
    bin = 'cmd';
    params = ['/s', '/c', 'tnpm'].concat(params);
  }

  const { npm_config_user_agent = '' } = process.env;

  if (npm_config_user_agent && !npm_config_user_agent.startsWith('npminstall')) {
    const [agent] = npm_config_user_agent.split('/');
    params = params.concat([`--by=${agent}`]);
  }

  child = spawn(bin, params, {
    cwd: join(__dirname, '.'),
    stdio: ['ignore', 'ignore', 'ignore'],
    detached: true,
  });
  child.unref();
});
