"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateStatsFile = exports.getDepTree = exports.getPlatformInfo = exports.getGitInfo = exports.getArtifactInfo = exports.getPkg = exports.getHardware = exports.GitInfo = void 0;
var tslib_1 = require("tslib");
var os = require("os");
var path_1 = require("path");
var fs_1 = require("fs");
var enum_1 = require("../enum");
var GitInfo_1 = require("./GitInfo");
exports.GitInfo = GitInfo_1.default;
var debug = require("debug");
var bfj = require("bfj");
var log = debug('bigbrother-webpack-plugin:util');
function getPkg(cwd) {
    var pkg = {};
    try {
        pkg = require(path_1.join(cwd, 'package.json'));
    }
    catch (_) { } // eslint-disable-line
    return pkg;
}
exports.getPkg = getPkg;
function getArtifactInfo(stats) {
    var json = stats.toJson();
    var totalSize = 0;
    var manifest = json.assets.map(function (_a) {
        var name = _a.name, size = _a.size;
        totalSize += size;
        return { name: name, size: size };
    });
    return {
        hash: stats.hash,
        size: totalSize,
        manifest: manifest,
    };
}
exports.getArtifactInfo = getArtifactInfo;
function getGitInfo(cwd) {
    var gitPath = path_1.join(cwd, (!process.env.TEST ? '.' : '') + "git");
    if (fs_1.existsSync(gitPath)) {
        var gitInfo = new GitInfo_1.default({ gitPath: gitPath });
        return gitInfo.gitInfo;
    }
    var _a = process.env, REPO_PROJECT_ID = _a.REPO_PROJECT_ID, COMMIT_ID = _a.COMMIT_ID;
    return {
        repoProjectId: REPO_PROJECT_ID,
        commitId: COMMIT_ID,
        branch: process.env.BRANCH_NAME || COMMIT_ID,
    };
}
exports.getGitInfo = getGitInfo;
function getPlatformInfo() {
    var _a = process.env, PLATFORM_TYPE = _a.PLATFORM_TYPE, CLOUD_BUILD_ID = _a.CLOUD_BUILD_ID, CLOUD_BUILD_LOG = _a.CLOUD_BUILD_LOG, APP_NAME = _a.APP_NAME, APP_TYPE = _a.APP_TYPE;
    var type = [enum_1.PLATFORM_TYPE.BASEMENT, enum_1.PLATFORM_TYPE.LINKE].indexOf(PLATFORM_TYPE) > -1
        ? PLATFORM_TYPE
        : '';
    return {
        type: type,
        // basement
        cloudBuildId: (CLOUD_BUILD_ID || null),
        cloudBuildLog: CLOUD_BUILD_LOG || null,
        // appname
        appName: APP_NAME,
        appType: APP_TYPE,
    };
}
exports.getPlatformInfo = getPlatformInfo;
function getHardware() {
    return {
        cpuLength: os.cpus().length,
        arch: os.arch(),
        memory: os.totalmem() / 1024 / 1024 / 1024,
        hostname: os.hostname(),
        platform: os.platform(),
    };
}
exports.getHardware = getHardware;
function getDepTree(cwd) {
    return tslib_1.__awaiter(this, void 0, void 0, function () {
        var Shameimaru, shameimaru;
        return tslib_1.__generator(this, function (_a) {
            Shameimaru = require('shameimaru');
            shameimaru = new Shameimaru(cwd);
            return [2 /*return*/, shameimaru.traverse()];
        });
    });
}
exports.getDepTree = getDepTree;
function generateStatsFile(filePath, stats) {
    return tslib_1.__awaiter(this, void 0, void 0, function () {
        var e_1;
        return tslib_1.__generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    log("Generate states file to " + filePath);
                    _a.label = 1;
                case 1:
                    _a.trys.push([1, 3, , 4]);
                    if (!filePath) {
                        return [2 /*return*/];
                    }
                    return [4 /*yield*/, bfj.write(filePath, stats, {
                            promises: 'ignore',
                            buffers: 'ignore',
                            maps: 'ignore',
                            iterables: 'ignore',
                            circular: 'ignore',
                        })];
                case 2:
                    _a.sent();
                    log('Generate states file success');
                    return [3 /*break*/, 4];
                case 3:
                    e_1 = _a.sent();
                    log('Generate states file error');
                    log(e_1.stack);
                    return [3 /*break*/, 4];
                case 4: return [2 /*return*/];
            }
        });
    });
}
exports.generateStatsFile = generateStatsFile;
