import * as webpack from 'webpack';
import { PLATFORM_TYPE } from '../enum';
export interface IAdapter {
    postBuild: (args: ISatoriCreateBuild, stats: object) => void;
    postDev: (args: ISatoriCreateBuild, stats: object) => void;
}
export interface IPlatformInfo {
    type: PLATFORM_TYPE;
    cloudBuildId?: string;
    cloudBuildLog?: string;
    appType?: string;
    appName?: string;
}
export interface IBuildGitInfo {
    repository?: string;
    userInfo?: string;
    branch?: string;
    repoProjectId?: string;
    commitId?: string;
}
export interface IHardware {
    cpuLength?: number;
    arch?: string;
    memory?: number;
    hostname?: string;
    platform?: string;
}
export interface INode {
    node: string;
    alinode?: string;
}
export interface IPkg {
    name: string;
    [key: string]: any;
}
interface ICommonArgs {
    buildTimeRef: string;
    pkg: IPkg;
    tool: {
        name: string;
        version: string;
        [key: string]: any;
    };
    success: boolean;
    startedAt: Date;
    endedAt: Date;
    cwd: string;
    node: INode;
    buildConfig?: object;
    artifact: {
        hash: string;
        size: number;
        manifest: object;
    };
    errors?: any[];
    stages?: object;
}
export interface ICreateDev extends ICommonArgs {
}
export interface ICreateBuild extends ICommonArgs {
}
export interface ISatoriCreateBuild extends ICommonArgs {
    git: IBuildGitInfo;
    platform: IPlatformInfo;
    envs: object;
    hardware: IHardware;
    shameimaruUrl: string;
    xiaoshengStatUrl?: string;
}
export interface ICreateRuntime extends ICommonArgs {
    gitInfo?: {
        gitUrL: string;
        curBranch: string;
    };
    envs: object;
}
export interface ITYPETOOL {
    name: string;
    version: string;
    [key: string]: any;
}
export interface IOptions {
    cwd: string;
    tool: ITYPETOOL;
    buildConfig?: object;
    apply: (compiler: webpack.Compiler) => void;
    report: (compiler: webpack.Compiler) => void;
}
export interface IStages {
    stage: string;
    startTime: number;
    endTime: number;
    elapse: number;
}
export {};
