/**
 * @videojs/http-streaming
 * @version 1.12.2
 * @copyright 2020 Brightcove, Inc
 * @license Apache-2.0
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("video.js")):"function"==typeof define&&define.amd?define(["exports","video.js"],t):t(e.videojsHttpStreaming={},e.videojs)}(this,function(e,t){"use strict";t=t&&t.hasOwnProperty("default")?t.default:t;var i="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{};function n(e,t){return e(t={exports:{}},t.exports),t.exports}var r,a=void 0!==i?i:"undefined"!=typeof window?window:{};"undefined"!=typeof document?r=document:(r=a["__GLOBAL_DOCUMENT_CACHE@4"])||(r=a["__GLOBAL_DOCUMENT_CACHE@4"]={});var s=r,o=n(function(e,t){var i,n,r,a,s;i=/^((?:[a-zA-Z0-9+\-.]+:)?)(\/\/[^\/?#]*)?((?:[^\/\?#]*\/)*.*?)??(;.*?)?(\?.*?)?(#.*?)?$/,n=/^([^\/?#]*)(.*)$/,r=/(?:\/|^)\.(?=\/)/g,a=/(?:\/|^)\.\.\/(?!\.\.\/).*?(?=\/)/g,s={buildAbsoluteURL:function(e,t,i){if(i=i||{},e=e.trim(),!(t=t.trim())){if(!i.alwaysNormalize)return e;var r=s.parseURL(e);if(!r)throw new Error("Error trying to parse base URL.");return r.path=s.normalizePath(r.path),s.buildURLFromParts(r)}var a=s.parseURL(t);if(!a)throw new Error("Error trying to parse relative URL.");if(a.scheme)return i.alwaysNormalize?(a.path=s.normalizePath(a.path),s.buildURLFromParts(a)):t;var o=s.parseURL(e);if(!o)throw new Error("Error trying to parse base URL.");if(!o.netLoc&&o.path&&"/"!==o.path[0]){var u=n.exec(o.path);o.netLoc=u[1],o.path=u[2]}o.netLoc&&!o.path&&(o.path="/");var d={scheme:o.scheme,netLoc:a.netLoc,path:null,params:a.params,query:a.query,fragment:a.fragment};if(!a.netLoc&&(d.netLoc=o.netLoc,"/"!==a.path[0]))if(a.path){var l=o.path,c=l.substring(0,l.lastIndexOf("/")+1)+a.path;d.path=s.normalizePath(c)}else d.path=o.path,a.params||(d.params=o.params,a.query||(d.query=o.query));return null===d.path&&(d.path=i.alwaysNormalize?s.normalizePath(a.path):a.path),s.buildURLFromParts(d)},parseURL:function(e){var t=i.exec(e);return t?{scheme:t[1]||"",netLoc:t[2]||"",path:t[3]||"",params:t[4]||"",query:t[5]||"",fragment:t[6]||""}:null},normalizePath:function(e){for(e=e.split("").reverse().join("").replace(r,"");e.length!==(e=e.replace(a,"")).length;);return e.split("").reverse().join("")},buildURLFromParts:function(e){return e.scheme+e.netLoc+e.path+e.params+e.query+e.fragment}},e.exports=s}),u="undefined"!=typeof window?window:void 0!==i?i:"undefined"!=typeof self?self:{},d=function(e,t){return/^[a-z]+:/i.test(t)?t:(/\/\//i.test(e)||(e=o.buildAbsoluteURL(u.location.href,e)),o.buildAbsoluteURL(e,t))},l=function(e,t,i){return e&&i.responseURL&&t!==i.responseURL?i.responseURL:t};
/*! @name m3u8-parser @version 4.4.0 @license Apache-2.0 */
function c(){return(c=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var i=arguments[t];for(var n in i)Object.prototype.hasOwnProperty.call(i,n)&&(e[n]=i[n])}return e}).apply(this,arguments)}function h(e,t){e.prototype=Object.create(t.prototype),e.prototype.constructor=e,e.__proto__=t}var f=function(){function e(){this.listeners={}}var t=e.prototype;return t.on=function(e,t){this.listeners[e]||(this.listeners[e]=[]),this.listeners[e].push(t)},t.off=function(e,t){if(!this.listeners[e])return!1;var i=this.listeners[e].indexOf(t);return this.listeners[e].splice(i,1),i>-1},t.trigger=function(e){var t,i,n,r=this.listeners[e];if(r)if(2===arguments.length)for(i=r.length,t=0;t<i;++t)r[t].call(this,arguments[1]);else for(n=Array.prototype.slice.call(arguments,1),i=r.length,t=0;t<i;++t)r[t].apply(this,n)},t.dispose=function(){this.listeners={}},t.pipe=function(e){this.on("data",function(t){e.push(t)})},e}(),p=function(e){function t(){var t;return(t=e.call(this)||this).buffer="",t}return h(t,e),t.prototype.push=function(e){var t;for(this.buffer+=e,t=this.buffer.indexOf("\n");t>-1;t=this.buffer.indexOf("\n"))this.trigger("data",this.buffer.substring(0,t)),this.buffer=this.buffer.substring(t+1)},t}(f),m=function(e){for(var t,i=e.split(new RegExp('(?:^|,)((?:[^=]*)=(?:"[^"]*"|[^,]*))')),n={},r=i.length;r--;)""!==i[r]&&((t=/([^=]*)=(.*)/.exec(i[r]).slice(1))[0]=t[0].replace(/^\s+|\s+$/g,""),t[1]=t[1].replace(/^\s+|\s+$/g,""),t[1]=t[1].replace(/^['"](.*)['"]$/g,"$1"),n[t[0]]=t[1]);return n},g=function(e){function t(){var t;return(t=e.call(this)||this).customParsers=[],t.tagMappers=[],t}h(t,e);var i=t.prototype;return i.push=function(e){var t,i,n=this;0!==(e=e.trim()).length&&("#"===e[0]?this.tagMappers.reduce(function(t,i){var n=i(e);return n===e?t:t.concat([n])},[e]).forEach(function(e){for(var r=0;r<n.customParsers.length;r++)if(n.customParsers[r].call(n,e))return;if(0===e.indexOf("#EXT"))if(e=e.replace("\r",""),t=/^#EXTM3U/.exec(e))n.trigger("data",{type:"tag",tagType:"m3u"});else{if(t=/^#EXTINF:?([0-9\.]*)?,?(.*)?$/.exec(e))return i={type:"tag",tagType:"inf"},t[1]&&(i.duration=parseFloat(t[1])),t[2]&&(i.title=t[2]),void n.trigger("data",i);if(t=/^#EXT-X-TARGETDURATION:?([0-9.]*)?/.exec(e))return i={type:"tag",tagType:"targetduration"},t[1]&&(i.duration=parseInt(t[1],10)),void n.trigger("data",i);if(t=/^#ZEN-TOTAL-DURATION:?([0-9.]*)?/.exec(e))return i={type:"tag",tagType:"totalduration"},t[1]&&(i.duration=parseInt(t[1],10)),void n.trigger("data",i);if(t=/^#EXT-X-VERSION:?([0-9.]*)?/.exec(e))return i={type:"tag",tagType:"version"},t[1]&&(i.version=parseInt(t[1],10)),void n.trigger("data",i);if(t=/^#EXT-X-MEDIA-SEQUENCE:?(\-?[0-9.]*)?/.exec(e))return i={type:"tag",tagType:"media-sequence"},t[1]&&(i.number=parseInt(t[1],10)),void n.trigger("data",i);if(t=/^#EXT-X-DISCONTINUITY-SEQUENCE:?(\-?[0-9.]*)?/.exec(e))return i={type:"tag",tagType:"discontinuity-sequence"},t[1]&&(i.number=parseInt(t[1],10)),void n.trigger("data",i);if(t=/^#EXT-X-PLAYLIST-TYPE:?(.*)?$/.exec(e))return i={type:"tag",tagType:"playlist-type"},t[1]&&(i.playlistType=t[1]),void n.trigger("data",i);if(t=/^#EXT-X-BYTERANGE:?([0-9.]*)?@?([0-9.]*)?/.exec(e))return i={type:"tag",tagType:"byterange"},t[1]&&(i.length=parseInt(t[1],10)),t[2]&&(i.offset=parseInt(t[2],10)),void n.trigger("data",i);if(t=/^#EXT-X-ALLOW-CACHE:?(YES|NO)?/.exec(e))return i={type:"tag",tagType:"allow-cache"},t[1]&&(i.allowed=!/NO/.test(t[1])),void n.trigger("data",i);if(t=/^#EXT-X-MAP:?(.*)$/.exec(e)){if(i={type:"tag",tagType:"map"},t[1]){var a=m(t[1]);if(a.URI&&(i.uri=a.URI),a.BYTERANGE){var s=a.BYTERANGE.split("@"),o=s[0],u=s[1];i.byterange={},o&&(i.byterange.length=parseInt(o,10)),u&&(i.byterange.offset=parseInt(u,10))}}n.trigger("data",i)}else if(t=/^#EXT-X-STREAM-INF:?(.*)$/.exec(e)){if(i={type:"tag",tagType:"stream-inf"},t[1]){if(i.attributes=m(t[1]),i.attributes.RESOLUTION){var d=i.attributes.RESOLUTION.split("x"),l={};d[0]&&(l.width=parseInt(d[0],10)),d[1]&&(l.height=parseInt(d[1],10)),i.attributes.RESOLUTION=l}i.attributes.BANDWIDTH&&(i.attributes.BANDWIDTH=parseInt(i.attributes.BANDWIDTH,10)),i.attributes["PROGRAM-ID"]&&(i.attributes["PROGRAM-ID"]=parseInt(i.attributes["PROGRAM-ID"],10))}n.trigger("data",i)}else{if(t=/^#EXT-X-MEDIA:?(.*)$/.exec(e))return i={type:"tag",tagType:"media"},t[1]&&(i.attributes=m(t[1])),void n.trigger("data",i);if(t=/^#EXT-X-ENDLIST/.exec(e))n.trigger("data",{type:"tag",tagType:"endlist"});else if(t=/^#EXT-X-DISCONTINUITY/.exec(e))n.trigger("data",{type:"tag",tagType:"discontinuity"});else{if(t=/^#EXT-X-PROGRAM-DATE-TIME:?(.*)$/.exec(e))return i={type:"tag",tagType:"program-date-time"},t[1]&&(i.dateTimeString=t[1],i.dateTimeObject=new Date(t[1])),void n.trigger("data",i);if(t=/^#EXT-X-KEY:?(.*)$/.exec(e))return i={type:"tag",tagType:"key"},t[1]&&(i.attributes=m(t[1]),i.attributes.IV&&("0x"===i.attributes.IV.substring(0,2).toLowerCase()&&(i.attributes.IV=i.attributes.IV.substring(2)),i.attributes.IV=i.attributes.IV.match(/.{8}/g),i.attributes.IV[0]=parseInt(i.attributes.IV[0],16),i.attributes.IV[1]=parseInt(i.attributes.IV[1],16),i.attributes.IV[2]=parseInt(i.attributes.IV[2],16),i.attributes.IV[3]=parseInt(i.attributes.IV[3],16),i.attributes.IV=new Uint32Array(i.attributes.IV))),void n.trigger("data",i);if(t=/^#EXT-X-START:?(.*)$/.exec(e))return i={type:"tag",tagType:"start"},t[1]&&(i.attributes=m(t[1]),i.attributes["TIME-OFFSET"]=parseFloat(i.attributes["TIME-OFFSET"]),i.attributes.PRECISE=/YES/.test(i.attributes.PRECISE)),void n.trigger("data",i);if(t=/^#EXT-X-CUE-OUT-CONT:?(.*)?$/.exec(e))return i={type:"tag",tagType:"cue-out-cont"},t[1]?i.data=t[1]:i.data="",void n.trigger("data",i);if(t=/^#EXT-X-CUE-OUT:?(.*)?$/.exec(e))return i={type:"tag",tagType:"cue-out"},t[1]?i.data=t[1]:i.data="",void n.trigger("data",i);if(t=/^#EXT-X-CUE-IN:?(.*)?$/.exec(e))return i={type:"tag",tagType:"cue-in"},t[1]?i.data=t[1]:i.data="",void n.trigger("data",i);n.trigger("data",{type:"tag",data:e.slice(4)})}}}else n.trigger("data",{type:"comment",text:e.slice(1)})}):this.trigger("data",{type:"uri",uri:e}))},i.addParser=function(e){var t=this,i=e.expression,n=e.customType,r=e.dataParser,a=e.segment;"function"!=typeof r&&(r=function(e){return e}),this.customParsers.push(function(e){if(i.exec(e))return t.trigger("data",{type:"custom",data:r(e),customType:n,segment:a}),!0})},i.addTagMapper=function(e){var t=e.expression,i=e.map;this.tagMappers.push(function(e){return t.test(e)?i(e):e})},t}(f);var y=function(e){function t(){var t;(t=e.call(this)||this).lineStream=new p,t.parseStream=new g,t.lineStream.pipe(t.parseStream);var i,n,r=function(e){if(void 0===e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return e}(t),a=[],s={},o={AUDIO:{},VIDEO:{},"CLOSED-CAPTIONS":{},SUBTITLES:{}},d=0;return t.manifest={allowCache:!0,discontinuityStarts:[],segments:[]},t.parseStream.on("data",function(e){var t,l;({tag:function(){(({"allow-cache":function(){this.manifest.allowCache=e.allowed,"allowed"in e||(this.trigger("info",{message:"defaulting allowCache to YES"}),this.manifest.allowCache=!0)},byterange:function(){var t={};"length"in e&&(s.byterange=t,t.length=e.length,"offset"in e||(this.trigger("info",{message:"defaulting offset to zero"}),e.offset=0)),"offset"in e&&(s.byterange=t,t.offset=e.offset)},endlist:function(){this.manifest.endList=!0},inf:function(){"mediaSequence"in this.manifest||(this.manifest.mediaSequence=0,this.trigger("info",{message:"defaulting media sequence to zero"})),"discontinuitySequence"in this.manifest||(this.manifest.discontinuitySequence=0,this.trigger("info",{message:"defaulting discontinuity sequence to zero"})),e.duration>0&&(s.duration=e.duration),0===e.duration&&(s.duration=.01,this.trigger("info",{message:"updating zero segment duration to a small value"})),this.manifest.segments=a},key:function(){if(e.attributes)if("NONE"!==e.attributes.METHOD)if(e.attributes.URI){if("urn:uuid:edef8ba9-79d6-4ace-a3c8-27dcd51d21ed"===e.attributes.KEYFORMAT){return-1===["SAMPLE-AES","SAMPLE-AES-CTR","SAMPLE-AES-CENC"].indexOf(e.attributes.METHOD)?void this.trigger("warn",{message:"invalid key method provided for Widevine"}):("SAMPLE-AES-CENC"===e.attributes.METHOD&&this.trigger("warn",{message:"SAMPLE-AES-CENC is deprecated, please use SAMPLE-AES-CTR instead"}),"data:text/plain;base64,"!==e.attributes.URI.substring(0,23)?void this.trigger("warn",{message:"invalid key URI provided for Widevine"}):e.attributes.KEYID&&"0x"===e.attributes.KEYID.substring(0,2)?void(this.manifest.contentProtection={"com.widevine.alpha":{attributes:{schemeIdUri:e.attributes.KEYFORMAT,keyId:e.attributes.KEYID.substring(2)},pssh:function(e){for(var t=u.atob(e||""),i=new Uint8Array(t.length),n=0;n<t.length;n++)i[n]=t.charCodeAt(n);return i}(e.attributes.URI.split(",")[1])}}):void this.trigger("warn",{message:"invalid key ID provided for Widevine"}))}e.attributes.METHOD||this.trigger("warn",{message:"defaulting key method to AES-128"}),n={method:e.attributes.METHOD||"AES-128",uri:e.attributes.URI},void 0!==e.attributes.IV&&(n.iv=e.attributes.IV)}else this.trigger("warn",{message:"ignoring key declaration without URI"});else n=null;else this.trigger("warn",{message:"ignoring key declaration without attribute list"})},"media-sequence":function(){isFinite(e.number)?this.manifest.mediaSequence=e.number:this.trigger("warn",{message:"ignoring invalid media sequence: "+e.number})},"discontinuity-sequence":function(){isFinite(e.number)?(this.manifest.discontinuitySequence=e.number,d=e.number):this.trigger("warn",{message:"ignoring invalid discontinuity sequence: "+e.number})},"playlist-type":function(){/VOD|EVENT/.test(e.playlistType)?this.manifest.playlistType=e.playlistType:this.trigger("warn",{message:"ignoring unknown playlist type: "+e.playlist})},map:function(){i={},e.uri&&(i.uri=e.uri),e.byterange&&(i.byterange=e.byterange)},"stream-inf":function(){this.manifest.playlists=a,this.manifest.mediaGroups=this.manifest.mediaGroups||o,e.attributes?(s.attributes||(s.attributes={}),c(s.attributes,e.attributes)):this.trigger("warn",{message:"ignoring empty stream-inf attributes"})},media:function(){if(this.manifest.mediaGroups=this.manifest.mediaGroups||o,e.attributes&&e.attributes.TYPE&&e.attributes["GROUP-ID"]&&e.attributes.NAME){var i=this.manifest.mediaGroups[e.attributes.TYPE];i[e.attributes["GROUP-ID"]]=i[e.attributes["GROUP-ID"]]||{},t=i[e.attributes["GROUP-ID"]],(l={default:/yes/i.test(e.attributes.DEFAULT)}).default?l.autoselect=!0:l.autoselect=/yes/i.test(e.attributes.AUTOSELECT),e.attributes.LANGUAGE&&(l.language=e.attributes.LANGUAGE),e.attributes.URI&&(l.uri=e.attributes.URI),e.attributes["INSTREAM-ID"]&&(l.instreamId=e.attributes["INSTREAM-ID"]),e.attributes.CHARACTERISTICS&&(l.characteristics=e.attributes.CHARACTERISTICS),e.attributes.FORCED&&(l.forced=/yes/i.test(e.attributes.FORCED)),t[e.attributes.NAME]=l}else this.trigger("warn",{message:"ignoring incomplete or missing media group"})},discontinuity:function(){d+=1,s.discontinuity=!0,this.manifest.discontinuityStarts.push(a.length)},"program-date-time":function(){void 0===this.manifest.dateTimeString&&(this.manifest.dateTimeString=e.dateTimeString,this.manifest.dateTimeObject=e.dateTimeObject),s.dateTimeString=e.dateTimeString,s.dateTimeObject=e.dateTimeObject},targetduration:function(){!isFinite(e.duration)||e.duration<0?this.trigger("warn",{message:"ignoring invalid target duration: "+e.duration}):this.manifest.targetDuration=e.duration},totalduration:function(){!isFinite(e.duration)||e.duration<0?this.trigger("warn",{message:"ignoring invalid total duration: "+e.duration}):this.manifest.totalDuration=e.duration},start:function(){e.attributes&&!isNaN(e.attributes["TIME-OFFSET"])?this.manifest.start={timeOffset:e.attributes["TIME-OFFSET"],precise:e.attributes.PRECISE}:this.trigger("warn",{message:"ignoring start declaration without appropriate attribute list"})},"cue-out":function(){s.cueOut=e.data},"cue-out-cont":function(){s.cueOutCont=e.data},"cue-in":function(){s.cueIn=e.data}})[e.tagType]||function(){}).call(r)},uri:function(){s.uri=e.uri,a.push(s),!this.manifest.targetDuration||"duration"in s||(this.trigger("warn",{message:"defaulting segment duration to the target duration"}),s.duration=this.manifest.targetDuration),n&&(s.key=n),s.timeline=d,i&&(s.map=i),s={}},comment:function(){},custom:function(){e.segment?(s.custom=s.custom||{},s.custom[e.customType]=e.data):(this.manifest.custom=this.manifest.custom||{},this.manifest.custom[e.customType]=e.data)}})[e.type].call(r)}),t}h(t,e);var i=t.prototype;return i.push=function(e){this.lineStream.push(e)},i.end=function(){this.lineStream.push("\n")},i.addParser=function(e){this.parseStream.addParser(e)},i.addTagMapper=function(e){this.parseStream.addTagMapper(e)},t}(f),_=function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")},v=function(){function e(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}return function(t,i,n){return i&&e(t.prototype,i),n&&e(t,n),t}}(),b=function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function, not "+typeof t);e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}}),t&&(Object.setPrototypeOf?Object.setPrototypeOf(e,t):e.__proto__=t)},T=function(e,t){if(!e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return!t||"object"!=typeof t&&"function"!=typeof t?e:t},S=function(){return function(e,t){if(Array.isArray(e))return e;if(Symbol.iterator in Object(e))return function(e,t){var i=[],n=!0,r=!1,a=void 0;try{for(var s,o=e[Symbol.iterator]();!(n=(s=o.next()).done)&&(i.push(s.value),!t||i.length!==t);n=!0);}catch(e){r=!0,a=e}finally{try{!n&&o.return&&o.return()}finally{if(r)throw a}}return i}(e,t);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}(),w=t.mergeOptions,k=t.EventTarget,E=t.log,I=function(e,t){["AUDIO","SUBTITLES"].forEach(function(i){for(var n in e.mediaGroups[i])for(var r in e.mediaGroups[i][n]){var a=e.mediaGroups[i][n][r];t(a,i,n,r)}})},A=function(e,t){var i=w(e,{}),n=i.playlists[t.id];if(!n)return null;if(n.segments&&t.segments&&n.segments.length===t.segments.length&&n.endList===t.endList&&n.mediaSequence===t.mediaSequence)return null;var r=w(n,t);n.segments&&(r.segments=function(e,t,i){var n=t.slice();i=i||0;for(var r=Math.min(e.length,t.length+i),a=i;a<r;a++)n[a-i]=w(e[a],n[a-i]);return n}(n.segments,t.segments,t.mediaSequence-n.mediaSequence)),r.segments.forEach(function(e){!function(e,t){e.resolvedUri||(e.resolvedUri=d(t,e.uri)),e.key&&!e.key.resolvedUri&&(e.key.resolvedUri=d(t,e.key.uri)),e.map&&!e.map.resolvedUri&&(e.map.resolvedUri=d(t,e.map.uri))}(e,r.resolvedUri)});for(var a=0;a<i.playlists.length;a++)i.playlists[a].id===t.id&&(i.playlists[a]=r);return i.playlists[t.id]=r,i.playlists[t.uri]=r,i},L=function(e,t){return e+"-"+t},C=function(e){for(var t=e.playlists.length;t--;){var i=e.playlists[t];i.resolvedUri=d(e.uri,i.uri),i.id=L(t,i.uri),e.playlists[i.id]=i,e.playlists[i.uri]=i,i.attributes||(i.attributes={},E.warn("Invalid playlist STREAM-INF detected. Missing BANDWIDTH attribute."))}},U=function(e){I(e,function(t){t.uri&&(t.resolvedUri=d(e.uri,t.uri))})},O=function(e,t){var i=e.segments[e.segments.length-1];return t&&i&&i.duration?1e3*i.duration:500*(e.targetDuration||10)},D=function(e){function t(e,i){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};_(this,t);var r=T(this,(t.__proto__||Object.getPrototypeOf(t)).call(this)),a=n.withCredentials,s=void 0!==a&&a,o=n.handleManifestRedirects,u=void 0!==o&&o;r.srcUrl=e,r.hls_=i,r.withCredentials=s,r.handleManifestRedirects=u;var l=i.options_;if(r.customTagParsers=l&&l.customTagParsers||[],r.customTagMappers=l&&l.customTagMappers||[],!r.srcUrl)throw new Error("A non-empty playlist URL is required");return r.state="HAVE_NOTHING",r.on("mediaupdatetimeout",function(){"HAVE_METADATA"===r.state&&(r.state="HAVE_CURRENT_METADATA",r.request=r.hls_.xhr({uri:d(r.master.uri,r.media().uri),withCredentials:r.withCredentials},function(e,t){if(r.request)return e?r.playlistRequestError(r.request,r.media(),"HAVE_METADATA"):void r.haveMetadata(r.request,r.media().uri,r.media().id)}))}),r}return b(t,k),v(t,[{key:"playlistRequestError",value:function(e,t,i){var n=t.uri,r=t.id;this.request=null,i&&(this.state=i),this.error={playlist:this.master.playlists[r],status:e.status,message:"HLS playlist request error at URL: "+n+".",responseText:e.responseText,code:e.status>=500?4:2},this.trigger("error")}},{key:"haveMetadata",value:function(e,t,i){var n=this;this.request=null,this.state="HAVE_METADATA";var r=new y;this.customTagParsers.forEach(function(e){return r.addParser(e)}),this.customTagMappers.forEach(function(e){return r.addTagMapper(e)}),r.push(e.responseText),r.end(),r.manifest.uri=t,r.manifest.id=i,r.manifest.attributes=r.manifest.attributes||{};var a=A(this.master,r.manifest);this.targetDuration=r.manifest.targetDuration,a?(this.master=a,this.media_=this.master.playlists[i]):this.trigger("playlistunchanged"),this.media().endList||(u.clearTimeout(this.mediaUpdateTimeout),this.mediaUpdateTimeout=u.setTimeout(function(){n.trigger("mediaupdatetimeout")},O(this.media(),!!a))),this.trigger("loadedplaylist")}},{key:"dispose",value:function(){this.trigger("dispose"),this.stopRequest(),u.clearTimeout(this.mediaUpdateTimeout),u.clearTimeout(this.finalRenditionTimeout),this.off()}},{key:"stopRequest",value:function(){if(this.request){var e=this.request;this.request=null,e.onreadystatechange=null,e.abort()}}},{key:"media",value:function(e,t){var i=this;if(!e)return this.media_;if("HAVE_NOTHING"===this.state)throw new Error("Cannot switch media playlist from "+this.state);if("string"==typeof e){if(!this.master.playlists[e])throw new Error("Unknown playlist URI: "+e);e=this.master.playlists[e]}if(u.clearTimeout(this.finalRenditionTimeout),t){var n=e.targetDuration/2*1e3||5e3;this.finalRenditionTimeout=u.setTimeout(this.media.bind(this,e,!1),n)}else{var r=this.state,a=!this.media_||e.id!==this.media_.id;if(this.master.playlists[e.id].endList)return this.request&&(this.request.onreadystatechange=null,this.request.abort(),this.request=null),this.state="HAVE_METADATA",this.media_=e,void(a&&(this.trigger("mediachanging"),this.trigger("mediachange")));if(a){if(this.state="SWITCHING_MEDIA",this.request){if(e.resolvedUri===this.request.url)return;this.request.onreadystatechange=null,this.request.abort(),this.request=null}this.media_&&this.trigger("mediachanging"),this.request=this.hls_.xhr({uri:e.resolvedUri,withCredentials:this.withCredentials},function(t,n){if(i.request){if(e.resolvedUri=l(i.handleManifestRedirects,e.resolvedUri,n),t)return i.playlistRequestError(i.request,e,r);i.haveMetadata(n,e.uri,e.id),"HAVE_MASTER"===r?i.trigger("loadedmetadata"):i.trigger("mediachange")}})}}}},{key:"pause",value:function(){this.stopRequest(),u.clearTimeout(this.mediaUpdateTimeout),"HAVE_NOTHING"===this.state&&(this.started=!1),"SWITCHING_MEDIA"===this.state?this.media_?this.state="HAVE_METADATA":this.state="HAVE_MASTER":"HAVE_CURRENT_METADATA"===this.state&&(this.state="HAVE_METADATA")}},{key:"load",value:function(e){var t=this;u.clearTimeout(this.mediaUpdateTimeout);var i=this.media();if(e){var n=i?i.targetDuration/2*1e3:5e3;this.mediaUpdateTimeout=u.setTimeout(function(){return t.load()},n)}else this.started?i&&!i.endList?this.trigger("mediaupdatetimeout"):this.trigger("loadedplaylist"):this.start()}},{key:"start",value:function(){var e=this;this.started=!0,this.request=this.hls_.xhr({uri:this.srcUrl,withCredentials:this.withCredentials},function(t,i){if(e.request){if(e.request=null,t)return e.error={status:i.status,message:"HLS playlist request error at URL: "+e.srcUrl+".",responseText:i.responseText,code:2},"HAVE_NOTHING"===e.state&&(e.started=!1),e.trigger("error");var n=new y;if(e.customTagParsers.forEach(function(e){return n.addParser(e)}),e.customTagMappers.forEach(function(e){return n.addTagMapper(e)}),n.push(i.responseText),n.end(),e.state="HAVE_MASTER",e.srcUrl=l(e.handleManifestRedirects,e.srcUrl,i),n.manifest.uri=e.srcUrl,n.manifest.playlists)return e.master=n.manifest,C(e.master),U(e.master),e.trigger("loadedplaylist"),void(e.request||e.media(n.manifest.playlists[0]));var r=L(0,e.srcUrl);return e.master={mediaGroups:{AUDIO:{},VIDEO:{},"CLOSED-CAPTIONS":{},SUBTITLES:{}},uri:u.location.href,playlists:[{uri:e.srcUrl,id:r,resolvedUri:e.srcUrl,attributes:{}}]},e.master.playlists[r]=e.master.playlists[0],e.master.playlists[e.srcUrl]=e.master.playlists[0],e.haveMetadata(i,e.srcUrl,r),e.trigger("loadedmetadata")}})}}]),t}(),P=t.createTimeRange,R=function(e,t,i){var n,r;return void 0===t&&(t=e.mediaSequence+e.segments.length),t<e.mediaSequence?0:(n=function(e,t){var i=0,n=t-e.mediaSequence,r=e.segments[n];if(r){if(void 0!==r.start)return{result:r.start,precise:!0};if(void 0!==r.end)return{result:r.end-r.duration,precise:!0}}for(;n--;){if(void 0!==(r=e.segments[n]).end)return{result:i+r.end,precise:!0};if(i+=r.duration,void 0!==r.start)return{result:i+r.start,precise:!0}}return{result:i,precise:!1}}(e,t)).precise?n.result:(r=function(e,t){for(var i=0,n=void 0,r=t-e.mediaSequence;r<e.segments.length;r++){if(void 0!==(n=e.segments[r]).start)return{result:n.start-i,precise:!0};if(i+=n.duration,void 0!==n.end)return{result:n.end-i,precise:!0}}return{result:-1,precise:!1}}(e,t)).precise?r.result:n.result+i},x=function(e,t,i){if(!e)return 0;if("number"!=typeof i&&(i=0),void 0===t){if(e.totalDuration)return e.totalDuration;if(!e.endList)return u.Infinity}return R(e,t,i)},N=function(e,t,i){var n=0;if(t>i){var r=[i,t];t=r[0],i=r[1]}if(t<0){for(var a=t;a<Math.min(0,i);a++)n+=e.targetDuration;t=0}for(var s=t;s<i;s++)n+=e.segments[s].duration;return n},M=function(e,t){if(!e.segments.length)return 0;var i=e.segments.length,n=e.segments[i-1].duration||e.targetDuration,r="number"==typeof t?t:n+2*e.targetDuration;if(0===r)return i;for(var a=0;i--&&!((a+=e.segments[i].duration)>=r););return Math.max(0,i)},B=function(e,t,i,n){if(!e||!e.segments)return null;if(e.endList)return x(e);if(null===t)return null;t=t||0;var r=i?M(e,n):e.segments.length;return R(e,e.mediaSequence+r,t)},q=function(e){return e-Math.floor(e)==0},F=function(e,t){if(q(t))return t+.1*e;for(var i=t.toString().split(".")[1].length,n=1;n<=i;n++){var r=Math.pow(10,n),a=t*r;if(q(a)||n===i)return(a+e)/r}},H=F.bind(null,1),j=F.bind(null,-1),V=function(e){return e.excludeUntil&&e.excludeUntil>Date.now()},G=function(e){return e.excludeUntil&&e.excludeUntil===1/0},W=function(e){var t=V(e);return!e.disabled&&!t},z=function(e,t){return t.attributes&&t.attributes[e]},X=function(e,t){if(1===e.playlists.length)return!0;var i=t.attributes.BANDWIDTH||Number.MAX_VALUE;return 0===e.playlists.filter(function(e){return!!W(e)&&(e.attributes.BANDWIDTH||0)<i}).length},Y={duration:x,seekable:function(e,t,i){var n=t||0,r=B(e,t,!0,i);return null===r?P():P(n,r)},safeLiveIndex:M,getMediaInfoForTime:function(e,t,i,n){var r=void 0,a=void 0,s=e.segments.length,o=t-n;if(o<0){if(i>0)for(r=i-1;r>=0;r--)if(a=e.segments[r],(o+=j(a.duration))>0)return{mediaIndex:r,startTime:n-N(e,i,r)};return{mediaIndex:0,startTime:t}}if(i<0){for(r=i;r<0;r++)if((o-=e.targetDuration)<0)return{mediaIndex:0,startTime:t};i=0}for(r=i;r<s;r++)if(a=e.segments[r],(o-=H(a.duration))<0)return{mediaIndex:r,startTime:n+N(e,i,r)};return{mediaIndex:s-1,startTime:t}},isEnabled:W,isDisabled:function(e){return e.disabled},isBlacklisted:V,isIncompatible:G,playlistEnd:B,isAes:function(e){for(var t=0;t<e.segments.length;t++)if(e.segments[t].key)return!0;return!1},isFmp4:function(e){for(var t=0;t<e.segments.length;t++)if(e.segments[t].map)return!0;return!1},hasAttribute:z,estimateSegmentRequestTime:function(e,t,i){var n=arguments.length>3&&void 0!==arguments[3]?arguments[3]:0;return z("BANDWIDTH",i)?(e*i.attributes.BANDWIDTH-8*n)/t:NaN},isLowestEnabledRendition:X},$=t.xhr,K=t.mergeOptions,Q=function(){return function e(i,n){i=K({timeout:45e3},i);var r=e.beforeRequest||t.Hls.xhr.beforeRequest;if(r&&"function"==typeof r){var a=r(i);a&&(i=a)}var s=$(i,function(e,t){var i=s.response;!e&&i&&(s.responseTime=Date.now(),s.roundTripTime=s.responseTime-s.requestTime,s.bytesReceived=i.byteLength||i.length,s.bandwidth||(s.bandwidth=Math.floor(s.bytesReceived/s.roundTripTime*8*1e3))),t.headers&&(s.responseHeaders=t.headers),e&&"ETIMEDOUT"===e.code&&(s.timedout=!0),e||s.aborted||200===t.statusCode||206===t.statusCode||0===t.statusCode||(e=new Error("XHR Failed with a response of: "+(s&&(i||s.responseText)))),n(e,s)}),o=s.abort;return s.abort=function(){return s.aborted=!0,o.apply(s,arguments)},s.uri=i.uri,s.requestTime=Date.now(),s}},J=function(e){var t,i,n={};return e.byterange&&(n.Range=(t=e.byterange,i=t.offset+t.length-1,"bytes="+t.offset+"-"+i)),n};var Z=function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")},ee=function(){function e(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}return function(t,i,n){return i&&e(t.prototype,i),n&&e(t,n),t}}(),te=function(e,t){if(!e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return!t||"object"!=typeof t&&"function"!=typeof t?e:t},ie=function(){var e=[[[],[],[],[],[]],[[],[],[],[],[]]],t=e[0],i=e[1],n=t[4],r=i[4],a=void 0,s=void 0,o=void 0,u=[],d=[],l=void 0,c=void 0,h=void 0,f=void 0,p=void 0;for(a=0;a<256;a++)d[(u[a]=a<<1^283*(a>>7))^a]=a;for(s=o=0;!n[s];s^=l||1,o=d[o]||1)for(h=(h=o^o<<1^o<<2^o<<3^o<<4)>>8^255&h^99,n[s]=h,r[h]=s,p=16843009*u[c=u[l=u[s]]]^65537*c^257*l^16843008*s,f=257*u[h]^16843008*h,a=0;a<4;a++)t[a][s]=f=f<<24^f>>>8,i[a][h]=p=p<<24^p>>>8;for(a=0;a<5;a++)t[a]=t[a].slice(0),i[a]=i[a].slice(0);return e},ne=null,re=function(){function e(t){Z(this,e),ne||(ne=ie()),this._tables=[[ne[0][0].slice(),ne[0][1].slice(),ne[0][2].slice(),ne[0][3].slice(),ne[0][4].slice()],[ne[1][0].slice(),ne[1][1].slice(),ne[1][2].slice(),ne[1][3].slice(),ne[1][4].slice()]];var i=void 0,n=void 0,r=void 0,a=void 0,s=void 0,o=this._tables[0][4],u=this._tables[1],d=t.length,l=1;if(4!==d&&6!==d&&8!==d)throw new Error("Invalid aes key size");for(a=t.slice(0),s=[],this._key=[a,s],i=d;i<4*d+28;i++)r=a[i-1],(i%d==0||8===d&&i%d==4)&&(r=o[r>>>24]<<24^o[r>>16&255]<<16^o[r>>8&255]<<8^o[255&r],i%d==0&&(r=r<<8^r>>>24^l<<24,l=l<<1^283*(l>>7))),a[i]=a[i-d]^r;for(n=0;i;n++,i--)r=a[3&n?i:i-4],s[n]=i<=4||n<4?r:u[0][o[r>>>24]]^u[1][o[r>>16&255]]^u[2][o[r>>8&255]]^u[3][o[255&r]]}return e.prototype.decrypt=function(e,t,i,n,r,a){var s=this._key[1],o=e^s[0],u=n^s[1],d=i^s[2],l=t^s[3],c=void 0,h=void 0,f=void 0,p=s.length/4-2,m=void 0,g=4,y=this._tables[1],_=y[0],v=y[1],b=y[2],T=y[3],S=y[4];for(m=0;m<p;m++)c=_[o>>>24]^v[u>>16&255]^b[d>>8&255]^T[255&l]^s[g],h=_[u>>>24]^v[d>>16&255]^b[l>>8&255]^T[255&o]^s[g+1],f=_[d>>>24]^v[l>>16&255]^b[o>>8&255]^T[255&u]^s[g+2],l=_[l>>>24]^v[o>>16&255]^b[u>>8&255]^T[255&d]^s[g+3],g+=4,o=c,u=h,d=f;for(m=0;m<4;m++)r[(3&-m)+a]=S[o>>>24]<<24^S[u>>16&255]<<16^S[d>>8&255]<<8^S[255&l]^s[g++],c=o,o=u,u=d,d=l,l=c},e}(),ae=function(){function e(){Z(this,e),this.listeners={}}return e.prototype.on=function(e,t){this.listeners[e]||(this.listeners[e]=[]),this.listeners[e].push(t)},e.prototype.off=function(e,t){if(!this.listeners[e])return!1;var i=this.listeners[e].indexOf(t);return this.listeners[e].splice(i,1),i>-1},e.prototype.trigger=function(e){var t=this.listeners[e];if(t)if(2===arguments.length)for(var i=t.length,n=0;n<i;++n)t[n].call(this,arguments[1]);else for(var r=Array.prototype.slice.call(arguments,1),a=t.length,s=0;s<a;++s)t[s].apply(this,r)},e.prototype.dispose=function(){this.listeners={}},e.prototype.pipe=function(e){this.on("data",function(t){e.push(t)})},e}(),se=function(e){function t(){Z(this,t);var i=te(this,e.call(this,ae));return i.jobs=[],i.delay=1,i.timeout_=null,i}return function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function, not "+typeof t);e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}}),t&&(Object.setPrototypeOf?Object.setPrototypeOf(e,t):e.__proto__=t)}(t,e),t.prototype.processJob_=function(){this.jobs.shift()(),this.jobs.length?this.timeout_=setTimeout(this.processJob_.bind(this),this.delay):this.timeout_=null},t.prototype.push=function(e){this.jobs.push(e),this.timeout_||(this.timeout_=setTimeout(this.processJob_.bind(this),this.delay))},t}(ae),oe=function(e){return e<<24|(65280&e)<<8|(16711680&e)>>8|e>>>24},ue=function(e,t,i){var n=new Int32Array(e.buffer,e.byteOffset,e.byteLength>>2),r=new re(Array.prototype.slice.call(t)),a=new Uint8Array(e.byteLength),s=new Int32Array(a.buffer),o=void 0,u=void 0,d=void 0,l=void 0,c=void 0,h=void 0,f=void 0,p=void 0,m=void 0;for(o=i[0],u=i[1],d=i[2],l=i[3],m=0;m<n.length;m+=4)c=oe(n[m]),h=oe(n[m+1]),f=oe(n[m+2]),p=oe(n[m+3]),r.decrypt(c,h,f,p,s,m),s[m]=oe(s[m]^o),s[m+1]=oe(s[m+1]^u),s[m+2]=oe(s[m+2]^d),s[m+3]=oe(s[m+3]^l),o=c,u=h,d=f,l=p;return a},de=function(){function e(t,i,n,r){Z(this,e);var a=e.STEP,s=new Int32Array(t.buffer),o=new Uint8Array(t.byteLength),u=0;for(this.asyncStream_=new se,this.asyncStream_.push(this.decryptChunk_(s.subarray(u,u+a),i,n,o)),u=a;u<s.length;u+=a)n=new Uint32Array([oe(s[u-4]),oe(s[u-3]),oe(s[u-2]),oe(s[u-1])]),this.asyncStream_.push(this.decryptChunk_(s.subarray(u,u+a),i,n,o));this.asyncStream_.push(function(){var e;r(null,(e=o).subarray(0,e.byteLength-e[e.byteLength-1]))})}return e.prototype.decryptChunk_=function(e,t,i,n){return function(){var r=ue(e,t,i);n.set(r,e.byteOffset)}},ee(e,null,[{key:"STEP",get:function(){return 32e3}}]),e}(),le=function(e,t){return e.start(t)+"-"+e.end(t)},ce=function(e,t){var i=e.toString(16);return"00".substring(0,2-i.length)+i+(t%2?" ":"")},he=function(e){return e>=32&&e<126?String.fromCharCode(e):"."},fe=function(e){var t={};return Object.keys(e).forEach(function(i){var n=e[i];ArrayBuffer.isView(n)?t[i]={bytes:n.buffer,byteOffset:n.byteOffset,byteLength:n.byteLength}:t[i]=n}),t},pe=function(e){var t=e.byterange||{length:1/0,offset:0};return[t.length,t.offset,e.resolvedUri].join(",")},me=function(e){return e.resolvedUri},ge=function(e){for(var t=Array.prototype.slice.call(e),i="",n=0;n<t.length/16;n++)i+=t.slice(16*n,16*n+16).map(ce).join("")+" "+t.slice(16*n,16*n+16).map(he).join("")+"\n";return i},ye=Object.freeze({createTransferableMessage:fe,initSegmentId:pe,segmentKeyId:me,hexDump:ge,tagDump:function(e){var t=e.bytes;return ge(t)},textRanges:function(e){var t="",i=void 0;for(i=0;i<e.length;i++)t+=le(e,i)+" ";return t}}),_e=function(e){var t=e.playlist,i=e.time,n=void 0===i?void 0:i,r=e.callback;if(!r)throw new Error("getProgramTime: callback must be provided");if(!t||void 0===n)return r({message:"getProgramTime: playlist and time must be provided"});var a=function(e,t){if(!t||!t.segments||0===t.segments.length)return null;for(var i=0,n=void 0,r=0;r<t.segments.length&&!(e<=(i=(n=t.segments[r]).videoTimingInfo?n.videoTimingInfo.transmuxedPresentationEnd:i+n.duration));r++);var a=t.segments[t.segments.length-1];if(a.videoTimingInfo&&a.videoTimingInfo.transmuxedPresentationEnd<e)return null;if(e>i){if(e>i+.25*a.duration)return null;n=a}return{segment:n,estimatedStart:n.videoTimingInfo?n.videoTimingInfo.transmuxedPresentationStart:i-n.duration,type:n.videoTimingInfo?"accurate":"estimate"}}(n,t);if(!a)return r({message:"valid programTime was not found"});if("estimate"===a.type)return r({message:"Accurate programTime could not be determined. Please seek to e.seekTime and try again",seekTime:a.estimatedStart});var s={mediaSeconds:n},o=function(e,t){if(!t.dateTimeObject)return null;var i=t.videoTimingInfo.transmuxerPrependedSeconds,n=e-(t.videoTimingInfo.transmuxedPresentationStart+i);return new Date(t.dateTimeObject.getTime()+1e3*n)}(n,a.segment);return o&&(s.programDateTime=o.toISOString()),r(null,s)},ve=function e(t){var i=t.programTime,n=t.playlist,r=t.retryCount,a=void 0===r?2:r,s=t.seekTo,o=t.pauseAfterSeek,u=void 0===o||o,d=t.tech,l=t.callback;if(!l)throw new Error("seekToProgramTime: callback must be provided");if(void 0===i||!n||!s)return l({message:"seekToProgramTime: programTime, seekTo and playlist must be provided"});if(!n.endList&&!d.hasStarted_)return l({message:"player must be playing a live stream to start buffering"});if(!function(e){if(!e.segments||0===e.segments.length)return!1;for(var t=0;t<e.segments.length;t++)if(!e.segments[t].dateTimeObject)return!1;return!0}(n))return l({message:"programDateTime tags must be provided in the manifest "+n.resolvedUri});var c=function(e,t){var i=void 0;try{i=new Date(e)}catch(e){return null}if(!t||!t.segments||0===t.segments.length)return null;var n=t.segments[0];if(i<n.dateTimeObject)return null;for(var r=0;r<t.segments.length-1&&(n=t.segments[r],!(i<t.segments[r+1].dateTimeObject));r++);var a,s=t.segments[t.segments.length-1],o=s.dateTimeObject,u=s.videoTimingInfo?(a=s.videoTimingInfo).transmuxedPresentationEnd-a.transmuxedPresentationStart-a.transmuxerPrependedSeconds:s.duration+.25*s.duration;return i>new Date(o.getTime()+1e3*u)?null:(i>o&&(n=s),{segment:n,estimatedStart:n.videoTimingInfo?n.videoTimingInfo.transmuxedPresentationStart:Y.duration(t,t.mediaSequence+t.segments.indexOf(n)),type:n.videoTimingInfo?"accurate":"estimate"})}(i,n);if(!c)return l({message:i+" was not found in the stream"});var h=c.segment,f=function(e,t){var i=void 0,n=void 0;try{i=new Date(e),n=new Date(t)}catch(e){}var r=i.getTime();return(n.getTime()-r)/1e3}(h.dateTimeObject,i);if("estimate"===c.type)return 0===a?l({message:i+" is not buffered yet. Try again"}):(s(c.estimatedStart+f),void d.one("seeked",function(){e({programTime:i,playlist:n,retryCount:a-1,seekTo:s,pauseAfterSeek:u,tech:d,callback:l})}));var p=h.start+f;d.one("seeked",function(){return l(null,d.currentTime())}),u&&d.pause(),s(p)},be=function(e,i){var n=[],r=void 0;if(e&&e.length)for(r=0;r<e.length;r++)i(e.start(r),e.end(r))&&n.push([e.start(r),e.end(r)]);return t.createTimeRanges(n)},Te=function(e,t){return be(e,function(e,i){return e-.1<=t&&i+.1>=t})},Se=function(e,t){return be(e,function(e){return e-1/30>=t})},we=function(e){var t=[];if(!e||!e.length)return"";for(var i=0;i<e.length;i++)t.push(e.start(i)+" => "+e.end(i));return t.join(", ")},ke=function(e){for(var t=[],i=0;i<e.length;i++)t.push({start:e.start(i),end:e.end(i)});return t},Ee=function(e,t,i){var n=void 0,r=void 0;if(i&&i.cues)for(n=i.cues.length;n--;)(r=i.cues[n]).startTime<=t&&r.endTime>=e&&i.removeCue(r)},Ie=function(e){return isNaN(e)||Math.abs(e)===1/0?Number.MAX_VALUE:e},Ae=function(e,i,n){var r=u.WebKitDataCue||u.VTTCue;if(i&&i.forEach(function(e){var t=e.stream;this.inbandTextTracks_[t].addCue(new r(e.startTime+this.timestampOffset,e.endTime+this.timestampOffset,e.text))},e),n){var a=Ie(e.mediaSource_.duration);if(n.forEach(function(e){var i=e.cueTime+this.timestampOffset;!("number"!=typeof i||u.isNaN(i)||i<0)&&i<1/0&&e.frames.forEach(function(e){var n=new r(i,i,e.value||e.url||e.data||"");n.frame=e,n.value=e,function(e){Object.defineProperties(e.frame,{id:{get:function(){return t.log.warn("cue.frame.id is deprecated. Use cue.value.key instead."),e.value.key}},value:{get:function(){return t.log.warn("cue.frame.value is deprecated. Use cue.value.data instead."),e.value.data}},privateData:{get:function(){return t.log.warn("cue.frame.privateData is deprecated. Use cue.value.data instead."),e.value.data}}})}(n),this.metadataTrack_.addCue(n)},this)},e),e.metadataTrack_&&e.metadataTrack_.cues&&e.metadataTrack_.cues.length){for(var s=e.metadataTrack_.cues,o=[],d=0;d<s.length;d++)s[d]&&o.push(s[d]);var l=o.reduce(function(e,t){var i=e[t.startTime]||[];return i.push(t),e[t.startTime]=i,e},{}),c=Object.keys(l).sort(function(e,t){return Number(e)-Number(t)});c.forEach(function(e,t){var i=l[e],n=Number(c[t+1])||a;i.forEach(function(e){e.endTime=n})})}}},Le="undefined"!=typeof window?window:{},Ce="undefined"==typeof Symbol?"__target":Symbol(),Ue="application/javascript",Oe=Le.BlobBuilder||Le.WebKitBlobBuilder||Le.MozBlobBuilder||Le.MSBlobBuilder,De=Le.URL||Le.webkitURL||De&&De.msURL,Pe=Le.Worker;function Re(e,t){return function(i){var n=this;if(!t)return new Pe(e);if(Pe&&!i){var r=Be(t.toString().replace(/^function.+?{/,"").slice(0,-1));return this[Ce]=new Pe(r),function(e,t){if(!e||!t)return;var i=e.terminate;e.objURL=t,e.terminate=function(){e.objURL&&De.revokeObjectURL(e.objURL),i.call(e)}}(this[Ce],r),this[Ce]}var a={postMessage:function(e){n.onmessage&&setTimeout(function(){n.onmessage({data:e,target:a})})}};t.call(a),this.postMessage=function(e){setTimeout(function(){a.onmessage({data:e,target:n})})},this.isThisThread=!0}}if(Pe){var xe,Ne=Be("self.onmessage = function () {}"),Me=new Uint8Array(1);try{(xe=new Pe(Ne)).postMessage(Me,[Me.buffer])}catch(e){Pe=null}finally{De.revokeObjectURL(Ne),xe&&xe.terminate()}}function Be(e){try{return De.createObjectURL(new Blob([e],{type:Ue}))}catch(i){var t=new Oe;return t.append(e),De.createObjectURL(t.getBlob(type))}}var qe=new Re("./transmuxer-worker.worker.js",function(e,t){var i=this;!function(){var e=function(){this.init=function(){var e={};this.on=function(t,i){e[t]||(e[t]=[]),e[t]=e[t].concat(i)},this.off=function(t,i){var n;return!!e[t]&&(n=e[t].indexOf(i),e[t]=e[t].slice(),e[t].splice(n,1),n>-1)},this.trigger=function(t){var i,n,r,a;if(i=e[t])if(2===arguments.length)for(r=i.length,n=0;n<r;++n)i[n].call(this,arguments[1]);else{for(a=[],n=arguments.length,n=1;n<arguments.length;++n)a.push(arguments[n]);for(r=i.length,n=0;n<r;++n)i[n].apply(this,a)}},this.dispose=function(){e={}}}};e.prototype.pipe=function(e){return this.on("data",function(t){e.push(t)}),this.on("done",function(t){e.flush(t)}),this.on("partialdone",function(t){e.partialFlush(t)}),this.on("endedtimeline",function(t){e.endTimeline(t)}),this.on("reset",function(t){e.reset(t)}),e},e.prototype.push=function(e){this.trigger("data",e)},e.prototype.flush=function(e){this.trigger("done",e)},e.prototype.partialFlush=function(e){this.trigger("partialdone",e)},e.prototype.endTimeline=function(e){this.trigger("endedtimeline",e)},e.prototype.reset=function(e){this.trigger("reset",e)};var t,n,r,a,s,o,u,d,l,c,h,f,p,m,g,y,_,v,b,T,S,w,k,E,I,A,L,C,U,O,D,P,R,x,N,M,B,q,F,H,j=e,V=Math.pow(2,32)-1;!function(){var e;if(w={avc1:[],avcC:[],btrt:[],dinf:[],dref:[],esds:[],ftyp:[],hdlr:[],mdat:[],mdhd:[],mdia:[],mfhd:[],minf:[],moof:[],moov:[],mp4a:[],mvex:[],mvhd:[],pasp:[],sdtp:[],smhd:[],stbl:[],stco:[],stsc:[],stsd:[],stsz:[],stts:[],styp:[],tfdt:[],tfhd:[],traf:[],trak:[],trun:[],trex:[],tkhd:[],vmhd:[]},"undefined"!=typeof Uint8Array){for(e in w)w.hasOwnProperty(e)&&(w[e]=[e.charCodeAt(0),e.charCodeAt(1),e.charCodeAt(2),e.charCodeAt(3)]);k=new Uint8Array(["i".charCodeAt(0),"s".charCodeAt(0),"o".charCodeAt(0),"m".charCodeAt(0)]),I=new Uint8Array(["a".charCodeAt(0),"v".charCodeAt(0),"c".charCodeAt(0),"1".charCodeAt(0)]),E=new Uint8Array([0,0,0,1]),A=new Uint8Array([0,0,0,0,0,0,0,0,118,105,100,101,0,0,0,0,0,0,0,0,0,0,0,0,86,105,100,101,111,72,97,110,100,108,101,114,0]),L=new Uint8Array([0,0,0,0,0,0,0,0,115,111,117,110,0,0,0,0,0,0,0,0,0,0,0,0,83,111,117,110,100,72,97,110,100,108,101,114,0]),C={video:A,audio:L},D=new Uint8Array([0,0,0,0,0,0,0,1,0,0,0,12,117,114,108,32,0,0,0,1]),O=new Uint8Array([0,0,0,0,0,0,0,0]),P=new Uint8Array([0,0,0,0,0,0,0,0]),R=P,x=new Uint8Array([0,0,0,0,0,0,0,0,0,0,0,0]),N=P,U=new Uint8Array([0,0,0,1,0,0,0,0,0,0,0,0])}}(),t=function(e){var t,i,n=[],r=0;for(t=1;t<arguments.length;t++)n.push(arguments[t]);for(t=n.length;t--;)r+=n[t].byteLength;for(i=new Uint8Array(r+8),new DataView(i.buffer,i.byteOffset,i.byteLength).setUint32(0,i.byteLength),i.set(e,4),t=0,r=8;t<n.length;t++)i.set(n[t],r),r+=n[t].byteLength;return i},n=function(){return t(w.dinf,t(w.dref,D))},r=function(e){return t(w.esds,new Uint8Array([0,0,0,0,3,25,0,0,0,4,17,64,21,0,6,0,0,0,218,192,0,0,218,192,5,2,e.audioobjecttype<<3|e.samplingfrequencyindex>>>1,e.samplingfrequencyindex<<7|e.channelcount<<3,6,1,2]))},g=function(e){return t(w.hdlr,C[e])},m=function(e){var i=new Uint8Array([0,0,0,0,0,0,0,2,0,0,0,3,0,1,95,144,e.duration>>>24&255,e.duration>>>16&255,e.duration>>>8&255,255&e.duration,85,196,0,0]);return e.samplerate&&(i[12]=e.samplerate>>>24&255,i[13]=e.samplerate>>>16&255,i[14]=e.samplerate>>>8&255,i[15]=255&e.samplerate),t(w.mdhd,i)},p=function(e){return t(w.mdia,m(e),g(e.type),o(e))},s=function(e){return t(w.mfhd,new Uint8Array([0,0,0,0,(4278190080&e)>>24,(16711680&e)>>16,(65280&e)>>8,255&e]))},o=function(e){return t(w.minf,"video"===e.type?t(w.vmhd,U):t(w.smhd,O),n(),_(e))},u=function(e,i){for(var n=[],r=i.length;r--;)n[r]=b(i[r]);return t.apply(null,[w.moof,s(e)].concat(n))},d=function(e){for(var i=e.length,n=[];i--;)n[i]=h(e[i]);return t.apply(null,[w.moov,c(4294967295)].concat(n).concat(l(e)))},l=function(e){for(var i=e.length,n=[];i--;)n[i]=T(e[i]);return t.apply(null,[w.mvex].concat(n))},c=function(e){var i=new Uint8Array([0,0,0,0,0,0,0,1,0,0,0,2,0,1,95,144,(4278190080&e)>>24,(16711680&e)>>16,(65280&e)>>8,255&e,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255]);return t(w.mvhd,i)},y=function(e){var i,n,r=e.samples||[],a=new Uint8Array(4+r.length);for(n=0;n<r.length;n++)i=r[n].flags,a[n+4]=i.dependsOn<<4|i.isDependedOn<<2|i.hasRedundancy;return t(w.sdtp,a)},_=function(e){return t(w.stbl,v(e),t(w.stts,N),t(w.stsc,R),t(w.stsz,x),t(w.stco,P))},v=function(e){return t(w.stsd,new Uint8Array([0,0,0,0,0,0,0,1]),"video"===e.type?M(e):B(e))},M=function(e){var i,n,r=e.sps||[],a=e.pps||[],s=[],o=[];for(i=0;i<r.length;i++)s.push((65280&r[i].byteLength)>>>8),s.push(255&r[i].byteLength),s=s.concat(Array.prototype.slice.call(r[i]));for(i=0;i<a.length;i++)o.push((65280&a[i].byteLength)>>>8),o.push(255&a[i].byteLength),o=o.concat(Array.prototype.slice.call(a[i]));if(n=[w.avc1,new Uint8Array([0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,(65280&e.width)>>8,255&e.width,(65280&e.height)>>8,255&e.height,0,72,0,0,0,72,0,0,0,0,0,0,0,1,19,118,105,100,101,111,106,115,45,99,111,110,116,114,105,98,45,104,108,115,0,0,0,0,0,0,0,0,0,0,0,0,0,24,17,17]),t(w.avcC,new Uint8Array([1,e.profileIdc,e.profileCompatibility,e.levelIdc,255].concat([r.length],s,[a.length],o))),t(w.btrt,new Uint8Array([0,28,156,128,0,45,198,192,0,45,198,192]))],e.sarRatio){var u=e.sarRatio[0],d=e.sarRatio[1];n.push(t(w.pasp,new Uint8Array([(4278190080&u)>>24,(16711680&u)>>16,(65280&u)>>8,255&u,(4278190080&d)>>24,(16711680&d)>>16,(65280&d)>>8,255&d])))}return t.apply(null,n)},B=function(e){return t(w.mp4a,new Uint8Array([0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,(65280&e.channelcount)>>8,255&e.channelcount,(65280&e.samplesize)>>8,255&e.samplesize,0,0,0,0,(65280&e.samplerate)>>8,255&e.samplerate,0,0]),r(e))},f=function(e){var i=new Uint8Array([0,0,0,7,0,0,0,0,0,0,0,0,(4278190080&e.id)>>24,(16711680&e.id)>>16,(65280&e.id)>>8,255&e.id,0,0,0,0,(4278190080&e.duration)>>24,(16711680&e.duration)>>16,(65280&e.duration)>>8,255&e.duration,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,0,0,(65280&e.width)>>8,255&e.width,0,0,(65280&e.height)>>8,255&e.height,0,0]);return t(w.tkhd,i)},b=function(e){var i,n,r,a,s,o;return i=t(w.tfhd,new Uint8Array([0,0,0,58,(4278190080&e.id)>>24,(16711680&e.id)>>16,(65280&e.id)>>8,255&e.id,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0])),s=Math.floor(e.baseMediaDecodeTime/(V+1)),o=Math.floor(e.baseMediaDecodeTime%(V+1)),n=t(w.tfdt,new Uint8Array([1,0,0,0,s>>>24&255,s>>>16&255,s>>>8&255,255&s,o>>>24&255,o>>>16&255,o>>>8&255,255&o])),92,"audio"===e.type?(r=S(e,92),t(w.traf,i,n,r)):(a=y(e),r=S(e,a.length+92),t(w.traf,i,n,r,a))},h=function(e){return e.duration=e.duration||4294967295,t(w.trak,f(e),p(e))},T=function(e){var i=new Uint8Array([0,0,0,0,(4278190080&e.id)>>24,(16711680&e.id)>>16,(65280&e.id)>>8,255&e.id,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,1]);return"video"!==e.type&&(i[i.length-1]=0),t(w.trex,i)},H=function(e,t){var i=0,n=0,r=0,a=0;return e.length&&(void 0!==e[0].duration&&(i=1),void 0!==e[0].size&&(n=2),void 0!==e[0].flags&&(r=4),void 0!==e[0].compositionTimeOffset&&(a=8)),[0,0,i|n|r|a,1,(4278190080&e.length)>>>24,(16711680&e.length)>>>16,(65280&e.length)>>>8,255&e.length,(4278190080&t)>>>24,(16711680&t)>>>16,(65280&t)>>>8,255&t]},F=function(e,i){var n,r,a,s;for(i+=20+16*(r=e.samples||[]).length,n=H(r,i),s=0;s<r.length;s++)a=r[s],n=n.concat([(4278190080&a.duration)>>>24,(16711680&a.duration)>>>16,(65280&a.duration)>>>8,255&a.duration,(4278190080&a.size)>>>24,(16711680&a.size)>>>16,(65280&a.size)>>>8,255&a.size,a.flags.isLeading<<2|a.flags.dependsOn,a.flags.isDependedOn<<6|a.flags.hasRedundancy<<4|a.flags.paddingValue<<1|a.flags.isNonSyncSample,61440&a.flags.degradationPriority,15&a.flags.degradationPriority,(4278190080&a.compositionTimeOffset)>>>24,(16711680&a.compositionTimeOffset)>>>16,(65280&a.compositionTimeOffset)>>>8,255&a.compositionTimeOffset]);return t(w.trun,new Uint8Array(n))},q=function(e,i){var n,r,a,s;for(i+=20+8*(r=e.samples||[]).length,n=H(r,i),s=0;s<r.length;s++)a=r[s],n=n.concat([(4278190080&a.duration)>>>24,(16711680&a.duration)>>>16,(65280&a.duration)>>>8,255&a.duration,(4278190080&a.size)>>>24,(16711680&a.size)>>>16,(65280&a.size)>>>8,255&a.size]);return t(w.trun,new Uint8Array(n))},S=function(e,t){return"audio"===e.type?q(e,t):F(e,t)};a=function(){return t(w.ftyp,k,E,k,I)};var G,W,z,X,Y,$=function(e){return t(w.mdat,e)},K=u,Q=function(e){var t,i=a(),n=d(e);return(t=new Uint8Array(i.byteLength+n.byteLength)).set(i),t.set(n,i.byteLength),t},J=function(e,t){var i={size:0,flags:{isLeading:0,dependsOn:1,isDependedOn:0,hasRedundancy:0,degradationPriority:0,isNonSyncSample:1}};return i.dataOffset=t,i.compositionTimeOffset=e.pts-e.dts,i.duration=e.duration,i.size=4*e.length,i.size+=e.byteLength,e.keyFrame&&(i.flags.dependsOn=2,i.flags.isNonSyncSample=0),i},Z=function(e){var t,i,n=[],r=[];for(r.byteLength=0,r.nalCount=0,r.duration=0,n.byteLength=0,t=0;t<e.length;t++)"access_unit_delimiter_rbsp"===(i=e[t]).nalUnitType?(n.length&&(n.duration=i.dts-n.dts,r.byteLength+=n.byteLength,r.nalCount+=n.length,r.duration+=n.duration,r.push(n)),(n=[i]).byteLength=i.data.byteLength,n.pts=i.pts,n.dts=i.dts):("slice_layer_without_partitioning_rbsp_idr"===i.nalUnitType&&(n.keyFrame=!0),n.duration=i.dts-n.dts,n.byteLength+=i.data.byteLength,n.push(i));return r.length&&(!n.duration||n.duration<=0)&&(n.duration=r[r.length-1].duration),r.byteLength+=n.byteLength,r.nalCount+=n.length,r.duration+=n.duration,r.push(n),r},ee=function(e){var t,i,n=[],r=[];for(n.byteLength=0,n.nalCount=0,n.duration=0,n.pts=e[0].pts,n.dts=e[0].dts,r.byteLength=0,r.nalCount=0,r.duration=0,r.pts=e[0].pts,r.dts=e[0].dts,t=0;t<e.length;t++)(i=e[t]).keyFrame?(n.length&&(r.push(n),r.byteLength+=n.byteLength,r.nalCount+=n.nalCount,r.duration+=n.duration),(n=[i]).nalCount=i.length,n.byteLength=i.byteLength,n.pts=i.pts,n.dts=i.dts,n.duration=i.duration):(n.duration+=i.duration,n.nalCount+=i.length,n.byteLength+=i.byteLength,n.push(i));return r.length&&n.duration<=0&&(n.duration=r[r.length-1].duration),r.byteLength+=n.byteLength,r.nalCount+=n.nalCount,r.duration+=n.duration,r.push(n),r},te=function(e){var t;return!e[0][0].keyFrame&&e.length>1&&(t=e.shift(),e.byteLength-=t.byteLength,e.nalCount-=t.nalCount,e[0][0].dts=t.dts,e[0][0].pts=t.pts,e[0][0].duration+=t.duration),e},ie=function(e,t){var i,n,r,a,s,o=t||0,u=[];for(i=0;i<e.length;i++)for(a=e[i],n=0;n<a.length;n++)s=a[n],o+=(r=J(s,o)).size,u.push(r);return u},ne=function(e){var t,i,n,r,a,s,o=0,u=e.byteLength,d=e.nalCount,l=new Uint8Array(u+4*d),c=new DataView(l.buffer);for(t=0;t<e.length;t++)for(r=e[t],i=0;i<r.length;i++)for(a=r[i],n=0;n<a.length;n++)s=a[n],c.setUint32(o,s.data.byteLength),o+=4,l.set(s.data,o),o+=s.data.byteLength;return l},re=[33,16,5,32,164,27],ae=[33,65,108,84,1,2,4,8,168,2,4,8,17,191,252],se=function(e){for(var t=[];e--;)t.push(0);return t},oe={96000:[re,[227,64],se(154),[56]],88200:[re,[231],se(170),[56]],64000:[re,[248,192],se(240),[56]],48000:[re,[255,192],se(268),[55,148,128],se(54),[112]],44100:[re,[255,192],se(268),[55,163,128],se(84),[112]],32000:[re,[255,192],se(268),[55,234],se(226),[112]],24000:[re,[255,192],se(268),[55,255,128],se(268),[111,112],se(126),[224]],16000:[re,[255,192],se(268),[55,255,128],se(268),[111,255],se(269),[223,108],se(195),[1,192]],12000:[ae,se(268),[3,127,248],se(268),[6,255,240],se(268),[13,255,224],se(268),[27,253,128],se(259),[56]],11025:[ae,se(268),[3,127,248],se(268),[6,255,240],se(268),[13,255,224],se(268),[27,255,192],se(268),[55,175,128],se(108),[112]],8000:[ae,se(268),[3,121,16],se(47),[7]]},ue=(G=oe,Object.keys(G).reduce(function(e,t){return e[t]=new Uint8Array(G[t].reduce(function(e,t){return e.concat(t)},[])),e},{})),de=9e4,le=(W=function(e){return 9e4*e},z=function(e,t){return e*t},X=function(e){return e/9e4},Y=function(e,t){return e/t},function(e,t){return W(Y(e,t))}),ce=function(e,t){return z(X(e),t)},he=function(e,t,i){return X(i?e:e-t)},fe=function(e,t,i,n){var r,a,s,o,u,d=0,l=0,c=0;if(t.length&&(r=le(e.baseMediaDecodeTime,e.samplerate),a=Math.ceil(de/(e.samplerate/1024)),i&&n&&(d=r-Math.max(i,n),c=(l=Math.floor(d/a))*a),!(l<1||c>de/2))){for((s=ue[e.samplerate])||(s=t[0].data),o=0;o<l;o++)u=t[0],t.splice(0,0,{data:s,dts:u.dts-a,pts:u.pts-a});e.baseMediaDecodeTime-=Math.floor(ce(c,e.samplerate))}},pe=function(e,t,i){return t.minSegmentDts>=i?e:(t.minSegmentDts=1/0,e.filter(function(e){return e.dts>=i&&(t.minSegmentDts=Math.min(t.minSegmentDts,e.dts),t.minSegmentPts=t.minSegmentDts,!0)}))},me=function(e){var t,i,n=[];for(t=0;t<e.length;t++)i=e[t],n.push({size:i.data.byteLength,duration:1024});return n},ge=function(e){var t,i,n=0,r=new Uint8Array(function(e){var t,i=0;for(t=0;t<e.length;t++)i+=e[t].data.byteLength;return i}(e));for(t=0;t<e.length;t++)i=e[t],r.set(i.data,n),n+=i.data.byteLength;return r},ye=de,_e=function(e){delete e.minSegmentDts,delete e.maxSegmentDts,delete e.minSegmentPts,delete e.maxSegmentPts},ve=function(e,t){var i,n=e.minSegmentDts;return t||(n-=e.timelineStartInfo.dts),i=e.timelineStartInfo.baseMediaDecodeTime,i+=n,i=Math.max(0,i),"audio"===e.type&&(i*=e.samplerate/ye,i=Math.floor(i)),i},be=function(e,t){"number"==typeof t.pts&&(void 0===e.timelineStartInfo.pts&&(e.timelineStartInfo.pts=t.pts),void 0===e.minSegmentPts?e.minSegmentPts=t.pts:e.minSegmentPts=Math.min(e.minSegmentPts,t.pts),void 0===e.maxSegmentPts?e.maxSegmentPts=t.pts:e.maxSegmentPts=Math.max(e.maxSegmentPts,t.pts)),"number"==typeof t.dts&&(void 0===e.timelineStartInfo.dts&&(e.timelineStartInfo.dts=t.dts),void 0===e.minSegmentDts?e.minSegmentDts=t.dts:e.minSegmentDts=Math.min(e.minSegmentDts,t.dts),void 0===e.maxSegmentDts?e.maxSegmentDts=t.dts:e.maxSegmentDts=Math.max(e.maxSegmentDts,t.dts))},Te=function(e){for(var t=0,i={payloadType:-1,payloadSize:0},n=0,r=0;t<e.byteLength&&128!==e[t];){for(;255===e[t];)n+=255,t++;for(n+=e[t++];255===e[t];)r+=255,t++;if(r+=e[t++],!i.payload&&4===n){i.payloadType=n,i.payloadSize=r,i.payload=e.subarray(t,t+r);break}t+=r,n=0,r=0}return i},Se=function(e){return 181!==e.payload[0]?null:49!=(e.payload[1]<<8|e.payload[2])?null:"GA94"!==String.fromCharCode(e.payload[3],e.payload[4],e.payload[5],e.payload[6])?null:3!==e.payload[7]?null:e.payload.subarray(8,e.payload.length-1)},we=function(e,t){var i,n,r,a,s=[];if(!(64&t[0]))return s;for(n=31&t[0],i=0;i<n;i++)a={type:3&t[2+(r=3*i)],pts:e},4&t[r+2]&&(a.ccData=t[r+3]<<8|t[r+4],s.push(a));return s},ke=4,Ee=function e(){e.prototype.init.call(this),this.captionPackets_=[],this.ccStreams_=[new Ue(0,0),new Ue(0,1),new Ue(1,0),new Ue(1,1)],this.reset(),this.ccStreams_.forEach(function(e){e.on("data",this.trigger.bind(this,"data")),e.on("partialdone",this.trigger.bind(this,"partialdone")),e.on("done",this.trigger.bind(this,"done"))},this)};(Ee.prototype=new j).push=function(e){var t,i,n;if("sei_rbsp"===e.nalUnitType&&(t=Te(e.escapedRBSP)).payloadType===ke&&(i=Se(t)))if(e.dts<this.latestDts_)this.ignoreNextEqualDts_=!0;else{if(e.dts===this.latestDts_&&this.ignoreNextEqualDts_)return this.numSameDts_--,void(this.numSameDts_||(this.ignoreNextEqualDts_=!1));n=we(e.pts,i),this.captionPackets_=this.captionPackets_.concat(n),this.latestDts_!==e.dts&&(this.numSameDts_=0),this.numSameDts_++,this.latestDts_=e.dts}},Ee.prototype.flushCCStreams=function(e){this.ccStreams_.forEach(function(t){return"flush"===e?t.flush():t.partialFlush()},this)},Ee.prototype.flushStream=function(e){this.captionPackets_.length?(this.captionPackets_.forEach(function(e,t){e.presortIndex=t}),this.captionPackets_.sort(function(e,t){return e.pts===t.pts?e.presortIndex-t.presortIndex:e.pts-t.pts}),this.captionPackets_.forEach(function(e){e.type<2&&this.dispatchCea608Packet(e)},this),this.captionPackets_.length=0,this.flushCCStreams(e)):this.flushCCStreams(e)},Ee.prototype.flush=function(){return this.flushStream("flush")},Ee.prototype.partialFlush=function(){return this.flushStream("partialFlush")},Ee.prototype.reset=function(){this.latestDts_=null,this.ignoreNextEqualDts_=!1,this.numSameDts_=0,this.activeCea608Channel_=[null,null],this.ccStreams_.forEach(function(e){e.reset()})},Ee.prototype.dispatchCea608Packet=function(e){this.setsTextOrXDSActive(e)?this.activeCea608Channel_[e.type]=null:this.setsChannel1Active(e)?this.activeCea608Channel_[e.type]=0:this.setsChannel2Active(e)&&(this.activeCea608Channel_[e.type]=1),null!==this.activeCea608Channel_[e.type]&&this.ccStreams_[(e.type<<1)+this.activeCea608Channel_[e.type]].push(e)},Ee.prototype.setsChannel1Active=function(e){return 4096==(30720&e.ccData)},Ee.prototype.setsChannel2Active=function(e){return 6144==(30720&e.ccData)},Ee.prototype.setsTextOrXDSActive=function(e){return 256==(28928&e.ccData)||4138==(30974&e.ccData)||6186==(30974&e.ccData)};var Ie={42:225,92:233,94:237,95:243,96:250,123:231,124:247,125:209,126:241,127:9608,304:174,305:176,306:189,307:191,308:8482,309:162,310:163,311:9834,312:224,313:160,314:232,315:226,316:234,317:238,318:244,319:251,544:193,545:201,546:211,547:218,548:220,549:252,550:8216,551:161,552:42,553:39,554:8212,555:169,556:8480,557:8226,558:8220,559:8221,560:192,561:194,562:199,563:200,564:202,565:203,566:235,567:206,568:207,569:239,570:212,571:217,572:249,573:219,574:171,575:187,800:195,801:227,802:205,803:204,804:236,805:210,806:242,807:213,808:245,809:123,810:125,811:92,812:94,813:95,814:124,815:126,816:196,817:228,818:214,819:246,820:223,821:165,822:164,823:9474,824:197,825:229,826:216,827:248,828:9484,829:9488,830:9492,831:9496},Ae=function(e){return null===e?"":(e=Ie[e]||e,String.fromCharCode(e))},Le=[4352,4384,4608,4640,5376,5408,5632,5664,5888,5920,4096,4864,4896,5120,5152],Ce=function(){for(var e=[],t=15;t--;)e.push("");return e},Ue=function e(t,i){e.prototype.init.call(this),this.field_=t||0,this.dataChannel_=i||0,this.name_="CC"+(1+(this.field_<<1|this.dataChannel_)),this.setConstants(),this.reset(),this.push=function(e){var t,i,n,r,a;if((t=32639&e.ccData)!==this.lastControlCode_){if(4096==(61440&t)?this.lastControlCode_=t:t!==this.PADDING_&&(this.lastControlCode_=null),n=t>>>8,r=255&t,t!==this.PADDING_)if(t===this.RESUME_CAPTION_LOADING_)this.mode_="popOn";else if(t===this.END_OF_CAPTION_)this.mode_="popOn",this.clearFormatting(e.pts),this.flushDisplayed(e.pts),i=this.displayed_,this.displayed_=this.nonDisplayed_,this.nonDisplayed_=i,this.startPts_=e.pts;else if(t===this.ROLL_UP_2_ROWS_)this.rollUpRows_=2,this.setRollUp(e.pts);else if(t===this.ROLL_UP_3_ROWS_)this.rollUpRows_=3,this.setRollUp(e.pts);else if(t===this.ROLL_UP_4_ROWS_)this.rollUpRows_=4,this.setRollUp(e.pts);else if(t===this.CARRIAGE_RETURN_)this.clearFormatting(e.pts),this.flushDisplayed(e.pts),this.shiftRowsUp_(),this.startPts_=e.pts;else if(t===this.BACKSPACE_)"popOn"===this.mode_?this.nonDisplayed_[this.row_]=this.nonDisplayed_[this.row_].slice(0,-1):this.displayed_[this.row_]=this.displayed_[this.row_].slice(0,-1);else if(t===this.ERASE_DISPLAYED_MEMORY_)this.flushDisplayed(e.pts),this.displayed_=Ce();else if(t===this.ERASE_NON_DISPLAYED_MEMORY_)this.nonDisplayed_=Ce();else if(t===this.RESUME_DIRECT_CAPTIONING_)"paintOn"!==this.mode_&&(this.flushDisplayed(e.pts),this.displayed_=Ce()),this.mode_="paintOn",this.startPts_=e.pts;else if(this.isSpecialCharacter(n,r))a=Ae((n=(3&n)<<8)|r),this[this.mode_](e.pts,a),this.column_++;else if(this.isExtCharacter(n,r))"popOn"===this.mode_?this.nonDisplayed_[this.row_]=this.nonDisplayed_[this.row_].slice(0,-1):this.displayed_[this.row_]=this.displayed_[this.row_].slice(0,-1),a=Ae((n=(3&n)<<8)|r),this[this.mode_](e.pts,a),this.column_++;else if(this.isMidRowCode(n,r))this.clearFormatting(e.pts),this[this.mode_](e.pts," "),this.column_++,14==(14&r)&&this.addFormatting(e.pts,["i"]),1==(1&r)&&this.addFormatting(e.pts,["u"]);else if(this.isOffsetControlCode(n,r))this.column_+=3&r;else if(this.isPAC(n,r)){var s=Le.indexOf(7968&t);"rollUp"===this.mode_&&(s-this.rollUpRows_+1<0&&(s=this.rollUpRows_-1),this.setRollUp(e.pts,s)),s!==this.row_&&(this.clearFormatting(e.pts),this.row_=s),1&r&&-1===this.formatting_.indexOf("u")&&this.addFormatting(e.pts,["u"]),16==(16&t)&&(this.column_=4*((14&t)>>1)),this.isColorPAC(r)&&14==(14&r)&&this.addFormatting(e.pts,["i"])}else this.isNormalChar(n)&&(0===r&&(r=null),a=Ae(n),a+=Ae(r),this[this.mode_](e.pts,a),this.column_+=a.length)}else this.lastControlCode_=null}};Ue.prototype=new j,Ue.prototype.flushDisplayed=function(e){var t=this.displayed_.map(function(e){try{return e.trim()}catch(e){return console.error("Skipping malformed caption."),""}}).join("\n").replace(/^\n+|\n+$/g,"");t.length&&this.trigger("data",{startPts:this.startPts_,endPts:e,text:t,stream:this.name_})},Ue.prototype.reset=function(){this.mode_="popOn",this.topRow_=0,this.startPts_=0,this.displayed_=Ce(),this.nonDisplayed_=Ce(),this.lastControlCode_=null,this.column_=0,this.row_=14,this.rollUpRows_=2,this.formatting_=[]},Ue.prototype.setConstants=function(){0===this.dataChannel_?(this.BASE_=16,this.EXT_=17,this.CONTROL_=(20|this.field_)<<8,this.OFFSET_=23):1===this.dataChannel_&&(this.BASE_=24,this.EXT_=25,this.CONTROL_=(28|this.field_)<<8,this.OFFSET_=31),this.PADDING_=0,this.RESUME_CAPTION_LOADING_=32|this.CONTROL_,this.END_OF_CAPTION_=47|this.CONTROL_,this.ROLL_UP_2_ROWS_=37|this.CONTROL_,this.ROLL_UP_3_ROWS_=38|this.CONTROL_,this.ROLL_UP_4_ROWS_=39|this.CONTROL_,this.CARRIAGE_RETURN_=45|this.CONTROL_,this.RESUME_DIRECT_CAPTIONING_=41|this.CONTROL_,this.BACKSPACE_=33|this.CONTROL_,this.ERASE_DISPLAYED_MEMORY_=44|this.CONTROL_,this.ERASE_NON_DISPLAYED_MEMORY_=46|this.CONTROL_},Ue.prototype.isSpecialCharacter=function(e,t){return e===this.EXT_&&t>=48&&t<=63},Ue.prototype.isExtCharacter=function(e,t){return(e===this.EXT_+1||e===this.EXT_+2)&&t>=32&&t<=63},Ue.prototype.isMidRowCode=function(e,t){return e===this.EXT_&&t>=32&&t<=47},Ue.prototype.isOffsetControlCode=function(e,t){return e===this.OFFSET_&&t>=33&&t<=35},Ue.prototype.isPAC=function(e,t){return e>=this.BASE_&&e<this.BASE_+8&&t>=64&&t<=127},Ue.prototype.isColorPAC=function(e){return e>=64&&e<=79||e>=96&&e<=127},Ue.prototype.isNormalChar=function(e){return e>=32&&e<=127},Ue.prototype.setRollUp=function(e,t){if("rollUp"!==this.mode_&&(this.row_=14,this.mode_="rollUp",this.flushDisplayed(e),this.nonDisplayed_=Ce(),this.displayed_=Ce()),void 0!==t&&t!==this.row_)for(var i=0;i<this.rollUpRows_;i++)this.displayed_[t-i]=this.displayed_[this.row_-i],this.displayed_[this.row_-i]="";void 0===t&&(t=this.row_),this.topRow_=t-this.rollUpRows_+1},Ue.prototype.addFormatting=function(e,t){this.formatting_=this.formatting_.concat(t);var i=t.reduce(function(e,t){return e+"<"+t+">"},"");this[this.mode_](e,i)},Ue.prototype.clearFormatting=function(e){if(this.formatting_.length){var t=this.formatting_.reverse().reduce(function(e,t){return e+"</"+t+">"},"");this.formatting_=[],this[this.mode_](e,t)}},Ue.prototype.popOn=function(e,t){var i=this.nonDisplayed_[this.row_];i+=t,this.nonDisplayed_[this.row_]=i},Ue.prototype.rollUp=function(e,t){var i=this.displayed_[this.row_];i+=t,this.displayed_[this.row_]=i},Ue.prototype.shiftRowsUp_=function(){var e;for(e=0;e<this.topRow_;e++)this.displayed_[e]="";for(e=this.row_+1;e<15;e++)this.displayed_[e]="";for(e=this.topRow_;e<this.row_;e++)this.displayed_[e]=this.displayed_[e+1];this.displayed_[this.row_]=""},Ue.prototype.paintOn=function(e,t){var i=this.displayed_[this.row_];i+=t,this.displayed_[this.row_]=i};var Oe={CaptionStream:Ee,Cea608Stream:Ue},De={H264_STREAM_TYPE:27,ADTS_STREAM_TYPE:15,METADATA_STREAM_TYPE:21},Pe=function(e,t){var i=1;for(e>t&&(i=-1);Math.abs(t-e)>4294967296;)e+=8589934592*i;return e},Re=function e(t){var i,n;e.prototype.init.call(this),this.type_=t||"shared",this.push=function(e){"shared"!==this.type_&&e.type!==this.type_||(void 0===n&&(n=e.dts),e.dts=Pe(e.dts,n),e.pts=Pe(e.pts,n),i=e.dts,this.trigger("data",e))},this.flush=function(){n=i,this.trigger("done")},this.endTimeline=function(){this.flush(),this.trigger("endedtimeline")},this.discontinuity=function(){n=void 0,i=void 0},this.reset=function(){this.discontinuity(),this.trigger("reset")}};Re.prototype=new j;var xe,Ne=Re,Me=function(e,t,i){var n,r="";for(n=t;n<i;n++)r+="%"+("00"+e[n].toString(16)).slice(-2);return r},Be=function(e,t,i){return decodeURIComponent(Me(e,t,i))},qe=function(e){return e[0]<<21|e[1]<<14|e[2]<<7|e[3]},Fe={TXXX:function(e){var t;if(3===e.data[0]){for(t=1;t<e.data.length;t++)if(0===e.data[t]){e.description=Be(e.data,1,t),e.value=Be(e.data,t+1,e.data.length).replace(/\0*$/,"");break}e.data=e.value}},WXXX:function(e){var t;if(3===e.data[0])for(t=1;t<e.data.length;t++)if(0===e.data[t]){e.description=Be(e.data,1,t),e.url=Be(e.data,t+1,e.data.length);break}},PRIV:function(e){var t,i;for(t=0;t<e.data.length;t++)if(0===e.data[t]){e.owner=(i=e.data,unescape(Me(i,0,t)));break}e.privateData=e.data.subarray(t+1),e.data=e.privateData}};(xe=function(e){var t,i={debug:!(!e||!e.debug),descriptor:e&&e.descriptor},n=0,r=[],a=0;if(xe.prototype.init.call(this),this.dispatchType=De.METADATA_STREAM_TYPE.toString(16),i.descriptor)for(t=0;t<i.descriptor.length;t++)this.dispatchType+=("00"+i.descriptor[t].toString(16)).slice(-2);this.push=function(e){var t,s,o,u,d;if("timed-metadata"===e.type)if(e.dataAlignmentIndicator&&(a=0,r.length=0),0===r.length&&(e.data.length<10||e.data[0]!=="I".charCodeAt(0)||e.data[1]!=="D".charCodeAt(0)||e.data[2]!=="3".charCodeAt(0)))i.debug&&console.log("Skipping unrecognized metadata packet");else if(r.push(e),a+=e.data.byteLength,1===r.length&&(n=qe(e.data.subarray(6,10)),n+=10),!(a<n)){for(t={data:new Uint8Array(n),frames:[],pts:r[0].pts,dts:r[0].dts},d=0;d<n;)t.data.set(r[0].data.subarray(0,n-d),d),d+=r[0].data.byteLength,a-=r[0].data.byteLength,r.shift();s=10,64&t.data[5]&&(s+=4,s+=qe(t.data.subarray(10,14)),n-=qe(t.data.subarray(16,20)));do{if((o=qe(t.data.subarray(s+4,s+8)))<1)return console.log("Malformed ID3 frame encountered. Skipping metadata parsing.");if((u={id:String.fromCharCode(t.data[s],t.data[s+1],t.data[s+2],t.data[s+3]),data:t.data.subarray(s+10,s+o+10)}).key=u.id,Fe[u.id]&&(Fe[u.id](u),"com.apple.streaming.transportStreamTimestamp"===u.owner)){var l=u.data,c=(1&l[3])<<30|l[4]<<22|l[5]<<14|l[6]<<6|l[7]>>>2;c*=4,c+=3&l[7],u.timeStamp=c,void 0===t.pts&&void 0===t.dts&&(t.pts=u.timeStamp,t.dts=u.timeStamp),this.trigger("timestamp",u)}t.frames.push(u),s+=10,s+=o}while(s<n);this.trigger("data",t)}}}).prototype=new j;var He,je,Ve,Ge=xe,We=Ne;(He=function(){var e=new Uint8Array(188),t=0;He.prototype.init.call(this),this.push=function(i){var n,r=0,a=188;for(t?((n=new Uint8Array(i.byteLength+t)).set(e.subarray(0,t)),n.set(i,t),t=0):n=i;a<n.byteLength;)71!==n[r]||71!==n[a]?(r++,a++):(this.trigger("data",n.subarray(r,a)),r+=188,a+=188);r<n.byteLength&&(e.set(n.subarray(r),0),t=n.byteLength-r)},this.flush=function(){188===t&&71===e[0]&&(this.trigger("data",e),t=0),this.trigger("done")},this.endTimeline=function(){this.flush(),this.trigger("endedtimeline")},this.reset=function(){t=0,this.trigger("reset")}}).prototype=new j,(je=function(){var e,t,i,n;je.prototype.init.call(this),n=this,this.packetsWaitingForPmt=[],this.programMapTable=void 0,e=function(e,n){var r=0;n.payloadUnitStartIndicator&&(r+=e[r]+1),"pat"===n.type?t(e.subarray(r),n):i(e.subarray(r),n)},t=function(e,t){t.section_number=e[7],t.last_section_number=e[8],n.pmtPid=(31&e[10])<<8|e[11],t.pmtPid=n.pmtPid},i=function(e,t){var i,r;if(1&e[5]){for(n.programMapTable={video:null,audio:null,"timed-metadata":{}},i=3+((15&e[1])<<8|e[2])-4,r=12+((15&e[10])<<8|e[11]);r<i;){var a=e[r],s=(31&e[r+1])<<8|e[r+2];a===De.H264_STREAM_TYPE&&null===n.programMapTable.video?n.programMapTable.video=s:a===De.ADTS_STREAM_TYPE&&null===n.programMapTable.audio?n.programMapTable.audio=s:a===De.METADATA_STREAM_TYPE&&(n.programMapTable["timed-metadata"][s]=a),r+=5+((15&e[r+3])<<8|e[r+4])}t.programMapTable=n.programMapTable}},this.push=function(t){var i={},n=4;if(i.payloadUnitStartIndicator=!!(64&t[1]),i.pid=31&t[1],i.pid<<=8,i.pid|=t[2],(48&t[3])>>>4>1&&(n+=t[n]+1),0===i.pid)i.type="pat",e(t.subarray(n),i),this.trigger("data",i);else if(i.pid===this.pmtPid)for(i.type="pmt",e(t.subarray(n),i),this.trigger("data",i);this.packetsWaitingForPmt.length;)this.processPes_.apply(this,this.packetsWaitingForPmt.shift());else void 0===this.programMapTable?this.packetsWaitingForPmt.push([t,n,i]):this.processPes_(t,n,i)},this.processPes_=function(e,t,i){i.pid===this.programMapTable.video?i.streamType=De.H264_STREAM_TYPE:i.pid===this.programMapTable.audio?i.streamType=De.ADTS_STREAM_TYPE:i.streamType=this.programMapTable["timed-metadata"][i.pid],i.type="pes",i.data=e.subarray(t),this.trigger("data",i)}}).prototype=new j,je.STREAM_TYPES={h264:27,adts:15},(Ve=function(){var e,t=this,i={data:[],size:0},n={data:[],size:0},r={data:[],size:0},a=function(e,i,n){var r,a,s=new Uint8Array(e.size),o={type:i},u=0,d=0;if(e.data.length&&!(e.size<9)){for(o.trackId=e.data[0].pid,u=0;u<e.data.length;u++)a=e.data[u],s.set(a.data,d),d+=a.data.byteLength;var l,c,h;l=s,(c=o).packetLength=6+(l[4]<<8|l[5]),c.dataAlignmentIndicator=0!=(4&l[6]),192&(h=l[7])&&(c.pts=(14&l[9])<<27|(255&l[10])<<20|(254&l[11])<<12|(255&l[12])<<5|(254&l[13])>>>3,c.pts*=4,c.pts+=(6&l[13])>>>1,c.dts=c.pts,64&h&&(c.dts=(14&l[14])<<27|(255&l[15])<<20|(254&l[16])<<12|(255&l[17])<<5|(254&l[18])>>>3,c.dts*=4,c.dts+=(6&l[18])>>>1)),c.data=l.subarray(9+l[8]),r="video"===i||o.packetLength<=e.size,(n||r)&&(e.size=0,e.data.length=0),r&&t.trigger("data",o)}};Ve.prototype.init.call(this),this.push=function(s){({pat:function(){},pes:function(){var e,t;switch(s.streamType){case De.H264_STREAM_TYPE:case De.H264_STREAM_TYPE:e=i,t="video";break;case De.ADTS_STREAM_TYPE:e=n,t="audio";break;case De.METADATA_STREAM_TYPE:e=r,t="timed-metadata";break;default:return}s.payloadUnitStartIndicator&&a(e,t,!0),e.data.push(s),e.size+=s.data.byteLength},pmt:function(){var i={type:"metadata",tracks:[]};null!==(e=s.programMapTable).video&&i.tracks.push({timelineStartInfo:{baseMediaDecodeTime:0},id:+e.video,codec:"avc",type:"video"}),null!==e.audio&&i.tracks.push({timelineStartInfo:{baseMediaDecodeTime:0},id:+e.audio,codec:"adts",type:"audio"}),t.trigger("data",i)}})[s.type]()},this.reset=function(){i.size=0,i.data.length=0,n.size=0,n.data.length=0,this.trigger("reset")},this.flushStreams_=function(){a(i,"video"),a(n,"audio"),a(r,"timed-metadata")},this.flush=function(){this.flushStreams_(),this.trigger("done")}}).prototype=new j;var ze={PAT_PID:0,MP2T_PACKET_LENGTH:188,TransportPacketStream:He,TransportParseStream:je,ElementaryStream:Ve,TimestampRolloverStream:We,CaptionStream:Oe.CaptionStream,Cea608Stream:Oe.Cea608Stream,MetadataStream:Ge};for(var Xe in De)De.hasOwnProperty(Xe)&&(ze[Xe]=De[Xe]);var Ye,$e=ze,Ke=de,Qe=[96e3,88200,64e3,48e3,44100,32e3,24e3,22050,16e3,12e3,11025,8e3,7350];(Ye=function(e){var t,i=0;Ye.prototype.init.call(this),this.push=function(n){var r,a,s,o,u,d,l=0;if(e||(i=0),"audio"===n.type)for(t?(o=t,(t=new Uint8Array(o.byteLength+n.data.byteLength)).set(o),t.set(n.data,o.byteLength)):t=n.data;l+5<t.length;)if(255===t[l]&&240==(246&t[l+1])){if(a=2*(1&~t[l+1]),r=(3&t[l+3])<<11|t[l+4]<<3|(224&t[l+5])>>5,d=(u=1024*(1+(3&t[l+6])))*Ke/Qe[(60&t[l+2])>>>2],s=l+r,t.byteLength<s)return;if(this.trigger("data",{pts:n.pts+i*d,dts:n.dts+i*d,sampleCount:u,audioobjecttype:1+(t[l+2]>>>6&3),channelcount:(1&t[l+2])<<2|(192&t[l+3])>>>6,samplerate:Qe[(60&t[l+2])>>>2],samplingfrequencyindex:(60&t[l+2])>>>2,samplesize:16,data:t.subarray(l+7+a,s)}),i++,t.byteLength===s)return void(t=void 0);t=t.subarray(s)}else l++},this.flush=function(){i=0,this.trigger("done")},this.reset=function(){t=void 0,this.trigger("reset")},this.endTimeline=function(){t=void 0,this.trigger("endedtimeline")}}).prototype=new j;var Je,Ze,et,tt=Ye,it=function(e){var t=e.byteLength,i=0,n=0;this.length=function(){return 8*t},this.bitsAvailable=function(){return 8*t+n},this.loadWord=function(){var r=e.byteLength-t,a=new Uint8Array(4),s=Math.min(4,t);if(0===s)throw new Error("no bytes available");a.set(e.subarray(r,r+s)),i=new DataView(a.buffer).getUint32(0),n=8*s,t-=s},this.skipBits=function(e){var r;n>e?(i<<=e,n-=e):(e-=n,e-=8*(r=Math.floor(e/8)),t-=r,this.loadWord(),i<<=e,n-=e)},this.readBits=function(e){var r=Math.min(n,e),a=i>>>32-r;return(n-=r)>0?i<<=r:t>0&&this.loadWord(),(r=e-r)>0?a<<r|this.readBits(r):a},this.skipLeadingZeros=function(){var e;for(e=0;e<n;++e)if(0!=(i&2147483648>>>e))return i<<=e,n-=e,e;return this.loadWord(),e+this.skipLeadingZeros()},this.skipUnsignedExpGolomb=function(){this.skipBits(1+this.skipLeadingZeros())},this.skipExpGolomb=function(){this.skipBits(1+this.skipLeadingZeros())},this.readUnsignedExpGolomb=function(){var e=this.skipLeadingZeros();return this.readBits(e+1)-1},this.readExpGolomb=function(){var e=this.readUnsignedExpGolomb();return 1&e?1+e>>>1:-1*(e>>>1)},this.readBoolean=function(){return 1===this.readBits(1)},this.readUnsignedByte=function(){return this.readBits(8)},this.loadWord()};(Ze=function(){var e,t,i=0;Ze.prototype.init.call(this),this.push=function(n){var r;t?((r=new Uint8Array(t.byteLength+n.data.byteLength)).set(t),r.set(n.data,t.byteLength),t=r):t=n.data;for(var a=t.byteLength;i<a-3;i++)if(1===t[i+2]){e=i+5;break}for(;e<a;)switch(t[e]){case 0:if(0!==t[e-1]){e+=2;break}if(0!==t[e-2]){e++;break}i+3!==e-2&&this.trigger("data",t.subarray(i+3,e-2));do{e++}while(1!==t[e]&&e<a);i=e-2,e+=3;break;case 1:if(0!==t[e-1]||0!==t[e-2]){e+=3;break}this.trigger("data",t.subarray(i+3,e-2)),i=e-2,e+=3;break;default:e+=3}t=t.subarray(i),e-=i,i=0},this.reset=function(){t=null,i=0,this.trigger("reset")},this.flush=function(){t&&t.byteLength>3&&this.trigger("data",t.subarray(i+3)),t=null,i=0,this.trigger("done")},this.endTimeline=function(){this.flush(),this.trigger("endedtimeline")}}).prototype=new j,et={100:!0,110:!0,122:!0,244:!0,44:!0,83:!0,86:!0,118:!0,128:!0,138:!0,139:!0,134:!0},(Je=function(){var e,t,i,n,r,a,s,o=new Ze;Je.prototype.init.call(this),e=this,this.push=function(e){"video"===e.type&&(t=e.trackId,i=e.pts,n=e.dts,o.push(e))},o.on("data",function(s){var o={trackId:t,pts:i,dts:n,data:s};switch(31&s[0]){case 5:o.nalUnitType="slice_layer_without_partitioning_rbsp_idr";break;case 6:o.nalUnitType="sei_rbsp",o.escapedRBSP=r(s.subarray(1));break;case 7:o.nalUnitType="seq_parameter_set_rbsp",o.escapedRBSP=r(s.subarray(1)),o.config=a(o.escapedRBSP);break;case 8:o.nalUnitType="pic_parameter_set_rbsp";break;case 9:o.nalUnitType="access_unit_delimiter_rbsp"}e.trigger("data",o)}),o.on("done",function(){e.trigger("done")}),o.on("partialdone",function(){e.trigger("partialdone")}),o.on("reset",function(){e.trigger("reset")}),o.on("endedtimeline",function(){e.trigger("endedtimeline")}),this.flush=function(){o.flush()},this.partialFlush=function(){o.partialFlush()},this.reset=function(){o.reset()},this.endTimeline=function(){o.endTimeline()},s=function(e,t){var i,n=8,r=8;for(i=0;i<e;i++)0!==r&&(r=(n+t.readExpGolomb()+256)%256),n=0===r?n:r},r=function(e){for(var t,i,n=e.byteLength,r=[],a=1;a<n-2;)0===e[a]&&0===e[a+1]&&3===e[a+2]?(r.push(a+2),a+=2):a++;if(0===r.length)return e;t=n-r.length,i=new Uint8Array(t);var s=0;for(a=0;a<t;s++,a++)s===r[0]&&(s++,r.shift()),i[a]=e[s];return i},a=function(e){var t,i,n,r,a,o,u,d,l,c,h,f,p,m=0,g=0,y=0,_=0,v=1;if(i=(t=new it(e)).readUnsignedByte(),r=t.readUnsignedByte(),n=t.readUnsignedByte(),t.skipUnsignedExpGolomb(),et[i]&&(3===(a=t.readUnsignedExpGolomb())&&t.skipBits(1),t.skipUnsignedExpGolomb(),t.skipUnsignedExpGolomb(),t.skipBits(1),t.readBoolean()))for(h=3!==a?8:12,p=0;p<h;p++)t.readBoolean()&&s(p<6?16:64,t);if(t.skipUnsignedExpGolomb(),0===(o=t.readUnsignedExpGolomb()))t.readUnsignedExpGolomb();else if(1===o)for(t.skipBits(1),t.skipExpGolomb(),t.skipExpGolomb(),u=t.readUnsignedExpGolomb(),p=0;p<u;p++)t.skipExpGolomb();if(t.skipUnsignedExpGolomb(),t.skipBits(1),d=t.readUnsignedExpGolomb(),l=t.readUnsignedExpGolomb(),0===(c=t.readBits(1))&&t.skipBits(1),t.skipBits(1),t.readBoolean()&&(m=t.readUnsignedExpGolomb(),g=t.readUnsignedExpGolomb(),y=t.readUnsignedExpGolomb(),_=t.readUnsignedExpGolomb()),t.readBoolean()&&t.readBoolean()){switch(t.readUnsignedByte()){case 1:f=[1,1];break;case 2:f=[12,11];break;case 3:f=[10,11];break;case 4:f=[16,11];break;case 5:f=[40,33];break;case 6:f=[24,11];break;case 7:f=[20,11];break;case 8:f=[32,11];break;case 9:f=[80,33];break;case 10:f=[18,11];break;case 11:f=[15,11];break;case 12:f=[64,33];break;case 13:f=[160,99];break;case 14:f=[4,3];break;case 15:f=[3,2];break;case 16:f=[2,1];break;case 255:f=[t.readUnsignedByte()<<8|t.readUnsignedByte(),t.readUnsignedByte()<<8|t.readUnsignedByte()]}f&&(v=f[0]/f[1])}return{profileIdc:i,levelIdc:n,profileCompatibility:r,width:Math.ceil((16*(d+1)-2*m-2*g)*v),height:(2-c)*(l+1)*16-2*y-2*_,sarRatio:f}}}).prototype=new j;var nt,rt={H264Stream:Je,NalByteStream:Ze},at=function(e){return e[0]==="I".charCodeAt(0)&&e[1]==="D".charCodeAt(0)&&e[2]==="3".charCodeAt(0)},st=function(e,t){var i=e[t+6]<<21|e[t+7]<<14|e[t+8]<<7|e[t+9];return(16&e[t+5])>>4?i+20:i+10},ot=function(e,t){var i=(224&e[t+5])>>5,n=e[t+4]<<3;return 6144&e[t+3]|n|i};(nt=function(){var e=new Uint8Array,t=0;nt.prototype.init.call(this),this.setTimestamp=function(e){t=e},this.push=function(i){var n,r,a,s,o=0,u=0;for(e.length?(s=e.length,(e=new Uint8Array(i.byteLength+s)).set(e.subarray(0,s)),e.set(i,s)):e=i;e.length-u>=3;)if(e[u]!=="I".charCodeAt(0)||e[u+1]!=="D".charCodeAt(0)||e[u+2]!=="3".charCodeAt(0))if(255!=(255&e[u])||240!=(240&e[u+1]))u++;else{if(e.length-u<7)break;if(u+(o=ot(e,u))>e.length)break;a={type:"audio",data:e.subarray(u,u+o),pts:t,dts:t},this.trigger("data",a),u+=o}else{if(e.length-u<10)break;if(u+(o=st(e,u))>e.length)break;r={type:"timed-metadata",data:e.subarray(u,u+o)},this.trigger("data",r),u+=o}n=e.length-u,e=n>0?e.subarray(u):new Uint8Array},this.reset=function(){e=new Uint8Array,this.trigger("reset")},this.endTimeline=function(){e=new Uint8Array,this.trigger("endedtimeline")}}).prototype=new j;var ut,dt,lt,ct,ht=nt,ft=rt.H264Stream,pt=at,mt=de,gt=["audioobjecttype","channelcount","samplerate","samplingfrequencyindex","samplesize"],yt=["width","height","profileIdc","levelIdc","profileCompatibility","sarRatio"],_t=function(e,t){var i;if(e.length!==t.length)return!1;for(i=0;i<e.length;i++)if(e[i]!==t[i])return!1;return!0},vt=function(e,t,i,n,r,a){return{start:{dts:e,pts:e+(i-t)},end:{dts:e+(n-t),pts:e+(r-i)},prependedContentDuration:a,baseMediaDecodeTime:e}};(dt=function(e,t){var i=[],n=0,r=0,a=0,s=1/0;t=t||{},dt.prototype.init.call(this),this.push=function(t){be(e,t),e&&gt.forEach(function(i){e[i]=t[i]}),i.push(t)},this.setEarliestDts=function(t){r=t-e.timelineStartInfo.baseMediaDecodeTime},this.setVideoBaseMediaDecodeTime=function(e){s=e},this.setAudioAppendStart=function(e){a=e},this.flush=function(){var o,u,d,l,c;0!==i.length?(o=pe(i,e,r),e.baseMediaDecodeTime=ve(e,t.keepOriginalTimestamps),fe(e,o,a,s),e.samples=me(o),d=$(ge(o)),i=[],u=K(n,[e]),l=new Uint8Array(u.byteLength+d.byteLength),n++,l.set(u),l.set(d,u.byteLength),_e(e),c=Math.ceil(1024*mt/e.samplerate),o.length&&this.trigger("timingInfo",{start:o[0].pts,end:o[0].pts+o.length*c}),this.trigger("data",{track:e,boxes:l}),this.trigger("done","AudioSegmentStream")):this.trigger("done","AudioSegmentStream")},this.reset=function(){_e(e),i=[],this.trigger("reset")}}).prototype=new j,(ut=function(e,t){var i,n,r=0,a=[],s=[];t=t||{},ut.prototype.init.call(this),delete e.minPTS,this.gopCache_=[],this.push=function(t){be(e,t),"seq_parameter_set_rbsp"!==t.nalUnitType||i||(i=t.config,e.sps=[t.data],yt.forEach(function(t){e[t]=i[t]},this)),"pic_parameter_set_rbsp"!==t.nalUnitType||n||(n=t.data,e.pps=[t.data]),a.push(t)},this.flush=function(){for(var i,n,o,u,d,l,c,h,f=0;a.length&&"access_unit_delimiter_rbsp"!==a[0].nalUnitType;)a.shift();if(0===a.length)return this.resetStream_(),void this.trigger("done","VideoSegmentStream");if(i=Z(a),(o=ee(i))[0][0].keyFrame||((n=this.getGopForFusion_(a[0],e))?(f=n.duration,o.unshift(n),o.byteLength+=n.byteLength,o.nalCount+=n.nalCount,o.pts=n.pts,o.dts=n.dts,o.duration+=n.duration):o=te(o)),s.length){var p;if(!(p=t.alignGopsAtEnd?this.alignGopsAtEnd_(o):this.alignGopsAtStart_(o)))return this.gopCache_.unshift({gop:o.pop(),pps:e.pps,sps:e.sps}),this.gopCache_.length=Math.min(6,this.gopCache_.length),a=[],this.resetStream_(),void this.trigger("done","VideoSegmentStream");_e(e),o=p}be(e,o),e.samples=ie(o),d=$(ne(o)),e.baseMediaDecodeTime=ve(e,t.keepOriginalTimestamps),this.trigger("processedGopsInfo",o.map(function(e){return{pts:e.pts,dts:e.dts,byteLength:e.byteLength}})),c=o[0],h=o[o.length-1],this.trigger("segmentTimingInfo",vt(e.baseMediaDecodeTime,c.dts,c.pts,h.dts+h.duration,h.pts+h.duration,f)),this.trigger("timingInfo",{start:o[0].pts,end:o[o.length-1].pts+o[o.length-1].duration}),this.gopCache_.unshift({gop:o.pop(),pps:e.pps,sps:e.sps}),this.gopCache_.length=Math.min(6,this.gopCache_.length),a=[],this.trigger("baseMediaDecodeTime",e.baseMediaDecodeTime),this.trigger("timelineStartInfo",e.timelineStartInfo),u=K(r,[e]),l=new Uint8Array(u.byteLength+d.byteLength),r++,l.set(u),l.set(d,u.byteLength),this.trigger("data",{track:e,boxes:l}),this.resetStream_(),this.trigger("done","VideoSegmentStream")},this.reset=function(){this.resetStream_(),a=[],this.gopCache_.length=0,s.length=0,this.trigger("reset")},this.resetStream_=function(){_e(e),i=void 0,n=void 0},this.getGopForFusion_=function(t){var i,n,r,a,s,o=1/0;for(s=0;s<this.gopCache_.length;s++)r=(a=this.gopCache_[s]).gop,e.pps&&_t(e.pps[0],a.pps[0])&&e.sps&&_t(e.sps[0],a.sps[0])&&(r.dts<e.timelineStartInfo.dts||(i=t.dts-r.dts-r.duration)>=-1e4&&i<=45e3&&(!n||o>i)&&(n=a,o=i));return n?n.gop:null},this.alignGopsAtStart_=function(e){var t,i,n,r,a,o,u,d;for(a=e.byteLength,o=e.nalCount,u=e.duration,t=i=0;t<s.length&&i<e.length&&(n=s[t],r=e[i],n.pts!==r.pts);)r.pts>n.pts?t++:(i++,a-=r.byteLength,o-=r.nalCount,u-=r.duration);return 0===i?e:i===e.length?null:((d=e.slice(i)).byteLength=a,d.duration=u,d.nalCount=o,d.pts=d[0].pts,d.dts=d[0].dts,d)},this.alignGopsAtEnd_=function(e){var t,i,n,r,a,o,u;for(t=s.length-1,i=e.length-1,a=null,o=!1;t>=0&&i>=0;){if(n=s[t],r=e[i],n.pts===r.pts){o=!0;break}n.pts>r.pts?t--:(t===s.length-1&&(a=i),i--)}if(!o&&null===a)return null;if(0===(u=o?i:a))return e;var d=e.slice(u),l=d.reduce(function(e,t){return e.byteLength+=t.byteLength,e.duration+=t.duration,e.nalCount+=t.nalCount,e},{byteLength:0,duration:0,nalCount:0});return d.byteLength=l.byteLength,d.duration=l.duration,d.nalCount=l.nalCount,d.pts=d[0].pts,d.dts=d[0].dts,d},this.alignGopsWith=function(e){s=e}}).prototype=new j,(ct=function(e,t){this.numberOfTracks=0,this.metadataStream=t,void 0!==(e=e||{}).remux?this.remuxTracks=!!e.remux:this.remuxTracks=!0,"boolean"==typeof e.keepOriginalTimestamps?this.keepOriginalTimestamps=e.keepOriginalTimestamps:this.keepOriginalTimestamps=!1,this.pendingTracks=[],this.videoTrack=null,this.pendingBoxes=[],this.pendingCaptions=[],this.pendingMetadata=[],this.pendingBytes=0,this.emittedTracks=0,ct.prototype.init.call(this),this.push=function(e){return e.text?this.pendingCaptions.push(e):e.frames?this.pendingMetadata.push(e):(this.pendingTracks.push(e.track),this.pendingBytes+=e.boxes.byteLength,"video"===e.track.type&&(this.videoTrack=e.track,this.pendingBoxes.push(e.boxes)),void("audio"===e.track.type&&(this.audioTrack=e.track,this.pendingBoxes.unshift(e.boxes))))}}).prototype=new j,ct.prototype.flush=function(e){var t,i,n,r,a=0,s={captions:[],captionStreams:{},metadata:[],info:{}},o=0;if(this.pendingTracks.length<this.numberOfTracks){if("VideoSegmentStream"!==e&&"AudioSegmentStream"!==e)return;if(this.remuxTracks)return;if(0===this.pendingTracks.length)return this.emittedTracks++,void(this.emittedTracks>=this.numberOfTracks&&(this.trigger("done"),this.emittedTracks=0))}if(this.videoTrack?(o=this.videoTrack.timelineStartInfo.pts,yt.forEach(function(e){s.info[e]=this.videoTrack[e]},this)):this.audioTrack&&(o=this.audioTrack.timelineStartInfo.pts,gt.forEach(function(e){s.info[e]=this.audioTrack[e]},this)),this.videoTrack||this.audioTrack){for(1===this.pendingTracks.length?s.type=this.pendingTracks[0].type:s.type="combined",this.emittedTracks+=this.pendingTracks.length,n=Q(this.pendingTracks),s.initSegment=new Uint8Array(n.byteLength),s.initSegment.set(n),s.data=new Uint8Array(this.pendingBytes),r=0;r<this.pendingBoxes.length;r++)s.data.set(this.pendingBoxes[r],a),a+=this.pendingBoxes[r].byteLength;for(r=0;r<this.pendingCaptions.length;r++)(t=this.pendingCaptions[r]).startTime=he(t.startPts,o,this.keepOriginalTimestamps),t.endTime=he(t.endPts,o,this.keepOriginalTimestamps),s.captionStreams[t.stream]=!0,s.captions.push(t);for(r=0;r<this.pendingMetadata.length;r++)(i=this.pendingMetadata[r]).cueTime=he(i.pts,o,this.keepOriginalTimestamps),s.metadata.push(i);for(s.metadata.dispatchType=this.metadataStream.dispatchType,this.pendingTracks.length=0,this.videoTrack=null,this.pendingBoxes.length=0,this.pendingCaptions.length=0,this.pendingBytes=0,this.pendingMetadata.length=0,this.trigger("data",s),r=0;r<s.captions.length;r++)t=s.captions[r],this.trigger("caption",t);for(r=0;r<s.metadata.length;r++)i=s.metadata[r],this.trigger("id3Frame",i)}this.emittedTracks>=this.numberOfTracks&&(this.trigger("done"),this.emittedTracks=0)},ct.prototype.setRemux=function(e){this.remuxTracks=e},(lt=function(e){var t,i,n=this,r=!0;lt.prototype.init.call(this),e=e||{},this.baseMediaDecodeTime=e.baseMediaDecodeTime||0,this.transmuxPipeline_={},this.setupAacPipeline=function(){var r={};this.transmuxPipeline_=r,r.type="aac",r.metadataStream=new $e.MetadataStream,r.aacStream=new ht,r.audioTimestampRolloverStream=new $e.TimestampRolloverStream("audio"),r.timedMetadataTimestampRolloverStream=new $e.TimestampRolloverStream("timed-metadata"),r.adtsStream=new tt,r.coalesceStream=new ct(e,r.metadataStream),r.headOfPipeline=r.aacStream,r.aacStream.pipe(r.audioTimestampRolloverStream).pipe(r.adtsStream),r.aacStream.pipe(r.timedMetadataTimestampRolloverStream).pipe(r.metadataStream).pipe(r.coalesceStream),r.metadataStream.on("timestamp",function(e){r.aacStream.setTimestamp(e.timeStamp)}),r.aacStream.on("data",function(a){"timed-metadata"!==a.type||r.audioSegmentStream||(i=i||{timelineStartInfo:{baseMediaDecodeTime:n.baseMediaDecodeTime},codec:"adts",type:"audio"},r.coalesceStream.numberOfTracks++,r.audioSegmentStream=new dt(i,e),r.audioSegmentStream.on("timingInfo",n.trigger.bind(n,"audioTimingInfo")),r.adtsStream.pipe(r.audioSegmentStream).pipe(r.coalesceStream)),n.trigger("trackinfo",{hasAudio:!!i,hasVideo:!!t})}),r.coalesceStream.on("data",this.trigger.bind(this,"data")),r.coalesceStream.on("done",this.trigger.bind(this,"done"))},this.setupTsPipeline=function(){var r={};this.transmuxPipeline_=r,r.type="ts",r.metadataStream=new $e.MetadataStream,r.packetStream=new $e.TransportPacketStream,r.parseStream=new $e.TransportParseStream,r.elementaryStream=new $e.ElementaryStream,r.timestampRolloverStream=new $e.TimestampRolloverStream,r.adtsStream=new tt,r.h264Stream=new ft,r.captionStream=new $e.CaptionStream,r.coalesceStream=new ct(e,r.metadataStream),r.headOfPipeline=r.packetStream,r.packetStream.pipe(r.parseStream).pipe(r.elementaryStream).pipe(r.timestampRolloverStream),r.timestampRolloverStream.pipe(r.h264Stream),r.timestampRolloverStream.pipe(r.adtsStream),r.timestampRolloverStream.pipe(r.metadataStream).pipe(r.coalesceStream),r.h264Stream.pipe(r.captionStream).pipe(r.coalesceStream),r.elementaryStream.on("data",function(a){var s;if("metadata"===a.type){for(s=a.tracks.length;s--;)t||"video"!==a.tracks[s].type?i||"audio"!==a.tracks[s].type||((i=a.tracks[s]).timelineStartInfo.baseMediaDecodeTime=n.baseMediaDecodeTime):(t=a.tracks[s]).timelineStartInfo.baseMediaDecodeTime=n.baseMediaDecodeTime;t&&!r.videoSegmentStream&&(r.coalesceStream.numberOfTracks++,r.videoSegmentStream=new ut(t,e),r.videoSegmentStream.on("timelineStartInfo",function(e){i&&(i.timelineStartInfo=e,r.audioSegmentStream.setEarliestDts(e.dts))}),r.videoSegmentStream.on("processedGopsInfo",n.trigger.bind(n,"gopInfo")),r.videoSegmentStream.on("segmentTimingInfo",n.trigger.bind(n,"videoSegmentTimingInfo")),r.videoSegmentStream.on("baseMediaDecodeTime",function(e){i&&r.audioSegmentStream.setVideoBaseMediaDecodeTime(e)}),r.videoSegmentStream.on("timingInfo",n.trigger.bind(n,"videoTimingInfo")),r.h264Stream.pipe(r.videoSegmentStream).pipe(r.coalesceStream)),i&&!r.audioSegmentStream&&(r.coalesceStream.numberOfTracks++,r.audioSegmentStream=new dt(i,e),r.audioSegmentStream.on("timingInfo",n.trigger.bind(n,"audioTimingInfo")),r.adtsStream.pipe(r.audioSegmentStream).pipe(r.coalesceStream)),n.trigger("trackinfo",{hasAudio:!!i,hasVideo:!!t})}}),r.coalesceStream.on("data",this.trigger.bind(this,"data")),r.coalesceStream.on("id3Frame",function(e){e.dispatchType=r.metadataStream.dispatchType,n.trigger("id3Frame",e)}),r.coalesceStream.on("caption",this.trigger.bind(this,"caption")),r.coalesceStream.on("done",this.trigger.bind(this,"done"))},this.setBaseMediaDecodeTime=function(n){var r=this.transmuxPipeline_;e.keepOriginalTimestamps||(this.baseMediaDecodeTime=n),i&&(i.timelineStartInfo.dts=void 0,i.timelineStartInfo.pts=void 0,_e(i),e.keepOriginalTimestamps||(i.timelineStartInfo.baseMediaDecodeTime=n),r.audioTimestampRolloverStream&&r.audioTimestampRolloverStream.discontinuity()),t&&(r.videoSegmentStream&&(r.videoSegmentStream.gopCache_=[]),t.timelineStartInfo.dts=void 0,t.timelineStartInfo.pts=void 0,_e(t),r.captionStream.reset(),e.keepOriginalTimestamps||(t.timelineStartInfo.baseMediaDecodeTime=n)),r.timestampRolloverStream&&r.timestampRolloverStream.discontinuity()},this.setAudioAppendStart=function(e){i&&this.transmuxPipeline_.audioSegmentStream.setAudioAppendStart(e)},this.setRemux=function(t){var i=this.transmuxPipeline_;e.remux=t,i&&i.coalesceStream&&i.coalesceStream.setRemux(t)},this.alignGopsWith=function(e){t&&this.transmuxPipeline_.videoSegmentStream&&this.transmuxPipeline_.videoSegmentStream.alignGopsWith(e)},this.push=function(e){if(r){var t=pt(e);t&&"aac"!==this.transmuxPipeline_.type?this.setupAacPipeline():t||"ts"===this.transmuxPipeline_.type||this.setupTsPipeline(),r=!1}this.transmuxPipeline_.headOfPipeline.push(e)},this.flush=function(){r=!0,this.transmuxPipeline_.headOfPipeline.flush()},this.endTimeline=function(){this.transmuxPipeline_.headOfPipeline.endTimeline()},this.reset=function(){this.transmuxPipeline_.headOfPipeline&&this.transmuxPipeline_.headOfPipeline.reset()},this.resetCaptions=function(){this.transmuxPipeline_.captionStream&&this.transmuxPipeline_.captionStream.reset()}}).prototype=new j;var bt={Transmuxer:lt,VideoSegmentStream:ut,AudioSegmentStream:dt,AUDIO_PROPERTIES:gt,VIDEO_PROPERTIES:yt,generateVideoSegmentTimingInfo:vt},Tt=function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")},St=function(){function e(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}return function(t,i,n){return i&&e(t.prototype,i),n&&e(t,n),t}}(),wt=function(){function e(t,i){Tt(this,e),this.options=i||{},this.self=t,this.init()}return St(e,[{key:"init",value:function(){var e,t;this.transmuxer&&this.transmuxer.dispose(),this.transmuxer=new bt.Transmuxer(this.options),e=this.self,(t=this.transmuxer).on("data",function(t){var i=t.initSegment;t.initSegment={data:i.buffer,byteOffset:i.byteOffset,byteLength:i.byteLength};var n=t.data;t.data=n.buffer,e.postMessage({action:"data",segment:t,byteOffset:n.byteOffset,byteLength:n.byteLength},[t.data])}),t.captionStream&&t.captionStream.on("data",function(t){e.postMessage({action:"caption",data:t})}),t.on("done",function(t){e.postMessage({action:"done"})}),t.on("gopInfo",function(t){e.postMessage({action:"gopInfo",gopInfo:t})}),t.on("videoSegmentTimingInfo",function(t){e.postMessage({action:"videoSegmentTimingInfo",videoSegmentTimingInfo:t})})}},{key:"push",value:function(e){var t=new Uint8Array(e.data,e.byteOffset,e.byteLength);this.transmuxer.push(t)}},{key:"reset",value:function(){this.init()}},{key:"setTimestampOffset",value:function(e){var t=e.timestampOffset||0;this.transmuxer.setBaseMediaDecodeTime(Math.round(9e4*t))}},{key:"setAudioAppendStart",value:function(e){this.transmuxer.setAudioAppendStart(Math.ceil(9e4*e.appendStart))}},{key:"flush",value:function(e){this.transmuxer.flush()}},{key:"resetCaptions",value:function(){this.transmuxer.resetCaptions()}},{key:"alignGopsWith",value:function(e){this.transmuxer.alignGopsWith(e.gopsToAlignWith.slice())}}]),e}();new function(e){e.onmessage=function(t){"init"===t.data.action&&t.data.options?this.messageHandlers=new wt(e,t.data.options):(this.messageHandlers||(this.messageHandlers=new wt(e)),t.data&&t.data.action&&"init"!==t.data.action&&this.messageHandlers[t.data.action]&&this.messageHandlers[t.data.action](t.data))}}(i)}()}),Fe={videoCodec:"avc1",videoObjectTypeIndicator:".4d400d",audioProfile:"2"},He=function(e){return e.map(function(e){return e.replace(/avc1\.(\d+)\.(\d+)/i,function(e,t,i){return"avc1."+("00"+Number(t).toString(16)).slice(-2)+"00"+("00"+Number(i).toString(16)).slice(-2)})})},je=function(){var e,t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:"",i={codecCount:0};return i.codecCount=t.split(",").length,i.codecCount=i.codecCount||2,(e=/(^|\s|,)+(avc[13])([^ ,]*)/i.exec(t))&&(i.videoCodec=e[2],i.videoObjectTypeIndicator=e[3]),i.audioProfile=/(^|\s|,)+mp4a.[0-9A-Fa-f]+\.([0-9A-Fa-f]+)/i.exec(t),i.audioProfile=i.audioProfile&&i.audioProfile[2],i},Ve=function(e,t,i){return e+"/"+t+'; codecs="'+i.filter(function(e){return!!e}).join(", ")+'"'},Ge=function(e,i){var n=function(e){return e.segments&&e.segments.length&&e.segments[0].map?"mp4":"mp2t"}(i),r=function(e){var t=e.attributes||{};return t.CODECS?je(t.CODECS):Fe}(i),a=i.attributes||{},s=!0,o=!1;if(!i)return[];if(e.mediaGroups.AUDIO&&a.AUDIO){var u=e.mediaGroups.AUDIO[a.AUDIO];if(u)for(var d in o=!0,s=!1,u)if(!u[d].uri&&!u[d].playlists){s=!0;break}}o&&!r.audioProfile&&(s||(r.audioProfile=function(e,t){if(!e.mediaGroups.AUDIO||!t)return null;var i=e.mediaGroups.AUDIO[t];if(!i)return null;for(var n in i){var r=i[n];if(r.default&&r.playlists)return je(r.playlists[0].attributes.CODECS).audioProfile}return null}(e,a.AUDIO)),r.audioProfile||(t.log.warn("Multiple audio tracks present but no audio codec string is specified. Attempting to use the default audio codec (mp4a.40.2)"),r.audioProfile=Fe.audioProfile));var l={};r.videoCodec&&(l.video=""+r.videoCodec+r.videoObjectTypeIndicator),r.audioProfile&&(l.audio="mp4a.40."+r.audioProfile);var c=Ve("audio",n,[l.audio]),h=Ve("video",n,[l.video]),f=Ve("video",n,[l.video,l.audio]);return o?!s&&l.video?[h,c]:s||l.video?[f,c]:[c,c]:l.video?[f]:[c]},We=function(e){var t={type:"",parameters:{}},i=e.trim().split(";");return t.type=i.shift().trim(),i.forEach(function(e){var i=e.trim().split("=");if(i.length>1){var n=i[0].replace(/"/g,"").trim(),r=i[1].replace(/"/g,"").trim();t.parameters[n]=r}}),t},ze=function(e){return/mp4a\.\d+.\d+/i.test(e)},Xe=function(e){return/avc1\.[\da-f]+/i.test(e)},Ye=function(e,i,n){var r=null,a=null,s=0,o=[],u=[];if(!e&&!i)return t.createTimeRange();if(!e)return i.buffered;if(!i)return e.buffered;if(n)return e.buffered;if(0===e.buffered.length&&0===i.buffered.length)return t.createTimeRange();for(var d=e.buffered,l=i.buffered,c=d.length;c--;)o.push({time:d.start(c),type:"start"}),o.push({time:d.end(c),type:"end"});for(c=l.length;c--;)o.push({time:l.start(c),type:"start"}),o.push({time:l.end(c),type:"end"});for(o.sort(function(e,t){return e.time-t.time}),c=0;c<o.length;c++)"start"===o[c].type?2===++s&&(r=o[c].time):"end"===o[c].type&&1===--s&&(a=o[c].time),null!==r&&null!==a&&(u.push([r,a]),r=null,a=null);return t.createTimeRanges(u)},$e=function(e){function i(e,n){_(this,i);var r=T(this,(i.__proto__||Object.getPrototypeOf(i)).call(this,t.EventTarget));r.timestampOffset_=0,r.pendingBuffers_=[],r.bufferUpdating_=!1,r.mediaSource_=e,r.codecs_=n,r.audioCodec_=null,r.videoCodec_=null,r.audioDisabled_=!1,r.appendAudioInitSegment_=!0,r.gopBuffer_=[],r.timeMapping_=0,r.safeAppend_=t.browser.IE_VERSION>=11;var a={remux:!1,alignGopsAtEnd:r.safeAppend_};return r.codecs_.forEach(function(e){ze(e)?r.audioCodec_=e:Xe(e)&&(r.videoCodec_=e)}),r.transmuxer_=new qe,r.transmuxer_.postMessage({action:"init",options:a}),r.transmuxer_.onmessage=function(e){return"data"===e.data.action?r.data_(e):"done"===e.data.action?r.done_(e):"gopInfo"===e.data.action?r.appendGopInfo_(e):"videoSegmentTimingInfo"===e.data.action?r.videoSegmentTimingInfo_(e.data.videoSegmentTimingInfo):void 0},Object.defineProperty(r,"timestampOffset",{get:function(){return this.timestampOffset_},set:function(e){"number"==typeof e&&e>=0&&(this.timestampOffset_=e,this.appendAudioInitSegment_=!0,this.gopBuffer_.length=0,this.timeMapping_=0,this.transmuxer_.postMessage({action:"setTimestampOffset",timestampOffset:e}))}}),Object.defineProperty(r,"appendWindowStart",{get:function(){return(this.videoBuffer_||this.audioBuffer_).appendWindowStart},set:function(e){this.videoBuffer_&&(this.videoBuffer_.appendWindowStart=e),this.audioBuffer_&&(this.audioBuffer_.appendWindowStart=e)}}),Object.defineProperty(r,"updating",{get:function(){return!!(this.bufferUpdating_||!this.audioDisabled_&&this.audioBuffer_&&this.audioBuffer_.updating||this.videoBuffer_&&this.videoBuffer_.updating)}}),Object.defineProperty(r,"buffered",{get:function(){return Ye(this.videoBuffer_,this.audioBuffer_,this.audioDisabled_)}}),r}return b(i,e),v(i,[{key:"data_",value:function(e){var t=e.data.segment;t.data=new Uint8Array(t.data,e.data.byteOffset,e.data.byteLength),t.initSegment=new Uint8Array(t.initSegment.data,t.initSegment.byteOffset,t.initSegment.byteLength),function(e,t,i){var n=t.player_;if(i.captions&&i.captions.length)for(var r in e.inbandTextTracks_||(e.inbandTextTracks_={}),i.captionStreams)if(!e.inbandTextTracks_[r]){n.tech_.trigger({type:"usage",name:"hls-608"});var a=n.textTracks().getTrackById(r);e.inbandTextTracks_[r]=a||n.addRemoteTextTrack({kind:"captions",id:r,label:r},!1).track}i.metadata&&i.metadata.length&&!e.metadataTrack_&&(e.metadataTrack_=n.addRemoteTextTrack({kind:"metadata",label:"Timed Metadata"},!1).track,e.metadataTrack_.inBandMetadataTrackDispatchType=i.metadata.dispatchType)}(this,this.mediaSource_,t),this.pendingBuffers_.push(t)}},{key:"done_",value:function(e){"closed"!==this.mediaSource_.readyState?this.processPendingSegments_():this.pendingBuffers_.length=0}},{key:"videoSegmentTimingInfo_",value:function(e){var t={start:{decode:e.start.dts/9e4,presentation:e.start.pts/9e4},end:{decode:e.end.dts/9e4,presentation:e.end.pts/9e4},baseMediaDecodeTime:e.baseMediaDecodeTime/9e4};e.prependedContentDuration&&(t.prependedContentDuration=e.prependedContentDuration/9e4),this.trigger({type:"videoSegmentTimingInfo",videoSegmentTimingInfo:t})}},{key:"createRealSourceBuffers_",value:function(){var e=this,t=["audio","video"];t.forEach(function(i){if(e[i+"Codec_"]&&!e[i+"Buffer_"]){var n=null;if(e.mediaSource_[i+"Buffer_"])(n=e.mediaSource_[i+"Buffer_"]).updating=!1;else{var r=i+'/mp4;codecs="'+e[i+"Codec_"]+'"';n=function(e,t){var i=e.addSourceBuffer(t),n=Object.create(null);n.updating=!1,n.realBuffer_=i;var r=function(e){"function"==typeof i[e]?n[e]=function(){return i[e].apply(i,arguments)}:void 0===n[e]&&Object.defineProperty(n,e,{get:function(){return i[e]},set:function(t){return i[e]=t}})};for(var a in i)r(a);return n}(e.mediaSource_.nativeMediaSource_,r),e.mediaSource_[i+"Buffer_"]=n}e[i+"Buffer_"]=n,["update","updatestart","updateend"].forEach(function(r){n.addEventListener(r,function(){if("audio"!==i||!e.audioDisabled_)return"updateend"===r&&(e[i+"Buffer_"].updating=!1),t.every(function(t){return!("audio"!==t||!e.audioDisabled_)||(i===t||!e[t+"Buffer_"]||!e[t+"Buffer_"].updating)})?e.trigger(r):void 0})})}})}},{key:"appendBuffer",value:function(e){if(this.bufferUpdating_=!0,this.audioBuffer_&&this.audioBuffer_.buffered.length){var t=this.audioBuffer_.buffered;this.transmuxer_.postMessage({action:"setAudioAppendStart",appendStart:t.end(t.length-1)})}this.videoBuffer_&&this.transmuxer_.postMessage({action:"alignGopsWith",gopsToAlignWith:function(e,t,i){if(void 0===t||null===t||!e.length)return[];var n=Math.ceil(9e4*(t-i+3)),r=void 0;for(r=0;r<e.length&&!(e[r].pts>n);r++);return e.slice(r)}(this.gopBuffer_,this.mediaSource_.player_?this.mediaSource_.player_.currentTime():null,this.timeMapping_)}),this.transmuxer_.postMessage({action:"push",data:e.buffer,byteOffset:e.byteOffset,byteLength:e.byteLength},[e.buffer]),this.transmuxer_.postMessage({action:"flush"})}},{key:"appendGopInfo_",value:function(e){this.gopBuffer_=function(e,t,i){if(!t.length)return e;if(i)return t.slice();for(var n=t[0].pts,r=0;r<e.length&&!(e[r].pts>=n);r++);return e.slice(0,r).concat(t)}(this.gopBuffer_,e.data.gopInfo,this.safeAppend_)}},{key:"remove",value:function(e,t){if(this.videoBuffer_&&(this.videoBuffer_.updating=!0,this.videoBuffer_.remove(e,t),this.gopBuffer_=function(e,t,i,n){for(var r=Math.ceil(9e4*(t-n)),a=Math.ceil(9e4*(i-n)),s=e.slice(),o=e.length;o--&&!(e[o].pts<=a););if(-1===o)return s;for(var u=o+1;u--&&!(e[u].pts<=r););return u=Math.max(u,0),s.splice(u,o-u+1),s}(this.gopBuffer_,e,t,this.timeMapping_)),!this.audioDisabled_&&this.audioBuffer_&&(this.audioBuffer_.updating=!0,this.audioBuffer_.remove(e,t)),Ee(e,t,this.metadataTrack_),this.inbandTextTracks_)for(var i in this.inbandTextTracks_)Ee(e,t,this.inbandTextTracks_[i])}},{key:"processPendingSegments_",value:function(){var e={video:{segments:[],bytes:0},audio:{segments:[],bytes:0},captions:[],metadata:[]};if(!this.pendingBuffers_.length)return this.trigger("updateend"),void(this.bufferUpdating_=!1);e=this.pendingBuffers_.reduce(function(e,t){var i=t.type,n=t.data,r=t.initSegment;return e[i].segments.push(n),e[i].bytes+=n.byteLength,e[i].initSegment=r,t.captions&&(e.captions=e.captions.concat(t.captions)),t.info&&(e[i].info=t.info),t.metadata&&(e.metadata=e.metadata.concat(t.metadata)),e},e),this.videoBuffer_||this.audioBuffer_||(0===e.video.bytes&&(this.videoCodec_=null),0===e.audio.bytes&&(this.audioCodec_=null),this.createRealSourceBuffers_()),e.audio.info&&this.mediaSource_.trigger({type:"audioinfo",info:e.audio.info}),e.video.info&&this.mediaSource_.trigger({type:"videoinfo",info:e.video.info}),this.appendAudioInitSegment_&&(!this.audioDisabled_&&this.audioBuffer_&&(e.audio.segments.unshift(e.audio.initSegment),e.audio.bytes+=e.audio.initSegment.byteLength),this.appendAudioInitSegment_=!1);var t=!1;this.videoBuffer_&&e.video.bytes?(e.video.segments.unshift(e.video.initSegment),e.video.bytes+=e.video.initSegment.byteLength,this.concatAndAppendSegments_(e.video,this.videoBuffer_)):!this.videoBuffer_||!this.audioDisabled_&&this.audioBuffer_||(t=!0),Ae(this,e.captions,e.metadata),!this.audioDisabled_&&this.audioBuffer_&&this.concatAndAppendSegments_(e.audio,this.audioBuffer_),this.pendingBuffers_.length=0,t&&this.trigger("updateend"),this.bufferUpdating_=!1}},{key:"concatAndAppendSegments_",value:function(e,t){var i=0,n=void 0;if(e.bytes){n=new Uint8Array(e.bytes),e.segments.forEach(function(e){n.set(e,i),i+=e.byteLength});try{t.updating=!0,t.appendBuffer(n)}catch(e){this.mediaSource_.player_&&this.mediaSource_.player_.error({code:-3,type:"APPEND_BUFFER_ERR",message:e.message,originalError:e})}}}},{key:"abort",value:function(){this.videoBuffer_&&this.videoBuffer_.abort(),!this.audioDisabled_&&this.audioBuffer_&&this.audioBuffer_.abort(),this.transmuxer_&&this.transmuxer_.postMessage({action:"reset"}),this.pendingBuffers_.length=0,this.bufferUpdating_=!1}},{key:"dispose",value:function(){this.trigger("dispose"),this.off()}}]),i}(t.EventTarget),Ke=function(e){function i(){_(this,i);var e=T(this,(i.__proto__||Object.getPrototypeOf(i)).call(this)),n=void 0;for(n in e.nativeMediaSource_=new u.MediaSource,e.nativeMediaSource_)n in i.prototype||"function"!=typeof e.nativeMediaSource_[n]||(e[n]=e.nativeMediaSource_[n].bind(e.nativeMediaSource_));return e.duration_=NaN,Object.defineProperty(e,"duration",{get:function(){return this.duration_===1/0?this.duration_:this.nativeMediaSource_.duration},set:function(e){this.duration_=e,e===1/0||(this.nativeMediaSource_.duration=e)}}),Object.defineProperty(e,"seekable",{get:function(){return this.duration_===1/0?t.createTimeRanges([[0,this.nativeMediaSource_.duration]]):this.nativeMediaSource_.seekable}}),Object.defineProperty(e,"readyState",{get:function(){return this.nativeMediaSource_.readyState}}),Object.defineProperty(e,"activeSourceBuffers",{get:function(){return this.activeSourceBuffers_}}),e.sourceBuffers=[],e.activeSourceBuffers_=[],e.updateActiveSourceBuffers_=function(){if(e.activeSourceBuffers_.length=0,1===e.sourceBuffers.length){var t=e.sourceBuffers[0];return t.appendAudioInitSegment_=!0,t.audioDisabled_=!t.audioCodec_,void e.activeSourceBuffers_.push(t)}for(var i=!1,n=!0,r=0;r<e.player_.audioTracks().length;r++){var a=e.player_.audioTracks()[r];if(a.enabled&&"main"!==a.kind){i=!0,n=!1;break}}e.sourceBuffers.forEach(function(t,r){if(t.appendAudioInitSegment_=!0,t.videoCodec_&&t.audioCodec_)t.audioDisabled_=i;else if(t.videoCodec_&&!t.audioCodec_)t.audioDisabled_=!0,n=!1;else if(!t.videoCodec_&&t.audioCodec_&&(t.audioDisabled_=r?n:!n,t.audioDisabled_))return;e.activeSourceBuffers_.push(t)})},e.onPlayerMediachange_=function(){e.sourceBuffers.forEach(function(e){e.appendAudioInitSegment_=!0})},e.onHlsReset_=function(){e.sourceBuffers.forEach(function(e){e.transmuxer_&&e.transmuxer_.postMessage({action:"resetCaptions"})})},e.onHlsSegmentTimeMapping_=function(t){e.sourceBuffers.forEach(function(e){return e.timeMapping_=t.mapping})},["sourceopen","sourceclose","sourceended"].forEach(function(e){this.nativeMediaSource_.addEventListener(e,this.trigger.bind(this))},e),e.on("sourceopen",function(i){var n=s.querySelector('[src="'+e.url_+'"]');n&&(e.player_=t(n.parentNode),e.player_&&(e.player_.tech_.on("hls-reset",e.onHlsReset_),e.player_.tech_.on("hls-segment-time-mapping",e.onHlsSegmentTimeMapping_),e.player_.audioTracks&&e.player_.audioTracks()&&(e.player_.audioTracks().on("change",e.updateActiveSourceBuffers_),e.player_.audioTracks().on("addtrack",e.updateActiveSourceBuffers_),e.player_.audioTracks().on("removetrack",e.updateActiveSourceBuffers_)),e.player_.on("mediachange",e.onPlayerMediachange_)))}),e.on("sourceended",function(t){for(var i=Ie(e.duration),n=0;n<e.sourceBuffers.length;n++){var r=e.sourceBuffers[n],a=r.metadataTrack_&&r.metadataTrack_.cues;a&&a.length&&(a[a.length-1].endTime=i)}}),e.on("sourceclose",function(e){this.sourceBuffers.forEach(function(e){e.transmuxer_&&e.transmuxer_.terminate()}),this.sourceBuffers.length=0,this.player_&&(this.player_.audioTracks&&this.player_.audioTracks()&&(this.player_.audioTracks().off("change",this.updateActiveSourceBuffers_),this.player_.audioTracks().off("addtrack",this.updateActiveSourceBuffers_),this.player_.audioTracks().off("removetrack",this.updateActiveSourceBuffers_)),this.player_.el_&&this.player_.off("mediachange",this.onPlayerMediachange_),this.player_.tech_&&this.player_.tech_.el_&&(this.player_.tech_.off("hls-reset",this.onHlsReset_),this.player_.tech_.off("hls-segment-time-mapping",this.onHlsSegmentTimeMapping_)))}),e}return b(i,e),v(i,[{key:"addSeekableRange_",value:function(e,t){var i=void 0;if(this.duration!==1/0)throw(i=new Error("MediaSource.addSeekableRange() can only be invoked when the duration is Infinity")).name="InvalidStateError",i.code=11,i;(t>this.nativeMediaSource_.duration||isNaN(this.nativeMediaSource_.duration))&&(this.nativeMediaSource_.duration=t)}},{key:"addSourceBuffer",value:function(e){var t=void 0,i=We(e);if(/^(video|audio)\/mp2t$/i.test(i.type)){var n=[];i.parameters&&i.parameters.codecs&&(n=i.parameters.codecs.split(","),n=(n=He(n)).filter(function(e){return ze(e)||Xe(e)})),0===n.length&&(n=["avc1.4d400d","mp4a.40.2"]),t=new $e(this,n),0!==this.sourceBuffers.length&&(this.sourceBuffers[0].createRealSourceBuffers_(),t.createRealSourceBuffers_(),this.sourceBuffers[0].audioDisabled_=!0)}else t=this.nativeMediaSource_.addSourceBuffer(e);return this.sourceBuffers.push(t),t}},{key:"dispose",value:function(){this.trigger("dispose"),this.off(),this.sourceBuffers.forEach(function(e){e.dispose&&e.dispose()}),this.sourceBuffers.length=0}}]),i}(t.EventTarget),Qe=0;t.mediaSources={};var Je=function(e,i){var n=t.mediaSources[e];if(!n)throw new Error("Media Source not found (Video.js)");n.trigger({type:"sourceopen",swfId:i})},Ze=function(){return!!u.MediaSource&&!!u.MediaSource.isTypeSupported&&u.MediaSource.isTypeSupported('video/mp4;codecs="avc1.4d400d,mp4a.40.2"')},et=function(){if(this.MediaSource={open:Je,supportsNativeMediaSources:Ze},Ze())return new Ke;throw new Error("Cannot use create a virtual MediaSource for this video")};et.open=Je,et.supportsNativeMediaSources=Ze;var tt={createObjectURL:function(e){var i=void 0;return e instanceof Ke?(i=u.URL.createObjectURL(e.nativeMediaSource_),e.url_=i,i):e instanceof Ke?(i="blob:vjs-media-source/"+Qe,Qe++,t.mediaSources[i]=e,i):(i=u.URL.createObjectURL(e),e.url_=i,i)}};function it(e){return e&&"object"==typeof e&&"default"in e?e.default:e}t.MediaSource=et,t.URL=tt;var nt=it(o),rt=it(u),at=function(e,t){return/^[a-z]+:/i.test(t)?t:(/\/\//i.test(e)||(e=nt.buildAbsoluteURL(rt.location&&rt.location.href||"",e)),nt.buildAbsoluteURL(e,t))};var st,ot=(st=u)&&"object"==typeof st&&"default"in st?st.default:st,ut=function(e){return ot.atob?ot.atob(e):Buffer.from(e,"base64").toString("binary")};var dt=function(e){for(var t=ut(e),i=new Uint8Array(t.length),n=0;n<t.length;n++)i[n]=t.charCodeAt(n);return i},lt=/[A-Z_a-z\xC0-\xD6\xD8-\xF6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD]/,ct=new RegExp("[\\-\\.0-9"+lt.source.slice(1,-1)+"\\u00B7\\u0300-\\u036F\\u203F-\\u2040]"),ht=new RegExp("^"+lt.source+ct.source+"*(?::"+lt.source+ct.source+"*)?$"),ft=0,pt=1,mt=2,gt=3,yt=4,_t=5,vt=6,bt=7;function Tt(){}function St(e,t){return t.lineNumber=e.lineNumber,t.columnNumber=e.columnNumber,t}function wt(e,t,i,n,r,a){for(var s,o=++t,u=ft;;){var d=e.charAt(o);switch(d){case"=":if(u===pt)s=e.slice(t,o),u=gt;else{if(u!==mt)throw new Error("attribute equal must after attrName");u=gt}break;case"'":case'"':if(u===gt||u===pt){if(u===pt&&(a.warning('attribute value must after "="'),s=e.slice(t,o)),t=o+1,!((o=e.indexOf(d,t))>0))throw new Error("attribute value no end '"+d+"' match");l=e.slice(t,o).replace(/&#?\w+;/g,r),i.add(s,l,t-1),u=_t}else{if(u!=yt)throw new Error('attribute value must after "="');l=e.slice(t,o).replace(/&#?\w+;/g,r),i.add(s,l,t),a.warning('attribute "'+s+'" missed start quot('+d+")!!"),t=o+1,u=_t}break;case"/":switch(u){case ft:i.setTagName(e.slice(t,o));case _t:case vt:case bt:u=bt,i.closed=!0;case yt:case pt:case mt:break;default:throw new Error("attribute invalid close char('/')")}break;case"":return a.error("unexpected end of input"),u==ft&&i.setTagName(e.slice(t,o)),o;case">":switch(u){case ft:i.setTagName(e.slice(t,o));case _t:case vt:case bt:break;case yt:case pt:"/"===(l=e.slice(t,o)).slice(-1)&&(i.closed=!0,l=l.slice(0,-1));case mt:u===mt&&(l=s),u==yt?(a.warning('attribute "'+l+'" missed quot(")!!'),i.add(s,l.replace(/&#?\w+;/g,r),t)):("http://www.w3.org/1999/xhtml"===n[""]&&l.match(/^(?:disabled|checked|selected)$/i)||a.warning('attribute "'+l+'" missed value!! "'+l+'" instead!!'),i.add(l,l,t));break;case gt:throw new Error("attribute value missed!!")}return o;case"":d=" ";default:if(d<=" ")switch(u){case ft:i.setTagName(e.slice(t,o)),u=vt;break;case pt:s=e.slice(t,o),u=mt;break;case yt:var l=e.slice(t,o).replace(/&#?\w+;/g,r);a.warning('attribute "'+l+'" missed quot(")!!'),i.add(s,l,t);case _t:u=vt}else switch(u){case mt:i.tagName;"http://www.w3.org/1999/xhtml"===n[""]&&s.match(/^(?:disabled|checked|selected)$/i)||a.warning('attribute "'+s+'" missed value!! "'+s+'" instead2!!'),i.add(s,s,t),t=o,u=pt;break;case _t:a.warning('attribute space is required"'+s+'"!!');case vt:u=pt,t=o;break;case gt:u=yt,t=o;break;case bt:throw new Error("elements closed character '/' and '>' must be connected to")}}o++}}function kt(e,t,i){for(var n=e.tagName,r=null,a=e.length;a--;){var s=e[a],o=s.qName,u=s.value;if((h=o.indexOf(":"))>0)var d=s.prefix=o.slice(0,h),l=o.slice(h+1),c="xmlns"===d&&l;else l=o,d=null,c="xmlns"===o&&"";s.localName=l,!1!==c&&(null==r&&(r={},At(i,i={})),i[c]=r[c]=u,s.uri="http://www.w3.org/2000/xmlns/",t.startPrefixMapping(c,u))}for(a=e.length;a--;){(d=(s=e[a]).prefix)&&("xml"===d&&(s.uri="http://www.w3.org/XML/1998/namespace"),"xmlns"!==d&&(s.uri=i[d||""]))}var h;(h=n.indexOf(":"))>0?(d=e.prefix=n.slice(0,h),l=e.localName=n.slice(h+1)):(d=null,l=e.localName=n);var f=e.uri=i[d||""];if(t.startElement(f,l,n,e),!e.closed)return e.currentNSMap=i,e.localNSMap=r,!0;if(t.endElement(f,l,n),r)for(d in r)t.endPrefixMapping(d)}function Et(e,t,i,n,r){if(/^(?:script|textarea)$/i.test(i)){var a=e.indexOf("</"+i+">",t),s=e.substring(t+1,a);if(/[&<]/.test(s))return/^script$/i.test(i)?(r.characters(s,0,s.length),a):(s=s.replace(/&#?\w+;/g,n),r.characters(s,0,s.length),a)}return t+1}function It(e,t,i,n){var r=n[i];return null==r&&((r=e.lastIndexOf("</"+i+">"))<t&&(r=e.lastIndexOf("</"+i)),n[i]=r),r<t}function At(e,t){for(var i in e)t[i]=e[i]}function Lt(e,t,i,n){switch(e.charAt(t+2)){case"-":return"-"===e.charAt(t+3)?(r=e.indexOf("--\x3e",t+4))>t?(i.comment(e,t+4,r-t-4),r+3):(n.error("Unclosed comment"),-1):-1;default:if("CDATA["==e.substr(t+3,6)){var r=e.indexOf("]]>",t+9);return i.startCDATA(),i.characters(e,t+9,r-t-9),i.endCDATA(),r+3}var a=function(e,t){var i,n=[],r=/'[^']+'|"[^"]+"|[^\s<>\/=]+=?|(\/?\s*>|<)/g;r.lastIndex=t,r.exec(e);for(;i=r.exec(e);)if(n.push(i),i[1])return n}(e,t),s=a.length;if(s>1&&/!doctype/i.test(a[0][0])){var o=a[1][0],u=s>3&&/^public$/i.test(a[2][0])&&a[3][0],d=s>4&&a[4][0],l=a[s-1];return i.startDTD(o,u&&u.replace(/^(['"])(.*?)\1$/,"$2"),d&&d.replace(/^(['"])(.*?)\1$/,"$2")),i.endDTD(),l.index+l[0].length}}return-1}function Ct(e,t,i){var n=e.indexOf("?>",t);if(n){var r=e.substring(t,n).match(/^<\?(\S*)\s*([\s\S]*?)\s*$/);if(r){r[0].length;return i.processingInstruction(r[1],r[2]),n+2}return-1}return-1}function Ut(e){}function Ot(e,t){return e.__proto__=t,e}Tt.prototype={parse:function(e,t,i){var n=this.domBuilder;n.startDocument(),At(t,t={}),function(e,t,i,n,r){function a(e){var t=e.slice(1,-1);return t in i?i[t]:"#"===t.charAt(0)?function(e){if(e>65535){var t=55296+((e-=65536)>>10),i=56320+(1023&e);return String.fromCharCode(t,i)}return String.fromCharCode(e)}(parseInt(t.substr(1).replace("x","0x"))):(r.error("entity not found:"+e),e)}function s(t){if(t>p){var i=e.substring(p,t).replace(/&#?\w+;/g,a);c&&o(p),n.characters(i,0,t-p),p=t}}function o(t,i){for(;t>=d&&(i=l.exec(e));)u=i.index,d=u+i[0].length,c.lineNumber++;c.columnNumber=t-u+1}var u=0,d=0,l=/.*(?:\r\n?|\n)|.*$/g,c=n.locator,h=[{currentNSMap:t}],f={},p=0;for(;;){try{var m=e.indexOf("<",p);if(m<0){if(!e.substr(p).match(/^\s*$/)){var g=n.doc,y=g.createTextNode(e.substr(p));g.appendChild(y),n.currentElement=y}return}switch(m>p&&s(m),e.charAt(m+1)){case"/":var _=e.indexOf(">",m+3),v=e.substring(m+2,_),b=h.pop();_<0?(v=e.substring(m+2).replace(/[\s<].*/,""),r.error("end tag name: "+v+" is not complete:"+b.tagName),_=m+1+v.length):v.match(/\s</)&&(v=v.replace(/[\s<].*/,""),r.error("end tag name: "+v+" maybe not complete"),_=m+1+v.length);var T=b.localNSMap,S=b.tagName==v,w=S||b.tagName&&b.tagName.toLowerCase()==v.toLowerCase();if(w){if(n.endElement(b.uri,b.localName,v),T)for(var k in T)n.endPrefixMapping(k);S||r.fatalError("end tag name: "+v+" is not match the current start tagName:"+b.tagName)}else h.push(b);_++;break;case"?":c&&o(m),_=Ct(e,m,n);break;case"!":c&&o(m),_=Lt(e,m,n,r);break;default:c&&o(m);var E=new Ut,I=h[h.length-1].currentNSMap,_=wt(e,m,E,I,a,r),A=E.length;if(!E.closed&&It(e,_,E.tagName,f)&&(E.closed=!0,i.nbsp||r.warning("unclosed xml attribute")),c&&A){for(var L=St(c,{}),C=0;C<A;C++){var U=E[C];o(U.offset),U.locator=St(c,{})}n.locator=L,kt(E,n,I)&&h.push(E),n.locator=c}else kt(E,n,I)&&h.push(E);"http://www.w3.org/1999/xhtml"!==E.uri||E.closed?_++:_=Et(e,_,E.tagName,a,n)}}catch(e){r.error("element parse error: "+e),_=-1}_>p?p=_:s(Math.max(m,p)+1)}}(e,t,i,n,this.errorHandler),n.endDocument()}},Ut.prototype={setTagName:function(e){if(!ht.test(e))throw new Error("invalid tagName:"+e);this.tagName=e},add:function(e,t,i){if(!ht.test(e))throw new Error("invalid attribute:"+e);this[this.length++]={qName:e,value:t,offset:i}},length:0,getLocalName:function(e){return this[e].localName},getLocator:function(e){return this[e].locator},getQName:function(e){return this[e].qName},getURI:function(e){return this[e].uri},getValue:function(e){return this[e].value}},Ot({},Ot.prototype)instanceof Ot||(Ot=function(e,t){function i(){}for(t in i.prototype=t,i=new i,e)i[t]=e[t];return i});var Dt={XMLReader:Tt};function Pt(e,t){for(var i in e)t[i]=e[i]}function Rt(e,t){var i=e.prototype;if(Object.create){var n=Object.create(t.prototype);i.__proto__=n}if(!(i instanceof t)){var r=function(){};r.prototype=t.prototype,Pt(i,r=new r),e.prototype=i=r}i.constructor!=e&&("function"!=typeof e&&console.error("unknow Class:"+e),i.constructor=e)}var xt="http://www.w3.org/1999/xhtml",Nt={},Mt=Nt.ELEMENT_NODE=1,Bt=Nt.ATTRIBUTE_NODE=2,qt=Nt.TEXT_NODE=3,Ft=Nt.CDATA_SECTION_NODE=4,Ht=Nt.ENTITY_REFERENCE_NODE=5,jt=Nt.ENTITY_NODE=6,Vt=Nt.PROCESSING_INSTRUCTION_NODE=7,Gt=Nt.COMMENT_NODE=8,Wt=Nt.DOCUMENT_NODE=9,zt=Nt.DOCUMENT_TYPE_NODE=10,Xt=Nt.DOCUMENT_FRAGMENT_NODE=11,Yt=Nt.NOTATION_NODE=12,$t={},Kt={},Qt=($t.INDEX_SIZE_ERR=(Kt[1]="Index size error",1),$t.DOMSTRING_SIZE_ERR=(Kt[2]="DOMString size error",2),$t.HIERARCHY_REQUEST_ERR=(Kt[3]="Hierarchy request error",3)),Jt=($t.WRONG_DOCUMENT_ERR=(Kt[4]="Wrong document",4),$t.INVALID_CHARACTER_ERR=(Kt[5]="Invalid character",5),$t.NO_DATA_ALLOWED_ERR=(Kt[6]="No data allowed",6),$t.NO_MODIFICATION_ALLOWED_ERR=(Kt[7]="No modification allowed",7),$t.NOT_FOUND_ERR=(Kt[8]="Not found",8)),Zt=($t.NOT_SUPPORTED_ERR=(Kt[9]="Not supported",9),$t.INUSE_ATTRIBUTE_ERR=(Kt[10]="Attribute in use",10));$t.INVALID_STATE_ERR=(Kt[11]="Invalid state",11),$t.SYNTAX_ERR=(Kt[12]="Syntax error",12),$t.INVALID_MODIFICATION_ERR=(Kt[13]="Invalid modification",13),$t.NAMESPACE_ERR=(Kt[14]="Invalid namespace",14),$t.INVALID_ACCESS_ERR=(Kt[15]="Invalid access",15);function ei(e,t){if(t instanceof Error)var i=t;else i=this,Error.call(this,Kt[e]),this.message=Kt[e],Error.captureStackTrace&&Error.captureStackTrace(this,ei);return i.code=e,t&&(this.message=this.message+": "+t),i}function ti(){}function ii(e,t){this._node=e,this._refresh=t,ni(this)}function ni(e){var t=e._node._inc||e._node.ownerDocument._inc;if(e._inc!=t){var i=e._refresh(e._node);Pi(e,"length",i.length),Pt(i,e),e._inc=t}}function ri(){}function ai(e,t){for(var i=e.length;i--;)if(e[i]===t)return i}function si(e,t,i,n){if(n?t[ai(t,n)]=i:t[t.length++]=i,e){i.ownerElement=e;var r=e.ownerDocument;r&&(n&&fi(r,e,n),function(e,t,i){e&&e._inc++,"http://www.w3.org/2000/xmlns/"==i.namespaceURI&&(t._nsMap[i.prefix?i.localName:""]=i.value)}(r,e,i))}}function oi(e,t,i){var n=ai(t,i);if(!(n>=0))throw ei(Jt,new Error(e.tagName+"@"+i));for(var r=t.length-1;n<r;)t[n]=t[++n];if(t.length=r,e){var a=e.ownerDocument;a&&(fi(a,e,i),i.ownerElement=null)}}function ui(e){if(this._features={},e)for(var t in e)this._features=e[t]}function di(){}function li(e){return("<"==e?"&lt;":">"==e&&"&gt;")||"&"==e&&"&amp;"||'"'==e&&"&quot;"||"&#"+e.charCodeAt()+";"}function ci(e,t){if(t(e))return!0;if(e=e.firstChild)do{if(ci(e,t))return!0}while(e=e.nextSibling)}function hi(){}function fi(e,t,i,n){e&&e._inc++,"http://www.w3.org/2000/xmlns/"==i.namespaceURI&&delete t._nsMap[i.prefix?i.localName:""]}function pi(e,t,i){if(e&&e._inc){e._inc++;var n=t.childNodes;if(i)n[n.length++]=i;else{for(var r=t.firstChild,a=0;r;)n[a++]=r,r=r.nextSibling;n.length=a}}}function mi(e,t){var i=t.previousSibling,n=t.nextSibling;return i?i.nextSibling=n:e.firstChild=n,n?n.previousSibling=i:e.lastChild=i,pi(e.ownerDocument,e),t}function gi(e,t,i){var n=t.parentNode;if(n&&n.removeChild(t),t.nodeType===Xt){var r=t.firstChild;if(null==r)return t;var a=t.lastChild}else r=a=t;var s=i?i.previousSibling:e.lastChild;r.previousSibling=s,a.nextSibling=i,s?s.nextSibling=r:e.firstChild=r,null==i?e.lastChild=a:i.previousSibling=a;do{r.parentNode=e}while(r!==a&&(r=r.nextSibling));return pi(e.ownerDocument||e,e),t.nodeType==Xt&&(t.firstChild=t.lastChild=null),t}function yi(){this._nsMap={}}function _i(){}function vi(){}function bi(){}function Ti(){}function Si(){}function wi(){}function ki(){}function Ei(){}function Ii(){}function Ai(){}function Li(){}function Ci(){}function Ui(e,t){var i=[],n=9==this.nodeType?this.documentElement:this,r=n.prefix,a=n.namespaceURI;if(a&&null==r&&null==(r=n.lookupPrefix(a)))var s=[{namespace:a,prefix:null}];return Di(this,i,e,t,s),i.join("")}function Oi(e,t,i){var n=e.prefix||"",r=e.namespaceURI;if(!n&&!r)return!1;if("xml"===n&&"http://www.w3.org/XML/1998/namespace"===r||"http://www.w3.org/2000/xmlns/"==r)return!1;for(var a=i.length;a--;){var s=i[a];if(s.prefix==n)return s.namespace!=r}return!0}function Di(e,t,i,n,r){if(n){if(!(e=n(e)))return;if("string"==typeof e)return void t.push(e)}switch(e.nodeType){case Mt:r||(r=[]);r.length;var a=e.attributes,s=a.length,o=e.firstChild,u=e.tagName;i=xt===e.namespaceURI||i,t.push("<",u);for(var d=0;d<s;d++){"xmlns"==(l=a.item(d)).prefix?r.push({prefix:l.localName,namespace:l.value}):"xmlns"==l.nodeName&&r.push({prefix:"",namespace:l.value})}for(d=0;d<s;d++){var l;if(Oi(l=a.item(d),0,r)){var c=l.prefix||"",h=l.namespaceURI,f=c?" xmlns:"+c:" xmlns";t.push(f,'="',h,'"'),r.push({prefix:c,namespace:h})}Di(l,t,i,n,r)}if(Oi(e,0,r)){c=e.prefix||"",h=e.namespaceURI,f=c?" xmlns:"+c:" xmlns";t.push(f,'="',h,'"'),r.push({prefix:c,namespace:h})}if(o||i&&!/^(?:meta|link|img|br|hr|input)$/i.test(u)){if(t.push(">"),i&&/^script$/i.test(u))for(;o;)o.data?t.push(o.data):Di(o,t,i,n,r),o=o.nextSibling;else for(;o;)Di(o,t,i,n,r),o=o.nextSibling;t.push("</",u,">")}else t.push("/>");return;case Wt:case Xt:for(o=e.firstChild;o;)Di(o,t,i,n,r),o=o.nextSibling;return;case Bt:return t.push(" ",e.name,'="',e.value.replace(/[<&"]/g,li),'"');case qt:return t.push(e.data.replace(/[<&]/g,li));case Ft:return t.push("<![CDATA[",e.data,"]]>");case Gt:return t.push("\x3c!--",e.data,"--\x3e");case zt:var p=e.publicId,m=e.systemId;if(t.push("<!DOCTYPE ",e.name),p)t.push(' PUBLIC "',p),m&&"."!=m&&t.push('" "',m),t.push('">');else if(m&&"."!=m)t.push(' SYSTEM "',m,'">');else{var g=e.internalSubset;g&&t.push(" [",g,"]"),t.push(">")}return;case Vt:return t.push("<?",e.target," ",e.data,"?>");case Ht:return t.push("&",e.nodeName,";");default:t.push("??",e.nodeName)}}function Pi(e,t,i){e[t]=i}ei.prototype=Error.prototype,Pt($t,ei),ti.prototype={length:0,item:function(e){return this[e]||null},toString:function(e,t){for(var i=[],n=0;n<this.length;n++)Di(this[n],i,e,t);return i.join("")}},ii.prototype.item=function(e){return ni(this),this[e]},Rt(ii,ti),ri.prototype={length:0,item:ti.prototype.item,getNamedItem:function(e){for(var t=this.length;t--;){var i=this[t];if(i.nodeName==e)return i}},setNamedItem:function(e){var t=e.ownerElement;if(t&&t!=this._ownerElement)throw new ei(Zt);var i=this.getNamedItem(e.nodeName);return si(this._ownerElement,this,e,i),i},setNamedItemNS:function(e){var t,i=e.ownerElement;if(i&&i!=this._ownerElement)throw new ei(Zt);return t=this.getNamedItemNS(e.namespaceURI,e.localName),si(this._ownerElement,this,e,t),t},removeNamedItem:function(e){var t=this.getNamedItem(e);return oi(this._ownerElement,this,t),t},removeNamedItemNS:function(e,t){var i=this.getNamedItemNS(e,t);return oi(this._ownerElement,this,i),i},getNamedItemNS:function(e,t){for(var i=this.length;i--;){var n=this[i];if(n.localName==t&&n.namespaceURI==e)return n}return null}},ui.prototype={hasFeature:function(e,t){var i=this._features[e.toLowerCase()];return!(!i||t&&!(t in i))},createDocument:function(e,t,i){var n=new hi;if(n.implementation=this,n.childNodes=new ti,n.doctype=i,i&&n.appendChild(i),t){var r=n.createElementNS(e,t);n.appendChild(r)}return n},createDocumentType:function(e,t,i){var n=new wi;return n.name=e,n.nodeName=e,n.publicId=t,n.systemId=i,n}},di.prototype={firstChild:null,lastChild:null,previousSibling:null,nextSibling:null,attributes:null,parentNode:null,childNodes:null,ownerDocument:null,nodeValue:null,namespaceURI:null,prefix:null,localName:null,insertBefore:function(e,t){return gi(this,e,t)},replaceChild:function(e,t){this.insertBefore(e,t),t&&this.removeChild(t)},removeChild:function(e){return mi(this,e)},appendChild:function(e){return this.insertBefore(e,null)},hasChildNodes:function(){return null!=this.firstChild},cloneNode:function(e){return function e(t,i,n){var r=new i.constructor;for(var a in i){var s=i[a];"object"!=typeof s&&s!=r[a]&&(r[a]=s)}i.childNodes&&(r.childNodes=new ti);r.ownerDocument=t;switch(r.nodeType){case Mt:var o=i.attributes,u=r.attributes=new ri,d=o.length;u._ownerElement=r;for(var l=0;l<d;l++)r.setAttributeNode(e(t,o.item(l),!0));break;case Bt:n=!0}if(n)for(var c=i.firstChild;c;)r.appendChild(e(t,c,n)),c=c.nextSibling;return r}(this.ownerDocument||this,this,e)},normalize:function(){for(var e=this.firstChild;e;){var t=e.nextSibling;t&&t.nodeType==qt&&e.nodeType==qt?(this.removeChild(t),e.appendData(t.data)):(e.normalize(),e=t)}},isSupported:function(e,t){return this.ownerDocument.implementation.hasFeature(e,t)},hasAttributes:function(){return this.attributes.length>0},lookupPrefix:function(e){for(var t=this;t;){var i=t._nsMap;if(i)for(var n in i)if(i[n]==e)return n;t=t.nodeType==Bt?t.ownerDocument:t.parentNode}return null},lookupNamespaceURI:function(e){for(var t=this;t;){var i=t._nsMap;if(i&&e in i)return i[e];t=t.nodeType==Bt?t.ownerDocument:t.parentNode}return null},isDefaultNamespace:function(e){return null==this.lookupPrefix(e)}},Pt(Nt,di),Pt(Nt,di.prototype),hi.prototype={nodeName:"#document",nodeType:Wt,doctype:null,documentElement:null,_inc:1,insertBefore:function(e,t){if(e.nodeType==Xt){for(var i=e.firstChild;i;){var n=i.nextSibling;this.insertBefore(i,t),i=n}return e}return null==this.documentElement&&e.nodeType==Mt&&(this.documentElement=e),gi(this,e,t),e.ownerDocument=this,e},removeChild:function(e){return this.documentElement==e&&(this.documentElement=null),mi(this,e)},importNode:function(e,t){return function e(t,i,n){var r;switch(i.nodeType){case Mt:(r=i.cloneNode(!1)).ownerDocument=t;case Xt:break;case Bt:n=!0}r||(r=i.cloneNode(!1));r.ownerDocument=t;r.parentNode=null;if(n)for(var a=i.firstChild;a;)r.appendChild(e(t,a,n)),a=a.nextSibling;return r}(this,e,t)},getElementById:function(e){var t=null;return ci(this.documentElement,function(i){if(i.nodeType==Mt&&i.getAttribute("id")==e)return t=i,!0}),t},createElement:function(e){var t=new yi;return t.ownerDocument=this,t.nodeName=e,t.tagName=e,t.childNodes=new ti,(t.attributes=new ri)._ownerElement=t,t},createDocumentFragment:function(){var e=new Ai;return e.ownerDocument=this,e.childNodes=new ti,e},createTextNode:function(e){var t=new bi;return t.ownerDocument=this,t.appendData(e),t},createComment:function(e){var t=new Ti;return t.ownerDocument=this,t.appendData(e),t},createCDATASection:function(e){var t=new Si;return t.ownerDocument=this,t.appendData(e),t},createProcessingInstruction:function(e,t){var i=new Li;return i.ownerDocument=this,i.tagName=i.target=e,i.nodeValue=i.data=t,i},createAttribute:function(e){var t=new _i;return t.ownerDocument=this,t.name=e,t.nodeName=e,t.localName=e,t.specified=!0,t},createEntityReference:function(e){var t=new Ii;return t.ownerDocument=this,t.nodeName=e,t},createElementNS:function(e,t){var i=new yi,n=t.split(":"),r=i.attributes=new ri;return i.childNodes=new ti,i.ownerDocument=this,i.nodeName=t,i.tagName=t,i.namespaceURI=e,2==n.length?(i.prefix=n[0],i.localName=n[1]):i.localName=t,r._ownerElement=i,i},createAttributeNS:function(e,t){var i=new _i,n=t.split(":");return i.ownerDocument=this,i.nodeName=t,i.name=t,i.namespaceURI=e,i.specified=!0,2==n.length?(i.prefix=n[0],i.localName=n[1]):i.localName=t,i}},Rt(hi,di),yi.prototype={nodeType:Mt,hasAttribute:function(e){return null!=this.getAttributeNode(e)},getAttribute:function(e){var t=this.getAttributeNode(e);return t&&t.value||""},getAttributeNode:function(e){return this.attributes.getNamedItem(e)},setAttribute:function(e,t){var i=this.ownerDocument.createAttribute(e);i.value=i.nodeValue=""+t,this.setAttributeNode(i)},removeAttribute:function(e){var t=this.getAttributeNode(e);t&&this.removeAttributeNode(t)},appendChild:function(e){return e.nodeType===Xt?this.insertBefore(e,null):function(e,t){var i=t.parentNode;if(i){var n=e.lastChild;i.removeChild(t),n=e.lastChild}return n=e.lastChild,t.parentNode=e,t.previousSibling=n,t.nextSibling=null,n?n.nextSibling=t:e.firstChild=t,e.lastChild=t,pi(e.ownerDocument,e,t),t}(this,e)},setAttributeNode:function(e){return this.attributes.setNamedItem(e)},setAttributeNodeNS:function(e){return this.attributes.setNamedItemNS(e)},removeAttributeNode:function(e){return this.attributes.removeNamedItem(e.nodeName)},removeAttributeNS:function(e,t){var i=this.getAttributeNodeNS(e,t);i&&this.removeAttributeNode(i)},hasAttributeNS:function(e,t){return null!=this.getAttributeNodeNS(e,t)},getAttributeNS:function(e,t){var i=this.getAttributeNodeNS(e,t);return i&&i.value||""},setAttributeNS:function(e,t,i){var n=this.ownerDocument.createAttributeNS(e,t);n.value=n.nodeValue=""+i,this.setAttributeNode(n)},getAttributeNodeNS:function(e,t){return this.attributes.getNamedItemNS(e,t)},getElementsByTagName:function(e){return new ii(this,function(t){var i=[];return ci(t,function(n){n===t||n.nodeType!=Mt||"*"!==e&&n.tagName!=e||i.push(n)}),i})},getElementsByTagNameNS:function(e,t){return new ii(this,function(i){var n=[];return ci(i,function(r){r===i||r.nodeType!==Mt||"*"!==e&&r.namespaceURI!==e||"*"!==t&&r.localName!=t||n.push(r)}),n})}},hi.prototype.getElementsByTagName=yi.prototype.getElementsByTagName,hi.prototype.getElementsByTagNameNS=yi.prototype.getElementsByTagNameNS,Rt(yi,di),_i.prototype.nodeType=Bt,Rt(_i,di),vi.prototype={data:"",substringData:function(e,t){return this.data.substring(e,e+t)},appendData:function(e){e=this.data+e,this.nodeValue=this.data=e,this.length=e.length},insertData:function(e,t){this.replaceData(e,0,t)},appendChild:function(e){throw new Error(Kt[Qt])},deleteData:function(e,t){this.replaceData(e,t,"")},replaceData:function(e,t,i){i=this.data.substring(0,e)+i+this.data.substring(e+t),this.nodeValue=this.data=i,this.length=i.length}},Rt(vi,di),bi.prototype={nodeName:"#text",nodeType:qt,splitText:function(e){var t=this.data,i=t.substring(e);t=t.substring(0,e),this.data=this.nodeValue=t,this.length=t.length;var n=this.ownerDocument.createTextNode(i);return this.parentNode&&this.parentNode.insertBefore(n,this.nextSibling),n}},Rt(bi,vi),Ti.prototype={nodeName:"#comment",nodeType:Gt},Rt(Ti,vi),Si.prototype={nodeName:"#cdata-section",nodeType:Ft},Rt(Si,vi),wi.prototype.nodeType=zt,Rt(wi,di),ki.prototype.nodeType=Yt,Rt(ki,di),Ei.prototype.nodeType=jt,Rt(Ei,di),Ii.prototype.nodeType=Ht,Rt(Ii,di),Ai.prototype.nodeName="#document-fragment",Ai.prototype.nodeType=Xt,Rt(Ai,di),Li.prototype.nodeType=Vt,Rt(Li,di),Ci.prototype.serializeToString=function(e,t,i){return Ui.call(e,t,i)},di.prototype.toString=Ui;try{if(Object.defineProperty){Object.defineProperty(ii.prototype,"length",{get:function(){return ni(this),this.$$length}}),Object.defineProperty(di.prototype,"textContent",{get:function(){return function e(t){switch(t.nodeType){case Mt:case Xt:var i=[];for(t=t.firstChild;t;)7!==t.nodeType&&8!==t.nodeType&&i.push(e(t)),t=t.nextSibling;return i.join("");default:return t.nodeValue}}(this)},set:function(e){switch(this.nodeType){case Mt:case Xt:for(;this.firstChild;)this.removeChild(this.firstChild);(e||String(e))&&this.appendChild(this.ownerDocument.createTextNode(e));break;default:this.data=e,this.value=e,this.nodeValue=e}}}),Pi=function(e,t,i){e["$$"+t]=i}}}catch(e){}var Ri,xi,Ni={DOMImplementation:ui,XMLSerializer:Ci},Mi=n(function(e,t){function i(e){this.options=e||{locator:{}}}function n(){this.cdata=!1}function r(e,t){t.lineNumber=e.lineNumber,t.columnNumber=e.columnNumber}function a(e){if(e)return"\n@"+(e.systemId||"")+"#[line:"+e.lineNumber+",col:"+e.columnNumber+"]"}function s(e,t,i){return"string"==typeof e?e.substr(t,i):e.length>=t+i||t?new java.lang.String(e,t,i)+"":e}function o(e,t){e.currentElement?e.currentElement.appendChild(t):e.doc.appendChild(t)}i.prototype.parseFromString=function(e,t){var i=this.options,r=new u,s=i.domBuilder||new n,o=i.errorHandler,d=i.locator,l=i.xmlns||{},c={lt:"<",gt:">",amp:"&",quot:'"',apos:"'"};return d&&s.setDocumentLocator(d),r.errorHandler=function(e,t,i){if(!e){if(t instanceof n)return t;e=t}var r={},s=e instanceof Function;function o(t){var n=e[t];!n&&s&&(n=2==e.length?function(i){e(t,i)}:e),r[t]=n&&function(e){n("[xmldom "+t+"]\t"+e+a(i))}||function(){}}return i=i||{},o("warning"),o("error"),o("fatalError"),r}(o,s,d),r.domBuilder=i.domBuilder||s,/\/x?html?$/.test(t)&&(c.nbsp=" ",c.copy="©",l[""]="http://www.w3.org/1999/xhtml"),l.xml=l.xml||"http://www.w3.org/XML/1998/namespace",e?r.parse(e,l,c):r.errorHandler.error("invalid doc source"),s.doc},n.prototype={startDocument:function(){this.doc=(new d).createDocument(null,null,null),this.locator&&(this.doc.documentURI=this.locator.systemId)},startElement:function(e,t,i,n){var a=this.doc,s=a.createElementNS(e,i||t),u=n.length;o(this,s),this.currentElement=s,this.locator&&r(this.locator,s);for(var d=0;d<u;d++){e=n.getURI(d);var l=n.getValue(d),c=(i=n.getQName(d),a.createAttributeNS(e,i));this.locator&&r(n.getLocator(d),c),c.value=c.nodeValue=l,s.setAttributeNode(c)}},endElement:function(e,t,i){var n=this.currentElement;n.tagName;this.currentElement=n.parentNode},startPrefixMapping:function(e,t){},endPrefixMapping:function(e){},processingInstruction:function(e,t){var i=this.doc.createProcessingInstruction(e,t);this.locator&&r(this.locator,i),o(this,i)},ignorableWhitespace:function(e,t,i){},characters:function(e,t,i){if(e=s.apply(this,arguments)){if(this.cdata)var n=this.doc.createCDATASection(e);else n=this.doc.createTextNode(e);this.currentElement?this.currentElement.appendChild(n):/^\s*$/.test(e)&&this.doc.appendChild(n),this.locator&&r(this.locator,n)}},skippedEntity:function(e){},endDocument:function(){this.doc.normalize()},setDocumentLocator:function(e){(this.locator=e)&&(e.lineNumber=0)},comment:function(e,t,i){e=s.apply(this,arguments);var n=this.doc.createComment(e);this.locator&&r(this.locator,n),o(this,n)},startCDATA:function(){this.cdata=!0},endCDATA:function(){this.cdata=!1},startDTD:function(e,t,i){var n=this.doc.implementation;if(n&&n.createDocumentType){var a=n.createDocumentType(e,t,i);this.locator&&r(this.locator,a),o(this,a)}},warning:function(e){console.warn("[xmldom warning]\t"+e,a(this.locator))},error:function(e){console.error("[xmldom error]\t"+e,a(this.locator))},fatalError:function(e){throw console.error("[xmldom fatalError]\t"+e,a(this.locator)),e}},"endDTD,startEntity,endEntity,attributeDecl,elementDecl,externalEntityDecl,internalEntityDecl,resolveEntity,getExternalSubset,notationDecl,unparsedEntityDecl".replace(/\w+/g,function(e){n.prototype[e]=function(){return null}});var u=Dt.XMLReader,d=t.DOMImplementation=Ni.DOMImplementation;t.XMLSerializer=Ni.XMLSerializer,t.DOMParser=i}),Bi=(Mi.DOMImplementation,Mi.XMLSerializer,Mi.DOMParser),qi=function(e){return!!e&&"object"==typeof e},Fi=function e(){for(var t=arguments.length,i=new Array(t),n=0;n<t;n++)i[n]=arguments[n];return i.reduce(function(t,i){return Object.keys(i).forEach(function(n){Array.isArray(t[n])&&Array.isArray(i[n])?t[n]=t[n].concat(i[n]):qi(t[n])&&qi(i[n])?t[n]=e(t[n],i[n]):t[n]=i[n]}),t},{})},Hi=function(e){return e.reduce(function(e,t){return e.concat(t)},[])},ji=function(e){if(!e.length)return[];for(var t=[],i=0;i<e.length;i++)t.push(e[i]);return t},Vi="INVALID_NUMBER_OF_PERIOD",Gi="DASH_EMPTY_MANIFEST",Wi="DASH_INVALID_XML",zi="NO_BASE_URL",Xi="SEGMENT_TIME_UNSPECIFIED",Yi="UNSUPPORTED_UTC_TIMING_SCHEME",$i=function(e){var t=e.baseUrl,i=void 0===t?"":t,n=e.source,r=void 0===n?"":n,a=e.range,s=void 0===a?"":a,o=e.indexRange,u=void 0===o?"":o,d={uri:r,resolvedUri:at(i||"",r)};if(s||u){var l=(s||u).split("-"),c=parseInt(l[0],10),h=parseInt(l[1],10);d.byterange={length:h-c+1,offset:c}}return d},Ki={static:function(e){var t=e.duration,i=e.timescale,n=void 0===i?1:i,r=e.sourceDuration;return{start:0,end:Math.ceil(r/(t/n))}},dynamic:function(e){var t=e.NOW,i=e.clientOffset,n=e.availabilityStartTime,r=e.timescale,a=void 0===r?1:r,s=e.duration,o=e.start,u=void 0===o?0:o,d=e.minimumUpdatePeriod,l=void 0===d?0:d,c=e.timeShiftBufferDepth,h=void 0===c?1/0:c,f=(t+i)/1e3,p=n+u,m=f+l-p,g=Math.ceil(m*a/s),y=Math.floor((f-p-h)*a/s),_=Math.floor((f-p)*a/s);return{start:Math.max(0,y),end:Math.min(g,_)}}},Qi=function(e){var t=e.type,i=void 0===t?"static":t,n=e.duration,r=e.timescale,a=void 0===r?1:r,s=e.sourceDuration,o=Ki[i](e),u=function(e,t){for(var i=[],n=e;n<t;n++)i.push(n);return i}(o.start,o.end).map(function(e){return function(t,i){var n=e.duration,r=e.timescale,a=void 0===r?1:r,s=e.periodIndex,o=e.startNumber;return{number:(void 0===o?1:o)+t,duration:n/a,timeline:s,time:i*n}}}(e));if("static"===i){var d=u.length-1;u[d].duration=s-n/a*d}return u},Ji=function(e){var t=e.baseUrl,i=e.initialization,n=void 0===i?{}:i,r=e.sourceDuration,a=e.timescale,s=void 0===a?1:a,o=e.indexRange,u=void 0===o?"":o,d=e.duration;if(!t)throw new Error(zi);var l=$i({baseUrl:t,source:n.sourceURL,range:n.range}),c=$i({baseUrl:t,source:t,indexRange:u});if(c.map=l,d){var h=Qi(e);h.length&&(c.duration=h[0].duration,c.timeline=h[0].timeline)}else r&&(c.duration=r/s,c.timeline=0);return c.number=0,[c]},Zi=function(e,t,i){for(var n=e.sidx.map?e.sidx.map:null,r=e.sidx.duration,a=e.timeline||0,s=e.sidx.byterange,o=s.offset+s.length,u=t.timescale,d=t.references.filter(function(e){return 1!==e.referenceType}),l=[],c=o+t.firstOffset,h=0;h<d.length;h++){var f=t.references[h],p=f.referencedSize,m=f.subsegmentDuration,g=Ji({baseUrl:i,timescale:u,timeline:a,periodIndex:a,duration:m,sourceDuration:r,indexRange:c+"-"+(c+p-1)})[0];n&&(g.map=n),l.push(g),c+=p}return e.segments=l,e},en=function(e){var t;return(t=e.reduce(function(e,t){var i,n=t.attributes.id+(t.attributes.lang||"");e[n]?(t.segments[0]&&(t.segments[0].discontinuity=!0),(i=e[n].segments).push.apply(i,t.segments),t.attributes.contentProtection&&(e[n].attributes.contentProtection=t.attributes.contentProtection)):e[n]=t;return e},{}),Object.keys(t).map(function(e){return t[e]})).map(function(e){var t,i;return e.discontinuityStarts=(t=e.segments,i="discontinuity",t.reduce(function(e,t,n){return t[i]&&e.push(n),e},[])),e})},tn=function(e,t){if(void 0===t&&(t={}),!Object.keys(t).length)return e;for(var i in e){var n=e[i];if(n.sidx){var r=n.sidx.uri+"-"+(s=n.sidx.byterange,void 0,o=s.offset+s.length-1,s.offset+"-"+o),a=t[r]&&t[r].sidx;n.sidx&&a&&Zi(n,a,n.sidx.resolvedUri)}}var s,o;return e},nn=function(e){var t,i=e.attributes,n=e.segments,r=e.sidx,a={attributes:(t={NAME:i.id,AUDIO:"audio",SUBTITLES:"subs",RESOLUTION:{width:i.width,height:i.height},CODECS:i.codecs,BANDWIDTH:i.bandwidth},t["PROGRAM-ID"]=1,t),uri:"",endList:"static"===(i.type||"static"),timeline:i.periodIndex,resolvedUri:"",targetDuration:i.duration,segments:n,mediaSequence:n.length?n[0].number:1};return i.contentProtection&&(a.contentProtection=i.contentProtection),r&&(a.sidx=r),a},rn=function(e,t){var i;if(void 0===t&&(t={}),!e.length)return{};var n=e[0].attributes,r=n.sourceDuration,a=n.type,s=void 0===a?"static":a,o=n.suggestedPresentationDelay,u=n.minimumUpdatePeriod,d=void 0===u?0:u,l=en(e.filter(function(e){var t=e.attributes;return"video/mp4"===t.mimeType||"video"===t.contentType})).map(nn),c=en(e.filter(function(e){var t=e.attributes;return"audio/mp4"===t.mimeType||"audio"===t.contentType})),h=e.filter(function(e){var t=e.attributes;return"text/vtt"===t.mimeType||"text"===t.contentType}),f={allowCache:!0,discontinuityStarts:[],segments:[],endList:!0,mediaGroups:(i={AUDIO:{},VIDEO:{}},i["CLOSED-CAPTIONS"]={},i.SUBTITLES={},i),uri:"",duration:r,playlists:tn(l,t),minimumUpdatePeriod:1e3*d};return"dynamic"===s&&(f.suggestedPresentationDelay=o),c.length&&(f.mediaGroups.AUDIO.audio=function(e,t){var i;void 0===t&&(t={});var n=e.reduce(function(e,n){var r=n.attributes.role&&n.attributes.role.value||"",a=n.attributes.lang||"",s="main";if(a){var o=r?" ("+r+")":"";s=""+n.attributes.lang+o}return e[s]&&e[s].playlists[0].attributes.BANDWIDTH>n.attributes.bandwidth?e:(e[s]={language:a,autoselect:!0,default:"main"===r,playlists:tn([function(e){var t,i=e.attributes,n=e.segments,r=e.sidx,a={attributes:(t={NAME:i.id,BANDWIDTH:i.bandwidth,CODECS:i.codecs},t["PROGRAM-ID"]=1,t),uri:"",endList:"static"===(i.type||"static"),timeline:i.periodIndex,resolvedUri:"",targetDuration:i.duration,segments:n,mediaSequence:n.length?n[0].number:1};return i.contentProtection&&(a.contentProtection=i.contentProtection),r&&(a.sidx=r),a}(n)],t),uri:""},void 0===i&&"main"===r&&((i=n).default=!0),e)},{});i||(n[Object.keys(n)[0]].default=!0);return n}(c,t)),h.length&&(f.mediaGroups.SUBTITLES.subs=function(e,t){return void 0===t&&(t={}),e.reduce(function(e,i){var n,r,a,s,o=i.attributes.lang||"text";return e[o]?e:(e[o]={language:o,default:!1,autoselect:!1,playlists:tn([(n=i,a=n.attributes,s=n.segments,void 0===s&&(s=[{uri:a.baseUrl,timeline:a.periodIndex,resolvedUri:a.baseUrl||"",duration:a.sourceDuration,number:0}],a.duration=a.sourceDuration),{attributes:(r={NAME:a.id,BANDWIDTH:a.bandwidth},r["PROGRAM-ID"]=1,r),uri:"",endList:"static"===(a.type||"static"),timeline:a.periodIndex,resolvedUri:a.baseUrl||"",targetDuration:a.duration,segments:s,mediaSequence:s.length?s[0].number:1})],t),uri:""},e)},{})}(h,t)),f},an=function(e,t,i){var n=e.NOW,r=e.clientOffset,a=e.availabilityStartTime,s=e.timescale,o=void 0===s?1:s,u=e.start,d=void 0===u?0:u,l=e.minimumUpdatePeriod,c=(n+r)/1e3+(void 0===l?0:l)-(a+d);return Math.ceil((c*o-t)/i)},sn=function(e,t){for(var i=e.type,n=void 0===i?"static":i,r=e.minimumUpdatePeriod,a=void 0===r?0:r,s=e.media,o=void 0===s?"":s,u=e.sourceDuration,d=e.timescale,l=void 0===d?1:d,c=e.startNumber,h=void 0===c?1:c,f=e.periodIndex,p=[],m=-1,g=0;g<t.length;g++){var y=t[g],_=y.d,v=y.r||0,b=y.t||0;m<0&&(m=b),b&&b>m&&(m=b);var T=void 0;if(v<0){var S=g+1;T=S===t.length?"dynamic"===n&&a>0&&o.indexOf("$Number$")>0?an(e,m,_):(u*l-m)/_:(t[S].t-m)/_}else T=v+1;for(var w=h+p.length+T,k=h+p.length;k<w;)p.push({number:k,duration:_/l,time:m,timeline:f}),m+=_,k++}return p},on=/\$([A-z]*)(?:(%0)([0-9]+)d)?\$/g,un=function(e,t){return e.replace(on,function(e){return function(t,i,n,r){if("$$"===t)return"$";if(void 0===e[i])return t;var a=""+e[i];return"RepresentationID"===i?a:(r=n?parseInt(r,10):1,a.length>=r?a:""+new Array(r-a.length+1).join("0")+a)}}(t))},dn=function(e,t){var i={RepresentationID:e.id,Bandwidth:e.bandwidth||0},n=e.initialization,r=void 0===n?{sourceURL:"",range:""}:n,a=$i({baseUrl:e.baseUrl,source:un(r.sourceURL,i),range:r.range});return function(e,t){return e.duration||t?e.duration?Qi(e):sn(e,t):[{number:e.startNumber||1,duration:e.sourceDuration,time:0,timeline:e.periodIndex}]}(e,t).map(function(t){i.Number=t.number,i.Time=t.time;var n=un(e.media||"",i);return{uri:n,timeline:t.timeline,duration:t.duration,resolvedUri:at(e.baseUrl||"",n),map:a,number:t.number}})},ln=function(e,t){var i=e.duration,n=e.segmentUrls,r=void 0===n?[]:n;if(!i&&!t||i&&t)throw new Error(Xi);var a,s=r.map(function(t){return function(e,t){var i=e.baseUrl,n=e.initialization,r=void 0===n?{}:n,a=$i({baseUrl:i,source:r.sourceURL,range:r.range}),s=$i({baseUrl:i,source:t.media,range:t.mediaRange});return s.map=a,s}(e,t)});return i&&(a=Qi(e)),t&&(a=sn(e,t)),a.map(function(e,t){if(s[t]){var i=s[t];return i.timeline=e.timeline,i.duration=e.duration,i.number=e.number,i}}).filter(function(e){return e})},cn=function(e){var t,i,n=e.attributes,r=e.segmentInfo;r.template?(i=dn,t=Fi(n,r.template)):r.base?(i=Ji,t=Fi(n,r.base)):r.list&&(i=ln,t=Fi(n,r.list));var a={attributes:n};if(!i)return a;var s=i(t,r.timeline);if(t.duration){var o=t,u=o.duration,d=o.timescale,l=void 0===d?1:d;t.duration=u/l}else s.length?t.duration=s.reduce(function(e,t){return Math.max(e,Math.ceil(t.duration))},0):t.duration=0;return a.attributes=t,a.segments=s,r.base&&t.indexRange&&(a.sidx=s[0],a.segments=[]),a},hn=function(e,t){return ji(e.childNodes).filter(function(e){return e.tagName===t})},fn=function(e){return e.textContent.trim()},pn=function(e){var t=/P(?:(\d*)Y)?(?:(\d*)M)?(?:(\d*)D)?(?:T(?:(\d*)H)?(?:(\d*)M)?(?:([\d.]*)S)?)?/.exec(e);if(!t)return 0;var i=t.slice(1),n=i[0],r=i[1],a=i[2],s=i[3],o=i[4],u=i[5];return 31536e3*parseFloat(n||0)+2592e3*parseFloat(r||0)+86400*parseFloat(a||0)+3600*parseFloat(s||0)+60*parseFloat(o||0)+parseFloat(u||0)},mn={mediaPresentationDuration:function(e){return pn(e)},availabilityStartTime:function(e){return/^\d+-\d+-\d+T\d+:\d+:\d+(\.\d+)?$/.test(t=e)&&(t+="Z"),Date.parse(t)/1e3;var t},minimumUpdatePeriod:function(e){return pn(e)},suggestedPresentationDelay:function(e){return pn(e)},type:function(e){return e},timeShiftBufferDepth:function(e){return pn(e)},start:function(e){return pn(e)},width:function(e){return parseInt(e,10)},height:function(e){return parseInt(e,10)},bandwidth:function(e){return parseInt(e,10)},startNumber:function(e){return parseInt(e,10)},timescale:function(e){return parseInt(e,10)},duration:function(e){var t=parseInt(e,10);return isNaN(t)?pn(e):t},d:function(e){return parseInt(e,10)},t:function(e){return parseInt(e,10)},r:function(e){return parseInt(e,10)},DEFAULT:function(e){return e}},gn=function(e){return e&&e.attributes?ji(e.attributes).reduce(function(e,t){var i=mn[t.name]||mn.DEFAULT;return e[t.name]=i(t.value),e},{}):{}},yn={"urn:uuid:1077efec-c0b2-4d02-ace3-3c1e52e2fb4b":"org.w3.clearkey","urn:uuid:edef8ba9-79d6-4ace-a3c8-27dcd51d21ed":"com.widevine.alpha","urn:uuid:9a04f079-9840-4286-ab92-e65be0885f95":"com.microsoft.playready","urn:uuid:f239e769-efa3-4850-9c16-a903c6932efb":"com.adobe.primetime"},_n=function(e,t){return t.length?Hi(e.map(function(e){return t.map(function(t){return at(e,fn(t))})})):e},vn=function(e){var t=hn(e,"SegmentTemplate")[0],i=hn(e,"SegmentList")[0],n=i&&hn(i,"SegmentURL").map(function(e){return Fi({tag:"SegmentURL"},gn(e))}),r=hn(e,"SegmentBase")[0],a=i||t,s=a&&hn(a,"SegmentTimeline")[0],o=i||r||t,u=o&&hn(o,"Initialization")[0],d=t&&gn(t);d&&u?d.initialization=u&&gn(u):d&&d.initialization&&(d.initialization={sourceURL:d.initialization});var l={template:d,timeline:s&&hn(s,"S").map(function(e){return gn(e)}),list:i&&Fi(gn(i),{segmentUrls:n,initialization:gn(u)}),base:r&&Fi(gn(r),{initialization:gn(u)})};return Object.keys(l).forEach(function(e){l[e]||delete l[e]}),l},bn=function(e,t,i){return function(n){var r=gn(n),a=_n(t,hn(n,"BaseURL")),s=hn(n,"Role")[0],o={role:gn(s)},u=Fi(e,r,o),d=hn(n,"ContentProtection").reduce(function(e,t){var i=gn(t),n=yn[i.schemeIdUri];if(n){e[n]={attributes:i};var r=hn(t,"cenc:pssh")[0];if(r){var a=fn(r),s=a&&dt(a);e[n].pssh=s}}return e},{});Object.keys(d).length&&(u=Fi(u,{contentProtection:d}));var l=vn(n),c=hn(n,"Representation"),h=Fi(i,l);return Hi(c.map(function(e,t,i){return function(n){var r=hn(n,"BaseURL"),a=_n(t,r),s=Fi(e,gn(n)),o=vn(n);return a.map(function(e){return{segmentInfo:Fi(i,o),attributes:Fi(s,{baseUrl:e})}})}}(u,a,h)))}},Tn=function(e,t){void 0===t&&(t={});var i=t,n=i.manifestUri,r=void 0===n?"":n,a=i.NOW,s=void 0===a?Date.now():a,o=i.clientOffset,d=void 0===o?0:o,l=hn(e,"Period");if(!l.length)throw new Error(Vi);var c=gn(e),h=_n([r],hn(e,"BaseURL"));return c.sourceDuration=c.mediaPresentationDuration||0,c.NOW=s,c.clientOffset=d,Hi(l.map(function(e,t){return function(i,n){var r=_n(t,hn(i,"BaseURL")),a=gn(i),s=parseInt(a.id,10),o=u.isNaN(s)?n:s,d=Fi(e,{periodIndex:o}),l=hn(i,"AdaptationSet"),c=vn(i);return Hi(l.map(bn(d,r,c)))}}(c,h)))},Sn=function(e){if(""===e)throw new Error(Gi);var t=(new Bi).parseFromString(e,"application/xml"),i=t&&"MPD"===t.documentElement.tagName?t.documentElement:null;if(!i||i&&i.getElementsByTagName("parsererror").length>0)throw new Error(Wi);return i},wn=function(e,t){return void 0===t&&(t={}),rn(Tn(Sn(e),t).map(cn),t.sidxMapping)},kn=function(e){return function(e){var t=hn(e,"UTCTiming")[0];if(!t)return null;var i=gn(t);switch(i.schemeIdUri){case"urn:mpeg:dash:utc:http-head:2014":case"urn:mpeg:dash:utc:http-head:2012":i.method="HEAD";break;case"urn:mpeg:dash:utc:http-xsdate:2014":case"urn:mpeg:dash:utc:http-iso:2014":case"urn:mpeg:dash:utc:http-xsdate:2012":case"urn:mpeg:dash:utc:http-iso:2012":i.method="GET";break;case"urn:mpeg:dash:utc:direct:2014":case"urn:mpeg:dash:utc:direct:2012":i.method="DIRECT",i.value=Date.parse(i.value);break;case"urn:mpeg:dash:utc:http-ntp:2014":case"urn:mpeg:dash:utc:ntp:2014":case"urn:mpeg:dash:utc:sntp:2014":default:throw new Error(Yi)}return i}(Sn(e))},En=function(e){return e>>>0},In=function(e){return("00"+e.toString(16)).slice(-2)},An=En,Ln=function(e){return new Date(1e3*e-20828448e5)},Cn=function(e){return{isLeading:(12&e[0])>>>2,dependsOn:3&e[0],isDependedOn:(192&e[1])>>>6,hasRedundancy:(48&e[1])>>>4,paddingValue:(14&e[1])>>>1,isNonSyncSample:1&e[1],degradationPriority:e[2]<<8|e[3]}},Un=function(e){var t="";return t+=String.fromCharCode(e[0]),t+=String.fromCharCode(e[1]),t+=String.fromCharCode(e[2]),t+=String.fromCharCode(e[3])},On={avc1:function(e){var t=new DataView(e.buffer,e.byteOffset,e.byteLength);return{dataReferenceIndex:t.getUint16(6),width:t.getUint16(24),height:t.getUint16(26),horizresolution:t.getUint16(28)+t.getUint16(30)/16,vertresolution:t.getUint16(32)+t.getUint16(34)/16,frameCount:t.getUint16(40),depth:t.getUint16(74),config:Ri(e.subarray(78,e.byteLength))}},avcC:function(e){var t,i,n,r,a=new DataView(e.buffer,e.byteOffset,e.byteLength),s={configurationVersion:e[0],avcProfileIndication:e[1],profileCompatibility:e[2],avcLevelIndication:e[3],lengthSizeMinusOne:3&e[4],sps:[],pps:[]},o=31&e[5];for(n=6,r=0;r<o;r++)i=a.getUint16(n),n+=2,s.sps.push(new Uint8Array(e.subarray(n,n+i))),n+=i;for(t=e[n],n++,r=0;r<t;r++)i=a.getUint16(n),n+=2,s.pps.push(new Uint8Array(e.subarray(n,n+i))),n+=i;return s},btrt:function(e){var t=new DataView(e.buffer,e.byteOffset,e.byteLength);return{bufferSizeDB:t.getUint32(0),maxBitrate:t.getUint32(4),avgBitrate:t.getUint32(8)}},esds:function(e){return{version:e[0],flags:new Uint8Array(e.subarray(1,4)),esId:e[6]<<8|e[7],streamPriority:31&e[8],decoderConfig:{objectProfileIndication:e[11],streamType:e[12]>>>2&63,bufferSize:e[13]<<16|e[14]<<8|e[15],maxBitrate:e[16]<<24|e[17]<<16|e[18]<<8|e[19],avgBitrate:e[20]<<24|e[21]<<16|e[22]<<8|e[23],decoderConfigDescriptor:{tag:e[24],length:e[25],audioObjectType:e[26]>>>3&31,samplingFrequencyIndex:(7&e[26])<<1|e[27]>>>7&1,channelConfiguration:e[27]>>>3&15}}}},ftyp:function(e){for(var t=new DataView(e.buffer,e.byteOffset,e.byteLength),i={majorBrand:Un(e.subarray(0,4)),minorVersion:t.getUint32(4),compatibleBrands:[]},n=8;n<e.byteLength;)i.compatibleBrands.push(Un(e.subarray(n,n+4))),n+=4;return i},dinf:function(e){return{boxes:Ri(e)}},dref:function(e){return{version:e[0],flags:new Uint8Array(e.subarray(1,4)),dataReferences:Ri(e.subarray(8))}},hdlr:function(e){var t={version:new DataView(e.buffer,e.byteOffset,e.byteLength).getUint8(0),flags:new Uint8Array(e.subarray(1,4)),handlerType:Un(e.subarray(8,12)),name:""},i=8;for(i=24;i<e.byteLength;i++){if(0===e[i]){i++;break}t.name+=String.fromCharCode(e[i])}return t.name=decodeURIComponent(escape(t.name)),t},mdat:function(e){return{byteLength:e.byteLength,nals:function(e){var t,i,n=new DataView(e.buffer,e.byteOffset,e.byteLength),r=[];for(t=0;t+4<e.length;t+=i)if(i=n.getUint32(t),t+=4,i<=0)r.push("<span style='color:red;'>MALFORMED DATA</span>");else switch(31&e[t]){case 1:r.push("slice_layer_without_partitioning_rbsp");break;case 5:r.push("slice_layer_without_partitioning_rbsp_idr");break;case 6:r.push("sei_rbsp");break;case 7:r.push("seq_parameter_set_rbsp");break;case 8:r.push("pic_parameter_set_rbsp");break;case 9:r.push("access_unit_delimiter_rbsp");break;default:r.push("UNKNOWN NAL - "+e[t]&31)}return r}(e)}},mdhd:function(e){var t,i=new DataView(e.buffer,e.byteOffset,e.byteLength),n=4,r={version:i.getUint8(0),flags:new Uint8Array(e.subarray(1,4)),language:""};return 1===r.version?(n+=4,r.creationTime=Ln(i.getUint32(n)),n+=8,r.modificationTime=Ln(i.getUint32(n)),n+=4,r.timescale=i.getUint32(n),n+=8,r.duration=i.getUint32(n)):(r.creationTime=Ln(i.getUint32(n)),n+=4,r.modificationTime=Ln(i.getUint32(n)),n+=4,r.timescale=i.getUint32(n),n+=4,r.duration=i.getUint32(n)),n+=4,t=i.getUint16(n),r.language+=String.fromCharCode(96+(t>>10)),r.language+=String.fromCharCode(96+((992&t)>>5)),r.language+=String.fromCharCode(96+(31&t)),r},mdia:function(e){return{boxes:Ri(e)}},mfhd:function(e){return{version:e[0],flags:new Uint8Array(e.subarray(1,4)),sequenceNumber:e[4]<<24|e[5]<<16|e[6]<<8|e[7]}},minf:function(e){return{boxes:Ri(e)}},mp4a:function(e){var t=new DataView(e.buffer,e.byteOffset,e.byteLength),i={dataReferenceIndex:t.getUint16(6),channelcount:t.getUint16(16),samplesize:t.getUint16(18),samplerate:t.getUint16(24)+t.getUint16(26)/65536};return e.byteLength>28&&(i.streamDescriptor=Ri(e.subarray(28))[0]),i},moof:function(e){return{boxes:Ri(e)}},moov:function(e){return{boxes:Ri(e)}},mvex:function(e){return{boxes:Ri(e)}},mvhd:function(e){var t=new DataView(e.buffer,e.byteOffset,e.byteLength),i=4,n={version:t.getUint8(0),flags:new Uint8Array(e.subarray(1,4))};return 1===n.version?(i+=4,n.creationTime=Ln(t.getUint32(i)),i+=8,n.modificationTime=Ln(t.getUint32(i)),i+=4,n.timescale=t.getUint32(i),i+=8,n.duration=t.getUint32(i)):(n.creationTime=Ln(t.getUint32(i)),i+=4,n.modificationTime=Ln(t.getUint32(i)),i+=4,n.timescale=t.getUint32(i),i+=4,n.duration=t.getUint32(i)),i+=4,n.rate=t.getUint16(i)+t.getUint16(i+2)/16,i+=4,n.volume=t.getUint8(i)+t.getUint8(i+1)/8,i+=2,i+=2,i+=8,n.matrix=new Uint32Array(e.subarray(i,i+36)),i+=36,i+=24,n.nextTrackId=t.getUint32(i),n},pdin:function(e){var t=new DataView(e.buffer,e.byteOffset,e.byteLength);return{version:t.getUint8(0),flags:new Uint8Array(e.subarray(1,4)),rate:t.getUint32(4),initialDelay:t.getUint32(8)}},sdtp:function(e){var t,i={version:e[0],flags:new Uint8Array(e.subarray(1,4)),samples:[]};for(t=4;t<e.byteLength;t++)i.samples.push({dependsOn:(48&e[t])>>4,isDependedOn:(12&e[t])>>2,hasRedundancy:3&e[t]});return i},sidx:function(e){var t,i=new DataView(e.buffer,e.byteOffset,e.byteLength),n={version:e[0],flags:new Uint8Array(e.subarray(1,4)),references:[],referenceId:i.getUint32(4),timescale:i.getUint32(8),earliestPresentationTime:i.getUint32(12),firstOffset:i.getUint32(16)},r=i.getUint16(22);for(t=24;r;t+=12,r--)n.references.push({referenceType:(128&e[t])>>>7,referencedSize:2147483647&i.getUint32(t),subsegmentDuration:i.getUint32(t+4),startsWithSap:!!(128&e[t+8]),sapType:(112&e[t+8])>>>4,sapDeltaTime:268435455&i.getUint32(t+8)});return n},smhd:function(e){return{version:e[0],flags:new Uint8Array(e.subarray(1,4)),balance:e[4]+e[5]/256}},stbl:function(e){return{boxes:Ri(e)}},stco:function(e){var t,i=new DataView(e.buffer,e.byteOffset,e.byteLength),n={version:e[0],flags:new Uint8Array(e.subarray(1,4)),chunkOffsets:[]},r=i.getUint32(4);for(t=8;r;t+=4,r--)n.chunkOffsets.push(i.getUint32(t));return n},stsc:function(e){var t,i=new DataView(e.buffer,e.byteOffset,e.byteLength),n=i.getUint32(4),r={version:e[0],flags:new Uint8Array(e.subarray(1,4)),sampleToChunks:[]};for(t=8;n;t+=12,n--)r.sampleToChunks.push({firstChunk:i.getUint32(t),samplesPerChunk:i.getUint32(t+4),sampleDescriptionIndex:i.getUint32(t+8)});return r},stsd:function(e){return{version:e[0],flags:new Uint8Array(e.subarray(1,4)),sampleDescriptions:Ri(e.subarray(8))}},stsz:function(e){var t,i=new DataView(e.buffer,e.byteOffset,e.byteLength),n={version:e[0],flags:new Uint8Array(e.subarray(1,4)),sampleSize:i.getUint32(4),entries:[]};for(t=12;t<e.byteLength;t+=4)n.entries.push(i.getUint32(t));return n},stts:function(e){var t,i=new DataView(e.buffer,e.byteOffset,e.byteLength),n={version:e[0],flags:new Uint8Array(e.subarray(1,4)),timeToSamples:[]},r=i.getUint32(4);for(t=8;r;t+=8,r--)n.timeToSamples.push({sampleCount:i.getUint32(t),sampleDelta:i.getUint32(t+4)});return n},styp:function(e){return On.ftyp(e)},tfdt:function(e){var t={version:e[0],flags:new Uint8Array(e.subarray(1,4)),baseMediaDecodeTime:An(e[4]<<24|e[5]<<16|e[6]<<8|e[7])};return 1===t.version&&(t.baseMediaDecodeTime*=Math.pow(2,32),t.baseMediaDecodeTime+=An(e[8]<<24|e[9]<<16|e[10]<<8|e[11])),t},tfhd:function(e){var t,i=new DataView(e.buffer,e.byteOffset,e.byteLength),n={version:e[0],flags:new Uint8Array(e.subarray(1,4)),trackId:i.getUint32(4)},r=1&n.flags[2],a=2&n.flags[2],s=8&n.flags[2],o=16&n.flags[2],u=32&n.flags[2],d=65536&n.flags[0],l=131072&n.flags[0];return t=8,r&&(t+=4,n.baseDataOffset=i.getUint32(12),t+=4),a&&(n.sampleDescriptionIndex=i.getUint32(t),t+=4),s&&(n.defaultSampleDuration=i.getUint32(t),t+=4),o&&(n.defaultSampleSize=i.getUint32(t),t+=4),u&&(n.defaultSampleFlags=i.getUint32(t)),d&&(n.durationIsEmpty=!0),!r&&l&&(n.baseDataOffsetIsMoof=!0),n},tkhd:function(e){var t=new DataView(e.buffer,e.byteOffset,e.byteLength),i=4,n={version:t.getUint8(0),flags:new Uint8Array(e.subarray(1,4))};return 1===n.version?(i+=4,n.creationTime=Ln(t.getUint32(i)),i+=8,n.modificationTime=Ln(t.getUint32(i)),i+=4,n.trackId=t.getUint32(i),i+=4,i+=8,n.duration=t.getUint32(i)):(n.creationTime=Ln(t.getUint32(i)),i+=4,n.modificationTime=Ln(t.getUint32(i)),i+=4,n.trackId=t.getUint32(i),i+=4,i+=4,n.duration=t.getUint32(i)),i+=4,i+=8,n.layer=t.getUint16(i),i+=2,n.alternateGroup=t.getUint16(i),i+=2,n.volume=t.getUint8(i)+t.getUint8(i+1)/8,i+=2,i+=2,n.matrix=new Uint32Array(e.subarray(i,i+36)),i+=36,n.width=t.getUint16(i)+t.getUint16(i+2)/16,i+=4,n.height=t.getUint16(i)+t.getUint16(i+2)/16,n},traf:function(e){return{boxes:Ri(e)}},trak:function(e){return{boxes:Ri(e)}},trex:function(e){var t=new DataView(e.buffer,e.byteOffset,e.byteLength);return{version:e[0],flags:new Uint8Array(e.subarray(1,4)),trackId:t.getUint32(4),defaultSampleDescriptionIndex:t.getUint32(8),defaultSampleDuration:t.getUint32(12),defaultSampleSize:t.getUint32(16),sampleDependsOn:3&e[20],sampleIsDependedOn:(192&e[21])>>6,sampleHasRedundancy:(48&e[21])>>4,samplePaddingValue:(14&e[21])>>1,sampleIsDifferenceSample:!!(1&e[21]),sampleDegradationPriority:t.getUint16(22)}},trun:function(e){var t,i={version:e[0],flags:new Uint8Array(e.subarray(1,4)),samples:[]},n=new DataView(e.buffer,e.byteOffset,e.byteLength),r=1&i.flags[2],a=4&i.flags[2],s=1&i.flags[1],o=2&i.flags[1],u=4&i.flags[1],d=8&i.flags[1],l=n.getUint32(4),c=8;for(r&&(i.dataOffset=n.getInt32(c),c+=4),a&&l&&(t={flags:Cn(e.subarray(c,c+4))},c+=4,s&&(t.duration=n.getUint32(c),c+=4),o&&(t.size=n.getUint32(c),c+=4),d&&(t.compositionTimeOffset=n.getUint32(c),c+=4),i.samples.push(t),l--);l--;)t={},s&&(t.duration=n.getUint32(c),c+=4),o&&(t.size=n.getUint32(c),c+=4),u&&(t.flags=Cn(e.subarray(c,c+4)),c+=4),d&&(t.compositionTimeOffset=n.getUint32(c),c+=4),i.samples.push(t);return i},"url ":function(e){return{version:e[0],flags:new Uint8Array(e.subarray(1,4))}},vmhd:function(e){var t=new DataView(e.buffer,e.byteOffset,e.byteLength);return{version:e[0],flags:new Uint8Array(e.subarray(1,4)),graphicsmode:t.getUint16(4),opcolor:new Uint16Array([t.getUint16(6),t.getUint16(8),t.getUint16(10)])}}},Dn={inspect:Ri=function(e){for(var t,i,n,r,a,s=0,o=[],u=new ArrayBuffer(e.length),d=new Uint8Array(u),l=0;l<e.length;++l)d[l]=e[l];for(t=new DataView(u);s<e.byteLength;)i=t.getUint32(s),n=Un(e.subarray(s+4,s+8)),r=i>1?s+i:e.byteLength,(a=(On[n]||function(e){return{data:e}})(e.subarray(s+8,r))).size=i,a.type=n,o.push(a),s=r;return o},textify:xi=function(e,t){var i;return t=t||0,i=new Array(2*t+1).join(" "),e.map(function(e,n){return i+e.type+"\n"+Object.keys(e).filter(function(e){return"type"!==e&&"boxes"!==e}).map(function(t){var n=i+"  "+t+": ",r=e[t];if(r instanceof Uint8Array||r instanceof Uint32Array){var a=Array.prototype.slice.call(new Uint8Array(r.buffer,r.byteOffset,r.byteLength)).map(function(e){return" "+("00"+e.toString(16)).slice(-2)}).join("").match(/.{1,24}/g);return a?1===a.length?n+"<"+a.join("").slice(1)+">":n+"<\n"+a.map(function(e){return i+"  "+e}).join("\n")+"\n"+i+"  >":n+"<>"}return n+JSON.stringify(r,null,2).split("\n").map(function(e,t){return 0===t?e:i+"  "+e}).join("\n")}).join("\n")+(e.boxes?"\n"+xi(e.boxes,t+1):"")}).join("\n")},parseType:Un,findBox:function e(t,i){var n,r,a,s,o,u=[];if(!i.length)return null;for(n=0;n<t.byteLength;)r=An(t[n]<<24|t[n+1]<<16|t[n+2]<<8|t[n+3]),a=Un(t.subarray(n+4,n+8)),s=r>1?n+r:t.byteLength,a===i[0]&&(1===i.length?u.push(t.subarray(n+8,s)):(o=e(t.subarray(n+8,s),i.slice(1))).length&&(u=u.concat(o))),n=s;return u},parseTraf:On.traf,parseTfdt:On.tfdt,parseHdlr:On.hdlr,parseTfhd:On.tfhd,parseTrun:On.trun,parseSidx:On.sidx},Pn=t.EventTarget,Rn=t.mergeOptions,xn=function(e,t){for(var i=void 0,n=Rn(e,{duration:t.duration,minimumUpdatePeriod:t.minimumUpdatePeriod}),r=0;r<t.playlists.length;r++){var a=A(n,t.playlists[r]);a?n=a:i=!0}return I(t,function(e,t,r,a){if(e.playlists&&e.playlists.length){var s=e.playlists[0].id,o=A(n,e.playlists[0]);o&&((n=o).mediaGroups[t][r][a].playlists[0]=n.playlists[s],i=!1)}}),i?null:n},Nn=function(e){var t=e.byterange.offset+e.byterange.length-1;return e.uri+"-"+e.byterange.offset+"-"+t},Mn=function(e,t){var i,n,r={};for(var a in e){var s=e[a].sidx;if(s){var o=Nn(s);if(!t[o])break;var u=t[o].sidxInfo;i=u,n=s,(Boolean(!i.map&&!n.map)||Boolean(i.map&&n.map&&i.map.byterange.offset===n.map.byterange.offset&&i.map.byterange.length===n.map.byterange.length))&&i.uri===n.uri&&i.byterange.offset===n.byterange.offset&&i.byterange.length===n.byterange.length&&(r[o]=t[o])}}return r},Bn=function(e,i,n,r,a){var s={uri:l(r.handleManifestRedirects,e.resolvedUri),byterange:e.byterange,playlist:i};return n(t.mergeOptions(s,{responseType:"arraybuffer",headers:J(s)}),a)},qn=function(e){function t(e,i){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},r=arguments[3];_(this,t);var a=T(this,(t.__proto__||Object.getPrototypeOf(t)).call(this)),s=n.withCredentials,o=void 0!==s&&s,u=n.handleManifestRedirects,d=void 0!==u&&u;if(a.hls_=i,a.withCredentials=o,a.handleManifestRedirects=d,!e)throw new Error("A non-empty playlist URL or playlist is required");return a.on("minimumUpdatePeriod",function(){a.refreshXml_()}),a.on("mediaupdatetimeout",function(){a.refreshMedia_(a.media().id)}),a.state="HAVE_NOTHING",a.loadedPlaylists_={},"string"==typeof e?(a.srcUrl=e,a.sidxMapping_={},T(a)):(a.setupChildLoader(r,e),a)}return b(t,Pn),v(t,[{key:"setupChildLoader",value:function(e,t){this.masterPlaylistLoader_=e,this.childPlaylist_=t}},{key:"dispose",value:function(){this.trigger("dispose"),this.stopRequest(),this.loadedPlaylists_={},u.clearTimeout(this.minimumUpdatePeriodTimeout_),u.clearTimeout(this.mediaRequest_),u.clearTimeout(this.mediaUpdateTimeout),this.off()}},{key:"hasPendingRequest",value:function(){return this.request||this.mediaRequest_}},{key:"stopRequest",value:function(){if(this.request){var e=this.request;this.request=null,e.onreadystatechange=null,e.abort()}}},{key:"sidxRequestFinished_",value:function(e,t,i,n){var r=this;return function(a,s){if(r.request){if(r.request=null,a)return r.error={status:s.status,message:"DASH playlist request error at URL: "+e.uri,response:s.response,code:2},i&&(r.state=i),r.trigger("error"),n(t,null);var o=new Uint8Array(s.response),u=Dn.parseSidx(o.subarray(8));return n(t,u)}}}},{key:"media",value:function(e){var t=this;if(!e)return this.media_;if("HAVE_NOTHING"===this.state)throw new Error("Cannot switch media playlist from "+this.state);var i=this.state;if("string"==typeof e){if(!this.master.playlists[e])throw new Error("Unknown playlist URI: "+e);e=this.master.playlists[e]}var n=!this.media_||e.id!==this.media_.id;if(n&&this.loadedPlaylists_[e.id]&&this.loadedPlaylists_[e.id].endList)return this.state="HAVE_METADATA",this.media_=e,void(n&&(this.trigger("mediachanging"),this.trigger("mediachange")));if(n)if(this.media_&&this.trigger("mediachanging"),e.sidx){var r=void 0,a=void 0;this.masterPlaylistLoader_?(r=this.masterPlaylistLoader_.master,a=this.masterPlaylistLoader_.sidxMapping_):(r=this.master,a=this.sidxMapping_);var s=Nn(e.sidx);a[s]={sidxInfo:e.sidx},this.request=Bn(e.sidx,e,this.hls_.xhr,{handleManifestRedirects:this.handleManifestRedirects},this.sidxRequestFinished_(e,r,i,function(n,r){if(!n||!r)throw new Error("failed to request sidx");a[s].sidx=r,t.haveMetadata({startingState:i,playlist:n.playlists[e.id]})}))}else this.mediaRequest_=u.setTimeout(this.haveMetadata.bind(this,{startingState:i,playlist:e}),0)}},{key:"haveMetadata",value:function(e){var t=e.startingState,i=e.playlist;this.state="HAVE_METADATA",this.loadedPlaylists_[i.id]=i,this.mediaRequest_=null,this.refreshMedia_(i.id),"HAVE_MASTER"===t?this.trigger("loadedmetadata"):this.trigger("mediachange")}},{key:"pause",value:function(){this.stopRequest(),u.clearTimeout(this.mediaUpdateTimeout),u.clearTimeout(this.minimumUpdatePeriodTimeout_),"HAVE_NOTHING"===this.state&&(this.started=!1)}},{key:"load",value:function(e){var t=this;u.clearTimeout(this.mediaUpdateTimeout),u.clearTimeout(this.minimumUpdatePeriodTimeout_);var i=this.media();if(e){var n=i?i.targetDuration/2*1e3:5e3;this.mediaUpdateTimeout=u.setTimeout(function(){return t.load()},n)}else this.started?i&&!i.endList?this.trigger("mediaupdatetimeout"):this.trigger("loadedplaylist"):this.start()}},{key:"parseMasterXml",value:function(){var e=wn(this.masterXml_,{manifestUri:this.srcUrl,clientOffset:this.clientOffset_,sidxMapping:this.sidxMapping_});e.uri=this.srcUrl;for(var t=0;t<e.playlists.length;t++){var i="placeholder-uri-"+t;e.playlists[t].uri=i}return I(e,function(t,i,n,r){if(t.playlists&&t.playlists.length){var a="placeholder-uri-"+i+"-"+n+"-"+r,s=L(0,a);t.playlists[0].uri=a,t.playlists[0].id=s,e.playlists[s]=t.playlists[0],e.playlists[a]=t.playlists[0]}}),C(e),U(e),e}},{key:"start",value:function(){var e=this;this.started=!0,this.masterPlaylistLoader_?this.mediaRequest_=u.setTimeout(this.haveMaster_.bind(this),0):this.request=this.hls_.xhr({uri:this.srcUrl,withCredentials:this.withCredentials},function(t,i){if(e.request){if(e.request=null,t)return e.error={status:i.status,message:"DASH playlist request error at URL: "+e.srcUrl,responseText:i.responseText,code:2},"HAVE_NOTHING"===e.state&&(e.started=!1),e.trigger("error");e.masterXml_=i.responseText,i.responseHeaders&&i.responseHeaders.date?e.masterLoaded_=Date.parse(i.responseHeaders.date):e.masterLoaded_=Date.now(),e.srcUrl=l(e.handleManifestRedirects,e.srcUrl,i),e.syncClientServerClock_(e.onClientServerClockSync_.bind(e))}})}},{key:"syncClientServerClock_",value:function(e){var t=this,i=kn(this.masterXml_);return null===i?(this.clientOffset_=this.masterLoaded_-Date.now(),e()):"DIRECT"===i.method?(this.clientOffset_=i.value-Date.now(),e()):void(this.request=this.hls_.xhr({uri:d(this.srcUrl,i.value),method:i.method,withCredentials:this.withCredentials},function(n,r){if(t.request){if(n)return t.clientOffset_=t.masterLoaded_-Date.now(),e();var a=void 0;a="HEAD"===i.method?r.responseHeaders&&r.responseHeaders.date?Date.parse(r.responseHeaders.date):t.masterLoaded_:Date.parse(r.responseText),t.clientOffset_=a-Date.now(),e()}}))}},{key:"haveMaster_",value:function(){this.state="HAVE_MASTER",this.mediaRequest_=null,this.masterPlaylistLoader_?this.media_||this.media(this.childPlaylist_):(this.master=this.parseMasterXml(),this.trigger("loadedplaylist"))}},{key:"onClientServerClockSync_",value:function(){var e=this;this.haveMaster_(),this.hasPendingRequest()||this.media_||this.media(this.master.playlists[0]),this.master&&this.master.minimumUpdatePeriod&&(this.minimumUpdatePeriodTimeout_=u.setTimeout(function(){e.trigger("minimumUpdatePeriod")},this.master.minimumUpdatePeriod))}},{key:"refreshXml_",value:function(){var e=this;this.request=this.hls_.xhr({uri:this.srcUrl,withCredentials:this.withCredentials},function(t,i){if(e.request){if(e.request=null,t)return e.error={status:i.status,message:"DASH playlist request error at URL: "+e.srcUrl,responseText:i.responseText,code:2},"HAVE_NOTHING"===e.state&&(e.started=!1),e.trigger("error");e.masterXml_=i.responseText,e.sidxMapping_=function(e,t,i,n){var r=wn(e,{manifestUri:t,clientOffset:i}),a=Mn(r.playlists,n);return I(r,function(e,t,i,r){if(e.playlists&&e.playlists.length){var s=e.playlists;a=Rn(a,Mn(s,n))}}),a}(e.masterXml_,e.srcUrl,e.clientOffset_,e.sidxMapping_);var n=e.parseMasterXml(),r=xn(e.master,n),a=e.media().sidx;if(r)if(a){var s=Nn(a);if(!e.sidxMapping_[s]){var o=e.media();e.request=Bn(o.sidx,o,e.hls_.xhr,{handleManifestRedirects:e.handleManifestRedirects},e.sidxRequestFinished_(o,n,e.state,function(t,i){if(!t||!i)throw new Error("failed to request sidx on minimumUpdatePeriod");e.sidxMapping_[s].sidx=i,e.minimumUpdatePeriodTimeout_=u.setTimeout(function(){e.trigger("minimumUpdatePeriod")},e.master.minimumUpdatePeriod),e.refreshMedia_(e.media().id)}))}}else e.master=r;e.minimumUpdatePeriodTimeout_=u.setTimeout(function(){e.trigger("minimumUpdatePeriod")},e.master.minimumUpdatePeriod)}})}},{key:"refreshMedia_",value:function(e){var t=this;if(!e)throw new Error("refreshMedia_ must take a media id");var i=void 0,n=void 0;this.masterPlaylistLoader_?(i=this.masterPlaylistLoader_.master,n=this.masterPlaylistLoader_.parseMasterXml()):(i=this.master,n=this.parseMasterXml());var r=xn(i,n);r?(this.masterPlaylistLoader_?this.masterPlaylistLoader_.master=r:this.master=r,this.media_=r.playlists[e]):(this.media_=n.playlists[e],this.trigger("playlistunchanged")),this.media().endList||(this.mediaUpdateTimeout=u.setTimeout(function(){t.trigger("mediaupdatetimeout")},O(this.media(),!!r))),this.trigger("loadedplaylist")}}]),t}(),Fn=function(e){return t.log.debug?t.log.debug.bind(t,"VHS:",e+" >"):function(){}};function Hn(){}var jn,Vn,Gn,Wn,zn,Xn=function(){function e(t,i,n,r){_(this,e),this.callbacks_=[],this.pendingCallback_=null,this.timestampOffset_=0,this.mediaSource=t,this.processedAppend_=!1,this.type_=n,this.mimeType_=i,this.logger_=Fn("SourceUpdater["+n+"]["+i+"]"),"closed"===t.readyState?t.addEventListener("sourceopen",this.createSourceBuffer_.bind(this,i,r)):this.createSourceBuffer_(i,r)}return v(e,[{key:"createSourceBuffer_",value:function(e,t){var i=this;this.sourceBuffer_=this.mediaSource.addSourceBuffer(e),this.logger_("created SourceBuffer"),t&&(t.trigger("sourcebufferadded"),this.mediaSource.sourceBuffers.length<2)?t.on("sourcebufferadded",function(){i.start_()}):this.start_()}},{key:"start_",value:function(){var e=this;this.started_=!0,this.onUpdateendCallback_=function(){var t=e.pendingCallback_;e.pendingCallback_=null,e.sourceBuffer_.removing=!1,e.logger_("buffered ["+we(e.buffered())+"]"),t&&t(),e.runCallback_()},this.sourceBuffer_.addEventListener("updateend",this.onUpdateendCallback_),this.runCallback_()}},{key:"abort",value:function(e){var t=this;this.processedAppend_&&this.queueCallback_(function(){t.sourceBuffer_.abort()},e)}},{key:"appendBuffer",value:function(e,t){var i=this;this.processedAppend_=!0,this.queueCallback_(function(){e.videoSegmentTimingInfoCallback&&i.sourceBuffer_.addEventListener("videoSegmentTimingInfo",e.videoSegmentTimingInfoCallback),i.sourceBuffer_.appendBuffer(e.bytes)},function(){e.videoSegmentTimingInfoCallback&&i.sourceBuffer_.removeEventListener("videoSegmentTimingInfo",e.videoSegmentTimingInfoCallback),t()})}},{key:"buffered",value:function(){return this.sourceBuffer_?this.sourceBuffer_.buffered:t.createTimeRanges()}},{key:"remove",value:function(e,t){var i=this,n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:Hn;this.processedAppend_&&this.queueCallback_(function(){i.logger_("remove ["+e+" => "+t+"]"),i.sourceBuffer_.removing=!0,i.sourceBuffer_.remove(e,t)},n)}},{key:"updating",value:function(){return!this.sourceBuffer_||this.sourceBuffer_.updating||!!this.pendingCallback_&&this.pendingCallback_!==Hn}},{key:"timestampOffset",value:function(e){var t=this;return void 0!==e&&(this.queueCallback_(function(){t.sourceBuffer_.timestampOffset=e,t.runCallback_()}),this.timestampOffset_=e),this.timestampOffset_}},{key:"queueCallback_",value:function(e,t){this.callbacks_.push([e.bind(this),t]),this.runCallback_()}},{key:"runCallback_",value:function(){var e=void 0;!this.updating()&&this.callbacks_.length&&this.started_&&(e=this.callbacks_.shift(),this.pendingCallback_=e[1],e[0]())}},{key:"dispose",value:function(){var e=this,t=function t(){e.sourceBuffer_&&"open"===e.mediaSource.readyState&&e.sourceBuffer_.abort(),e.sourceBuffer_.removeEventListener("updateend",t)};this.sourceBuffer_.removeEventListener("updateend",this.onUpdateendCallback_),this.sourceBuffer_.removing?this.sourceBuffer_.addEventListener("updateend",t):t()}}]),e}(),Yn={GOAL_BUFFER_LENGTH:30,MAX_GOAL_BUFFER_LENGTH:60,GOAL_BUFFER_LENGTH_RATE:1,INITIAL_BANDWIDTH:4194304,BANDWIDTH_VARIANCE:1.2,BUFFER_LOW_WATER_LINE:0,MAX_BUFFER_LOW_WATER_LINE:30,BUFFER_LOW_WATER_LINE_RATE:1},$n=En,Kn=In;jn=function(e){return Dn.findBox(e,["moov","trak"]).reduce(function(e,t){var i,n,r,a,s;return(i=Dn.findBox(t,["tkhd"])[0])?(n=i[0],a=$n(i[r=0===n?12:20]<<24|i[r+1]<<16|i[r+2]<<8|i[r+3]),(s=Dn.findBox(t,["mdia","mdhd"])[0])?(r=0===(n=s[0])?12:20,e[a]=$n(s[r]<<24|s[r+1]<<16|s[r+2]<<8|s[r+3]),e):null):null},{})},Vn=function(e,t){var i,n,r;return i=Dn.findBox(t,["moof","traf"]),n=[].concat.apply([],i.map(function(t){return Dn.findBox(t,["tfhd"]).map(function(i){var n,r;return n=$n(i[4]<<24|i[5]<<16|i[6]<<8|i[7]),r=e[n]||9e4,(Dn.findBox(t,["tfdt"]).map(function(e){var t,i;return t=e[0],i=$n(e[4]<<24|e[5]<<16|e[6]<<8|e[7]),1===t&&(i*=Math.pow(2,32),i+=$n(e[8]<<24|e[9]<<16|e[10]<<8|e[11])),i})[0]||1/0)/r})})),r=Math.min.apply(null,n),isFinite(r)?r:0},Gn=function(e,t){var i,n=Dn.findBox(t,["moof","traf"]),r=0,a=0;if(n&&n.length)for(var s=Dn.parseTraf(n[0]),o=0;o<s.boxes.length;o++)"tfhd"===s.boxes[o].type?i=s.boxes[o].trackId:"tfdt"===s.boxes[o].type?r=s.boxes[o].baseMediaDecodeTime:"trun"===s.boxes[o].type&&s.boxes[o].samples.length&&(a=s.boxes[o].samples[0].compositionTimeOffset||0);return(r+a)/(e[i]||9e4)},Wn=function(e){var t=[];return Dn.findBox(e,["moov","trak"]).forEach(function(e){var i=Dn.findBox(e,["mdia","hdlr"]),n=Dn.findBox(e,["tkhd"]);i.forEach(function(e,i){var r,a,s=Dn.parseType(e.subarray(8,12)),o=n[i];"vide"===s&&(a=0===(r=new DataView(o.buffer,o.byteOffset,o.byteLength)).getUint8(0)?r.getUint32(12):r.getUint32(20),t.push(a))})}),t},zn=function(e){var t=[];return Dn.findBox(e,["moov","trak"]).forEach(function(e){var i,n,r={},a=Dn.findBox(e,["tkhd"])[0];a&&(n=(i=new DataView(a.buffer,a.byteOffset,a.byteLength)).getUint8(0),r.id=0===n?i.getUint32(12):i.getUint32(20));var s=Dn.findBox(e,["mdia","hdlr"])[0];if(s){var o=Dn.parseType(s.subarray(8,12));r.type="vide"===o?"video":"soun"===o?"audio":o}var u=Dn.findBox(e,["mdia","minf","stbl","stsd"])[0];if(u){var d=u.subarray(8);r.codec=Dn.parseType(d.subarray(4,8));var l,c=Dn.findBox(d,[r.codec])[0];c&&(/^[a-z]vc[1-9]$/i.test(r.codec)?(l=c.subarray(78),"avcC"===Dn.parseType(l.subarray(4,8))&&l.length>11?(r.codec+=".",r.codec+=Kn(l[9]),r.codec+=Kn(l[10]),r.codec+=Kn(l[11])):r.codec="avc1.4d400d"):/^mp4[a,v]$/i.test(r.codec)&&(l=c.subarray(28),"esds"===Dn.parseType(l.subarray(4,8))&&l.length>20&&0!==l[19]?(r.codec+="."+Kn(l[19]),r.codec+="."+Kn(l[20]>>>2&63).replace(/^0/,"")):r.codec="mp4a.40.2"))}var h=Dn.findBox(e,["mdia","mdhd"])[0];if(h&&a){var f=0===n?12:20;r.timescale=$n(h[f]<<24|h[f+1]<<16|h[f+2]<<8|h[f+3])}t.push(r)}),t};var Qn={findBox:Dn.findBox,parseType:Dn.parseType,timescale:jn,startTime:Vn,compositionStartTime:Gn,videoTrackIds:Wn,tracks:zn},Jn=2,Zn=-101,er=-102,tr=function(e){e.forEach(function(e){e.abort()})},ir=function(e,t){return t.timedout?{status:t.status,message:"HLS request timed-out at URL: "+t.uri,code:Zn,xhr:t}:t.aborted?{status:t.status,message:"HLS request aborted at URL: "+t.uri,code:er,xhr:t}:e?{status:t.status,message:"HLS request errored at URL: "+t.uri,code:Jn,xhr:t}:null},nr=function(e,t,i){var n=0,r=!1;return function(a,s){if(!r)return a?(r=!0,tr(e),i(a,s)):(n+=1)===e.length?(s.endOfAllRequests=Date.now(),s.encryptedBytes?function(e,t,i){e.addEventListener("message",function n(r){if(r.data.source===t.requestId){e.removeEventListener("message",n);var a=r.data.decrypted;return t.bytes=new Uint8Array(a.bytes,a.byteOffset,a.byteLength),i(null,t)}});var n=void 0;n=t.key.bytes.slice?t.key.bytes.slice():new Uint32Array(Array.prototype.slice.call(t.key.bytes)),e.postMessage(fe({source:t.requestId,encrypted:t.encryptedBytes,key:n,iv:t.key.iv}),[t.encryptedBytes.buffer,n.buffer])}(t,s,i):i(null,s)):void 0}},rr=function(e,i){return function(n){var r,a,s;return e.stats=t.mergeOptions(e.stats,(a=(r=n).target,(s={bandwidth:1/0,bytesReceived:0,roundTripTime:Date.now()-a.requestTime||0}).bytesReceived=r.loaded,s.bandwidth=Math.floor(s.bytesReceived/s.roundTripTime*8*1e3),s)),!e.stats.firstBytesReceivedAt&&e.stats.bytesReceived&&(e.stats.firstBytesReceivedAt=Date.now()),i(n,e)}},ar=function(e,i,n,r,a,s,o){var u=[],d=nr(u,n,o);if(a.key&&!a.key.bytes){var l=e(t.mergeOptions(i,{uri:a.key.resolvedUri,responseType:"arraybuffer"}),function(e,t){return function(i,n){var r=n.response,a=ir(i,n);if(a)return t(a,e);if(16!==r.byteLength)return t({status:n.status,message:"Invalid HLS key at URL: "+n.uri,code:Jn,xhr:n},e);var s=new DataView(r);return e.key.bytes=new Uint32Array([s.getUint32(0),s.getUint32(4),s.getUint32(8),s.getUint32(12)]),t(null,e)}}(a,d));u.push(l)}if(a.map&&!a.map.bytes){var c=e(t.mergeOptions(i,{uri:a.map.resolvedUri,responseType:"arraybuffer",headers:J(a.map)}),function(e,t,i){return function(n,r){var a=r.response,s=ir(n,r);return s?i(s,e):0===a.byteLength?i({status:r.status,message:"Empty HLS segment content at URL: "+r.uri,code:Jn,xhr:r},e):(e.map.bytes=new Uint8Array(r.response),t&&!t.isInitialized()&&t.init(),e.map.timescales=Qn.timescale(e.map.bytes),e.map.videoTrackIds=Qn.videoTrackIds(e.map.bytes),i(null,e))}}(a,r,d));u.push(c)}var h=e(t.mergeOptions(i,{uri:a.resolvedUri,responseType:"arraybuffer",headers:J(a)}),function(e,t,i){return function(n,r){var a=r.response,s=ir(n,r),o=void 0;return s?i(s,e):0===a.byteLength?i({status:r.status,message:"Empty HLS segment content at URL: "+r.uri,code:Jn,xhr:r},e):(e.stats=function(e){return{bandwidth:e.bandwidth,bytesReceived:e.bytesReceived||0,roundTripTime:e.roundTripTime||0}}(r),e.key?e.encryptedBytes=new Uint8Array(r.response):e.bytes=new Uint8Array(r.response),t&&e.map&&e.map.bytes&&(t.isInitialized()||t.init(),(o=t.parse(e.bytes,e.map.videoTrackIds,e.map.timescales))&&o.captions&&(e.captionStreams=o.captionStreams,e.fmp4Captions=o.captions)),i(null,e))}}(a,r,d));return h.addEventListener("progress",rr(a,s)),u.push(h),function(){return tr(u)}},sr=function(e,t){var i;return e&&(i=u.getComputedStyle(e))?i[t]:""},or=function(e,t){var i=e.slice();e.sort(function(e,n){var r=t(e,n);return 0===r?i.indexOf(e)-i.indexOf(n):r})},ur=function(e,t){var i=void 0,n=void 0;return e.attributes.BANDWIDTH&&(i=e.attributes.BANDWIDTH),i=i||u.Number.MAX_VALUE,t.attributes.BANDWIDTH&&(n=t.attributes.BANDWIDTH),i-(n=n||u.Number.MAX_VALUE)},dr=function(e){for(var t=0,i={payloadType:-1,payloadSize:0},n=0,r=0;t<e.byteLength&&128!==e[t];){for(;255===e[t];)n+=255,t++;for(n+=e[t++];255===e[t];)r+=255,t++;if(r+=e[t++],!i.payload&&4===n){i.payloadType=n,i.payloadSize=r,i.payload=e.subarray(t,t+r);break}t+=r,n=0,r=0}return i},lr=function(e){return 181!==e.payload[0]?null:49!=(e.payload[1]<<8|e.payload[2])?null:"GA94"!==String.fromCharCode(e.payload[3],e.payload[4],e.payload[5],e.payload[6])?null:3!==e.payload[7]?null:e.payload.subarray(8,e.payload.length-1)},cr=function(e,t){var i,n,r,a,s=[];if(!(64&t[0]))return s;for(n=31&t[0],i=0;i<n;i++)a={type:3&t[2+(r=3*i)],pts:e},4&t[r+2]&&(a.ccData=t[r+3]<<8|t[r+4],s.push(a));return s},hr=function(e){for(var t,i,n=e.byteLength,r=[],a=1;a<n-2;)0===e[a]&&0===e[a+1]&&3===e[a+2]?(r.push(a+2),a+=2):a++;if(0===r.length)return e;t=n-r.length,i=new Uint8Array(t);var s=0;for(a=0;a<t;s++,a++)s===r[0]&&(s++,r.shift()),i[a]=e[s];return i},fr=4,pr=function(){this.init=function(){var e={};this.on=function(t,i){e[t]||(e[t]=[]),e[t]=e[t].concat(i)},this.off=function(t,i){var n;return!!e[t]&&(n=e[t].indexOf(i),e[t]=e[t].slice(),e[t].splice(n,1),n>-1)},this.trigger=function(t){var i,n,r,a;if(i=e[t])if(2===arguments.length)for(r=i.length,n=0;n<r;++n)i[n].call(this,arguments[1]);else{for(a=[],n=arguments.length,n=1;n<arguments.length;++n)a.push(arguments[n]);for(r=i.length,n=0;n<r;++n)i[n].apply(this,a)}},this.dispose=function(){e={}}}};pr.prototype.pipe=function(e){return this.on("data",function(t){e.push(t)}),this.on("done",function(t){e.flush(t)}),this.on("partialdone",function(t){e.partialFlush(t)}),this.on("endedtimeline",function(t){e.endTimeline(t)}),this.on("reset",function(t){e.reset(t)}),e},pr.prototype.push=function(e){this.trigger("data",e)},pr.prototype.flush=function(e){this.trigger("done",e)},pr.prototype.partialFlush=function(e){this.trigger("partialdone",e)},pr.prototype.endTimeline=function(e){this.trigger("endedtimeline",e)},pr.prototype.reset=function(e){this.trigger("reset",e)};var mr=pr,gr=function e(){e.prototype.init.call(this),this.captionPackets_=[],this.ccStreams_=[new Tr(0,0),new Tr(0,1),new Tr(1,0),new Tr(1,1)],this.reset(),this.ccStreams_.forEach(function(e){e.on("data",this.trigger.bind(this,"data")),e.on("partialdone",this.trigger.bind(this,"partialdone")),e.on("done",this.trigger.bind(this,"done"))},this)};(gr.prototype=new mr).push=function(e){var t,i,n;if("sei_rbsp"===e.nalUnitType&&(t=dr(e.escapedRBSP)).payloadType===fr&&(i=lr(t)))if(e.dts<this.latestDts_)this.ignoreNextEqualDts_=!0;else{if(e.dts===this.latestDts_&&this.ignoreNextEqualDts_)return this.numSameDts_--,void(this.numSameDts_||(this.ignoreNextEqualDts_=!1));n=cr(e.pts,i),this.captionPackets_=this.captionPackets_.concat(n),this.latestDts_!==e.dts&&(this.numSameDts_=0),this.numSameDts_++,this.latestDts_=e.dts}},gr.prototype.flushCCStreams=function(e){this.ccStreams_.forEach(function(t){return"flush"===e?t.flush():t.partialFlush()},this)},gr.prototype.flushStream=function(e){this.captionPackets_.length?(this.captionPackets_.forEach(function(e,t){e.presortIndex=t}),this.captionPackets_.sort(function(e,t){return e.pts===t.pts?e.presortIndex-t.presortIndex:e.pts-t.pts}),this.captionPackets_.forEach(function(e){e.type<2&&this.dispatchCea608Packet(e)},this),this.captionPackets_.length=0,this.flushCCStreams(e)):this.flushCCStreams(e)},gr.prototype.flush=function(){return this.flushStream("flush")},gr.prototype.partialFlush=function(){return this.flushStream("partialFlush")},gr.prototype.reset=function(){this.latestDts_=null,this.ignoreNextEqualDts_=!1,this.numSameDts_=0,this.activeCea608Channel_=[null,null],this.ccStreams_.forEach(function(e){e.reset()})},gr.prototype.dispatchCea608Packet=function(e){this.setsTextOrXDSActive(e)?this.activeCea608Channel_[e.type]=null:this.setsChannel1Active(e)?this.activeCea608Channel_[e.type]=0:this.setsChannel2Active(e)&&(this.activeCea608Channel_[e.type]=1),null!==this.activeCea608Channel_[e.type]&&this.ccStreams_[(e.type<<1)+this.activeCea608Channel_[e.type]].push(e)},gr.prototype.setsChannel1Active=function(e){return 4096==(30720&e.ccData)},gr.prototype.setsChannel2Active=function(e){return 6144==(30720&e.ccData)},gr.prototype.setsTextOrXDSActive=function(e){return 256==(28928&e.ccData)||4138==(30974&e.ccData)||6186==(30974&e.ccData)};var yr={42:225,92:233,94:237,95:243,96:250,123:231,124:247,125:209,126:241,127:9608,304:174,305:176,306:189,307:191,308:8482,309:162,310:163,311:9834,312:224,313:160,314:232,315:226,316:234,317:238,318:244,319:251,544:193,545:201,546:211,547:218,548:220,549:252,550:8216,551:161,552:42,553:39,554:8212,555:169,556:8480,557:8226,558:8220,559:8221,560:192,561:194,562:199,563:200,564:202,565:203,566:235,567:206,568:207,569:239,570:212,571:217,572:249,573:219,574:171,575:187,800:195,801:227,802:205,803:204,804:236,805:210,806:242,807:213,808:245,809:123,810:125,811:92,812:94,813:95,814:124,815:126,816:196,817:228,818:214,819:246,820:223,821:165,822:164,823:9474,824:197,825:229,826:216,827:248,828:9484,829:9488,830:9492,831:9496},_r=function(e){return null===e?"":(e=yr[e]||e,String.fromCharCode(e))},vr=[4352,4384,4608,4640,5376,5408,5632,5664,5888,5920,4096,4864,4896,5120,5152],br=function(){for(var e=[],t=15;t--;)e.push("");return e},Tr=function e(t,i){e.prototype.init.call(this),this.field_=t||0,this.dataChannel_=i||0,this.name_="CC"+(1+(this.field_<<1|this.dataChannel_)),this.setConstants(),this.reset(),this.push=function(e){var t,i,n,r,a;if((t=32639&e.ccData)!==this.lastControlCode_){if(4096==(61440&t)?this.lastControlCode_=t:t!==this.PADDING_&&(this.lastControlCode_=null),n=t>>>8,r=255&t,t!==this.PADDING_)if(t===this.RESUME_CAPTION_LOADING_)this.mode_="popOn";else if(t===this.END_OF_CAPTION_)this.mode_="popOn",this.clearFormatting(e.pts),this.flushDisplayed(e.pts),i=this.displayed_,this.displayed_=this.nonDisplayed_,this.nonDisplayed_=i,this.startPts_=e.pts;else if(t===this.ROLL_UP_2_ROWS_)this.rollUpRows_=2,this.setRollUp(e.pts);else if(t===this.ROLL_UP_3_ROWS_)this.rollUpRows_=3,this.setRollUp(e.pts);else if(t===this.ROLL_UP_4_ROWS_)this.rollUpRows_=4,this.setRollUp(e.pts);else if(t===this.CARRIAGE_RETURN_)this.clearFormatting(e.pts),this.flushDisplayed(e.pts),this.shiftRowsUp_(),this.startPts_=e.pts;else if(t===this.BACKSPACE_)"popOn"===this.mode_?this.nonDisplayed_[this.row_]=this.nonDisplayed_[this.row_].slice(0,-1):this.displayed_[this.row_]=this.displayed_[this.row_].slice(0,-1);else if(t===this.ERASE_DISPLAYED_MEMORY_)this.flushDisplayed(e.pts),this.displayed_=br();else if(t===this.ERASE_NON_DISPLAYED_MEMORY_)this.nonDisplayed_=br();else if(t===this.RESUME_DIRECT_CAPTIONING_)"paintOn"!==this.mode_&&(this.flushDisplayed(e.pts),this.displayed_=br()),this.mode_="paintOn",this.startPts_=e.pts;else if(this.isSpecialCharacter(n,r))a=_r((n=(3&n)<<8)|r),this[this.mode_](e.pts,a),this.column_++;else if(this.isExtCharacter(n,r))"popOn"===this.mode_?this.nonDisplayed_[this.row_]=this.nonDisplayed_[this.row_].slice(0,-1):this.displayed_[this.row_]=this.displayed_[this.row_].slice(0,-1),a=_r((n=(3&n)<<8)|r),this[this.mode_](e.pts,a),this.column_++;else if(this.isMidRowCode(n,r))this.clearFormatting(e.pts),this[this.mode_](e.pts," "),this.column_++,14==(14&r)&&this.addFormatting(e.pts,["i"]),1==(1&r)&&this.addFormatting(e.pts,["u"]);else if(this.isOffsetControlCode(n,r))this.column_+=3&r;else if(this.isPAC(n,r)){var s=vr.indexOf(7968&t);"rollUp"===this.mode_&&(s-this.rollUpRows_+1<0&&(s=this.rollUpRows_-1),this.setRollUp(e.pts,s)),s!==this.row_&&(this.clearFormatting(e.pts),this.row_=s),1&r&&-1===this.formatting_.indexOf("u")&&this.addFormatting(e.pts,["u"]),16==(16&t)&&(this.column_=4*((14&t)>>1)),this.isColorPAC(r)&&14==(14&r)&&this.addFormatting(e.pts,["i"])}else this.isNormalChar(n)&&(0===r&&(r=null),a=_r(n),a+=_r(r),this[this.mode_](e.pts,a),this.column_+=a.length)}else this.lastControlCode_=null}};Tr.prototype=new mr,Tr.prototype.flushDisplayed=function(e){var t=this.displayed_.map(function(e){try{return e.trim()}catch(e){return console.error("Skipping malformed caption."),""}}).join("\n").replace(/^\n+|\n+$/g,"");t.length&&this.trigger("data",{startPts:this.startPts_,endPts:e,text:t,stream:this.name_})},Tr.prototype.reset=function(){this.mode_="popOn",this.topRow_=0,this.startPts_=0,this.displayed_=br(),this.nonDisplayed_=br(),this.lastControlCode_=null,this.column_=0,this.row_=14,this.rollUpRows_=2,this.formatting_=[]},Tr.prototype.setConstants=function(){0===this.dataChannel_?(this.BASE_=16,this.EXT_=17,this.CONTROL_=(20|this.field_)<<8,this.OFFSET_=23):1===this.dataChannel_&&(this.BASE_=24,this.EXT_=25,this.CONTROL_=(28|this.field_)<<8,this.OFFSET_=31),this.PADDING_=0,this.RESUME_CAPTION_LOADING_=32|this.CONTROL_,this.END_OF_CAPTION_=47|this.CONTROL_,this.ROLL_UP_2_ROWS_=37|this.CONTROL_,this.ROLL_UP_3_ROWS_=38|this.CONTROL_,this.ROLL_UP_4_ROWS_=39|this.CONTROL_,this.CARRIAGE_RETURN_=45|this.CONTROL_,this.RESUME_DIRECT_CAPTIONING_=41|this.CONTROL_,this.BACKSPACE_=33|this.CONTROL_,this.ERASE_DISPLAYED_MEMORY_=44|this.CONTROL_,this.ERASE_NON_DISPLAYED_MEMORY_=46|this.CONTROL_},Tr.prototype.isSpecialCharacter=function(e,t){return e===this.EXT_&&t>=48&&t<=63},Tr.prototype.isExtCharacter=function(e,t){return(e===this.EXT_+1||e===this.EXT_+2)&&t>=32&&t<=63},Tr.prototype.isMidRowCode=function(e,t){return e===this.EXT_&&t>=32&&t<=47},Tr.prototype.isOffsetControlCode=function(e,t){return e===this.OFFSET_&&t>=33&&t<=35},Tr.prototype.isPAC=function(e,t){return e>=this.BASE_&&e<this.BASE_+8&&t>=64&&t<=127},Tr.prototype.isColorPAC=function(e){return e>=64&&e<=79||e>=96&&e<=127},Tr.prototype.isNormalChar=function(e){return e>=32&&e<=127},Tr.prototype.setRollUp=function(e,t){if("rollUp"!==this.mode_&&(this.row_=14,this.mode_="rollUp",this.flushDisplayed(e),this.nonDisplayed_=br(),this.displayed_=br()),void 0!==t&&t!==this.row_)for(var i=0;i<this.rollUpRows_;i++)this.displayed_[t-i]=this.displayed_[this.row_-i],this.displayed_[this.row_-i]="";void 0===t&&(t=this.row_),this.topRow_=t-this.rollUpRows_+1},Tr.prototype.addFormatting=function(e,t){this.formatting_=this.formatting_.concat(t);var i=t.reduce(function(e,t){return e+"<"+t+">"},"");this[this.mode_](e,i)},Tr.prototype.clearFormatting=function(e){if(this.formatting_.length){var t=this.formatting_.reverse().reduce(function(e,t){return e+"</"+t+">"},"");this.formatting_=[],this[this.mode_](e,t)}},Tr.prototype.popOn=function(e,t){var i=this.nonDisplayed_[this.row_];i+=t,this.nonDisplayed_[this.row_]=i},Tr.prototype.rollUp=function(e,t){var i=this.displayed_[this.row_];i+=t,this.displayed_[this.row_]=i},Tr.prototype.shiftRowsUp_=function(){var e;for(e=0;e<this.topRow_;e++)this.displayed_[e]="";for(e=this.row_+1;e<15;e++)this.displayed_[e]="";for(e=this.topRow_;e<this.row_;e++)this.displayed_[e]=this.displayed_[e+1];this.displayed_[this.row_]=""},Tr.prototype.paintOn=function(e,t){var i=this.displayed_[this.row_];i+=t,this.displayed_[this.row_]=i};var Sr=hr,wr=gr,kr=function(e,t){for(var i=e,n=0;n<t.length;n++){var r=t[n];if(i<r.size)return r;i-=r.size}return null},Er=function(e,t){var i=Qn.findBox(e,["moof","traf"]),n={},r=[];return Qn.findBox(e,["mdat"]).forEach(function(e,t){var n=i[t];r.push({mdat:e,traf:n})}),r.forEach(function(e){var i,r=e.mdat,a=e.traf,s=Qn.findBox(a,["tfhd"]),o=Dn.parseTfhd(s[0]),u=o.trackId,d=Qn.findBox(a,["tfdt"]),l=d.length>0?Dn.parseTfdt(d[0]).baseMediaDecodeTime:0,c=Qn.findBox(a,["trun"]);t===u&&c.length>0&&(i=function(e,t,i){var n,r,a,s,o=new DataView(e.buffer,e.byteOffset,e.byteLength),u=[];for(r=0;r+4<e.length;r+=a)if(a=o.getUint32(r),r+=4,!(a<=0))switch(31&e[r]){case 6:var d=e.subarray(r+1,r+1+a),l=kr(r,t);n={nalUnitType:"sei_rbsp",size:a,data:d,escapedRBSP:Sr(d),trackId:i},l?(n.pts=l.pts,n.dts=l.dts,s=l):(n.pts=s.pts,n.dts=s.dts),u.push(n)}return u}(r,function(e,t,i){var n=t,r=i.defaultSampleDuration||0,a=i.defaultSampleSize||0,s=i.trackId,o=[];return e.forEach(function(e){var t=Dn.parseTrun(e).samples;t.forEach(function(e){void 0===e.duration&&(e.duration=r),void 0===e.size&&(e.size=a),e.trackId=s,e.dts=n,void 0===e.compositionTimeOffset&&(e.compositionTimeOffset=0),e.pts=n+e.compositionTimeOffset,n+=e.duration}),o=o.concat(t)}),o}(c,l,o),u),n[u]||(n[u]=[]),n[u]=n[u].concat(i))}),n},Ir=function(){var e,t,i,n,r,a,s=!1;this.isInitialized=function(){return s},this.init=function(t){e=new wr,s=!0,a=!!t&&t.isPartial,e.on("data",function(e){e.startTime=e.startPts/n,e.endTime=e.endPts/n,r.captions.push(e),r.captionStreams[e.stream]=!0})},this.isNewInit=function(e,t){return!(e&&0===e.length||t&&"object"==typeof t&&0===Object.keys(t).length||i===e[0]&&n===t[i])},this.parse=function(e,a,s){var o;if(!this.isInitialized())return null;if(!a||!s)return null;if(this.isNewInit(a,s))i=a[0],n=s[i];else if(null===i||!n)return t.push(e),null;for(;t.length>0;){var u=t.shift();this.parse(u,a,s)}return null!==(o=function(e,t,i){return null===t?null:{seiNals:Er(e,t)[t],timescale:i}}(e,i,n))&&o.seiNals?(this.pushNals(o.seiNals),this.flushStream(),r):null},this.pushNals=function(t){if(!this.isInitialized()||!t||0===t.length)return null;t.forEach(function(t){e.push(t)})},this.flushStream=function(){if(!this.isInitialized())return null;a?e.partialFlush():e.flush()},this.clearParsedCaptions=function(){r.captions=[],r.captionStreams={}},this.resetCaptionStream=function(){if(!this.isInitialized())return null;e.reset()},this.clearAllCaptions=function(){this.clearParsedCaptions(),this.resetCaptionStream()},this.reset=function(){t=[],i=null,n=null,r?this.clearParsedCaptions():r={captions:[],captionStreams:{}},this.resetCaptionStream()},this.reset()},Ar=function(e){return"number"==typeof e&&isFinite(e)},Lr=function(e){function i(e){_(this,i);var t=T(this,(i.__proto__||Object.getPrototypeOf(i)).call(this));if(!e)throw new TypeError("Initialization settings are required");if("function"!=typeof e.currentTime)throw new TypeError("No currentTime getter specified");if(!e.mediaSource)throw new TypeError("No MediaSource specified");return t.bandwidth=e.bandwidth,t.throughput={rate:0,count:0},t.roundTrip=NaN,t.resetStats_(),t.mediaIndex=null,t.hasPlayed_=e.hasPlayed,t.currentTime_=e.currentTime,t.seekable_=e.seekable,t.seeking_=e.seeking,t.duration_=e.duration,t.mediaSource_=e.mediaSource,t.hls_=e.hls,t.loaderType_=e.loaderType,t.startingMedia_=void 0,t.segmentMetadataTrack_=e.segmentMetadataTrack,t.goalBufferLength_=e.goalBufferLength,t.sourceType_=e.sourceType,t.inbandTextTracks_=e.inbandTextTracks,t.state_="INIT",t.checkBufferTimeout_=null,t.error_=void 0,t.currentTimeline_=-1,t.pendingSegment_=null,t.mimeType_=null,t.sourceUpdater_=null,t.xhrOptions_=null,t.activeInitSegmentId_=null,t.initSegments_={},t.cacheEncryptionKeys_=e.cacheEncryptionKeys,t.keyCache_={},"main"===t.loaderType_?t.captionParser_=new Ir:t.captionParser_=null,t.decrypter_=e.decrypter,t.syncController_=e.syncController,t.syncPoint_={segmentIndex:0,time:0},t.triggerSyncInfoUpdate_=function(){return t.trigger("syncinfoupdate")},t.syncController_.on("syncinfoupdate",t.triggerSyncInfoUpdate_),t.mediaSource_.addEventListener("sourceopen",function(){return t.ended_=!1}),t.fetchAtBuffer_=!1,t.logger_=Fn("SegmentLoader["+t.loaderType_+"]"),Object.defineProperty(t,"state",{get:function(){return this.state_},set:function(e){e!==this.state_&&(this.logger_(this.state_+" -> "+e),this.state_=e)}}),t}return b(i,e),v(i,[{key:"resetStats_",value:function(){this.mediaBytesTransferred=0,this.mediaRequests=0,this.mediaRequestsAborted=0,this.mediaRequestsTimedout=0,this.mediaRequestsErrored=0,this.mediaTransferDuration=0,this.mediaSecondsLoaded=0}},{key:"dispose",value:function(){this.trigger("dispose"),this.state="DISPOSED",this.pause(),this.abort_(),this.sourceUpdater_&&this.sourceUpdater_.dispose(),this.resetStats_(),this.captionParser_&&this.captionParser_.reset(),this.checkBufferTimeout_&&u.clearTimeout(this.checkBufferTimeout_),this.syncController_&&this.triggerSyncInfoUpdate_&&this.syncController_.off("syncinfoupdate",this.triggerSyncInfoUpdate_),this.off()}},{key:"abort",value:function(){"WAITING"===this.state?(this.abort_(),this.state="READY",this.paused()||this.monitorBuffer_()):this.pendingSegment_&&(this.pendingSegment_=null)}},{key:"abort_",value:function(){this.pendingSegment_&&this.pendingSegment_.abortRequests(),this.pendingSegment_=null}},{key:"error",value:function(e){return void 0!==e&&(this.error_=e),this.pendingSegment_=null,this.error_}},{key:"endOfStream",value:function(){this.ended_=!0,this.pause(),this.trigger("ended")}},{key:"buffered_",value:function(){return this.sourceUpdater_?this.sourceUpdater_.buffered():t.createTimeRanges()}},{key:"initSegment",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]&&arguments[1];if(!e)return null;var i=pe(e),n=this.initSegments_[i];return t&&!n&&e.bytes&&(this.initSegments_[i]=n={resolvedUri:e.resolvedUri,byterange:e.byterange,bytes:e.bytes,timescales:e.timescales,videoTrackIds:e.videoTrackIds}),n||e}},{key:"segmentKey",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]&&arguments[1];if(!e)return null;var i=me(e),n=this.keyCache_[i];this.cacheEncryptionKeys_&&t&&!n&&e.bytes&&(this.keyCache_[i]=n={resolvedUri:e.resolvedUri,bytes:e.bytes});var r={resolvedUri:(n||e).resolvedUri};return n&&(r.bytes=n.bytes),r}},{key:"couldBeginLoading_",value:function(){return this.playlist_&&(this.sourceUpdater_||this.mimeType_&&"INIT"===this.state)&&!this.paused()}},{key:"load",value:function(){if(this.monitorBuffer_(),this.playlist_){if(this.syncController_.setDateTimeMapping(this.playlist_),"INIT"===this.state&&this.couldBeginLoading_())return this.init_();!this.couldBeginLoading_()||"READY"!==this.state&&"INIT"!==this.state||(this.state="READY")}}},{key:"init_",value:function(){return this.state="READY",this.sourceUpdater_=new Xn(this.mediaSource_,this.mimeType_,this.loaderType_,this.sourceBufferEmitter_),this.resetEverything(),this.monitorBuffer_()}},{key:"playlist",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(e){var i=this.playlist_,n=this.pendingSegment_;this.playlist_=e,this.xhrOptions_=t,"INIT"===this.state&&(e.syncInfo={mediaSequence:e.mediaSequence,time:0});var r=null;if(i&&(i.id?r=i.id:i.uri&&(r=i.uri)),this.logger_("playlist update ["+r+" => "+(e.id||e.uri)+"]"),this.trigger("syncinfoupdate"),"INIT"===this.state&&this.couldBeginLoading_())return this.init_();if(i&&i.uri===e.uri){var a=e.mediaSequence-i.mediaSequence;this.logger_("live window shift ["+a+"]"),null!==this.mediaIndex&&(this.mediaIndex-=a),n&&(n.mediaIndex-=a,n.mediaIndex>=0&&(n.segment=e.segments[n.mediaIndex])),this.syncController_.saveExpiredSegmentInfo(i,e)}else null!==this.mediaIndex&&this.resyncLoader()}}},{key:"pause",value:function(){this.checkBufferTimeout_&&(u.clearTimeout(this.checkBufferTimeout_),this.checkBufferTimeout_=null)}},{key:"paused",value:function(){return null===this.checkBufferTimeout_}},{key:"mimeType",value:function(e,t){this.mimeType_||(this.mimeType_=e,this.sourceBufferEmitter_=t,"INIT"===this.state&&this.couldBeginLoading_()&&this.init_())}},{key:"resetEverything",value:function(e){this.ended_=!1,this.resetLoader(),this.remove(0,this.duration_(),e),this.captionParser_&&this.captionParser_.clearAllCaptions(),this.trigger("reseteverything")}},{key:"resetLoader",value:function(){this.fetchAtBuffer_=!1,this.resyncLoader()}},{key:"resyncLoader",value:function(){this.mediaIndex=null,this.syncPoint_=null,this.abort()}},{key:"remove",value:function(e,t,i){if(this.sourceUpdater_&&this.sourceUpdater_.remove(e,t,i),Ee(e,t,this.segmentMetadataTrack_),this.inbandTextTracks_)for(var n in this.inbandTextTracks_)Ee(e,t,this.inbandTextTracks_[n])}},{key:"monitorBuffer_",value:function(){this.checkBufferTimeout_&&u.clearTimeout(this.checkBufferTimeout_),this.checkBufferTimeout_=u.setTimeout(this.monitorBufferTick_.bind(this),1)}},{key:"monitorBufferTick_",value:function(){"READY"===this.state&&this.fillBuffer_(),this.checkBufferTimeout_&&u.clearTimeout(this.checkBufferTimeout_),this.checkBufferTimeout_=u.setTimeout(this.monitorBufferTick_.bind(this),500)}},{key:"fillBuffer_",value:function(){if(!this.sourceUpdater_.updating()){this.syncPoint_||(this.syncPoint_=this.syncController_.getSyncPoint(this.playlist_,this.duration_(),this.currentTimeline_,this.currentTime_()));var e=this.checkBuffer_(this.buffered_(),this.playlist_,this.mediaIndex,this.hasPlayed_(),this.currentTime_(),this.syncPoint_);e&&(this.isEndOfStream_(e.mediaIndex)?this.endOfStream():(e.mediaIndex!==this.playlist_.segments.length-1||"ended"!==this.mediaSource_.readyState||this.seeking_())&&(e.timeline!==this.currentTimeline_&&(this.syncController_.reset(),e.timestampOffset=e.startOfSegment,this.captionParser_&&this.captionParser_.clearAllCaptions()),this.loadSegment_(e)))}}},{key:"isEndOfStream_",value:function(e){return function(e,t,i){if(!e||!t)return!1;var n=i===e.segments.length;return e.endList&&"open"===t.readyState&&n}(arguments.length>1&&void 0!==arguments[1]?arguments[1]:this.playlist_,this.mediaSource_,e)&&!this.sourceUpdater_.updating()}},{key:"checkBuffer_",value:function(e,t,i,n,r,a){var s=0,o=void 0;e.length&&(s=e.end(e.length-1));var u=Math.max(0,s-r);if(!t.segments.length)return null;if(u>=this.goalBufferLength_())return null;if(!n&&u>=1)return null;if(null===a)return i=this.getSyncSegmentCandidate_(t),this.generateSegmentInfo_(t,i,null,!0);if(null!==i){t.segments[i];return o=s,this.generateSegmentInfo_(t,i+1,o,!1)}if(this.fetchAtBuffer_){var d=Y.getMediaInfoForTime(t,s,a.segmentIndex,a.time);i=d.mediaIndex,o=d.startTime}else{var l=Y.getMediaInfoForTime(t,r,a.segmentIndex,a.time);i=l.mediaIndex,o=l.startTime}return this.generateSegmentInfo_(t,i,o,!1)}},{key:"getSyncSegmentCandidate_",value:function(e){var t=this;if(-1===this.currentTimeline_)return 0;var i=e.segments.map(function(e,t){return{timeline:e.timeline,segmentIndex:t}}).filter(function(e){return e.timeline===t.currentTimeline_});return i.length?i[Math.min(i.length-1,1)].segmentIndex:Math.max(e.segments.length-1,0)}},{key:"generateSegmentInfo_",value:function(e,t,i,n){if(t<0||t>=e.segments.length)return null;var r=e.segments[t];return{requestId:"segment-loader-"+Math.random(),uri:r.resolvedUri,mediaIndex:t,isSyncRequest:n,startOfSegment:i,playlist:e,bytes:null,encryptedBytes:null,timestampOffset:null,timeline:r.timeline,duration:r.duration,segment:r}}},{key:"abortRequestEarly_",value:function(e){if(this.hls_.tech_.paused()||!this.xhrOptions_.timeout||!this.playlist_.attributes.BANDWIDTH)return!1;if(Date.now()-(e.firstBytesReceivedAt||Date.now())<1e3)return!1;var t=this.currentTime_(),i=e.bandwidth,n=this.pendingSegment_.duration,r=Y.estimateSegmentRequestTime(n,i,this.playlist_,e.bytesReceived),a=function(e,t){var i=arguments.length>2&&void 0!==arguments[2]?arguments[2]:1;return((e.length?e.end(e.length-1):0)-t)/i}(this.buffered_(),t,this.hls_.tech_.playbackRate())-1;if(r<=a)return!1;var s=function(e){var t=e.master,i=e.currentTime,n=e.bandwidth,r=e.duration,a=e.segmentDuration,s=e.timeUntilRebuffer,o=e.currentTimeline,u=e.syncController,d=t.playlists.filter(function(e){return!Y.isIncompatible(e)}),l=d.filter(Y.isEnabled);l.length||(l=d.filter(function(e){return!Y.isDisabled(e)}));var c=l.filter(Y.hasAttribute.bind(null,"BANDWIDTH")).map(function(e){var t=u.getSyncPoint(e,r,o,i)?1:2;return{playlist:e,rebufferingImpact:Y.estimateSegmentRequestTime(a,n,e)*t-s}}),h=c.filter(function(e){return e.rebufferingImpact<=0});return or(h,function(e,t){return ur(t.playlist,e.playlist)}),h.length?h[0]:(or(c,function(e,t){return e.rebufferingImpact-t.rebufferingImpact}),c[0]||null)}({master:this.hls_.playlists.master,currentTime:t,bandwidth:i,duration:this.duration_(),segmentDuration:n,timeUntilRebuffer:a,currentTimeline:this.currentTimeline_,syncController:this.syncController_});if(s){var o=r-a-s.rebufferingImpact,u=.5;return a<=1/30&&(u=1),!s.playlist||s.playlist.uri===this.playlist_.uri||o<u?!1:(this.bandwidth=s.playlist.attributes.BANDWIDTH*Yn.BANDWIDTH_VARIANCE+1,this.abort(),this.trigger("earlyabort"),!0)}}},{key:"handleProgress_",value:function(e,t){this.pendingSegment_&&t.requestId===this.pendingSegment_.requestId&&!this.abortRequestEarly_(t.stats)&&this.trigger("progress")}},{key:"loadSegment_",value:function(e){this.state="WAITING",this.pendingSegment_=e,this.trimBackBuffer_(e),e.abortRequests=ar(this.hls_.xhr,this.xhrOptions_,this.decrypter_,this.captionParser_,this.createSimplifiedSegmentObj_(e),this.handleProgress_.bind(this),this.segmentRequestFinished_.bind(this))}},{key:"trimBackBuffer_",value:function(e){var t=function(e,t,i){var n=t-30;e.length&&(n=Math.max(n,e.start(0)));var r=t-i;return Math.min(r,n)}(this.seekable_(),this.currentTime_(),this.playlist_.targetDuration||10);t>0&&this.remove(0,t)}},{key:"createSimplifiedSegmentObj_",value:function(e){var t=e.segment,i={resolvedUri:t.resolvedUri,byterange:t.byterange,requestId:e.requestId};if(t.key){var n=t.key.iv||new Uint32Array([0,0,0,e.mediaIndex+e.playlist.mediaSequence]);i.key=this.segmentKey(t.key),i.key.iv=n}return t.map&&(i.map=this.initSegment(t.map)),i}},{key:"segmentRequestFinished_",value:function(e,t){if(this.mediaRequests+=1,t.stats&&(this.mediaBytesTransferred+=t.stats.bytesReceived,this.mediaTransferDuration+=t.stats.roundTripTime),this.pendingSegment_){if(t.requestId===this.pendingSegment_.requestId){if(e)return this.pendingSegment_=null,this.state="READY",e.code===er?void(this.mediaRequestsAborted+=1):(this.pause(),e.code===Zn?(this.mediaRequestsTimedout+=1,this.bandwidth=1,this.roundTrip=NaN,void this.trigger("bandwidthupdate")):(this.mediaRequestsErrored+=1,this.error(e),void this.trigger("error")));this.bandwidth=t.stats.bandwidth,this.roundTrip=t.stats.roundTripTime,t.map&&(t.map=this.initSegment(t.map,!0)),t.key&&this.segmentKey(t.key,!0),this.processSegmentResponse_(t)}}else this.mediaRequestsAborted+=1}},{key:"processSegmentResponse_",value:function(e){var t=this.pendingSegment_;t.bytes=e.bytes,e.map&&(t.segment.map.bytes=e.map.bytes),t.endOfAllRequests=e.endOfAllRequests,e.fmp4Captions&&(!function(e,t,i){for(var n in i)if(!e[n]){t.trigger({type:"usage",name:"hls-608"});var r=t.textTracks().getTrackById(n);e[n]=r||t.addRemoteTextTrack({kind:"captions",id:n,label:n},!1).track}}(this.inbandTextTracks_,this.hls_.tech_,e.captionStreams),function(e){var t=e.inbandTextTracks,i=e.captionArray,n=e.timestampOffset;if(i){var r=window.WebKitDataCue||window.VTTCue;i.forEach(function(e){var i=e.stream,a=e.startTime,s=e.endTime;t[i]&&(a+=n,s+=n,t[i].addCue(new r(a,s,e.text)))})}}({inbandTextTracks:this.inbandTextTracks_,captionArray:e.fmp4Captions,timestampOffset:0}),this.captionParser_&&this.captionParser_.clearParsedCaptions()),this.handleSegment_()}},{key:"handleSegment_",value:function(){var e=this;if(this.pendingSegment_){var t=this.pendingSegment_,i=t.segment,n=this.syncController_.probeSegmentInfo(t);void 0===this.startingMedia_&&n&&(n.containsAudio||n.containsVideo)&&(this.startingMedia_={containsAudio:n.containsAudio,containsVideo:n.containsVideo});var r,a,s,o=(r=this.loaderType_,a=this.startingMedia_,s=n,"main"===r&&a&&s?s.containsAudio||s.containsVideo?a.containsVideo&&!s.containsVideo?"Only audio found in segment when we expected video. We can't switch to audio only from a stream that had video. To get rid of this message, please add codec information to the manifest.":!a.containsVideo&&s.containsVideo?"Video found in segment when we expected only audio. We can't switch to a stream with video from an audio only stream. To get rid of this message, please add codec information to the manifest.":null:"Neither audio nor video found in segment.":null);if(o)return this.error({message:o,blacklistDuration:1/0}),void this.trigger("error");if(t.isSyncRequest)return this.trigger("syncinfoupdate"),this.pendingSegment_=null,void(this.state="READY");if(null!==t.timestampOffset&&t.timestampOffset!==this.sourceUpdater_.timestampOffset()){if(n&&n.segmentTimestampInfo){var u=n.segmentTimestampInfo[0].ptsTime,d=n.segmentTimestampInfo[0].dtsTime;t.timestampOffset-=u-d}this.sourceUpdater_.timestampOffset(t.timestampOffset),this.trigger("timestampoffset")}var l=this.syncController_.mappingForTimeline(t.timeline);if(null!==l&&this.trigger({type:"segmenttimemapping",mapping:l}),this.state="APPENDING",i.map){var c=pe(i.map);if(!this.activeInitSegmentId_||this.activeInitSegmentId_!==c){var h=this.initSegment(i.map);this.sourceUpdater_.appendBuffer({bytes:h.bytes},function(){e.activeInitSegmentId_=c})}}t.byteLength=t.bytes.byteLength,"number"==typeof i.start&&"number"==typeof i.end?this.mediaSecondsLoaded+=i.end-i.start:this.mediaSecondsLoaded+=i.duration,this.logger_(function(e){var t=e.segment,i=t.start,n=t.end,r=e.playlist,a=r.mediaSequence,s=r.id,o=r.segments,u=void 0===o?[]:o,d=e.mediaIndex,l=e.timeline;return["appending ["+d+"] of ["+a+", "+(a+u.length)+"] from playlist ["+s+"]","["+i+" => "+n+"] in timeline ["+l+"]"].join(" ")}(t)),this.sourceUpdater_.appendBuffer({bytes:t.bytes,videoSegmentTimingInfoCallback:this.handleVideoSegmentTimingInfo_.bind(this,t.requestId)},this.handleUpdateEnd_.bind(this))}else this.state="READY"}},{key:"handleVideoSegmentTimingInfo_",value:function(e,t){if(this.pendingSegment_&&e===this.pendingSegment_.requestId){var i=this.pendingSegment_.segment;i.videoTimingInfo||(i.videoTimingInfo={}),i.videoTimingInfo.transmuxerPrependedSeconds=t.videoSegmentTimingInfo.prependedContentDuration||0,i.videoTimingInfo.transmuxedPresentationStart=t.videoSegmentTimingInfo.start.presentation,i.videoTimingInfo.transmuxedPresentationEnd=t.videoSegmentTimingInfo.end.presentation,i.videoTimingInfo.baseMediaDecodeTime=t.videoSegmentTimingInfo.baseMediaDecodeTime}}},{key:"handleUpdateEnd_",value:function(){if(!this.pendingSegment_)return this.state="READY",void(this.paused()||this.monitorBuffer_());var e=this.pendingSegment_,t=e.segment,i=null!==this.mediaIndex;this.pendingSegment_=null,this.recordThroughput_(e),this.addSegmentMetadataCue_(e),this.state="READY",this.mediaIndex=e.mediaIndex,this.fetchAtBuffer_=!0,this.currentTimeline_=e.timeline,this.trigger("syncinfoupdate"),t.end&&this.currentTime_()-t.end>3*e.playlist.targetDuration?this.resetEverything():(i&&this.trigger("bandwidthupdate"),this.trigger("progress"),this.isEndOfStream_(e.mediaIndex+1,e.playlist)&&this.endOfStream(),this.paused()||this.monitorBuffer_())}},{key:"recordThroughput_",value:function(e){var t=this.throughput.rate,i=Date.now()-e.endOfAllRequests+1,n=Math.floor(e.byteLength/i*8*1e3);this.throughput.rate+=(n-t)/++this.throughput.count}},{key:"addSegmentMetadataCue_",value:function(e){if(this.segmentMetadataTrack_){var t=e.segment,i=t.start,n=t.end;if(Ar(i)&&Ar(n)){Ee(i,n,this.segmentMetadataTrack_);var r=u.WebKitDataCue||u.VTTCue,a={custom:t.custom,dateTimeObject:t.dateTimeObject,dateTimeString:t.dateTimeString,bandwidth:e.playlist.attributes.BANDWIDTH,resolution:e.playlist.attributes.RESOLUTION,codecs:e.playlist.attributes.CODECS,byteLength:e.byteLength,uri:e.uri,timeline:e.timeline,playlist:e.playlist.id,start:i,end:n},s=new r(i,n,JSON.stringify(a));s.value=a,this.segmentMetadataTrack_.addCue(s)}}}}]),i}(t.EventTarget),Cr=function(e){return decodeURIComponent(escape(String.fromCharCode.apply(null,e)))},Ur=new Uint8Array("\n\n".split("").map(function(e){return e.charCodeAt(0)})),Or=function(e){function i(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};_(this,i);var n=T(this,(i.__proto__||Object.getPrototypeOf(i)).call(this,e,t));return n.mediaSource_=null,n.subtitlesTrack_=null,n}return b(i,Lr),v(i,[{key:"buffered_",value:function(){if(!this.subtitlesTrack_||!this.subtitlesTrack_.cues.length)return t.createTimeRanges();var e=this.subtitlesTrack_.cues,i=e[0].startTime,n=e[e.length-1].startTime;return t.createTimeRanges([[i,n]])}},{key:"initSegment",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]&&arguments[1];if(!e)return null;var i=pe(e),n=this.initSegments_[i];if(t&&!n&&e.bytes){var r=Ur.byteLength+e.bytes.byteLength,a=new Uint8Array(r);a.set(e.bytes),a.set(Ur,e.bytes.byteLength),this.initSegments_[i]=n={resolvedUri:e.resolvedUri,byterange:e.byterange,bytes:a}}return n||e}},{key:"couldBeginLoading_",value:function(){return this.playlist_&&this.subtitlesTrack_&&!this.paused()}},{key:"init_",value:function(){return this.state="READY",this.resetEverything(),this.monitorBuffer_()}},{key:"track",value:function(e){return void 0===e?this.subtitlesTrack_:(this.subtitlesTrack_=e,"INIT"===this.state&&this.couldBeginLoading_()&&this.init_(),this.subtitlesTrack_)}},{key:"remove",value:function(e,t){Ee(e,t,this.subtitlesTrack_)}},{key:"fillBuffer_",value:function(){var e=this;this.syncPoint_||(this.syncPoint_=this.syncController_.getSyncPoint(this.playlist_,this.duration_(),this.currentTimeline_,this.currentTime_()));var t=this.checkBuffer_(this.buffered_(),this.playlist_,this.mediaIndex,this.hasPlayed_(),this.currentTime_(),this.syncPoint_);if(t=this.skipEmptySegments_(t)){if(null===this.syncController_.timestampOffsetForTimeline(t.timeline)){return this.syncController_.one("timestampoffset",function(){e.state="READY",e.paused()||e.monitorBuffer_()}),void(this.state="WAITING_ON_TIMELINE")}this.loadSegment_(t)}}},{key:"skipEmptySegments_",value:function(e){for(;e&&e.segment.empty;)e=this.generateSegmentInfo_(e.playlist,e.mediaIndex+1,e.startOfSegment+e.duration,e.isSyncRequest);return e}},{key:"handleSegment_",value:function(){var e=this;if(this.pendingSegment_&&this.subtitlesTrack_){this.state="APPENDING";var t=this.pendingSegment_,i=t.segment;if("function"!=typeof u.WebVTT&&this.subtitlesTrack_&&this.subtitlesTrack_.tech_){var n=void 0,r=function(){e.subtitlesTrack_.tech_.off("vttjsloaded",n),e.error({message:"Error loading vtt.js"}),e.state="READY",e.pause(),e.trigger("error")};return n=function(){e.subtitlesTrack_.tech_.off("vttjserror",r),e.handleSegment_()},this.state="WAITING_ON_VTTJS",this.subtitlesTrack_.tech_.one("vttjsloaded",n),void this.subtitlesTrack_.tech_.one("vttjserror",r)}i.requested=!0;try{this.parseVTTCues_(t)}catch(e){return this.error({message:e.message}),this.state="READY",this.pause(),this.trigger("error")}if(this.updateTimeMapping_(t,this.syncController_.timelines[t.timeline],this.playlist_),t.isSyncRequest)return this.trigger("syncinfoupdate"),this.pendingSegment_=null,void(this.state="READY");t.byteLength=t.bytes.byteLength,this.mediaSecondsLoaded+=i.duration,t.cues.length&&this.remove(t.cues[0].endTime,t.cues[t.cues.length-1].endTime),t.cues.forEach(function(t){e.subtitlesTrack_.addCue(t)}),this.handleUpdateEnd_()}else this.state="READY"}},{key:"parseVTTCues_",value:function(e){var i=void 0,n=!1;"function"==typeof u.TextDecoder?i=new u.TextDecoder("utf8"):(i=u.WebVTT.StringDecoder(),n=!0);var r=new u.WebVTT.Parser(u,u.vttjs,i);if(e.cues=[],e.timestampmap={MPEGTS:0,LOCAL:0},r.oncue=e.cues.push.bind(e.cues),r.ontimestampmap=function(t){return e.timestampmap=t},r.onparsingerror=function(e){t.log.warn("Error encountered when parsing cues: "+e.message)},e.segment.map){var a=e.segment.map.bytes;n&&(a=Cr(a)),r.parse(a)}var s=e.bytes;n&&(s=Cr(s)),r.parse(s),r.flush()}},{key:"updateTimeMapping_",value:function(e,t,i){var n=e.segment;if(t)if(e.cues.length){var r=e.timestampmap,a=r.MPEGTS/9e4-r.LOCAL+t.mapping;if(e.cues.forEach(function(e){e.startTime+=a,e.endTime+=a}),!i.syncInfo){var s=e.cues[0].startTime,o=e.cues[e.cues.length-1].startTime;i.syncInfo={mediaSequence:i.mediaSequence+e.mediaIndex,time:Math.min(s,o-n.duration)}}}else n.empty=!0}}]),i}(),Dr=function(e,t){for(var i=e.cues,n=0;n<i.length;n++){var r=i[n];if(t>=r.adStartTime&&t<=r.adEndTime)return r}return null},Pr=27,Rr=15,xr=21,Nr=function(e,t){var i=1;for(e>t&&(i=-1);Math.abs(t-e)>4294967296;)e+=8589934592*i;return e},Mr=function e(t){var i,n;e.prototype.init.call(this),this.type_=t||"shared",this.push=function(e){"shared"!==this.type_&&e.type!==this.type_||(void 0===n&&(n=e.dts),e.dts=Nr(e.dts,n),e.pts=Nr(e.pts,n),i=e.dts,this.trigger("data",e))},this.flush=function(){n=i,this.trigger("done")},this.endTimeline=function(){this.flush(),this.trigger("endedtimeline")},this.discontinuity=function(){n=void 0,i=void 0},this.reset=function(){this.discontinuity(),this.trigger("reset")}};Mr.prototype=new mr;var Br,qr,Fr,Hr,jr=function(e){var t=31&e[1];return t<<=8,t|=e[2]},Vr=function(e){return!!(64&e[1])},Gr=function(e){var t=0;return(48&e[3])>>>4>1&&(t+=e[4]+1),t},Wr=function(e){switch(e){case 5:return"slice_layer_without_partitioning_rbsp_idr";case 6:return"sei_rbsp";case 7:return"seq_parameter_set_rbsp";case 8:return"pic_parameter_set_rbsp";case 9:return"access_unit_delimiter_rbsp";default:return null}},zr={parseType:function(e,t){var i=jr(e);return 0===i?"pat":i===t?"pmt":t?"pes":null},parsePat:function(e){var t=Vr(e),i=4+Gr(e);return t&&(i+=e[i]+1),(31&e[i+10])<<8|e[i+11]},parsePmt:function(e){var t={},i=Vr(e),n=4+Gr(e);if(i&&(n+=e[n]+1),1&e[n+5]){var r;r=3+((15&e[n+1])<<8|e[n+2])-4;for(var a=12+((15&e[n+10])<<8|e[n+11]);a<r;){var s=n+a;t[(31&e[s+1])<<8|e[s+2]]=e[s],a+=5+((15&e[s+3])<<8|e[s+4])}return t}},parsePayloadUnitStartIndicator:Vr,parsePesType:function(e,t){switch(t[jr(e)]){case Pr:return"video";case Rr:return"audio";case xr:return"timed-metadata";default:return null}},parsePesTime:function(e){if(!Vr(e))return null;var t=4+Gr(e);if(t>=e.byteLength)return null;var i,n=null;return 192&(i=e[t+7])&&((n={}).pts=(14&e[t+9])<<27|(255&e[t+10])<<20|(254&e[t+11])<<12|(255&e[t+12])<<5|(254&e[t+13])>>>3,n.pts*=4,n.pts+=(6&e[t+13])>>>1,n.dts=n.pts,64&i&&(n.dts=(14&e[t+14])<<27|(255&e[t+15])<<20|(254&e[t+16])<<12|(255&e[t+17])<<5|(254&e[t+18])>>>3,n.dts*=4,n.dts+=(6&e[t+18])>>>1)),n},videoPacketContainsKeyFrame:function(e){for(var t=4+Gr(e),i=e.subarray(t),n=0,r=0,a=!1;r<i.byteLength-3;r++)if(1===i[r+2]){n=r+5;break}for(;n<i.byteLength;)switch(i[n]){case 0:if(0!==i[n-1]){n+=2;break}if(0!==i[n-2]){n++;break}r+3!==n-2&&"slice_layer_without_partitioning_rbsp_idr"===Wr(31&i[r+3])&&(a=!0);do{n++}while(1!==i[n]&&n<i.length);r=n-2,n+=3;break;case 1:if(0!==i[n-1]||0!==i[n-2]){n+=3;break}"slice_layer_without_partitioning_rbsp_idr"===Wr(31&i[r+3])&&(a=!0),r=n-2,n+=3;break;default:n+=3}return i=i.subarray(r),n-=r,r=0,i&&i.byteLength>3&&"slice_layer_without_partitioning_rbsp_idr"===Wr(31&i[r+3])&&(a=!0),a}},Xr=[96e3,88200,64e3,48e3,44100,32e3,24e3,22050,16e3,12e3,11025,8e3,7350],Yr=function(e){return e[0]<<21|e[1]<<14|e[2]<<7|e[3]},$r={isLikelyAacData:function(e){return e[0]==="I".charCodeAt(0)&&e[1]==="D".charCodeAt(0)&&e[2]==="3".charCodeAt(0)},parseId3TagSize:function(e,t){var i=e[t+6]<<21|e[t+7]<<14|e[t+8]<<7|e[t+9];return(16&e[t+5])>>4?i+20:i+10},parseAdtsSize:function(e,t){var i=(224&e[t+5])>>5,n=e[t+4]<<3;return 6144&e[t+3]|n|i},parseType:function(e,t){return e[t]==="I".charCodeAt(0)&&e[t+1]==="D".charCodeAt(0)&&e[t+2]==="3".charCodeAt(0)?"timed-metadata":!0&e[t]&&240==(240&e[t+1])?"audio":null},parseSampleRate:function(e){for(var t=0;t+5<e.length;){if(255===e[t]&&240==(246&e[t+1]))return Xr[(60&e[t+2])>>>2];t++}return null},parseAacTimestamp:function(e){var t,i,n;t=10,64&e[5]&&(t+=4,t+=Yr(e.subarray(10,14)));do{if((i=Yr(e.subarray(t+4,t+8)))<1)return null;if("PRIV"===String.fromCharCode(e[t],e[t+1],e[t+2],e[t+3])){n=e.subarray(t+10,t+i+10);for(var r=0;r<n.byteLength;r++)if(0===n[r]){if("com.apple.streaming.transportStreamTimestamp"===unescape(function(e,t,i){var n,r="";for(n=t;n<i;n++)r+="%"+("00"+e[n].toString(16)).slice(-2);return r}(n,0,r))){var a=n.subarray(r+1),s=(1&a[3])<<30|a[4]<<22|a[5]<<14|a[6]<<6|a[7]>>>2;return s*=4,s+=3&a[7]}break}}t+=10,t+=i}while(t<e.byteLength);return null}},Kr=9e4,Qr=(Br=function(e){return 9e4*e},qr=function(e,t){return e*t},Fr=function(e){return e/9e4},Hr=function(e,t){return e/t},Nr),Jr={};Jr.ts=zr,Jr.aac=$r;var Zr=Kr,ea=function(e,t,i){for(var n,r,a,s,o=0,u=188,d=!1;u<=e.byteLength;)if(71!==e[o]||71!==e[u]&&u!==e.byteLength)o++,u++;else{switch(n=e.subarray(o,u),Jr.ts.parseType(n,t.pid)){case"pes":r=Jr.ts.parsePesType(n,t.table),a=Jr.ts.parsePayloadUnitStartIndicator(n),"audio"===r&&a&&(s=Jr.ts.parsePesTime(n))&&(s.type="audio",i.audio.push(s),d=!0)}if(d)break;o+=188,u+=188}for(o=(u=e.byteLength)-188,d=!1;o>=0;)if(71!==e[o]||71!==e[u]&&u!==e.byteLength)o--,u--;else{switch(n=e.subarray(o,u),Jr.ts.parseType(n,t.pid)){case"pes":r=Jr.ts.parsePesType(n,t.table),a=Jr.ts.parsePayloadUnitStartIndicator(n),"audio"===r&&a&&(s=Jr.ts.parsePesTime(n))&&(s.type="audio",i.audio.push(s),d=!0)}if(d)break;o-=188,u-=188}},ta=function(e,t,i){for(var n,r,a,s,o,u,d,l=0,c=188,h=!1,f={data:[],size:0};c<e.byteLength;)if(71!==e[l]||71!==e[c])l++,c++;else{switch(n=e.subarray(l,c),Jr.ts.parseType(n,t.pid)){case"pes":if(r=Jr.ts.parsePesType(n,t.table),a=Jr.ts.parsePayloadUnitStartIndicator(n),"video"===r&&(a&&!h&&(s=Jr.ts.parsePesTime(n))&&(s.type="video",i.video.push(s),h=!0),!i.firstKeyFrame)){if(a&&0!==f.size){for(o=new Uint8Array(f.size),u=0;f.data.length;)d=f.data.shift(),o.set(d,u),u+=d.byteLength;if(Jr.ts.videoPacketContainsKeyFrame(o)){var p=Jr.ts.parsePesTime(o);p?(i.firstKeyFrame=p,i.firstKeyFrame.type="video"):console.warn("Failed to extract PTS/DTS from PES at first keyframe. This could be an unusual TS segment, or else mux.js did not parse your TS segment correctly. If you know your TS segments do contain PTS/DTS on keyframes please file a bug report! You can try ffprobe to double check for yourself.")}f.size=0}f.data.push(n),f.size+=n.byteLength}}if(h&&i.firstKeyFrame)break;l+=188,c+=188}for(l=(c=e.byteLength)-188,h=!1;l>=0;)if(71!==e[l]||71!==e[c])l--,c--;else{switch(n=e.subarray(l,c),Jr.ts.parseType(n,t.pid)){case"pes":r=Jr.ts.parsePesType(n,t.table),a=Jr.ts.parsePayloadUnitStartIndicator(n),"video"===r&&a&&(s=Jr.ts.parsePesTime(n))&&(s.type="video",i.video.push(s),h=!0)}if(h)break;l-=188,c-=188}},ia=function(e){var t={pid:null,table:null},i={};for(var n in function(e,t){for(var i,n=0,r=188;r<e.byteLength;)if(71!==e[n]||71!==e[r])n++,r++;else{switch(i=e.subarray(n,r),Jr.ts.parseType(i,t.pid)){case"pat":t.pid||(t.pid=Jr.ts.parsePat(i));break;case"pmt":t.table||(t.table=Jr.ts.parsePmt(i))}if(t.pid&&t.table)return;n+=188,r+=188}}(e,t),t.table){if(t.table.hasOwnProperty(n))switch(t.table[n]){case Pr:i.video=[],ta(e,t,i),0===i.video.length&&delete i.video;break;case Rr:i.audio=[],ea(e,t,i),0===i.audio.length&&delete i.audio}}return i},na=function(e,t){var i;return(i=Jr.aac.isLikelyAacData(e)?function(e){for(var t,i=!1,n=0,r=null,a=null,s=0,o=0;e.length-o>=3;){switch(Jr.aac.parseType(e,o)){case"timed-metadata":if(e.length-o<10){i=!0;break}if((s=Jr.aac.parseId3TagSize(e,o))>e.length){i=!0;break}null===a&&(t=e.subarray(o,o+s),a=Jr.aac.parseAacTimestamp(t)),o+=s;break;case"audio":if(e.length-o<7){i=!0;break}if((s=Jr.aac.parseAdtsSize(e,o))>e.length){i=!0;break}null===r&&(t=e.subarray(o,o+s),r=Jr.aac.parseSampleRate(t)),n++,o+=s;break;default:o++}if(i)return null}if(null===r||null===a)return null;var u=Zr/r;return{audio:[{type:"audio",dts:a,pts:a},{type:"audio",dts:a+1024*n*u,pts:a+1024*n*u}]}}(e):ia(e))&&(i.audio||i.video)?(function(e,t){if(e.audio&&e.audio.length){var i=t;void 0===i&&(i=e.audio[0].dts),e.audio.forEach(function(e){e.dts=Qr(e.dts,i),e.pts=Qr(e.pts,i),e.dtsTime=e.dts/Zr,e.ptsTime=e.pts/Zr})}if(e.video&&e.video.length){var n=t;if(void 0===n&&(n=e.video[0].dts),e.video.forEach(function(e){e.dts=Qr(e.dts,n),e.pts=Qr(e.pts,n),e.dtsTime=e.dts/Zr,e.ptsTime=e.pts/Zr}),e.firstKeyFrame){var r=e.firstKeyFrame;r.dts=Qr(r.dts,n),r.pts=Qr(r.pts,n),r.dtsTime=r.dts/Zr,r.ptsTime=r.dts/Zr}}}(i,t),i):null},ra=[{name:"VOD",run:function(e,t,i,n,r){if(i!==1/0){return{time:0,segmentIndex:0}}return null}},{name:"ProgramDateTime",run:function(e,t,i,n,r){if(!e.datetimeToDisplayTime)return null;var a=t.segments||[],s=null,o=null;r=r||0;for(var u=0;u<a.length;u++){var d=a[u];if(d.dateTimeObject){var l=d.dateTimeObject.getTime()/1e3+e.datetimeToDisplayTime,c=Math.abs(r-l);if(null!==o&&(0===c||o<c))break;o=c,s={time:l,segmentIndex:u}}}return s}},{name:"Segment",run:function(e,t,i,n,r){var a=t.segments||[],s=null,o=null;r=r||0;for(var u=0;u<a.length;u++){var d=a[u];if(d.timeline===n&&void 0!==d.start){var l=Math.abs(r-d.start);if(null!==o&&o<l)break;(!s||null===o||o>=l)&&(o=l,s={time:d.start,segmentIndex:u})}}return s}},{name:"Discontinuity",run:function(e,t,i,n,r){var a=null;if(r=r||0,t.discontinuityStarts&&t.discontinuityStarts.length)for(var s=null,o=0;o<t.discontinuityStarts.length;o++){var u=t.discontinuityStarts[o],d=t.discontinuitySequence+o+1,l=e.discontinuities[d];if(l){var c=Math.abs(r-l.time);if(null!==s&&s<c)break;(!a||null===s||s>=c)&&(s=c,a={time:l.time,segmentIndex:u})}}return a}},{name:"Playlist",run:function(e,t,i,n,r){return t.syncInfo?{time:t.syncInfo.time,segmentIndex:t.syncInfo.mediaSequence-t.mediaSequence}:null}}],aa=function(e){function t(){_(this,t);var e=T(this,(t.__proto__||Object.getPrototypeOf(t)).call(this));return e.inspectCache_=void 0,e.timelines=[],e.discontinuities=[],e.datetimeToDisplayTime=null,e.logger_=Fn("SyncController"),e}return b(t,e),v(t,[{key:"getSyncPoint",value:function(e,t,i,n){var r=this.runStrategies_(e,t,i,n);return r.length?this.selectSyncPoint_(r,{key:"time",value:n}):null}},{key:"getExpiredTime",value:function(e,t){if(!e||!e.segments)return null;var i=this.runStrategies_(e,t,e.discontinuitySequence,0);if(!i.length)return null;var n=this.selectSyncPoint_(i,{key:"segmentIndex",value:0});return n.segmentIndex>0&&(n.time*=-1),Math.abs(n.time+N(e,n.segmentIndex,0))}},{key:"runStrategies_",value:function(e,t,i,n){for(var r=[],a=0;a<ra.length;a++){var s=ra[a],o=s.run(this,e,t,i,n);o&&(o.strategy=s.name,r.push({strategy:s.name,syncPoint:o}))}return r}},{key:"selectSyncPoint_",value:function(e,t){for(var i=e[0].syncPoint,n=Math.abs(e[0].syncPoint[t.key]-t.value),r=e[0].strategy,a=1;a<e.length;a++){var s=Math.abs(e[a].syncPoint[t.key]-t.value);s<n&&(n=s,i=e[a].syncPoint,r=e[a].strategy)}return this.logger_("syncPoint for ["+t.key+": "+t.value+"] chosen with strategy ["+r+"]: [time:"+i.time+", segmentIndex:"+i.segmentIndex+"]"),i}},{key:"saveExpiredSegmentInfo",value:function(e,t){for(var i=t.mediaSequence-e.mediaSequence-1;i>=0;i--){var n=e.segments[i];if(n&&void 0!==n.start){t.syncInfo={mediaSequence:e.mediaSequence+i,time:n.start},this.logger_("playlist refresh sync: [time:"+t.syncInfo.time+", mediaSequence: "+t.syncInfo.mediaSequence+"]"),this.trigger("syncinfoupdate");break}}}},{key:"setDateTimeMapping",value:function(e){if(!this.datetimeToDisplayTime&&e.segments&&e.segments.length&&e.segments[0].dateTimeObject){var t=e.segments[0].dateTimeObject.getTime()/1e3;this.datetimeToDisplayTime=-t}}},{key:"reset",value:function(){this.inspectCache_=void 0}},{key:"probeSegmentInfo",value:function(e){var t=e.segment,i=e.playlist,n=void 0;return(n=t.map?this.probeMp4Segment_(e):this.probeTsSegment_(e))&&this.calculateSegmentTimeMapping_(e,n)&&(this.saveDiscontinuitySyncInfo_(e),i.syncInfo||(i.syncInfo={mediaSequence:i.mediaSequence+e.mediaIndex,time:t.start})),n}},{key:"probeMp4Segment_",value:function(e){var t=e.segment,i=Qn.timescale(t.map.bytes),n=Qn.compositionStartTime(i,e.bytes);return null!==e.timestampOffset&&(e.timestampOffset-=n),{start:n,end:n+t.duration}}},{key:"probeTsSegment_",value:function(e){var t=na(e.bytes,this.inspectCache_),i=void 0,n=void 0,r=void 0;return t?(t.video&&2===t.video.length?(this.inspectCache_=t.video[1].dts,i=t.video[0].dtsTime,n=t.video[1].dtsTime,r=t.video):t.audio&&2===t.audio.length&&(this.inspectCache_=t.audio[1].dts,i=t.audio[0].dtsTime,n=t.audio[1].dtsTime,r=t.audio),{segmentTimestampInfo:r,start:i,end:n,containsVideo:t.video&&2===t.video.length,containsAudio:t.audio&&2===t.audio.length}):null}},{key:"timestampOffsetForTimeline",value:function(e){return void 0===this.timelines[e]?null:this.timelines[e].time}},{key:"mappingForTimeline",value:function(e){return void 0===this.timelines[e]?null:this.timelines[e].mapping}},{key:"calculateSegmentTimeMapping_",value:function(e,t){var i=e.segment,n=this.timelines[e.timeline];if(null!==e.timestampOffset)n={time:e.startOfSegment,mapping:e.startOfSegment-t.start},this.timelines[e.timeline]=n,this.trigger("timestampoffset"),this.logger_("time mapping for timeline "+e.timeline+": [time: "+n.time+"] [mapping: "+n.mapping+"]"),i.start=e.startOfSegment,i.end=t.end+n.mapping;else{if(!n)return!1;i.start=t.start+n.mapping,i.end=t.end+n.mapping}return!0}},{key:"saveDiscontinuitySyncInfo_",value:function(e){var t=e.playlist,i=e.segment;if(i.discontinuity)this.discontinuities[i.timeline]={time:i.start,accuracy:0};else if(t.discontinuityStarts&&t.discontinuityStarts.length)for(var n=0;n<t.discontinuityStarts.length;n++){var r=t.discontinuityStarts[n],a=t.discontinuitySequence+n+1,s=r-e.mediaIndex,o=Math.abs(s);if(!this.discontinuities[a]||this.discontinuities[a].accuracy>o){var u=void 0;u=s<0?i.start-N(t,e.mediaIndex,r):i.end+N(t,e.mediaIndex+1,r),this.discontinuities[a]={time:u,accuracy:o}}}}},{key:"dispose",value:function(){this.trigger("dispose"),this.off()}}]),t}(t.EventTarget),sa=new Re("./decrypter-worker.worker.js",function(e,t){var i=this;!function(){var e=function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")},t=function(){function e(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}return function(t,i,n){return i&&e(t.prototype,i),n&&e(t,n),t}}(),n=function(e,t){if(!e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return!t||"object"!=typeof t&&"function"!=typeof t?e:t},r=function(){var e=[[[],[],[],[],[]],[[],[],[],[],[]]],t=e[0],i=e[1],n=t[4],r=i[4],a=void 0,s=void 0,o=void 0,u=[],d=[],l=void 0,c=void 0,h=void 0,f=void 0,p=void 0;for(a=0;a<256;a++)d[(u[a]=a<<1^283*(a>>7))^a]=a;for(s=o=0;!n[s];s^=l||1,o=d[o]||1)for(h=(h=o^o<<1^o<<2^o<<3^o<<4)>>8^255&h^99,n[s]=h,r[h]=s,p=16843009*u[c=u[l=u[s]]]^65537*c^257*l^16843008*s,f=257*u[h]^16843008*h,a=0;a<4;a++)t[a][s]=f=f<<24^f>>>8,i[a][h]=p=p<<24^p>>>8;for(a=0;a<5;a++)t[a]=t[a].slice(0),i[a]=i[a].slice(0);return e},a=null,s=function(){function t(i){e(this,t),a||(a=r()),this._tables=[[a[0][0].slice(),a[0][1].slice(),a[0][2].slice(),a[0][3].slice(),a[0][4].slice()],[a[1][0].slice(),a[1][1].slice(),a[1][2].slice(),a[1][3].slice(),a[1][4].slice()]];var n=void 0,s=void 0,o=void 0,u=void 0,d=void 0,l=this._tables[0][4],c=this._tables[1],h=i.length,f=1;if(4!==h&&6!==h&&8!==h)throw new Error("Invalid aes key size");for(u=i.slice(0),d=[],this._key=[u,d],n=h;n<4*h+28;n++)o=u[n-1],(n%h==0||8===h&&n%h==4)&&(o=l[o>>>24]<<24^l[o>>16&255]<<16^l[o>>8&255]<<8^l[255&o],n%h==0&&(o=o<<8^o>>>24^f<<24,f=f<<1^283*(f>>7))),u[n]=u[n-h]^o;for(s=0;n;s++,n--)o=u[3&s?n:n-4],d[s]=n<=4||s<4?o:c[0][l[o>>>24]]^c[1][l[o>>16&255]]^c[2][l[o>>8&255]]^c[3][l[255&o]]}return t.prototype.decrypt=function(e,t,i,n,r,a){var s=this._key[1],o=e^s[0],u=n^s[1],d=i^s[2],l=t^s[3],c=void 0,h=void 0,f=void 0,p=s.length/4-2,m=void 0,g=4,y=this._tables[1],_=y[0],v=y[1],b=y[2],T=y[3],S=y[4];for(m=0;m<p;m++)c=_[o>>>24]^v[u>>16&255]^b[d>>8&255]^T[255&l]^s[g],h=_[u>>>24]^v[d>>16&255]^b[l>>8&255]^T[255&o]^s[g+1],f=_[d>>>24]^v[l>>16&255]^b[o>>8&255]^T[255&u]^s[g+2],l=_[l>>>24]^v[o>>16&255]^b[u>>8&255]^T[255&d]^s[g+3],g+=4,o=c,u=h,d=f;for(m=0;m<4;m++)r[(3&-m)+a]=S[o>>>24]<<24^S[u>>16&255]<<16^S[d>>8&255]<<8^S[255&l]^s[g++],c=o,o=u,u=d,d=l,l=c},t}(),o=function(){function t(){e(this,t),this.listeners={}}return t.prototype.on=function(e,t){this.listeners[e]||(this.listeners[e]=[]),this.listeners[e].push(t)},t.prototype.off=function(e,t){if(!this.listeners[e])return!1;var i=this.listeners[e].indexOf(t);return this.listeners[e].splice(i,1),i>-1},t.prototype.trigger=function(e){var t=this.listeners[e];if(t)if(2===arguments.length)for(var i=t.length,n=0;n<i;++n)t[n].call(this,arguments[1]);else for(var r=Array.prototype.slice.call(arguments,1),a=t.length,s=0;s<a;++s)t[s].apply(this,r)},t.prototype.dispose=function(){this.listeners={}},t.prototype.pipe=function(e){this.on("data",function(t){e.push(t)})},t}(),u=function(t){function i(){e(this,i);var r=n(this,t.call(this,o));return r.jobs=[],r.delay=1,r.timeout_=null,r}return function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function, not "+typeof t);e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}}),t&&(Object.setPrototypeOf?Object.setPrototypeOf(e,t):e.__proto__=t)}(i,t),i.prototype.processJob_=function(){this.jobs.shift()(),this.jobs.length?this.timeout_=setTimeout(this.processJob_.bind(this),this.delay):this.timeout_=null},i.prototype.push=function(e){this.jobs.push(e),this.timeout_||(this.timeout_=setTimeout(this.processJob_.bind(this),this.delay))},i}(o),d=function(e){return e<<24|(65280&e)<<8|(16711680&e)>>8|e>>>24},l=function(){function i(t,n,r,a){e(this,i);var s=i.STEP,o=new Int32Array(t.buffer),l=new Uint8Array(t.byteLength),c=0;for(this.asyncStream_=new u,this.asyncStream_.push(this.decryptChunk_(o.subarray(c,c+s),n,r,l)),c=s;c<o.length;c+=s)r=new Uint32Array([d(o[c-4]),d(o[c-3]),d(o[c-2]),d(o[c-1])]),this.asyncStream_.push(this.decryptChunk_(o.subarray(c,c+s),n,r,l));this.asyncStream_.push(function(){var e;a(null,(e=l).subarray(0,e.byteLength-e[e.byteLength-1]))})}return i.prototype.decryptChunk_=function(e,t,i,n){return function(){var r=function(e,t,i){var n=new Int32Array(e.buffer,e.byteOffset,e.byteLength>>2),r=new s(Array.prototype.slice.call(t)),a=new Uint8Array(e.byteLength),o=new Int32Array(a.buffer),u=void 0,l=void 0,c=void 0,h=void 0,f=void 0,p=void 0,m=void 0,g=void 0,y=void 0;for(u=i[0],l=i[1],c=i[2],h=i[3],y=0;y<n.length;y+=4)f=d(n[y]),p=d(n[y+1]),m=d(n[y+2]),g=d(n[y+3]),r.decrypt(f,p,m,g,o,y),o[y]=d(o[y]^u),o[y+1]=d(o[y+1]^l),o[y+2]=d(o[y+2]^c),o[y+3]=d(o[y+3]^h),u=f,l=p,c=m,h=g;return a}(e,t,i);n.set(r,e.byteOffset)}},t(i,null,[{key:"STEP",get:function(){return 32e3}}]),i}();new function(e){e.onmessage=function(t){var i=t.data,n=new Uint8Array(i.encrypted.bytes,i.encrypted.byteOffset,i.encrypted.byteLength),r=new Uint32Array(i.key.bytes,i.key.byteOffset,i.key.byteLength/4),a=new Uint32Array(i.iv.bytes,i.iv.byteOffset,i.iv.byteLength/4);new l(n,r,a,function(t,n){var r,a;e.postMessage((r={source:i.source,decrypted:n},a={},Object.keys(r).forEach(function(e){var t=r[e];ArrayBuffer.isView(t)?a[e]={bytes:t.buffer,byteOffset:t.byteOffset,byteLength:t.byteLength}:a[e]=t}),a),[n.buffer])})}}(i)}()}),oa=function(e){var t=e.default?"main":"alternative";return e.characteristics&&e.characteristics.indexOf("public.accessibility.describes-video")>=0&&(t="main-desc"),t},ua=function(e,t){e.abort(),e.pause(),t&&t.activePlaylistLoader&&(t.activePlaylistLoader.pause(),t.activePlaylistLoader=null)},da=function(e,t){t.activePlaylistLoader=e,e.load()},la={AUDIO:function(e,i){return function(){var n=i.segmentLoaders[e],r=i.mediaTypes[e],a=i.blacklistCurrentPlaylist;ua(n,r);var s=r.activeTrack(),o=r.activeGroup(),u=(o.filter(function(e){return e.default})[0]||o[0]).id,d=r.tracks[u];if(s!==d){for(var l in t.log.warn("Problem encountered loading the alternate audio track.Switching back to default."),r.tracks)r.tracks[l].enabled=r.tracks[l]===d;r.onTrackChanged()}else a({message:"Problem encountered loading the default audio track."})}},SUBTITLES:function(e,i){return function(){var n=i.segmentLoaders[e],r=i.mediaTypes[e];t.log.warn("Problem encountered loading the subtitle track.Disabling subtitle track."),ua(n,r);var a=r.activeTrack();a&&(a.mode="disabled"),r.onTrackChanged()}}},ca={AUDIO:function(e,t,i){if(t){var n=i.tech,r=i.requestOptions,a=i.segmentLoaders[e];t.on("loadedmetadata",function(){var e=t.media();a.playlist(e,r),(!n.paused()||e.endList&&"none"!==n.preload())&&a.load()}),t.on("loadedplaylist",function(){a.playlist(t.media(),r),n.paused()||a.load()}),t.on("error",la[e](e,i))}},SUBTITLES:function(e,t,i){var n=i.tech,r=i.requestOptions,a=i.segmentLoaders[e],s=i.mediaTypes[e];t.on("loadedmetadata",function(){var e=t.media();a.playlist(e,r),a.track(s.activeTrack()),(!n.paused()||e.endList&&"none"!==n.preload())&&a.load()}),t.on("loadedplaylist",function(){a.playlist(t.media(),r),n.paused()||a.load()}),t.on("error",la[e](e,i))}},ha={AUDIO:function(e,i){var n=i.hls,r=i.sourceType,a=i.segmentLoaders[e],s=i.requestOptions,o=i.master.mediaGroups,u=i.mediaTypes[e],d=u.groups,l=u.tracks,c=i.masterPlaylistLoader;for(var h in o[e]&&0!==Object.keys(o[e]).length||(o[e]={main:{default:{default:!0}}}),o[e])for(var f in d[h]||(d[h]=[]),o[e][h]){var p=o[e][h][f],m=void 0;if(m=p.resolvedUri?new D(p.resolvedUri,n,s):p.playlists&&"dash"===r?new qn(p.playlists[0],n,s,c):null,p=t.mergeOptions({id:f,playlistLoader:m},p),ca[e](e,p.playlistLoader,i),d[h].push(p),void 0===l[f]){var g=new t.AudioTrack({id:f,kind:oa(p),enabled:!1,language:p.language,default:p.default,label:f});l[f]=g}}a.on("error",la[e](e,i))},SUBTITLES:function(e,i){var n=i.tech,r=i.hls,a=i.sourceType,s=i.segmentLoaders[e],o=i.requestOptions,u=i.master.mediaGroups,d=i.mediaTypes[e],l=d.groups,c=d.tracks,h=i.masterPlaylistLoader;for(var f in u[e])for(var p in l[f]||(l[f]=[]),u[e][f])if(!u[e][f][p].forced){var m=u[e][f][p],g=void 0;if("hls"===a?g=new D(m.resolvedUri,r,o):"dash"===a&&(g=new qn(m.playlists[0],r,o,h)),m=t.mergeOptions({id:p,playlistLoader:g},m),ca[e](e,m.playlistLoader,i),l[f].push(m),void 0===c[p]){var y=n.addRemoteTextTrack({id:p,kind:"subtitles",default:m.default&&m.autoselect,language:m.language,label:p},!1).track;c[p]=y}}s.on("error",la[e](e,i))},"CLOSED-CAPTIONS":function(e,i){var n=i.tech,r=i.master.mediaGroups,a=i.mediaTypes[e],s=a.groups,o=a.tracks;for(var u in r[e])for(var d in s[u]||(s[u]=[]),r[e][u]){var l=r[e][u][d];if(l.instreamId.match(/CC\d/)&&(s[u].push(t.mergeOptions({id:d},l)),void 0===o[d])){var c=n.addRemoteTextTrack({id:l.instreamId,kind:"captions",default:l.default&&l.autoselect,language:l.language,label:d},!1).track;o[d]=c}}}},fa={AUDIO:function(e,t){return function(){var i=t.mediaTypes[e].tracks;for(var n in i)if(i[n].enabled)return i[n];return null}},SUBTITLES:function(e,t){return function(){var i=t.mediaTypes[e].tracks;for(var n in i)if("showing"===i[n].mode||"hidden"===i[n].mode)return i[n];return null}}},pa=function(e){["AUDIO","SUBTITLES","CLOSED-CAPTIONS"].forEach(function(t){ha[t](t,e)});var t=e.mediaTypes,i=e.masterPlaylistLoader,n=e.tech,r=e.hls;["AUDIO","SUBTITLES"].forEach(function(i){t[i].activeGroup=function(e,t){return function(i){var n=t.masterPlaylistLoader,r=t.mediaTypes[e].groups,a=n.media();if(!a)return null;var s=null;return a.attributes[e]&&(s=r[a.attributes[e]]),s=s||r.main,void 0===i?s:null===i?null:s.filter(function(e){return e.id===i.id})[0]||null}}(i,e),t[i].activeTrack=fa[i](i,e),t[i].onGroupChanged=function(e,t){return function(){var i=t.segmentLoaders,n=i[e],r=i.main,a=t.mediaTypes[e],s=a.activeTrack(),o=a.activeGroup(s),u=a.activePlaylistLoader;ua(n,a),o&&(o.playlistLoader?(n.resyncLoader(),da(o.playlistLoader,a)):u&&r.resetEverything())}}(i,e),t[i].onTrackChanged=function(e,t){return function(){var i=t.segmentLoaders,n=i[e],r=i.main,a=t.mediaTypes[e],s=a.activeTrack(),o=a.activeGroup(s),u=a.activePlaylistLoader;ua(n,a),o&&(o.playlistLoader?u!==o.playlistLoader?(n.track&&n.track(s),n.resetEverything(),da(o.playlistLoader,a)):da(o.playlistLoader,a):r.resetEverything())}}(i,e)});var a=t.AUDIO.activeGroup(),s=(a.filter(function(e){return e.default})[0]||a[0]).id;t.AUDIO.tracks[s].enabled=!0,t.AUDIO.onTrackChanged(),i.on("mediachange",function(){["AUDIO","SUBTITLES"].forEach(function(e){return t[e].onGroupChanged()})});var o=function(){t.AUDIO.onTrackChanged(),n.trigger({type:"usage",name:"hls-audio-change"})};for(var u in n.audioTracks().addEventListener("change",o),n.remoteTextTracks().addEventListener("change",t.SUBTITLES.onTrackChanged),r.on("dispose",function(){n.audioTracks().removeEventListener("change",o),n.remoteTextTracks().removeEventListener("change",t.SUBTITLES.onTrackChanged)}),n.clearTracks("audio"),t.AUDIO.tracks)n.audioTracks().addTrack(t.AUDIO.tracks[u])},ma=function(){var e={};return["AUDIO","SUBTITLES","CLOSED-CAPTIONS"].forEach(function(t){e[t]={groups:{},tracks:{},activePlaylistLoader:null,activeGroup:Hn,activeTrack:Hn,onGroupChanged:Hn,onTrackChanged:Hn}}),e},ga=void 0,ya=["mediaRequests","mediaRequestsAborted","mediaRequestsTimedout","mediaRequestsErrored","mediaTransferDuration","mediaBytesTransferred"],_a=function(e){return this.audioSegmentLoader_[e]+this.mainSegmentLoader_[e]},va=function(e){function i(e){_(this,i);var n=T(this,(i.__proto__||Object.getPrototypeOf(i)).call(this)),r=e.url,a=e.handleManifestRedirects,s=e.withCredentials,o=e.tech,u=e.bandwidth,d=e.externHls,l=e.useCueTags,c=e.blacklistDuration,h=e.enableLowInitialPlaylist,f=e.sourceType,p=e.seekTo,m=e.cacheEncryptionKeys;if(!r)throw new Error("A non-empty playlist URL is required");ga=d,n.withCredentials=s,n.tech_=o,n.hls_=o.hls,n.seekTo_=p,n.sourceType_=f,n.useCueTags_=l,n.blacklistDuration=c,n.enableLowInitialPlaylist=h,n.useCueTags_&&(n.cueTagsTrack_=n.tech_.addTextTrack("metadata","ad-cues"),n.cueTagsTrack_.inBandMetadataTrackDispatchType=""),n.requestOptions_={withCredentials:s,handleManifestRedirects:a,timeout:null},n.mediaTypes_=ma(),n.mediaSource=new t.MediaSource,n.mediaSource.addEventListener("sourceopen",n.handleSourceOpen_.bind(n)),n.seekable_=t.createTimeRanges(),n.hasPlayed_=!1,n.syncController_=new aa(e),n.segmentMetadataTrack_=o.addRemoteTextTrack({kind:"metadata",label:"segment-metadata"},!1).track,n.decrypter_=new sa,n.inbandTextTracks_={};var g={hls:n.hls_,mediaSource:n.mediaSource,currentTime:n.tech_.currentTime.bind(n.tech_),seekable:function(){return n.seekable()},seeking:function(){return n.tech_.seeking()},duration:function(){return n.mediaSource.duration},hasPlayed:function(){return n.hasPlayed_},goalBufferLength:function(){return n.goalBufferLength()},bandwidth:u,syncController:n.syncController_,decrypter:n.decrypter_,sourceType:n.sourceType_,inbandTextTracks:n.inbandTextTracks_,cacheEncryptionKeys:m};return n.masterPlaylistLoader_="dash"===n.sourceType_?new qn(r,n.hls_,n.requestOptions_):new D(r,n.hls_,n.requestOptions_),n.setupMasterPlaylistLoaderListeners_(),n.mainSegmentLoader_=new Lr(t.mergeOptions(g,{segmentMetadataTrack:n.segmentMetadataTrack_,loaderType:"main"}),e),n.audioSegmentLoader_=new Lr(t.mergeOptions(g,{loaderType:"audio"}),e),n.subtitleSegmentLoader_=new Or(t.mergeOptions(g,{loaderType:"vtt"}),e),n.setupSegmentLoaderListeners_(),ya.forEach(function(e){n[e+"_"]=_a.bind(n,e)}),n.logger_=Fn("MPC"),n.masterPlaylistLoader_.load(),n}return b(i,e),v(i,[{key:"setupMasterPlaylistLoaderListeners_",value:function(){var e=this;this.masterPlaylistLoader_.on("loadedmetadata",function(){var i=e.masterPlaylistLoader_.media(),n=1.5*i.targetDuration*1e3;X(e.masterPlaylistLoader_.master,e.masterPlaylistLoader_.media())?e.requestOptions_.timeout=0:e.requestOptions_.timeout=n,i.endList&&"none"!==e.tech_.preload()&&(e.mainSegmentLoader_.playlist(i,e.requestOptions_),e.mainSegmentLoader_.load()),pa({sourceType:e.sourceType_,segmentLoaders:{AUDIO:e.audioSegmentLoader_,SUBTITLES:e.subtitleSegmentLoader_,main:e.mainSegmentLoader_},tech:e.tech_,requestOptions:e.requestOptions_,masterPlaylistLoader:e.masterPlaylistLoader_,hls:e.hls_,master:e.master(),mediaTypes:e.mediaTypes_,blacklistCurrentPlaylist:e.blacklistCurrentPlaylist.bind(e)}),e.triggerPresenceUsage_(e.master(),i);try{e.setupSourceBuffers_()}catch(i){return t.log.warn("Failed to create SourceBuffers",i),e.mediaSource.endOfStream("decode")}e.setupFirstPlay(),!e.mediaTypes_.AUDIO.activePlaylistLoader||e.mediaTypes_.AUDIO.activePlaylistLoader.media()?e.trigger("selectedinitialmedia"):e.mediaTypes_.AUDIO.activePlaylistLoader.one("loadedmetadata",function(){e.trigger("selectedinitialmedia")})}),this.masterPlaylistLoader_.on("loadedplaylist",function(){var t=e.masterPlaylistLoader_.media();if(!t){e.excludeUnsupportedVariants_();var i=void 0;return e.enableLowInitialPlaylist&&(i=e.selectInitialPlaylist()),i||(i=e.selectPlaylist()),e.initialMedia_=i,void e.masterPlaylistLoader_.media(e.initialMedia_)}if(e.useCueTags_&&e.updateAdCues_(t),e.mainSegmentLoader_.playlist(t,e.requestOptions_),e.updateDuration(),e.tech_.paused()||(e.mainSegmentLoader_.load(),e.audioSegmentLoader_&&e.audioSegmentLoader_.load()),!t.endList){var n=function(){var t=e.seekable();0!==t.length&&e.mediaSource.addSeekableRange_(t.start(0),t.end(0))};if(e.duration()!==1/0){e.tech_.one("durationchange",function t(){e.duration()===1/0?n():e.tech_.one("durationchange",t)})}else n()}}),this.masterPlaylistLoader_.on("error",function(){e.blacklistCurrentPlaylist(e.masterPlaylistLoader_.error)}),this.masterPlaylistLoader_.on("mediachanging",function(){e.mainSegmentLoader_.abort(),e.mainSegmentLoader_.pause()}),this.masterPlaylistLoader_.on("mediachange",function(){var t=e.masterPlaylistLoader_.media(),i=1.5*t.targetDuration*1e3;X(e.masterPlaylistLoader_.master,e.masterPlaylistLoader_.media())?e.requestOptions_.timeout=0:e.requestOptions_.timeout=i,e.mainSegmentLoader_.playlist(t,e.requestOptions_),e.mainSegmentLoader_.load(),e.tech_.trigger({type:"mediachange",bubbles:!0})}),this.masterPlaylistLoader_.on("playlistunchanged",function(){var t=e.masterPlaylistLoader_.media();e.stuckAtPlaylistEnd_(t)&&(e.blacklistCurrentPlaylist({message:"Playlist no longer updating."}),e.tech_.trigger("playliststuck"))}),this.masterPlaylistLoader_.on("renditiondisabled",function(){e.tech_.trigger({type:"usage",name:"hls-rendition-disabled"})}),this.masterPlaylistLoader_.on("renditionenabled",function(){e.tech_.trigger({type:"usage",name:"hls-rendition-enabled"})})}},{key:"triggerPresenceUsage_",value:function(e,t){var i=e.mediaGroups||{},n=!0,r=Object.keys(i.AUDIO);for(var a in i.AUDIO)for(var s in i.AUDIO[a]){i.AUDIO[a][s].uri||(n=!1)}n&&this.tech_.trigger({type:"usage",name:"hls-demuxed"}),Object.keys(i.SUBTITLES).length&&this.tech_.trigger({type:"usage",name:"hls-webvtt"}),ga.Playlist.isAes(t)&&this.tech_.trigger({type:"usage",name:"hls-aes"}),ga.Playlist.isFmp4(t)&&this.tech_.trigger({type:"usage",name:"hls-fmp4"}),r.length&&Object.keys(i.AUDIO[r[0]]).length>1&&this.tech_.trigger({type:"usage",name:"hls-alternate-audio"}),this.useCueTags_&&this.tech_.trigger({type:"usage",name:"hls-playlist-cue-tags"})}},{key:"setupSegmentLoaderListeners_",value:function(){var e=this;this.mainSegmentLoader_.on("bandwidthupdate",function(){var t=e.selectPlaylist(),i=e.masterPlaylistLoader_.media(),n=e.tech_.buffered(),r=n.length?n.end(n.length-1)-e.tech_.currentTime():0,a=e.bufferLowWaterLine();(!i.endList||e.duration()<Yn.MAX_BUFFER_LOW_WATER_LINE||t.attributes.BANDWIDTH<i.attributes.BANDWIDTH||r>=a)&&e.masterPlaylistLoader_.media(t),e.tech_.trigger("bandwidthupdate")}),this.mainSegmentLoader_.on("progress",function(){e.trigger("progress")}),this.mainSegmentLoader_.on("error",function(){e.blacklistCurrentPlaylist(e.mainSegmentLoader_.error())}),this.mainSegmentLoader_.on("syncinfoupdate",function(){e.onSyncInfoUpdate_()}),this.mainSegmentLoader_.on("timestampoffset",function(){e.tech_.trigger({type:"usage",name:"hls-timestamp-offset"})}),this.audioSegmentLoader_.on("syncinfoupdate",function(){e.onSyncInfoUpdate_()}),this.mainSegmentLoader_.on("ended",function(){e.onEndOfStream()}),this.mainSegmentLoader_.on("earlyabort",function(){e.blacklistCurrentPlaylist({message:"Aborted early because there isn't enough bandwidth to complete the request without rebuffering."},120)}),this.mainSegmentLoader_.on("reseteverything",function(){e.tech_.trigger("hls-reset")}),this.mainSegmentLoader_.on("segmenttimemapping",function(t){e.tech_.trigger({type:"hls-segment-time-mapping",mapping:t.mapping})}),this.audioSegmentLoader_.on("ended",function(){e.onEndOfStream()})}},{key:"mediaSecondsLoaded_",value:function(){return Math.max(this.audioSegmentLoader_.mediaSecondsLoaded+this.mainSegmentLoader_.mediaSecondsLoaded)}},{key:"load",value:function(){this.mainSegmentLoader_.load(),this.mediaTypes_.AUDIO.activePlaylistLoader&&this.audioSegmentLoader_.load(),this.mediaTypes_.SUBTITLES.activePlaylistLoader&&this.subtitleSegmentLoader_.load()}},{key:"smoothQualityChange_",value:function(){var e=this.selectPlaylist();e!==this.masterPlaylistLoader_.media()&&(this.masterPlaylistLoader_.media(e),this.mainSegmentLoader_.resetLoader())}},{key:"fastQualityChange_",value:function(){var e=this,i=this.selectPlaylist();i!==this.masterPlaylistLoader_.media()&&(this.masterPlaylistLoader_.media(i),this.mainSegmentLoader_.resetEverything(function(){t.browser.IE_VERSION||t.browser.IS_EDGE?e.tech_.setCurrentTime(e.tech_.currentTime()+.04):e.tech_.setCurrentTime(e.tech_.currentTime())}))}},{key:"play",value:function(){if(!this.setupFirstPlay()){this.tech_.ended()&&this.seekTo_(0),this.hasPlayed_&&this.load();var e=this.tech_.seekable();return this.tech_.duration()===1/0&&this.tech_.currentTime()<e.start(0)?this.seekTo_(e.end(e.length-1)):void 0}}},{key:"setupFirstPlay",value:function(){var e=this,i=this.masterPlaylistLoader_.media();if(!i||this.tech_.paused()||this.hasPlayed_)return!1;if(!i.endList){var n=this.seekable();if(!n.length)return!1;if(t.browser.IE_VERSION&&0===this.tech_.readyState())return this.tech_.one("loadedmetadata",function(){e.trigger("firstplay"),e.seekTo_(n.end(0)),e.hasPlayed_=!0}),!1;this.trigger("firstplay"),this.seekTo_(n.end(0))}return this.hasPlayed_=!0,this.load(),!0}},{key:"handleSourceOpen_",value:function(){try{this.setupSourceBuffers_()}catch(e){return t.log.warn("Failed to create Source Buffers",e),this.mediaSource.endOfStream("decode")}if(this.tech_.autoplay()){var e=this.tech_.play();void 0!==e&&"function"==typeof e.then&&e.then(null,function(e){})}this.trigger("sourceopen")}},{key:"onEndOfStream",value:function(){var e=this.mainSegmentLoader_.ended_;if(this.mediaTypes_.AUDIO.activePlaylistLoader&&(e=!this.mainSegmentLoader_.startingMedia_||this.mainSegmentLoader_.startingMedia_.containsVideo?e&&this.audioSegmentLoader_.ended_:this.audioSegmentLoader_.ended_),e){this.logger_("calling mediaSource.endOfStream()");try{this.mediaSource.endOfStream()}catch(e){t.log.warn("Failed to call media source endOfStream",e)}}}},{key:"stuckAtPlaylistEnd_",value:function(e){if(!this.seekable().length)return!1;var t=this.syncController_.getExpiredTime(e,this.mediaSource.duration);if(null===t)return!1;var i=ga.Playlist.playlistEnd(e,t),n=this.tech_.currentTime(),r=this.tech_.buffered();if(!r.length)return i-n<=.1;var a=r.end(r.length-1);return a-n<=.1&&i-a<=.1}},{key:"blacklistCurrentPlaylist",value:function(){var e,i=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},n=arguments[1],r=void 0;if(r=i.playlist||this.masterPlaylistLoader_.media(),n=n||i.blacklistDuration||this.blacklistDuration,!r){this.error=i;try{return this.mediaSource.endOfStream("network")}catch(e){return this.trigger("error")}}var a=1===this.masterPlaylistLoader_.master.playlists.filter(W).length,s=this.masterPlaylistLoader_.master.playlists;return 1===s.length?(t.log.warn("Problem encountered with the current HLS playlist. Trying again since it is the only playlist."),this.tech_.trigger("retryplaylist"),this.masterPlaylistLoader_.load(a)):(a&&(t.log.warn("Removing all playlists from the blacklist because the last rendition is about to be blacklisted."),s.forEach(function(e){e.excludeUntil!==1/0&&delete e.excludeUntil}),this.tech_.trigger("retryplaylist")),r.excludeUntil=Date.now()+1e3*n,this.tech_.trigger("blacklistplaylist"),this.tech_.trigger({type:"usage",name:"hls-rendition-blacklisted"}),e=this.selectPlaylist(),t.log.warn("Problem encountered with the current HLS playlist."+(i.message?" "+i.message:"")+" Switching to another playlist."),this.masterPlaylistLoader_.media(e,a))}},{key:"pauseLoading",value:function(){this.mainSegmentLoader_.pause(),this.mediaTypes_.AUDIO.activePlaylistLoader&&this.audioSegmentLoader_.pause(),this.mediaTypes_.SUBTITLES.activePlaylistLoader&&this.subtitleSegmentLoader_.pause()}},{key:"setCurrentTime",value:function(e){var t=Te(this.tech_.buffered(),e);return this.masterPlaylistLoader_&&this.masterPlaylistLoader_.media()&&this.masterPlaylistLoader_.media().segments?t&&t.length?e:(this.mainSegmentLoader_.resetEverything(),this.mainSegmentLoader_.abort(),this.mediaTypes_.AUDIO.activePlaylistLoader&&(this.audioSegmentLoader_.resetEverything(),this.audioSegmentLoader_.abort()),this.mediaTypes_.SUBTITLES.activePlaylistLoader&&(this.subtitleSegmentLoader_.resetEverything(),this.subtitleSegmentLoader_.abort()),void this.load()):0}},{key:"duration",value:function(){return this.masterPlaylistLoader_?this.mediaSource?this.mediaSource.duration:ga.Playlist.duration(this.masterPlaylistLoader_.media()):0}},{key:"seekable",value:function(){return this.seekable_}},{key:"onSyncInfoUpdate_",value:function(){var e=void 0;if(this.masterPlaylistLoader_){var i=this.masterPlaylistLoader_.media();if(i){var n=this.syncController_.getExpiredTime(i,this.mediaSource.duration);if(null!==n){var r=this.masterPlaylistLoader_.master.suggestedPresentationDelay,a=ga.Playlist.seekable(i,n,r);if(0!==a.length){if(this.mediaTypes_.AUDIO.activePlaylistLoader){if(i=this.mediaTypes_.AUDIO.activePlaylistLoader.media(),null===(n=this.syncController_.getExpiredTime(i,this.mediaSource.duration)))return;if(0===(e=ga.Playlist.seekable(i,n,r)).length)return}var s=void 0,o=void 0;this.seekable_&&this.seekable_.length&&(s=this.seekable_.end(0),o=this.seekable_.start(0)),e?e.start(0)>a.end(0)||a.start(0)>e.end(0)?this.seekable_=a:this.seekable_=t.createTimeRanges([[e.start(0)>a.start(0)?e.start(0):a.start(0),e.end(0)<a.end(0)?e.end(0):a.end(0)]]):this.seekable_=a,this.seekable_&&this.seekable_.length&&this.seekable_.end(0)===s&&this.seekable_.start(0)===o||(this.logger_("seekable updated ["+we(this.seekable_)+"]"),this.tech_.trigger("seekablechanged"))}}}}}},{key:"updateDuration",value:function(){var e=this,i=this.mediaSource.duration,n=ga.Playlist.duration(this.masterPlaylistLoader_.media()),r=this.tech_.buffered(),a=function i(){e.logger_("Setting duration from "+e.mediaSource.duration+" => "+n);try{e.mediaSource.duration=n}catch(e){t.log.warn("Failed to set media source duration",e)}e.tech_.trigger("durationchange"),e.mediaSource.removeEventListener("sourceopen",i)};r.length>0&&(n=Math.max(n,r.end(r.length-1))),i!==n&&("open"!==this.mediaSource.readyState?this.mediaSource.addEventListener("sourceopen",a):a())}},{key:"dispose",value:function(){var e=this;this.trigger("dispose"),this.decrypter_.terminate(),this.masterPlaylistLoader_.dispose(),this.mainSegmentLoader_.dispose(),["AUDIO","SUBTITLES"].forEach(function(t){var i=e.mediaTypes_[t].groups;for(var n in i)i[n].forEach(function(e){e.playlistLoader&&e.playlistLoader.dispose()})}),this.audioSegmentLoader_.dispose(),this.subtitleSegmentLoader_.dispose(),this.off(),this.mediaSource.dispose&&this.mediaSource.dispose()}},{key:"master",value:function(){return this.masterPlaylistLoader_.master}},{key:"media",value:function(){return this.masterPlaylistLoader_.media()||this.initialMedia_}},{key:"setupSourceBuffers_",value:function(){var e,t=this.masterPlaylistLoader_.media();if(t&&"open"===this.mediaSource.readyState){if((e=Ge(this.masterPlaylistLoader_.master,t)).length<1)return this.error="No compatible SourceBuffer configuration for the variant stream:"+t.resolvedUri,this.mediaSource.endOfStream("decode");this.configureLoaderMimeTypes_(e),this.excludeIncompatibleVariants_(t)}}},{key:"configureLoaderMimeTypes_",value:function(e){var i=e.length>1&&-1===e[0].indexOf(",")&&e[0]!==e[1]?new t.EventTarget:null;this.mainSegmentLoader_.mimeType(e[0],i),e[1]&&this.audioSegmentLoader_.mimeType(e[1],i)}},{key:"excludeUnsupportedVariants_",value:function(){this.master().playlists.forEach(function(e){var t;e.attributes.CODECS&&u.MediaSource&&u.MediaSource.isTypeSupported&&!u.MediaSource.isTypeSupported('video/mp4; codecs="'+(t=e.attributes.CODECS,t.replace(/avc1\.(\d+)\.(\d+)/i,function(e){return He([e])[0]}))+'"')&&(e.excludeUntil=1/0)})}},{key:"excludeIncompatibleVariants_",value:function(e){var t=2,i=null,n=void 0;e.attributes.CODECS&&(n=je(e.attributes.CODECS),i=n.videoCodec,t=n.codecCount),this.master().playlists.forEach(function(e){var n={codecCount:2,videoCodec:null};e.attributes.CODECS&&(n=je(e.attributes.CODECS)),n.codecCount!==t&&(e.excludeUntil=1/0),n.videoCodec!==i&&(e.excludeUntil=1/0)})}},{key:"updateAdCues_",value:function(e){var t=0,i=this.seekable();i.length&&(t=i.start(0)),function(e,t){var i=arguments.length>2&&void 0!==arguments[2]?arguments[2]:0;if(e.segments)for(var n=i,r=void 0,a=0;a<e.segments.length;a++){var s=e.segments[a];if(r||(r=Dr(t,n+s.duration/2)),r){if("cueIn"in s){r.endTime=n,r.adEndTime=n,n+=s.duration,r=null;continue}if(n<r.endTime){n+=s.duration;continue}r.endTime+=s.duration}else if("cueOut"in s&&((r=new u.VTTCue(n,n+s.duration,s.cueOut)).adStartTime=n,r.adEndTime=n+parseFloat(s.cueOut),t.addCue(r)),"cueOutCont"in s){var o,d,l=s.cueOutCont.split("/").map(parseFloat),c=S(l,2);o=c[0],d=c[1],(r=new u.VTTCue(n,n+s.duration,"")).adStartTime=n-o,r.adEndTime=r.adStartTime+d,t.addCue(r)}n+=s.duration}}(e,this.cueTagsTrack_,t)}},{key:"goalBufferLength",value:function(){var e=this.tech_.currentTime(),t=Yn.GOAL_BUFFER_LENGTH,i=Yn.GOAL_BUFFER_LENGTH_RATE,n=Math.max(t,Yn.MAX_GOAL_BUFFER_LENGTH);return Math.min(t+e*i,n)}},{key:"bufferLowWaterLine",value:function(){var e=this.tech_.currentTime(),t=Yn.BUFFER_LOW_WATER_LINE,i=Yn.BUFFER_LOW_WATER_LINE_RATE,n=Math.max(t,Yn.MAX_BUFFER_LOW_WATER_LINE);return Math.min(t+e*i,n)}}]),i}(t.EventTarget),ba=function e(t,i,n){_(this,e);var r,a,s,o=t.masterPlaylistController_,u=o[(t.options_.smoothQualityChange?"smooth":"fast")+"QualityChange_"].bind(o);if(i.attributes.RESOLUTION){var d=i.attributes.RESOLUTION;this.width=d.width,this.height=d.height}this.bandwidth=i.attributes.BANDWIDTH,this.id=n,this.enabled=(r=t.playlists,a=i.id,s=u,function(e){var t=r.master.playlists[a],i=G(t),n=W(t);return void 0===e?n:(e?delete t.disabled:t.disabled=!0,e===n||i||(s(),e?r.trigger("renditionenabled"):r.trigger("renditiondisabled")),e)})},Ta=["seeking","seeked","pause","playing","error"],Sa=function(){function e(t){var i=this;_(this,e),this.tech_=t.tech,this.seekable=t.seekable,this.seekTo=t.seekTo,this.allowSeeksWithinUnsafeLiveWindow=t.allowSeeksWithinUnsafeLiveWindow,this.media=t.media,this.consecutiveUpdates=0,this.lastRecordedTime=null,this.timer_=null,this.checkCurrentTimeTimeout_=null,this.logger_=Fn("PlaybackWatcher"),this.logger_("initialize");var n=function(){return i.monitorCurrentTime_()},r=function(){return i.techWaiting_()},a=function(){return i.cancelTimer_()},s=function(){return i.fixesBadSeeks_()};this.tech_.on("seekablechanged",s),this.tech_.on("waiting",r),this.tech_.on(Ta,a),this.tech_.on("canplay",n),this.dispose=function(){i.logger_("dispose"),i.tech_.off("seekablechanged",s),i.tech_.off("waiting",r),i.tech_.off(Ta,a),i.tech_.off("canplay",n),i.checkCurrentTimeTimeout_&&u.clearTimeout(i.checkCurrentTimeTimeout_),i.cancelTimer_()}}return v(e,[{key:"monitorCurrentTime_",value:function(){this.checkCurrentTime_(),this.checkCurrentTimeTimeout_&&u.clearTimeout(this.checkCurrentTimeTimeout_),this.checkCurrentTimeTimeout_=u.setTimeout(this.monitorCurrentTime_.bind(this),250)}},{key:"checkCurrentTime_",value:function(){if(this.tech_.seeking()&&this.fixesBadSeeks_())return this.consecutiveUpdates=0,void(this.lastRecordedTime=this.tech_.currentTime());if(!this.tech_.paused()&&!this.tech_.seeking()){var e=this.tech_.currentTime(),t=this.tech_.buffered();if(this.lastRecordedTime===e&&(!t.length||e+.1>=t.end(t.length-1)))return this.techWaiting_();this.consecutiveUpdates>=5&&e===this.lastRecordedTime?(this.consecutiveUpdates++,this.waiting_()):e===this.lastRecordedTime?this.consecutiveUpdates++:(this.consecutiveUpdates=0,this.lastRecordedTime=e)}}},{key:"cancelTimer_",value:function(){this.consecutiveUpdates=0,this.timer_&&(this.logger_("cancelTimer_"),clearTimeout(this.timer_)),this.timer_=null}},{key:"fixesBadSeeks_",value:function(){if(!this.tech_.seeking())return!1;var e=this.seekable(),t=this.tech_.currentTime(),i=void 0;this.afterSeekableWindow_(e,t,this.media(),this.allowSeeksWithinUnsafeLiveWindow)&&(i=e.end(e.length-1));this.beforeSeekableWindow_(e,t)&&(i=e.start(0)+.1);return void 0!==i&&(this.logger_("Trying to seek outside of seekable at time "+t+" with seekable range "+we(e)+". Seeking to "+i+"."),this.seekTo(i),!0)}},{key:"waiting_",value:function(){if(!this.techWaiting_()){var e=this.tech_.currentTime(),t=this.tech_.buffered(),i=Te(t,e);return i.length&&e+3<=i.end(0)?(this.cancelTimer_(),this.seekTo(e),this.logger_("Stopped at "+e+" while inside a buffered region ["+i.start(0)+" -> "+i.end(0)+"]. Attempting to resume playback by seeking to the current time."),void this.tech_.trigger({type:"usage",name:"hls-unknown-waiting"})):void 0}}},{key:"techWaiting_",value:function(){var e=this.seekable(),t=this.tech_.currentTime();if(this.tech_.seeking()&&this.fixesBadSeeks_())return!0;if(this.tech_.seeking()||null!==this.timer_)return!0;if(this.beforeSeekableWindow_(e,t)){var i=e.end(e.length-1);return this.logger_("Fell out of live window at time "+t+". Seeking to live point (seekable end) "+i),this.cancelTimer_(),this.seekTo(i),this.tech_.trigger({type:"usage",name:"hls-live-resync"}),!0}var n=this.tech_.buffered(),r=Se(n,t);if(this.videoUnderflow_(r,n,t))return this.cancelTimer_(),this.seekTo(t),this.tech_.trigger({type:"usage",name:"hls-video-underflow"}),!0;if(r.length>0){var a=r.start(0)-t;return this.logger_("Stopped at "+t+", setting timer for "+a+", seeking to "+r.start(0)),this.timer_=setTimeout(this.skipTheGap_.bind(this),1e3*a,t),!0}return!1}},{key:"afterSeekableWindow_",value:function(e,t,i){var n=arguments.length>3&&void 0!==arguments[3]&&arguments[3];if(!e.length)return!1;var r=e.end(e.length-1)+.1;return!i.endList&&n&&(r=e.end(e.length-1)+3*i.targetDuration),t>r}},{key:"beforeSeekableWindow_",value:function(e,t){return!!(e.length&&e.start(0)>0&&t<e.start(0)-.1)}},{key:"videoUnderflow_",value:function(e,t,i){if(0===e.length){var n=this.gapFromVideoUnderflow_(t,i);if(n)return this.logger_("Encountered a gap in video from "+n.start+" to "+n.end+". Seeking to current time "+i),!0}return!1}},{key:"skipTheGap_",value:function(e){var t=this.tech_.buffered(),i=this.tech_.currentTime(),n=Se(t,i);this.cancelTimer_(),0!==n.length&&i===e&&(this.logger_("skipTheGap_:","currentTime:",i,"scheduled currentTime:",e,"nextRange start:",n.start(0)),this.seekTo(n.start(0)+1/30),this.tech_.trigger({type:"usage",name:"hls-gap-skip"}))}},{key:"gapFromVideoUnderflow_",value:function(e,i){for(var n=function(e){if(e.length<2)return t.createTimeRanges();for(var i=[],n=1;n<e.length;n++){var r=e.end(n-1),a=e.start(n);i.push([r,a])}return t.createTimeRanges(i)}(e),r=0;r<n.length;r++){var a=n.start(r),s=n.end(r);if(i-a<4&&i-a>2)return{start:a,end:s}}return null}}]),e}(),wa={errorInterval:30,getSource:function(e){return e(this.tech({IWillNotUseThisInPlugins:!0}).currentSource_)}},ka=function(e){!function e(i,n){var r=0,a=0,s=t.mergeOptions(wa,n);i.ready(function(){i.trigger({type:"usage",name:"hls-error-reload-initialized"})});var o=function(){a&&i.currentTime(a)},u=function(e){null!==e&&void 0!==e&&(a=i.duration()!==1/0&&i.currentTime()||0,i.one("loadedmetadata",o),i.src(e),i.trigger({type:"usage",name:"hls-error-reload"}),i.play())},d=function(){if(Date.now()-r<1e3*s.errorInterval)i.trigger({type:"usage",name:"hls-error-reload-canceled"});else{if(s.getSource&&"function"==typeof s.getSource)return r=Date.now(),s.getSource.call(i,u);t.log.error("ERROR: reloadSourceOnError - The option getSource must be a function!")}},l=function e(){i.off("loadedmetadata",o),i.off("error",d),i.off("dispose",e)};i.on("error",d),i.on("dispose",l),i.reloadSourceOnError=function(t){l(),e(i,t)}}(this,e)};t.use("*",function(e){return{setSource:function(e,t){t(null,e)},setCurrentTime:function(t){return e.vhs&&e.currentSource().src===e.vhs.source_.src&&e.vhs.setCurrentTime(t),t},play:function(){e.vhs&&e.currentSource().src===e.vhs.source_.src&&e.vhs.setCurrentTime(e.tech_.currentTime())}}});var Ea={PlaylistLoader:D,Playlist:Y,Decrypter:de,AsyncStream:se,decrypt:ue,utils:ye,STANDARD_PLAYLIST_SELECTOR:function(){return function(e,t,i,n,r){var a=e.playlists.map(function(e){var t,i;return t=e.attributes.RESOLUTION&&e.attributes.RESOLUTION.width,i=e.attributes.RESOLUTION&&e.attributes.RESOLUTION.height,{bandwidth:e.attributes.BANDWIDTH||u.Number.MAX_VALUE,width:t,height:i,playlist:e}});or(a,function(e,t){return e.bandwidth-t.bandwidth});var s=(a=a.filter(function(e){return!Y.isIncompatible(e.playlist)})).filter(function(e){return Y.isEnabled(e.playlist)});s.length||(s=a.filter(function(e){return!Y.isDisabled(e.playlist)}));var o=s.filter(function(e){return e.bandwidth*Yn.BANDWIDTH_VARIANCE<t}),d=o[o.length-1],l=o.filter(function(e){return e.bandwidth===d.bandwidth})[0];if(!1===r){var c=l||s[0]||a[0];return c?c.playlist:null}var h=o.filter(function(e){return e.width&&e.height});or(h,function(e,t){return e.width-t.width});var f=h.filter(function(e){return e.width===i&&e.height===n});d=f[f.length-1];var p=f.filter(function(e){return e.bandwidth===d.bandwidth})[0],m=void 0,g=void 0,y=void 0;p||(g=(m=h.filter(function(e){return e.width>i||e.height>n})).filter(function(e){return e.width===m[0].width&&e.height===m[0].height}),d=g[g.length-1],y=g.filter(function(e){return e.bandwidth===d.bandwidth})[0]);var _=y||p||l||s[0]||a[0];return _?_.playlist:null}(this.playlists.master,this.systemBandwidth,parseInt(sr(this.tech_.el(),"width"),10),parseInt(sr(this.tech_.el(),"height"),10),this.limitRenditionByPlayerDimensions)},INITIAL_PLAYLIST_SELECTOR:function(){var e=this.playlists.master.playlists.filter(Y.isEnabled);return or(e,function(e,t){return ur(e,t)}),e.filter(function(e){return je(e.attributes.CODECS).videoCodec})[0]||null},comparePlaylistBandwidth:ur,comparePlaylistResolution:function(e,t){var i=void 0,n=void 0;return e.attributes.RESOLUTION&&e.attributes.RESOLUTION.width&&(i=e.attributes.RESOLUTION.width),i=i||u.Number.MAX_VALUE,t.attributes.RESOLUTION&&t.attributes.RESOLUTION.width&&(n=t.attributes.RESOLUTION.width),i===(n=n||u.Number.MAX_VALUE)&&e.attributes.BANDWIDTH&&t.attributes.BANDWIDTH?e.attributes.BANDWIDTH-t.attributes.BANDWIDTH:i-n},xhr:Q()};["GOAL_BUFFER_LENGTH","MAX_GOAL_BUFFER_LENGTH","GOAL_BUFFER_LENGTH_RATE","BUFFER_LOW_WATER_LINE","MAX_BUFFER_LOW_WATER_LINE","BUFFER_LOW_WATER_LINE_RATE","BANDWIDTH_VARIANCE"].forEach(function(e){Object.defineProperty(Ea,e,{get:function(){return t.log.warn("using Hls."+e+" is UNSAFE be sure you know what you are doing"),Yn[e]},set:function(i){t.log.warn("using Hls."+e+" is UNSAFE be sure you know what you are doing"),"number"!=typeof i||i<0?t.log.warn("value of Hls."+e+" must be greater than or equal to 0"):Yn[e]=i}})});var Ia=function(e){if(/^(audio|video|application)\/(x-|vnd\.apple\.)?mpegurl/i.test(e))return"hls";return/^application\/dash\+xml/i.test(e)?"dash":null},Aa=function(e,t){for(var i=t.media(),n=-1,r=0;r<e.length;r++)if(e[r].id===i.id){n=r;break}e.selectedIndex_=n,e.trigger({selectedIndex:n,type:"change"})};Ea.canPlaySource=function(){return t.log.warn("HLS is no longer a tech. Please remove it from your player's techOrder.")};var La=function(e,i,n){if(!e)return e;var r=void 0,a=void 0;if(n.mimeType_)r=i.mimeType_,a=n.mimeType_;else{var s=We(i.mimeType_),o=void 0,u=void 0;s.parameters.codecs.split(",").forEach(function(e){e=e.trim(),ze(e)?o=e:Xe(e)&&(u=e)}),r=s.type+'; codecs="'+u+'"',a=s.type.replace("video","audio")+'; codecs="'+o+'"'}var d={},l=i.playlist_;for(var c in e)d[c]={audioContentType:a,videoContentType:r},l.contentProtection&&l.contentProtection[c]&&l.contentProtection[c].pssh&&(d[c].pssh=l.contentProtection[c].pssh),"string"==typeof e[c]&&(d[c].url=e[c]);return t.mergeOptions(e,d)},Ca=function(){if(!window.localStorage)return null;var e=window.localStorage.getItem("videojs-vhs");if(!e)return null;try{return JSON.parse(e)}catch(e){return null}};Ea.supportsNativeHls=function(){var e=s.createElement("video");if(!t.getTech("Html5").isSupported())return!1;return["application/vnd.apple.mpegurl","audio/mpegurl","audio/x-mpegurl","application/x-mpegurl","video/x-mpegurl","video/mpegurl","application/mpegurl"].some(function(t){return/maybe|probably/i.test(e.canPlayType(t))})}(),Ea.supportsNativeDash=!!t.getTech("Html5").isSupported()&&/maybe|probably/i.test(s.createElement("video").canPlayType("application/dash+xml")),Ea.supportsTypeNatively=function(e){return"hls"===e?Ea.supportsNativeHls:"dash"===e&&Ea.supportsNativeDash},Ea.isSupported=function(){return t.log.warn("HLS is no longer a tech. Please remove it from your player's techOrder.")};var Ua=t.getComponent("Component"),Oa=function(e){function i(e,n,r){_(this,i);var a=T(this,(i.__proto__||Object.getPrototypeOf(i)).call(this,n,r.hls));if(n.options_&&n.options_.playerId){var o=t(n.options_.playerId);o.hasOwnProperty("hls")||Object.defineProperty(o,"hls",{get:function(){return t.log.warn("player.hls is deprecated. Use player.tech().hls instead."),n.trigger({type:"usage",name:"hls-player-access"}),a},configurable:!0}),o.vhs=a,o.dash=a,a.player_=o}if(a.tech_=n,a.source_=e,a.stats={},a.setOptions_(),a.options_.overrideNative&&n.overrideNativeAudioTracks&&n.overrideNativeVideoTracks)n.overrideNativeAudioTracks(!0),n.overrideNativeVideoTracks(!0);else if(a.options_.overrideNative&&(n.featuresNativeVideoTracks||n.featuresNativeAudioTracks))throw new Error("Overriding native HLS requires emulated tracks. See https://git.io/vMpjB");return a.on(s,["fullscreenchange","webkitfullscreenchange","mozfullscreenchange","MSFullscreenChange"],function(e){var t=s.fullscreenElement||s.webkitFullscreenElement||s.mozFullScreenElement||s.msFullscreenElement;t&&t.contains(a.tech_.el())&&a.masterPlaylistController_.smoothQualityChange_()}),a.on(a.tech_,"seeking",function(){0===this.tech_.currentTime()&&this.tech_.player_.loop()&&this.setCurrentTime(0)}),a.on(a.tech_,"error",function(){this.masterPlaylistController_&&this.masterPlaylistController_.pauseLoading()}),a.on(a.tech_,"play",a.play),a}return b(i,Ua),v(i,[{key:"setOptions_",value:function(){var e=this;if(this.options_.withCredentials=this.options_.withCredentials||!1,this.options_.handleManifestRedirects=this.options_.handleManifestRedirects||!1,this.options_.limitRenditionByPlayerDimensions=!1!==this.options_.limitRenditionByPlayerDimensions,this.options_.smoothQualityChange=this.options_.smoothQualityChange||!1,this.options_.useBandwidthFromLocalStorage=void 0!==this.source_.useBandwidthFromLocalStorage?this.source_.useBandwidthFromLocalStorage:this.options_.useBandwidthFromLocalStorage||!1,this.options_.customTagParsers=this.options_.customTagParsers||[],this.options_.customTagMappers=this.options_.customTagMappers||[],this.options_.cacheEncryptionKeys=this.options_.cacheEncryptionKeys||!1,"number"!=typeof this.options_.blacklistDuration&&(this.options_.blacklistDuration=300),"number"!=typeof this.options_.bandwidth&&this.options_.useBandwidthFromLocalStorage){var t=Ca();t&&t.bandwidth&&(this.options_.bandwidth=t.bandwidth,this.tech_.trigger({type:"usage",name:"hls-bandwidth-from-local-storage"})),t&&t.throughput&&(this.options_.throughput=t.throughput,this.tech_.trigger({type:"usage",name:"hls-throughput-from-local-storage"}))}"number"!=typeof this.options_.bandwidth&&(this.options_.bandwidth=Yn.INITIAL_BANDWIDTH),this.options_.enableLowInitialPlaylist=this.options_.enableLowInitialPlaylist&&this.options_.bandwidth===Yn.INITIAL_BANDWIDTH,["withCredentials","limitRenditionByPlayerDimensions","bandwidth","smoothQualityChange","customTagParsers","customTagMappers","handleManifestRedirects","cacheEncryptionKeys"].forEach(function(t){void 0!==e.source_[t]&&(e.options_[t]=e.source_[t])}),this.limitRenditionByPlayerDimensions=this.options_.limitRenditionByPlayerDimensions}},{key:"src",value:function(e,i){var n=this;e&&(this.setOptions_(),this.options_.url=this.source_.src,this.options_.tech=this.tech_,this.options_.externHls=Ea,this.options_.sourceType=Ia(i),this.options_.seekTo=function(e){n.tech_.setCurrentTime(e),n.setCurrentTime(e)},this.masterPlaylistController_=new va(this.options_),this.playbackWatcher_=new Sa(t.mergeOptions(this.options_,{seekable:function(){return n.seekable()},media:function(){return n.masterPlaylistController_.media()}})),this.masterPlaylistController_.on("error",function(){t.players[n.tech_.options_.playerId].error(n.masterPlaylistController_.error)}),this.masterPlaylistController_.selectPlaylist=this.selectPlaylist?this.selectPlaylist.bind(this):Ea.STANDARD_PLAYLIST_SELECTOR.bind(this),this.masterPlaylistController_.selectInitialPlaylist=Ea.INITIAL_PLAYLIST_SELECTOR.bind(this),this.playlists=this.masterPlaylistController_.masterPlaylistLoader_,this.mediaSource=this.masterPlaylistController_.mediaSource,Object.defineProperties(this,{selectPlaylist:{get:function(){return this.masterPlaylistController_.selectPlaylist},set:function(e){this.masterPlaylistController_.selectPlaylist=e.bind(this)}},throughput:{get:function(){return this.masterPlaylistController_.mainSegmentLoader_.throughput.rate},set:function(e){this.masterPlaylistController_.mainSegmentLoader_.throughput.rate=e,this.masterPlaylistController_.mainSegmentLoader_.throughput.count=1}},bandwidth:{get:function(){return this.masterPlaylistController_.mainSegmentLoader_.bandwidth},set:function(e){this.masterPlaylistController_.mainSegmentLoader_.bandwidth=e,this.masterPlaylistController_.mainSegmentLoader_.throughput={rate:0,count:0}}},systemBandwidth:{get:function(){var e=1/(this.bandwidth||1),t=void 0;return t=this.throughput>0?1/this.throughput:0,Math.floor(1/(e+t))},set:function(){t.log.error('The "systemBandwidth" property is read-only')}}}),this.options_.bandwidth&&(this.bandwidth=this.options_.bandwidth),this.options_.throughput&&(this.throughput=this.options_.throughput),Object.defineProperties(this.stats,{bandwidth:{get:function(){return n.bandwidth||0},enumerable:!0},mediaRequests:{get:function(){return n.masterPlaylistController_.mediaRequests_()||0},enumerable:!0},mediaRequestsAborted:{get:function(){return n.masterPlaylistController_.mediaRequestsAborted_()||0},enumerable:!0},mediaRequestsTimedout:{get:function(){return n.masterPlaylistController_.mediaRequestsTimedout_()||0},enumerable:!0},mediaRequestsErrored:{get:function(){return n.masterPlaylistController_.mediaRequestsErrored_()||0},enumerable:!0},mediaTransferDuration:{get:function(){return n.masterPlaylistController_.mediaTransferDuration_()||0},enumerable:!0},mediaBytesTransferred:{get:function(){return n.masterPlaylistController_.mediaBytesTransferred_()||0},enumerable:!0},mediaSecondsLoaded:{get:function(){return n.masterPlaylistController_.mediaSecondsLoaded_()||0},enumerable:!0},buffered:{get:function(){return ke(n.tech_.buffered())},enumerable:!0},currentTime:{get:function(){return n.tech_.currentTime()},enumerable:!0},currentSource:{get:function(){return n.tech_.currentSource_},enumerable:!0},currentTech:{get:function(){return n.tech_.name_},enumerable:!0},duration:{get:function(){return n.tech_.duration()},enumerable:!0},master:{get:function(){return n.playlists.master},enumerable:!0},playerDimensions:{get:function(){return n.tech_.currentDimensions()},enumerable:!0},seekable:{get:function(){return ke(n.tech_.seekable())},enumerable:!0},timestamp:{get:function(){return Date.now()},enumerable:!0},videoPlaybackQuality:{get:function(){return n.tech_.getVideoPlaybackQuality()},enumerable:!0}}),this.tech_.one("canplay",this.masterPlaylistController_.setupFirstPlay.bind(this.masterPlaylistController_)),this.tech_.on("bandwidthupdate",function(){n.options_.useBandwidthFromLocalStorage&&function(e){if(!window.localStorage)return!1;var i=Ca();i=i?t.mergeOptions(i,e):e;try{window.localStorage.setItem("videojs-vhs",JSON.stringify(i))}catch(e){return!1}}({bandwidth:n.bandwidth,throughput:Math.round(n.throughput)})}),this.masterPlaylistController_.on("selectedinitialmedia",function(){var e,i;i=(e=n).playlists,e.representations=function(){return i&&i.master&&i.master.playlists?i.master.playlists.filter(function(e){return!G(e)}).map(function(t,i){return new ba(e,t,t.id)}):[]},function(e){var i=e.masterPlaylistController_.mainSegmentLoader_,n=e.masterPlaylistController_.audioSegmentLoader_,r=t.players[e.tech_.options_.playerId];if(r.eme){var a=La(e.source_.keySystems,i,n);a&&(r.currentSource().keySystems=a,11!==t.browser.IE_VERSION&&r.eme.initializeMediaKeys&&r.eme.initializeMediaKeys())}}(n)}),this.on(this.masterPlaylistController_,"progress",function(){this.tech_.trigger("progress")}),this.setupQualityLevels_(),this.tech_.el()&&this.tech_.src(t.URL.createObjectURL(this.masterPlaylistController_.mediaSource)))}},{key:"setupQualityLevels_",value:function(){var e=this,i=t.players[this.tech_.options_.playerId];i&&i.qualityLevels&&!this.qualityLevels_&&(this.qualityLevels_=i.qualityLevels(),this.masterPlaylistController_.on("selectedinitialmedia",function(){var t,i;t=e.qualityLevels_,(i=e).representations().forEach(function(e){t.addQualityLevel(e)}),Aa(t,i.playlists)}),this.playlists.on("mediachange",function(){Aa(e.qualityLevels_,e.playlists)}))}},{key:"play",value:function(){this.masterPlaylistController_.play()}},{key:"setCurrentTime",value:function(e){this.masterPlaylistController_.setCurrentTime(e)}},{key:"duration",value:function(){return this.masterPlaylistController_.duration()}},{key:"seekable",value:function(){return this.masterPlaylistController_.seekable()}},{key:"dispose",value:function(){this.playbackWatcher_&&this.playbackWatcher_.dispose(),this.masterPlaylistController_&&this.masterPlaylistController_.dispose(),this.qualityLevels_&&this.qualityLevels_.dispose(),this.player_&&(delete this.player_.vhs,delete this.player_.dash,delete this.player_.hls),this.tech_&&this.tech_.hls&&delete this.tech_.hls,function e(t,i,n){null===t&&(t=Function.prototype);var r=Object.getOwnPropertyDescriptor(t,i);if(void 0===r){var a=Object.getPrototypeOf(t);return null===a?void 0:e(a,i,n)}if("value"in r)return r.value;var s=r.get;return void 0!==s?s.call(n):void 0}(i.prototype.__proto__||Object.getPrototypeOf(i.prototype),"dispose",this).call(this)}},{key:"convertToProgramTime",value:function(e,t){return _e({playlist:this.masterPlaylistController_.media(),time:e,callback:t})}},{key:"seekToProgramTime",value:function(e,t){var i=!(arguments.length>2&&void 0!==arguments[2])||arguments[2],n=arguments.length>3&&void 0!==arguments[3]?arguments[3]:2;return ve({programTime:e,playlist:this.masterPlaylistController_.media(),retryCount:n,pauseAfterSeek:i,seekTo:this.options_.seekTo,tech:this.options_.tech,callback:t})}}]),i}(),Da={name:"videojs-http-streaming",VERSION:"1.12.2",canHandleSource:function(e){var i=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=t.mergeOptions(t.options,i);return Da.canPlayType(e.type,n)},handleSource:function(e,i){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},r=t.mergeOptions(t.options,n);return i.hls=new Oa(e,i,r),i.hls.xhr=Q(),i.hls.src(e.src,e.type),i.hls},canPlayType:function(e){var i=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=t.mergeOptions(t.options,i).hls.overrideNative,r=Ia(e);return r&&(!Ea.supportsTypeNatively(r)||n)?"maybe":""}};void 0!==t.MediaSource&&void 0!==t.URL||(t.MediaSource=et,t.URL=tt),et.supportsNativeMediaSources()&&t.getTech("Html5").registerSourceHandler(Da,0),t.HlsHandler=Oa,t.HlsSourceHandler=Da,t.Hls=Ea,t.use||t.registerComponent("Hls",Ea),t.options.hls=t.options.hls||{},t.registerPlugin?t.registerPlugin("reloadSourceOnError",ka):t.plugin("reloadSourceOnError",ka),e.LOCAL_STORAGE_KEY="videojs-vhs",e.Hls=Ea,e.HlsHandler=Oa,e.HlsSourceHandler=Da,e.emeKeySystems=La,e.simpleTypeFromSourceType=Ia,Object.defineProperty(e,"__esModule",{value:!0})});
