/**
 * @module 1-liners/zip
 *
 * @description
 *
 * Creates an array of grouped elements, the first of which contains the first elements of the given arrays,
 * the second of which contains the second elements of the given arrays, and so on.
 *
 * @example
 *
 * const zip = require('1-liners/zip');
 * zip(['a', 'b'], [1, 2], [true, false]) // => [['a', 1, true], ['b', 2, false]]
 *
 */
"use strict";

exports.__esModule = true;

exports["default"] = function () {
  for (var _len = arguments.length, arrays = Array(_len), _key = 0; _key < _len; _key++) {
    arrays[_key] = arguments[_key];
  }

  return Array.from({ length: Math.max.apply(Math, arrays.map(function (a) {
      return a.length;
    })) }).map(function (_, i) {
    return arrays.map(function (a) {
      return a[i];
    });
  });
};

module.exports = exports["default"];