/**
 * @module 1-liners/uniqBy
 *
 * @description
 *
 * Remove duplicates from an array of objects by invoking `iteratee` for each object.
 *
 * @example
 *
 * const get = require('1-liners/uniqBy');
 *
 * let array = [{ id: 1 }, { id: 2 }, { id: 1 }];
 * uniqBy(array, o => o.id); // => [{ id: 1 }, { id: 2 }]
 *
 */
"use strict";

exports.__esModule = true;

exports["default"] = function (array, iteratee) {
  return array.filter(function (value, index, self) {
    return index === self.findIndex(function (other) {
      return iteratee(other) === iteratee(value);
    });
  });
};

module.exports = exports["default"];