/**
 * @module 1-liners/uniq
 *
 * @description
 *
 * Creates a duplicate-free version of an array.
 *
 * @example
 *
 * const uniq = require('1-liners/uniq');
 *
 * uniq([1, 2, 2]); // => [1, 2]
 *
 */
"use strict";

exports.__esModule = true;

exports["default"] = function (array) {
  return array.filter(function (value, index, self) {
    return index === self.findIndex(function (other) {
      return other === value;
    });
  });
};

module.exports = exports["default"];