/**
 * @module 1-liners/shallowClone
 *
 * @description
 *
 * Copy all properties of an object into a new plain object.
 *
 * @example
 *
 * 	import shallowClone from '1-liners/shallowClone';
 *
 * 	const source = {
 * 		value: 'value',
 * 		reference: /reference/,
 * 	};
 * 	const target = shallowClone(source);
 *
 * 	target === source                      // => false
 * 	target.value === source.value          // => true
 * 	target.reference === source.reference  // => true
 *
 */
"use strict";

exports.__esModule = true;
// istanbul ignore next

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

exports["default"] = function (object) {
  return _extends({}, object);
};

module.exports = exports["default"];