/**
 * @module 1-liners/range
 *
 * @description
 *
 * A pure function to generate a range of numbers
 * from start(including) to end(excluding)
 * @example
 *
 * const range = require('1-liners/range');
 *
 * range(1, 5); // => [1, 2, 3, 4, 5]
 *
 */
"use strict";

exports.__esModule = true;

exports["default"] = function (start, end) {
  return Array.from({ length: end - start }, function (v, k) {
    return k + start;
  });
};

module.exports = exports["default"];