/**
 * @module 1-liners/put
 *
 * @description
 *
 * Same as `Object.assign({}, obj, {[key]: val})`
 *
 * @example
 *
 * 	const put = require('1-liners/put');
 *
 * 	const object = {id: 1};
 *
 * 	put('name', 'stoeffel', object);  // => { id: 1, name: 'stoeffel' }
 *
 */
"use strict";

exports.__esModule = true;
// istanbul ignore next

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

exports["default"] = function (key, val, obj) {
  // istanbul ignore next

  var _extends2;

  return _extends({}, obj, (_extends2 = {}, _extends2[key] = val, _extends2));
};

module.exports = exports["default"];