/**
 * @module 1-liners/pipe
 * 
 * @description
 *
 * Pipe arguments through functions.
 * 
 * @example
 * 
 * 	const pipe = require('1-liners/pipe');
 * 
 * 	pipe(f, g)(1, 2) === g(f(1, 2));
 * 
 */
"use strict";

exports.__esModule = true;

exports["default"] = function (f, g) {
  return function () {
    return g(f.apply(undefined, arguments));
  };
};

module.exports = exports["default"];