/**
 * @module 1-liners/partial
 * 
 * @description
 *
 * Partially apply a function.
 * 
 * @example
 * 
 * 	const partial = require('1-liners/partial');
 * 
 * 	const add = (a, b, c) => a + b + c;
 * 
 *  const fivePlus = (add, 2, 3);
 *
 *  fivePlus(4) === 9
 */
"use strict";

exports.__esModule = true;

exports["default"] = function (f) {
  for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
    args[_key - 1] = arguments[_key];
  }

  return function () {
    for (var _len2 = arguments.length, moreArgs = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      moreArgs[_key2] = arguments[_key2];
    }

    return f.apply(undefined, args.concat(moreArgs));
  };
};

module.exports = exports["default"];