/**
 * @module 1-liners/isString
 *
 * @description
 *
 * Same as `typeof value === 'string'`.
 *
 * @example
 *
 * 	const isString = require('1-liners/isString');
 *
 * 	isString('');               // => true
 * 	isString('anything');       // => true
 *
 * 	isString(/anything else/);  // => false
 *
 */
'use strict';

exports.__esModule = true;

exports['default'] = function (value) {
  return typeof value === 'string';
};

module.exports = exports['default'];