/**
 * @module 1-liners/isNull
 *
 * @description
 *
 * Same as `=== null`.
 *
 * @example
 *
 * 	const isNull = require('1-liners/isNull');
 *
 * 	isNull(null);             // => true
 *
 * 	isNull(undefined);        // => false
 * 	isNull(NaN);              // => false
 * 	isNull('anything else');  // => false
 *
 */
"use strict";

exports.__esModule = true;

exports["default"] = function (value) {
  return value === null;
};

module.exports = exports["default"];