/**
 * @module 1-liners/isFalsy
 *
 * @description
 *
 * Same as `!`.
 *
 * @example
 *
 * 	const isFalsy = require('1-liners/isFalsy');
 *
 * 	isFalsy('yes');  // => false
 * 	isFalsy(true);   // => false
 * 	isFalsy([]);     // => false
 *
 * 	isFalsy('');     // => true
 * 	isFalsy(0);      // => true
 * 	isFalsy(false);  // => true
 *
 */
"use strict";

exports.__esModule = true;

exports["default"] = function (x) {
  return !x;
};

module.exports = exports["default"];