/**
 * @module 1-liners/isBetween
 *
 * @description
 *
 * Check if the `number` lies between `min` and `max`, inclusive.
 *
 * @example
 *
 * 	const isBetween = require('1-liners/isBetween');
 *
 * 	isBetween(1, 10, 2.5);  // => true
 * 	isBetween(1, 10, -5);   // => false
 * 	isBetween(1, 10, 25);   // => false
 *
 */
"use strict";

exports.__esModule = true;

exports["default"] = function (min, max, number) {
  return min <= number && number <= max;
};

module.exports = exports["default"];