/**
 * @module 1-liners/flatMap
 * 
 * @description
 *
 * Map a function over a collection and flatten the result by one-level.
 * 
 * @example
 * 
 * 	const flatMap = require('1-liners/flatMap');
 * 
 * 	flatMap((x) => [x, x], [1, 2, 3]); // => [1, 1, 2, 2, 3, 3]
 * 
 */
"use strict";

exports.__esModule = true;

exports["default"] = function (fn, array) {
  return [].concat.apply([], array.map(fn));
};

module.exports = exports["default"];