/**
 * @module 1-liners/converge
 *
 * @description
 *
 * Converge two functions into one.
 *
 * @example
 *
 * 	const converge = require('1-liners/converge');
 *
 * 	converge(f, g, h)(1, 2) === f(g(1, 2), h(1, 2));
 *
 */
"use strict";

exports.__esModule = true;

exports["default"] = function (f, g, h) {
  return function () {
    return f(g.apply(undefined, arguments), h.apply(undefined, arguments));
  };
};

module.exports = exports["default"];