/**
 * @module 1-liners/compose
 * 
 * @description
 *
 * Compose a new function from two given functions.
 * 
 * @example
 * 
 * 	const compose = require('1-liners/compose');
 * 
 * 	compose(f, g)(1, 2) === f(g(1, 2));
 * 
 */
"use strict";

exports.__esModule = true;

exports["default"] = function (f, g) {
  return function () {
    return f(g.apply(undefined, arguments));
  };
};

module.exports = exports["default"];