/**
 * @module 1-liners/compactObject
 *
 * @description
 *
 * A pure function to make a object compact and remove falsey values
 * @example
 *
 * const compactObject = require('1-liners/compactObject');
 *
 * compactObject({value: 'ebvk', fgs: undefined,}); // => {value: 'ebvk'}
 *
 */

"use strict";

exports.__esModule = true;
// istanbul ignore next

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

exports["default"] = function (obj) {
  return Object.keys(obj).reduce(function (acc, a) {
    // istanbul ignore next

    var _ref;

    return _extends(acc, !!obj[a] ? (_ref = {}, _ref[a] = obj[a], _ref) : {});
  }, {});
};

module.exports = exports["default"];