/**
 * @module 1-liners/average
 *
 * @description
 *
 * Returns the average of all items of an `array`.
 *
 * @example
 *
 * 	const average = require('1-liners/average');
 *
 * 	average([2, 3, 4]);        // => 3
 * 	average([]);               // => NaN
 *
 */
"use strict";

exports.__esModule = true;

exports["default"] = function (array) {
  return array.reduce(function (a, b) {
    return a + b;
  }, 0) / array.length;
};

module.exports = exports["default"];