
const httpRequestList = [];
const fetchData = url => fetch(url).then(res => res.json());

// http轮询接口信息列表 添加轮询
myDashboard.getDashboardConfig().then(({dataTables}) => {
    httpRequestList.forEach(({name, url, path, jsonata: json, period: {checked, time = 10}}) => {
        let temperatureData = dataTables.find(x => x.name === name);
        const loadData = async () => {
            try {
                const res = await fetchData(url + path);
                temperatureData.config.source = jsonata(json).evaluate(res);
                return myDashboard.updateDataTableConfig(temperatureData.id, temperatureData.config);
            }
            catch (error) {
                console.log(error);
            }
        }
        checked ? setInterval(loadData, time * 1000) : loadData();
    });
});
