package com.zbkj.service.wangshang.notify.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.zbkj.common.constants.Constants;
import com.zbkj.common.model.huifu.HuifuWalletReconciliation;
import com.zbkj.service.config.PaymentChannel;
import com.zbkj.service.dao.HuifuWalletReconciliationDao;
import com.zbkj.service.service.TransactionLogService;
import com.zbkj.service.wangshang.api.domain.RequestHead;
import com.zbkj.service.wangshang.api.domain.model.notify.BkcloudfundsElectronicReceiptNotifyModel;
import com.zbkj.service.wangshang.api.internal.parser.xml.XmlConverter;
import com.zbkj.service.wangshang.api.service.notify.BkcloudfundsElectronicReceiptNotifyRequest;
import com.zbkj.service.wangshang.handle.CommomRequstHandle;
import com.zbkj.service.wangshang.notify.service.MybankNotifyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

/**
 * 电子业务凭证申请结果通知 @2.0.0
 * ant.mybank.bkcloudfunds.electronicreceipt.notify
 **/
@Service(value = "bkcloudfundsElectronicReceiptNotifyService")
public class BkcloudfundsElectronicReceiptNotifyServiceImpl implements MybankNotifyService {

    private static final Logger logger = LoggerFactory.getLogger(BkcloudfundsProtocolWithholdResultNotifyServiceImpl.class);
    @Autowired
    private CommomRequstHandle commomRequstHandle;
    @Resource
    private HuifuWalletReconciliationDao huifuWalletReconciliationDao;
    @Autowired
    TransactionLogService transactionLogService;

    @Override
    public String notifyHandle(String context, String function) throws Exception {
        logger.info("========= > 电子业务凭证申请结果通知:ant.mybank.bkcloudfunds.electronicreceipt.notify");
        logger.info("========= > 请求报文："+context);
        //通知内容转换
        BkcloudfundsElectronicReceiptNotifyRequest electronicReceiptNotifyRequest =
                XmlConverter.getInstance().toResponse(context, BkcloudfundsElectronicReceiptNotifyRequest.class);
        RequestHead head = electronicReceiptNotifyRequest.getBkcloudfundsElectronicReceiptNotify().getRequestHead();
        //通知内容保存
        boolean flag = saveNotify(electronicReceiptNotifyRequest.getBkcloudfundsElectronicReceiptNotify().getBkcloudfundsElectronicReceiptNotifyModel());
        //响应结果根据执行结果统一处理
        String response = commomRequstHandle.getSignResult(flag, head);
        transactionLogService.save("电子业务凭证申请结果通知:ant.mybank.bkcloudfunds.electronicreceipt.notify", Constants.Y, context,response, PaymentChannel.WANGSHANG.toString());
        return response;
    }

    private boolean saveNotify(BkcloudfundsElectronicReceiptNotifyModel model) {
        //TODO
        LambdaQueryWrapper<HuifuWalletReconciliation> lqw = Wrappers.lambdaQuery();
        lqw.eq(HuifuWalletReconciliation::getReceiptNo, model.getReceiptNo());
        List<HuifuWalletReconciliation> list = huifuWalletReconciliationDao.selectList(lqw);
        if(list.size()>0){
            HuifuWalletReconciliation re = list.get(0);
            if(model.getStatus().equals(re.getReceiptStatus())){
                return true;
            }
            re.setReceiptStatus(model.getStatus());//申请中
            re.setUpdateTime(new Date());
            huifuWalletReconciliationDao.updateById(re);
            return true;
        }
        return false;
    }

}
