package com.zbkj.service.wangshang.notify.service.impl;


import com.zbkj.common.constants.Constants;
import com.zbkj.service.config.PaymentChannel;
import com.zbkj.service.service.TransactionLogService;
import com.zbkj.service.wangshang.api.domain.RequestHead;
import com.zbkj.service.wangshang.api.domain.model.notify.MerchantprodMerchControlNotifyModel;
import com.zbkj.service.wangshang.api.internal.parser.xml.XmlConverter;
import com.zbkj.service.wangshang.api.service.notify.MerchantprodMerchControlNotifyRequest;
import com.zbkj.service.wangshang.handle.CommomRequstHandle;
import com.zbkj.service.wangshang.notify.service.MybankNotifyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


/**
 * 商户管控通知
 * ant.mybank.merchantprod.merch.control.notify
 **/
@Service(value = "bkMerchantprodMerchControlNotifyService")
public class BkMerchantprodMerchControlNotifyServiceImpl implements MybankNotifyService {

    private static final Logger logger = LoggerFactory.getLogger(BkMerchantprodMerchControlNotifyServiceImpl.class);
    @Autowired
    private CommomRequstHandle commomRequstHandle;
    @Autowired
    TransactionLogService transactionLogService;

    @Override
    public String notifyHandle(String context, String function) throws Exception {
        logger.info("========= > 商户管控通知:ant.mybank.merchantprod.merch.control.notify");
        logger.info("========= > 请求报文："+context);
        //通知内容转换
        MerchantprodMerchControlNotifyRequest merchantprodMerchControlNotifyRequest =
                XmlConverter.getInstance().toResponse(context, MerchantprodMerchControlNotifyRequest.class);
        RequestHead head = merchantprodMerchControlNotifyRequest.getMerchantprodMerchControlNotify().getRequestHead();
        //通知内容保存
        boolean flag = saveNotify(merchantprodMerchControlNotifyRequest.getMerchantprodMerchControlNotify().getMerchantprodMerchControlNotifyModel());
        //响应结果根据执行结果统一处理
        String response = commomRequstHandle.getSignResult(flag, head);
        transactionLogService.save("商户管控通知:ant.mybank.merchantprod.merch.control.notify", Constants.Y, context,response, PaymentChannel.WANGSHANG.toString());
        return response;
    }

    private boolean saveNotify(MerchantprodMerchControlNotifyModel model) {
        //TODO

        return true;
    }

}
