package com.zbkj.service.wangshang.api.domain.model.notify;


import com.zbkj.service.wangshang.api.domain.ResponseBody;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * 支付退回通知接口（异步接口）< ant.mybank.bkcloudfunds.refund.notify>
 * <p>
 * 针对支付退回订单，进行异步结果通知，应答结果不为成功时，会重复通知。线下联系联调人员单独配置此接口的通知地址。
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "body")
public class BkcloudfundsRefundNotifyModel extends ResponseBody {

    private static final long serialVersionUID = -8379998832138345501L;
    /**
     * 合作方机构号（网商银行分配）
     */
    @XmlElement(name = "IsvOrgId")
    private String isvOrgId;

    /**
     * 退款付方类型，即原支付单收方, 商户(MERCHANT)、 平台(PLATFORM)
     */
    @XmlElement(name = "ParticipantType")
    private String participantType;

    /**
     * 退款付方id，即原支付单收方
     * <p>
     * 如果是商户，则填入merchantId,
     * 如果是平台，则填入isvOrgId
     */
    @XmlElement(name = "ParticipantId")
    private String participantId;

    /**
     * 关联网商订单号
     */
    @XmlElement(name = "RelateOrderNo")
    private String relateOrderNo;

    /**
     * 关联网商支付流水号
     * <p>
     * 如果大额来账创建订单类型为单次订单，可不填
     * 如果大额来账创建订单类型为订单累计，则必填
     */
    @XmlElement(name = "RelateTransNo")
    private String relateTransNo;

    /**
     * 退款网商订单号
     */
    @XmlElement(name = "RefundOrderNo")
    private String refundOrderNo;

    /**
     * 渠道退款单号（聚合 ）
     */
    @XmlElement(name = "ChannelRefundOrderNo")
    private String channelRefundOrderNo;

    /**
     * 退款外部交易号
     * <p>
     * 由合作方生成，同笔退款交易，交易状态未明需要重试时，使用同一个交易号。
     */
    @XmlElement(name = "OutRefundNo")
    private String outRefundNo;

    /**
     * 订单退款金额,向渠道退款金额。
     */
    @XmlElement(name = "RefundAmount")
    private String refundAmount;

    /**
     * 币种，必须同原交易
     */
    @XmlElement(name = "Currency")
    private String currency;

    /**
     * 状态(SUCCESS, FAIL)
     */
    @XmlElement(name = "Status")
    private String status;

    /**
     * 商户实际退款金额
     * 聚合且退款成功时时出现
     */
    @XmlElement(name = "ParticipantActualRefundAmount")
    private String participantActualRefundAmount;

    /**
     * 退款完成时间（成功时出现）
     * YYYYMMDDhhmmss
     */
    @XmlElement(name = "RefundFinishDate")
    private String refundFinishDate;

    /**
     * 错误码 FAIL时出现
     */
    @XmlElement(name = "ErrorCode")
    private String errorCode;

    /**
     * 错误描述
     */
    @XmlElement(name = "ErrorDesc")
    private String errorDesc;

    /**
     * 扩展信息,Map的json序列化后Base64
     */
    @XmlElement(name = "ExtInfo")
    private String extInfo;

    /**
     * 备注
     */
    @XmlElement(name = "Memo")
    private String memo;

    public String getIsvOrgId() {
        return isvOrgId;
    }

    public void setIsvOrgId(String isvOrgId) {
        this.isvOrgId = isvOrgId;
    }

    public String getParticipantType() {
        return participantType;
    }

    public void setParticipantType(String participantType) {
        this.participantType = participantType;
    }

    public String getParticipantId() {
        return participantId;
    }

    public void setParticipantId(String participantId) {
        this.participantId = participantId;
    }

    public String getRelateOrderNo() {
        return relateOrderNo;
    }

    public void setRelateOrderNo(String relateOrderNo) {
        this.relateOrderNo = relateOrderNo;
    }

    public String getRelateTransNo() {
        return relateTransNo;
    }

    public void setRelateTransNo(String relateTransNo) {
        this.relateTransNo = relateTransNo;
    }

    public String getRefundOrderNo() {
        return refundOrderNo;
    }

    public void setRefundOrderNo(String refundOrderNo) {
        this.refundOrderNo = refundOrderNo;
    }

    public String getChannelRefundOrderNo() {
        return channelRefundOrderNo;
    }

    public void setChannelRefundOrderNo(String channelRefundOrderNo) {
        this.channelRefundOrderNo = channelRefundOrderNo;
    }

    public String getOutRefundNo() {
        return outRefundNo;
    }

    public void setOutRefundNo(String outRefundNo) {
        this.outRefundNo = outRefundNo;
    }

    public String getRefundAmount() {
        return refundAmount;
    }

    public void setRefundAmount(String refundAmount) {
        this.refundAmount = refundAmount;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getParticipantActualRefundAmount() {
        return participantActualRefundAmount;
    }

    public void setParticipantActualRefundAmount(String participantActualRefundAmount) {
        this.participantActualRefundAmount = participantActualRefundAmount;
    }

    public String getRefundFinishDate() {
        return refundFinishDate;
    }

    public void setRefundFinishDate(String refundFinishDate) {
        this.refundFinishDate = refundFinishDate;
    }

    public String getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorDesc() {
        return errorDesc;
    }

    public void setErrorDesc(String errorDesc) {
        this.errorDesc = errorDesc;
    }

    public String getExtInfo() {
        return extInfo;
    }

    public void setExtInfo(String extInfo) {
        this.extInfo = extInfo;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
}