package com.zbkj.service.wangshang.api.domain.model;

import com.zbkj.service.wangshang.api.domain.RequestBody;
import com.zbkj.service.wangshang.api.internal.util.CDataAdapter;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

/**
 * 通用下载申请结果查询（异步场景）
 * <ant.mybank.bkmbp.stmt.apply.result.common.query>
 **/
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "body")
public class BkmbpStmtApplyResultCommonQueryRequestModel extends RequestBody {


    private static final long serialVersionUID = 3167041743646941652L;

    /**
     * 合作方机构号（网商银行分配）。
     **/
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "IsvOrgId")
    private String isvOrgId;

    /**
     * 下载账单类型
     **/
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "StmtType")
    private String stmtType;

    /**
     * 申请外部流水号
     **/
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "OutRequestNo")
    private String outRequestNo;

    /**
     * 申请流水号
     **/
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "BackOrderNo")
    private String backOrderNo;


    public String getIsvOrgId() {
        return isvOrgId;
    }

    public void setIsvOrgId(String isvOrgId) {
        this.isvOrgId = isvOrgId;
    }

    public String getStmtType() {
        return stmtType;
    }

    public void setStmtType(String stmtType) {
        this.stmtType = stmtType;
    }

    public String getOutRequestNo() {
        return outRequestNo;
    }

    public void setOutRequestNo(String outRequestNo) {
        this.outRequestNo = outRequestNo;
    }

    public String getBackOrderNo() {
        return backOrderNo;
    }

    public void setBackOrderNo(String backOrderNo) {
        this.backOrderNo = backOrderNo;
    }
}