package com.zbkj.service.wangshang.api.domain.model;

import com.zbkj.service.wangshang.api.domain.RequestBody;
import com.zbkj.service.wangshang.api.internal.util.CDataAdapter;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

/**
 * 账户场景余额查询<ant.mybank.bkcloudfunds.merchant.scene.balance.query>
 * 请求模型
 * <p>
 * 基于商户返回具体可以进行相应交易行为的余额数量。 目前提供返回可以支付金额和可提现金额的查询。
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "body")
public class BkcloudfundsMerchantSceneBalanceQueryRequestModel extends RequestBody {

    private static final long serialVersionUID = -3906461136918595602L;
    /**
     * 合作方机构号
     * <p>
     * 网商银行分配
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "IsvOrgId")
    private String isvOrgId;

    /**
     * 商户号
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "MerchantId")
    private String merchantId;

    /**
     * 预留扩展字段
     * Map<String,String>的Json格式
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "ExtInfo")
    private String extInfo;

    public String getIsvOrgId() {
        return isvOrgId;
    }

    public void setIsvOrgId(String isvOrgId) {
        this.isvOrgId = isvOrgId;
    }

    public String getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getExtInfo() {
        return extInfo;
    }

    public void setExtInfo(String extInfo) {
        this.extInfo = extInfo;
    }
}