package com.zbkj.service.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.model.bcx.BcxPerformanceReport;
import com.zbkj.common.request.BcxPerformanceReportSearchRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.response.BcxBrokerageStatisticsResponse;
import com.zbkj.common.response.BcxPerformanceReportResponse;
import com.zbkj.common.response.BcxPerformanceReportStatisticsResponse;

import java.util.Date;
import java.util.List;

/**
 * description: 业绩报表 服务接口
 * author : linchunpeng
 * date : 2023/8/3
 */
public interface BcxPerformanceReportService extends IService<BcxPerformanceReport> {


    /**
     * description：根据订单，把业绩报表改为冻结中
     * author：linchunpeng
     * date：2023/8/11
     */
    void frozenByOrder(String orderNo);

    /**
     * description：把冻结中业绩报表改为待结算
     * author：linchunpeng
     * date：2023/8/11
     */
    void waitSettledByFrozen();

    /**
     * description：生成业绩报表（补偿）
     * author：linchunpeng
     * date：2023/9/6
     */
//    void generateReportWithCompensation();

    /**
     * description：根据订单编号，生成对应的业绩报表
     * author：linchunpeng
     * date：2023/8/11
     */
    void generateReport(String orderNo);

    /**
     * description：根据退款单订单编号，生成对应的退款单业绩报表
     * author：linchunpeng
     * date：2023/8/11
     */
    void generateRefundReport(String refundOrderNo);

    /**
     * description：查询业绩报表
     * author：linchunpeng
     * date：2023/8/15
     */
    PageInfo<BcxPerformanceReportResponse> getPage(BcxPerformanceReportSearchRequest request, PageParamRequest pageParamRequest);

    /**
     * description：根据结束时间，查询所有未结算业绩报表
     * author：linchunpeng
     * date：2023/8/17
     */
    List<BcxPerformanceReport> listWaitSettledByEndTime(Date endTime);

    /**
     * description：收益中心统计
     * author：linchunpeng
     * date：2023/8/28
     */
    BcxBrokerageStatisticsResponse brokerageStatistics();

    /**
     * description：业绩报表统计
     * author：linchunpeng
     * date：2024/3/28
     */
    BcxPerformanceReportStatisticsResponse statistics(BcxPerformanceReportSearchRequest request);
}