package com.zbkj.service.huifu.v2;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.huifu.bspay.sdk.opps.core.request.V2TradeAcctpaymentBalanceQueryRequest;
import com.huifu.bspay.sdk.opps.core.utils.DateTools;
import com.zbkj.service.huifu.core.Identify;

import java.util.HashMap;
import java.util.Map;

/**
 * 账户余额信息查询接口 - 示例
 *
 * @author sdk-generator
 * @Description
 */
@Identify(requestClass = V2TradeAcctpaymentBalanceQueryRequest.class)
public class V2TradeAcctpaymentBalanceQuery {

    public static V2TradeAcctpaymentBalanceQueryRequest method(Map<String, Object> map) {

        // 2.组装请求参数
        V2TradeAcctpaymentBalanceQueryRequest request = JSONObject.parseObject(JSON.toJSONString(map),V2TradeAcctpaymentBalanceQueryRequest.class);
//        V2TradeAcctpaymentBalanceQueryRequest request = new V2TradeAcctpaymentBalanceQueryRequest();
        // 请求日期
        request.setReqDate(DateTools.getCurrentDateYYYYMMDD());
        // 商户号
//        request.setHuifuId("6666000108854952");

        // 设置非必填字段
        Map<String, Object> extendInfoMap = getExtendInfos(map);
        request.setExtendInfo(extendInfoMap);
        return request;
    }

    /**
     * 非必填字段
     * @return
     */
    private static Map<String, Object> getExtendInfos(Map<String, Object> map) {
        // 设置非必填字段
        Map<String, Object> extendInfoMap = new HashMap<>();
        // 请求流水号
        extendInfoMap.put("req_seq_id", map.get("reqSeqId"));
        return extendInfoMap;
    }

}
