package com.zbkj.service.factory;

import com.zbkj.common.exception.CrmebWalletException;
import com.zbkj.service.service.HuifuWalletService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <b> 支付渠道工厂 </b>
 * @author ZXF
 * @create 2025/07/01 0001 13:57
 * @version
 * @注意事项 </b>
 */
@Service
public class PaymentFactory {
    @Autowired
    private List<HuifuWalletService> paymentChannels;

    public HuifuWalletService getPaymentChannel(String channel) throws CrmebWalletException {
        for (HuifuWalletService pc : paymentChannels) {
            System.out.println(pc.getClass().getSimpleName());
            if (pc.getClass().getSimpleName().startsWith(channel)) {
                return pc;
            }
        }
        throw new CrmebWalletException("企业钱包-支付渠道未定义");
    }
}
