/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.wangshang.api;

import com.zbkj.service.wangshang.api.DefaultRequest;
import com.zbkj.service.wangshang.api.MybankApiException;
import com.zbkj.service.wangshang.api.MybankApiExceptionEnum;
import com.zbkj.service.wangshang.api.MybankClient;
import com.zbkj.service.wangshang.api.MybankParser;
import com.zbkj.service.wangshang.api.MybankRequest;
import com.zbkj.service.wangshang.api.MybankResponse;
import com.zbkj.service.wangshang.api.MybankUploadRequest;
import com.zbkj.service.wangshang.api.internal.mapping.SignChecker;
import com.zbkj.service.wangshang.api.internal.mapping.Signer;
import com.zbkj.service.wangshang.api.internal.parser.xml.ObjectXmlParser;
import com.zbkj.service.wangshang.api.internal.util.HttpsUtil;
import com.zbkj.service.wangshang.api.internal.util.MybankLogger;
import com.zbkj.service.wangshang.api.internal.util.StringUtils;
import com.zbkj.service.wangshang.api.internal.util.WebUtils;
import com.zbkj.service.wangshang.api.service.base.MerchantprodMerchantUploadphotoRequest;
import com.zbkj.service.wangshang.api.service.base.bkcloudfunds.BkcloudfundsOssFileUploadRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMybankClient
implements MybankClient {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMybankClient.class);
    private String serverUrl;
    private String format = "XML";
    private String signType = "RSA";
    private String charset = "UTF-8";
    private int connectTimeout = 3000;
    private int readTimeout = 15000;

    public AbstractMybankClient(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public AbstractMybankClient(String serverUrl, String charset) {
        this.serverUrl = serverUrl;
        this.charset = charset;
    }

    public AbstractMybankClient(String serverUrl, String charset, String signType) {
        this(serverUrl, charset);
        if (!StringUtils.isEmpty(signType)) {
            this.signType = signType;
        }
    }

    public AbstractMybankClient(String serverUrl, String format, String charset, String signType) {
        this(serverUrl, charset);
        if (!StringUtils.isEmpty(format)) {
            this.format = format;
        }
        if (!StringUtils.isEmpty(signType)) {
            this.signType = signType;
        }
    }

    @Override
    public <T extends MybankResponse> T execute(MybankRequest<T> request) throws MybankApiException {
        ObjectXmlParser parser = null;
        if (!"XML".equals(this.format)) {
            throw new MybankApiException(MybankApiExceptionEnum.NOT_XML_TYPE);
        }
        parser = new ObjectXmlParser(request.getResponseClass());
        return this.execute(request, parser);
    }

    @Override
    public <T extends MybankResponse> T execute(MybankUploadRequest<T> request) throws MybankApiException {
        ObjectXmlParser parser = new ObjectXmlParser(request.getResponseClass());
        return this.execute(request, parser);
    }

    private <T extends MybankResponse> T execute(DefaultRequest<T> request, MybankParser<T> parser) throws MybankApiException {
        long beginTime = System.currentTimeMillis();
        Map<Object, Object> rt = new HashMap();
        rt = request instanceof MybankRequest ? this.doPost((MybankRequest)request) : this.doPost((MybankUploadRequest)request);
        HashMap<String, Long> costTimeMap = new HashMap<String, Long>();
        if (rt.containsKey("prepareTime")) {
            costTimeMap.put("prepareCostTime", (Long)rt.get("prepareTime") - beginTime);
            if (rt.containsKey("requestTime")) {
                costTimeMap.put("requestCostTime", (Long)rt.get("requestTime") - (Long)rt.get("prepareTime"));
            }
        }
        MybankResponse tRsp = null;
        try {
            tRsp = (MybankResponse)parser.parse((String)rt.get("rspContent"));
            tRsp.setXmlContent((String)rt.get("rspContent"));
            tRsp.setRequestContent((String)rt.get("requestContent"));
            this.checkResponseSign((String)rt.get("rspContent"));
            if (costTimeMap.containsKey("requestCostTime")) {
                costTimeMap.put("postCostTime", System.currentTimeMillis() - (Long)rt.get("requestTime"));
            }
        }
        catch (RuntimeException e) {
            MybankLogger.logBizError((String)rt.get("rspContent"), costTimeMap);
            throw new MybankApiException(e);
        }
        catch (MybankApiException e) {
            MybankLogger.logBizError((String)rt.get("rspContent"), costTimeMap);
            throw e;
        }
        MybankLogger.logBizSummary(rt, costTimeMap);
        return (T)tRsp;
    }

    private <T extends MybankResponse> Map<String, Object> doPost(MybankRequest<T> request) throws MybankApiException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String xmlContent = null;
        try {
            xmlContent = request.xmlBuild();
        }
        catch (MybankApiException e) {
            MybankLogger.logBizError(e);
            throw new MybankApiException(e);
        }
        if (request.isNeedSign()) {
            try {
                xmlContent = this.getSigner().sign(xmlContent, this.charset, this.signType);
            }
            catch (MybankApiException e) {
                MybankLogger.logBizError(e);
                throw new MybankApiException(e);
            }
        }
        result.put("requestContent", xmlContent);
        result.put("prepareTime", System.currentTimeMillis());
        String rsp = null;
        try {
            logger.info(">>>>>>>>> \u7f51\u5546\u63a5\u53e3 \u8bf7\u6c42\u5730\u5740\uff1a" + this.serverUrl);
            logger.info(">>>>>>>>> \u7f51\u5546\u63a5\u53e3 \u8bf7\u6c42\u62a5\u6587\uff1a" + xmlContent);
            rsp = WebUtils.doPost(this.serverUrl, xmlContent, request.getCookieValue(), this.charset, this.connectTimeout, this.readTimeout, request.getApiFunction(), request.getApiVersion());
            logger.info(">>>>>>>>> \u7f51\u5546\u63a5\u53e3 \u8fd4\u56de\u62a5\u6587\uff1a" + rsp);
        }
        catch (MybankApiException e) {
            logger.error(">>>>>>>>> \u7f51\u5546\u63a5\u53e3 \u8bf7\u6c42\u5730\u5740\uff1a" + this.serverUrl);
            logger.error(">>>>>>>>> \u7f51\u5546\u63a5\u53e3 \u8bf7\u6c42\u62a5\u6587\uff1a" + xmlContent);
            logger.error(">>>>>>>>> \u7f51\u5546\u63a5\u53e3 \u8fd4\u56de\u62a5\u6587 \u5f02\u5e38\uff1a" + e.getMessage());
            throw new MybankApiException(e);
        }
        result.put("requestTime", System.currentTimeMillis());
        result.put("rspContent", rsp);
        result.put("url", this.serverUrl);
        return result;
    }

    private <T extends MybankResponse> Map<String, Object> doPost(MybankUploadRequest<T> request) throws MybankApiException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, Object> map = null;
        try {
            map = request.getMapByModel();
        }
        catch (MybankApiException e) {
            MybankLogger.logBizError(e);
            throw new MybankApiException(MybankApiExceptionEnum.SERVER_SYSTEM_EXCEPTION, (Throwable)e);
        }
        String signString = request.uploadRequestSignString(map);
        try {
            signString = this.getSigner().webSign(signString, this.charset, this.signType);
        }
        catch (MybankApiException e) {
            MybankLogger.logBizError(e);
            throw new MybankApiException(MybankApiExceptionEnum.SERVER_SYSTEM_EXCEPTION, (Throwable)e);
        }
        if (request instanceof BkcloudfundsOssFileUploadRequest) {
            BkcloudfundsOssFileUploadRequest fileUploadRequest = (BkcloudfundsOssFileUploadRequest)request;
            fileUploadRequest.getRequestModel().setSignature(signString);
        }
        if (request instanceof MerchantprodMerchantUploadphotoRequest) {
            MerchantprodMerchantUploadphotoRequest uploadphotoRequest = (MerchantprodMerchantUploadphotoRequest)request;
            uploadphotoRequest.getUploadphotoRequestModel().setSignature(signString);
        }
        map.put("Signature", signString);
        HttpEntity httpEntity = request.entityBuilder(map);
        ByteArrayOutputStream out = new ByteArrayOutputStream((int)httpEntity.getContentLength());
        try {
            httpEntity.writeTo((OutputStream)out);
            result.put("requestContent", out.toString());
        }
        catch (IOException e) {
            MybankLogger.logBizError(e);
            throw new MybankApiException(MybankApiExceptionEnum.SERVER_SYSTEM_EXCEPTION, (Throwable)e);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                MybankLogger.logBizError(e);
                throw new MybankApiException(MybankApiExceptionEnum.SERVER_SYSTEM_EXCEPTION, (Throwable)e);
            }
        }
        result.put("prepareTime", System.currentTimeMillis());
        String rsp = null;
        try {
            rsp = HttpsUtil.httpPost(this.serverUrl, httpEntity, this.charset, request.getApiFunction(), request.getApiVersion());
        }
        catch (MybankApiException e) {
            throw new MybankApiException(MybankApiExceptionEnum.REQUEST_REMOTE_SERVER_ERROR, (Throwable)e);
        }
        result.put("requestTime", System.currentTimeMillis());
        result.put("rspContent", rsp);
        result.put("url", this.serverUrl);
        return result;
    }

    private void checkResponseSign(String rspContent) throws MybankApiException {
        boolean checkResult = this.getSignChecker().check(rspContent, this.charset, this.signType);
        if (!checkResult) {
            throw new MybankApiException(MybankApiExceptionEnum.VERIFY_FAIL);
        }
    }

    void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    void setFormat(String format) {
        this.format = format;
    }

    void setSignType(String signType) {
        this.signType = signType;
    }

    void setCharset(String charset) {
        this.charset = charset;
    }

    void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    abstract Signer getSigner();

    abstract SignChecker getSignChecker();

    static {
        Security.setProperty("jdk.certpath.disabledAlgorithms", "");
    }
}

