/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.task.web;

import com.bcxin.ins.common.dto.AjaxResult;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.entity.common.ComTaskCron;
import com.bcxin.ins.entity.common.ComTaskCronStatus;
import com.bcxin.ins.task.base.config.TaskConfig;
import com.bcxin.ins.task.base.service.TaskCronService;
import com.bcxin.ins.task.base.service.TaskCronStatusService;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.mybatisplus.mapper.EntityWrapper;
import com.bcxin.mybatisplus.mapper.Wrapper;
import com.bcxin.mybatisplus.plugins.Page;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${systemPath}/taskCron"})
public class TaskCronController
extends BaseController {
    @Autowired
    private TaskCronService taskCronService;
    @Autowired
    private TaskCronStatusService taskCronStatusService;
    private static final String ADD = TaskCronController.getViewPath((String)"admin/task/task_cron_add");
    private static final String LIST = TaskCronController.getViewPath((String)"admin/task/task_cron_list");

    @RequiresPermissions(value={"task:cron:list"})
    @RequestMapping(value={"/list"})
    public String listView(Model model) {
        return LIST;
    }

    @RequiresPermissions(value={"task:cron:list"})
    @RequestMapping(value={"/query"})
    @ResponseBody
    public String listData(Model model, ComTaskCron taskCron) {
        Page page = this.getPage();
        taskCron.setStatus(Integer.valueOf(-1));
        if (StrUtil.isBlank((String)taskCron.getName())) {
            taskCron.setName(null);
            this.taskCronService.selectPage(page, (Wrapper)new EntityWrapper((Object)taskCron));
        } else {
            this.taskCronService.selectPage(page, new EntityWrapper().like("name", taskCron.getName()));
        }
        ArrayList list = Lists.newArrayList();
        for (ComTaskCron t : page.getRecords()) {
            TaskConfig.getInstance();
            if (TaskConfig.TASKS.get(t.getCom_task_cron_id()) != null) {
                t.setIsStart(true);
            } else {
                t.setIsStart(false);
            }
            list.add(t);
        }
        page.setRecords((List)list);
        return this.jsonPage(page);
    }

    @RequiresPermissions(value={"task:cron:form"})
    @RequestMapping(value={"/form"})
    public String form(Model model, @RequestParam(required=false) Long id) {
        String flag = this.getParameter("modify");
        if (id != null) {
            ComTaskCron taskCron = (ComTaskCron)this.taskCronService.selectById(id);
            model.addAttribute("taskCron", (Object)taskCron);
        }
        model.addAttribute("modify", (Object)flag);
        return ADD;
    }

    @RequiresPermissions(value={"task:cron:status:form"})
    @RequestMapping(value={"/formStatus"})
    public String formStatus(Model model, @RequestParam(required=false) Long taskId) {
        ComTaskCronStatus status = new ComTaskCronStatus();
        status.setCom_task_cron_status_id(taskId);
        Page page = this.taskCronStatusService.selectPage(this.getPage(), (Wrapper)new EntityWrapper((Object)status));
        return this.jsonPage(page);
    }

    @RequiresPermissions(value={"task:cron:edit"})
    @RequestMapping(value={"/edit"})
    @ResponseBody
    public AjaxResult edit(Model model, ComTaskCron taskCron) {
        taskCron.setCreate_time(new Date());
        taskCron.setUpdate_time(new Date());
        this.taskCronService.insertOrUpdate(taskCron);
        TaskConfig.getInstance().resetTrigger(taskCron.getCom_task_cron_id(), taskCron.getCron_expression());
        return this.success(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @RequiresPermissions(value={"task:cron:edit"})
    @RequestMapping(value={"/pause"})
    @ResponseBody
    public AjaxResult pause(Model model) {
        try {
            List taskList = this.taskCronService.selectByMap(null);
            for (ComTaskCron taskCron : taskList) {
                TaskConfig.getInstance().stop(taskCron.getCom_task_cron_id());
            }
            return this.success(true, "\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            return this.fail(false, "\u505c\u6b62\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    @RequiresPermissions(value={"task:cron:edit"})
    @RequestMapping(value={"/launch"})
    @ResponseBody
    public AjaxResult launch(Model model) {
        try {
            List taskList = this.taskCronService.selectByMap(null);
            for (ComTaskCron taskCron : taskList) {
                if (taskCron.getStatus().equals(ComTaskCron.DEL_FLAG_DELETE)) continue;
                TaskConfig.getInstance().start(taskCron);
            }
            return this.success(true, "\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            return this.fail(false, "\u542f\u52a8\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    @RequiresPermissions(value={"task:cron:edit"})
    @RequestMapping(value={"/stop/{id}"})
    @ResponseBody
    public AjaxResult stop(Model model, @PathVariable Long id) {
        try {
            TaskConfig.getInstance().stop(id);
            return this.success(true, "\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            return this.fail(false, "\u505c\u6b62\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    @RequiresPermissions(value={"task:cron:edit"})
    @RequestMapping(value={"/start/{id}"})
    @ResponseBody
    public AjaxResult start(Model model, @PathVariable Long id) {
        ComTaskCron taskCron = (ComTaskCron)this.taskCronService.selectById(id);
        if (taskCron.getStatus().equals(ComTaskCron.DEL_FLAG_DELETE)) {
            return this.success(false, "\u4e0d\u80fd\u542f\u52a8\u5df2\u7ecf\u5931\u6548\u7684\u6570\u636e");
        }
        TaskConfig.getInstance().start(taskCron);
        return this.success(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @RequiresPermissions(value={"task:cron:delete"})
    @RequestMapping(value={"/status/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public AjaxResult status(Model model, @PathVariable Long id, @RequestParam Integer status) {
        ComTaskCron taskCron = new ComTaskCron();
        taskCron.setCom_task_cron_id(id);
        taskCron.setStatus(status);
        this.taskCronService.updateById(taskCron);
        TaskConfig.getInstance();
        if (TaskConfig.TASKS.get(id) != null) {
            return this.success(false, "\u6b63\u5728\u8fd0\u884c\u4e2d\u7684\u5b9a\u65f6\u4efb\u52a1\u4e0d\u80fd\u88ab\u5220\u9664");
        }
        return this.success(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @RequiresPermissions(value={"task:cron:delete"})
    @RequestMapping(value={"/delete/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public AjaxResult delete(Model model, @PathVariable Long id) {
        try {
            TaskConfig.getInstance();
            if (TaskConfig.TASKS.get(id) != null) {
                TaskConfig.getInstance().stop(id);
            }
            this.taskCronService.deleteById(id);
            return this.success(true, "\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            return this.fail(false, "\u5220\u9664\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }
}

