<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8" %>
<%@ include file="/WEB-INF/include/taglib.jsp" %>
<!DOCTYPE HTML>
<html>
<head>
    <title>定时任务信息维护列表</title>
</head>

<body>
<div class="animated fadeInRight">
    <div class="row">
        <div class="col-sm-12">
            <div class="ibox-content search-query">
                <form action="${ctx}/taskCron/list" method="post" id="searchForm" onsubmit="return false">
                    <div class="col-sm-3">
                        <div class="form-group">
                            <label class="control-label">关键字</label>
                            <div class="input-group">
                                <input type="text" class="form-control " name="likeValue" placeholder="类型/名称/上级">
                                <span class="input-group-btn">
                                        <button type="button" class="btn btn-primary" onclick="doRefresh()">搜索</button>
                                </span>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-12">
            <div class="ibox-content">
                <div class="row row-lg">
                    <div class="col-sm-12">
                        <div class="example-wrap">
                            <div class="example">
                                <div id="toolbar" class="fixed-table-toolbar">
                                    <button type="button" class="btn btn-primary" title="刷新数据" onclick="refreshdiv()">
                                        <i class="glyphicon glyphicon-refresh">刷新数据</i>
                                    </button>
                                </div>

                                <table id="table"
                                       data-toggle="table"
                                       data-show-toggle="true"
                                <%--data-click-to-select="true"--%>
                                       data-show-export="true"
                                       data-show-columns="true"
                                       data-striped="true"
                                       data-pagination="true"
                                <%-- data-sort-name="type"--%>
                                       data-url="${ctx}/taskCron/list"
                                       data-query-params="queryParams"
                                       data-side-pagination="server"
                                <%--  data-sort-order="desc"--%>
                                       data-cache="false"
                                       data-toolbar="#toolbar">
                                    <thead>
                                    <tr>
                                        <th data-checkbox="true" data-field="ID" >选择</th>
                                        <th data-halign="center" data-align="center" data-sortable="true" data-sort-name="name" data-field="name">任务名称</th>
                                        <th data-halign="center" data-align="center" data-sortable="true" data-sort-name="targetObject" data-field="targetObject">执行对象</th>
                                        <th data-halign="center" data-align="center" data-sortable="true" data-sort-name="taskMethod" data-field="taskMethod">执行方法名称</th>
                                        <th data-halign="center" data-align="center" data-sortable="true" data-sort-name="cronExpression" data-field="cronExpression">执行表达式</th>
                                        <th data-halign="center" data-align="center" data-sortable="true" data-sort-name="createTime"  data-field="createTime">创建时间</th>
                                        <th data-halign="center" data-align="center" data-sortable="true" data-sort-name="updateTime" data-field="updateTime">修改时间</th>
                                        <th data-halign="center" data-align="center" data-field="isStatus" data-formatter="statusClass2">TASK状态</th>
                                        <th data-halign="center" data-align="center" data-sortable="true" data-sort-name="status" data-field="status" data-formatter="statusClass">状态</th>
                                        <th data-halign="center" data-align="center" data-formatter = "stateFormatter">操作</th>
                                    </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<bcxinFooter>
    <script type="text/javascript">


    </script>
</bcxinFooter>
</body>
</html>
