<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8" %>
<%@ include file="/WEB-INF/include/taglib.jsp" %>
<!DOCTYPE HTML>
<html>
<head>
    <title>定时任务信息维护列表</title>
    <%@include file="/WEB-INF/include/head.jsp"%>
</head>

<body>
<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-sm-12">
            <div class="ibox-content search-query">
                <form action="${ctx}/taskCron/list" method="post" id="queryForm">
                    <div class="col-sm-3">
                        <div class="form-group">
                            <label class="control-label">关键字</label>
                            <div class="input-group">
                                <input type="text" class="form-control " name="name" placeholder="任务名称">
                                <span class="input-group-btn">
                                        <button type="button" id="queryBtn" class="btn btn-primary">搜索</button>
                                </span>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-12">
            <div class="ibox-content">
                <div class="row row-lg">
                    <div class="col-sm-12">
                        <div class="example-wrap">
                            <div class="example">
                                <div id="toolbar" class="fixed-table-toolbar">
                                    <shiro:hasPermission name="task:cron:form">
                                        <button type="button" class="btn btn-primary " title="添加" onclick="member_show('添加','${ctx}/taskCron/form?modify=add',null,null,'800',null)">
                                            <i class="glyphicon glyphicon-plus">添加</i>
                                        </button>
                                    </shiro:hasPermission>
                                    <shiro:hasPermission name="task:cron:form">
                                        <button type="button" class="btn btn-danger" title="批量停止" onclick="member_pause()">
                                            <i class="glyphicon glyphicon-pause">批停止</i>
                                        </button>
                                    </shiro:hasPermission>
                                    <shiro:hasPermission name="task:cron:form">
                                        <button type="button" class="btn btn-primary" title="批量启动" onclick="member_launch()">
                                            <i class="glyphicon glyphicon-play">批启动</i>
                                        </button>
                                    </shiro:hasPermission>
                                    <button type="button" class="btn btn-primary" title="刷新数据" onclick="refresh()">
                                        <i class="glyphicon glyphicon-refresh">刷新数据</i>
                                    </button>
                                </div>

                                <table id="defaultTable"
                                       data-toggle="table"
                                       data-search="false"
                                       data-show-toggle="true"
                                       data-show-export="true"
                                       data-show-columns="true"
                                       data-striped="true"
                                       data-pagination="true"
                                       data-sort-name="create_time"
                                       data-url="${ctx}/taskCron/query"
                                       data-method="post"
                                       data-content-type="application/x-www-form-urlencoded; charset=UTF-8"
                                       data-side-pagination="server"
                                       data-page-list="[10, 25, 50, 100, ALL]"
                                       data-query-params="myQueryParams"
                                       data-sort-order="desc"
                                       load-success.bs.table="onLoadSuccessFn"
                                       data-toolbar="#toolbar">
                                    <thead>
                                    <tr>
                                        <th data-checkbox="true" data-field="ID" >选择</th>
                                        <th data-halign="center" data-align="center" data-sortable="true" data-sort-name="name" data-field="name">任务名称</th>
                                        <th data-halign="center" data-align="center" data-sortable="true" data-sort-name="targetObject" data-field="target_object">执行对象</th>
                                        <th data-halign="center" data-align="center" data-sortable="true" data-sort-name="taskMethod" data-field="task_method">执行方法名称</th>
                                        <th data-halign="center" data-align="center" data-sortable="true" data-sort-name="cronExpression" data-field="cron_expression">执行表达式</th>
                                        <th data-halign="center" data-align="center" data-sortable="true" data-sort-name="createTime"  data-field="create_time">创建时间</th>
                                        <th data-halign="center" data-align="center" data-sortable="true" data-sort-name="updateTime" data-field="update_time">修改时间</th>
                                        <th data-halign="center" data-align="center" data-field="isStatus" data-formatter="statusClass2">TASK状态</th>
                                        <th data-halign="center" data-align="center" data-sortable="true" data-sort-name="status" data-field="status" data-formatter="statusClass">状态</th>
                                        <th data-halign="center" data-align="center" data-formatter = "stateFormatter">操作</th>
                                    </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<shiro:hasPermission name="task:cron:edit">
    <div id="buttons-start" class="hide">
        <a class="remove m-l-sm text-info" href="javascript:void(0)" onclick="member_start(this,'valueId')" title="启动">
            <i class="glyphicon glyphicon-expand"></i>
        </a>
    </div>
    <div id="buttons-stop" class="hide">
    <a class="remove m-l-sm text-danger" href="javascript:void(0)" onclick="member_stop(this,'valueId')" title="停止">
        <i class="glyphicon glyphicon-lock"></i>
    </a>
    </div>
</shiro:hasPermission>

<shiro:hasPermission name="task:cron:delete">
    <div id="status0" class="hide">
        <a class="like text-info" href="javascript:void(0)" onClick="member_del(this,'valueId','确认要冻结吗?',0)" title="冻结"><i class="glyphicon glyphicon-pause"></i></a>
    </div>
    <div id="status1" class="hide">
        <a class="like text-info" href="javascript:void(0)" onClick="member_del(this,'valueId','确认要启用吗?',1)" title="启用"><i class="glyphicon glyphicon-play"></i></a>
    </div>
</shiro:hasPermission>


<div id="buttonsHbox" class="hide">
    <shiro:hasPermission name="task:cron:form">
        <a class="edit m-l-sm text-warning" href="javascript:void(0)" onclick="var id ='valueId'; member_show('查看','${ctx}/taskCron/form?id=' + id,'','','900','400')" title="查看">
            <i class="glyphicon glyphicon-zoom-in"></i>
        </a>
    </shiro:hasPermission>
    <shiro:hasPermission name="task:cron:edit">
        <a class="edit m-l-sm text-warning" href="javascript:void(0)" onclick="var id ='valueId';member_show('修改','${ctx}/taskCron/form?id=' + id+'&modify=modify','','','900','400')" title="修改">
            <i class="glyphicon glyphicon-edit"></i>
        </a>
    </shiro:hasPermission>

</div>

<div id="buttonsDbox" class="hide">
    <shiro:hasPermission name="task:cron:delete">
        <a class="edit m-l-sm text-danger" href="javascript:void(0)" onclick="var id ='valueId';member_delect(this,'valueId','确认要删除任务吗?')" title="删除">
            <i class="glyphicon glyphicon-trash"></i>
        </a>
    </shiro:hasPermission>
</div>

<bcxinFooter>
    <script type="text/javascript">
        function refresh(){
            $('#defaultTable').bootstrapTable('refresh');
        }
        $(document).ready(function () {
            //查询按钮
            $("#queryBtn").unbind('click').click(function(){
                $('#defaultTable').bootstrapTable('refreshOptions',{pageNumber : 1});
            });

            //清空查询列表
            $("#clearQueryForm").unbind('click').click(function(){
                $("#queryForm").form("clear");
            });

        });
        /**
         * 操作
         */
        function stateFormatter(value, row, index) {
            var html = $("#buttonsHbox").html();
            if(html != ''){
                html = html.replace(new RegExp('valueId', 'g'),row.com_task_cron_id);
            }

            var html1 = $("#buttonsDbox").html();
            if(html1 != ''){
                html1 = html1.replace(new RegExp('valueId', 'g'),row.com_task_cron_id);
            }

            var html2 = $("#buttons-start").html();
            if(html2 != ''){
                html2 = html2.replace("valueId",row.com_task_cron_id);
            }
            var html3 = $("#buttons-stop").html();
            if(html3 != ''){
                html3 = html3.replace("valueId",row.com_task_cron_id);
            }
            var html4;
            if(row.isStart){
                html4 = html3;
            }else {
                html4 = html2;
            }

            var html6 = $("#status0").html();
            if(html6 != ''){
                html6 = html6.replace("valueId",row.com_task_cron_id);
            }
            var html7 = $("#status1").html();
            if(html7 != ''){
                html7 = html7.replace("valueId",row.com_task_cron_id);
            }
            var html8;
            if(row.status=='1'){
                html8=html6
            }else{
                html8=html7
            }

            return [html8,html4,html,html1].join(" ");
        }

        function member_del(obj,id,title,status){
            layer.confirm(title,{btn: ['确定','取消'] //按钮
            }, function(){
                $.ajax({
                    type:'DELETE',
                    dataType:'json',
                    url:'${ctx}/taskCron/status/'+id+'?status='+status,
                    success:function(result){
                        if(result.success==true){
                            layer.msg(result.msg,{icon:1,time:1000});
                            $('#defaultTable').bootstrapTable("refresh");
                        }else{
                            layer.alert(result.msg, {icon: 2});
                        }
                    }
                })
            });
        }

        function member_delect(obj,id,title){
            layer.confirm(title,{btn: ['确定','取消'] //按钮
            }, function(){
                $.ajax({
                    type:'DELETE',
                    dataType:'json',
                    url:'${ctx}/taskCron/delete/'+id,
                    success:function(result){
                        if(result.success==true){
                            layer.msg(result.msg,{icon:1,time:1000});
                            $('#defaultTable').bootstrapTable("refresh");
                        }else{
                            layer.alert(result.msg, {icon: 2});
                        }
                    }
                })
            });
        }
        function member_stop(obj,id){
            layer.confirm('确认要停止定时任务吗？',{btn: ['确定','取消'] //按钮
            }, function(){
                $.ajax({
                    type:'POST',
                    dataType:'json',
                    url:'${ctx}/taskCron/stop/'+id,
                    success:function(result){
                        if(result.success==true){
                            layer.msg(result.msg,{icon:1,time:1000});
                            $('#defaultTable').bootstrapTable("refresh");
                        }else{
                            layer.alert(result.msg, {icon: 2});
                        }
                    }
                })
            });
        }
        function member_start(obj,id){
            layer.confirm('确认要启动定时任务吗？',{btn: ['确定','取消'] //按钮
            }, function(){
                $.ajax({
                    type:'POST',
                    dataType:'json',
                    url:'${ctx}/taskCron/start/'+id,
                    success:function(result){
                        if(result.success==true){
                            layer.msg(result.msg,{icon:1,time:1000});
                            $('#defaultTable').bootstrapTable("refresh");
                        }else{
                            layer.alert(result.msg, {icon: 2});
                        }
                    }
                })
            });
        }

        function member_pause(){
            layer.confirm('确认要批量停止定时任务吗？',{btn: ['确定','取消'] //按钮
            }, function(){
                $.ajax({
                    type:'POST',
                    dataType:'json',
                    url:'${ctx}/taskCron/pause',
                    success:function(result){
                        if(result.success==true){
                            layer.msg(result.msg,{icon:1,time:1000});
                            $('#defaultTable').bootstrapTable("refresh");
                        }else{
                            layer.alert(result.msg, {icon: 2});
                        }
                    }
                })
            });
        }
        function member_launch(){
            layer.confirm('确认要批量启动定时任务吗？',{btn: ['确定','取消'] //按钮
            }, function(){
                $.ajax({
                    type:'POST',
                    dataType:'json',
                    url:'${ctx}/taskCron/launch',
                    success:function(result){
                        if(result.success==true){
                            layer.msg(result.msg,{icon:1,time:1000});
                            $('#defaultTable').bootstrapTable("refresh");
                        }else{
                            layer.alert(result.msg, {icon: 2});
                        }
                    }
                })
            });
        }

        function statusClass(value) {
            if(value == '1'){
                return ' <span class="label label-primary">启用</span>';
            }
            if(value=='0'){
                return '<span class="label label-danger">停用</span>';
            }
        }

        function statusClass2(value,row) {
            if(row.isStart){
                return ' <span class="label label-primary">运行</span>';
            }else{
                return '<span class="label label-danger">闲置</span>';
            }
        }

        /*获取选中行对象*/
        function getContent(){
            var index = $("#defaultTable").find("tr.danger").data("index");
            return $("#defaultTable").bootstrapTable('getData')[index];
        }

        function setRatio(val) {
            return val+"%"

        }
        function setAmount(val) {
            return toDecimal(val);
        }

        function myQueryParams(params) { //limit offset order sort
            var obj = g_sobj($("#queryForm").form());
            for(var i in obj){
                if(obj[i]=="") eval("delete obj."+i);
            }
            return $.extend(obj, params);
        }

    </script>
</bcxinFooter>
</body>
</html>
