package com.bcxin.ins.task.web;

import com.bcxin.ins.common.dto.AjaxResult;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.mybatisplus.mapper.EntityWrapper;
import com.bcxin.mybatisplus.plugins.Page;
import com.bcxin.ins.task.base.config.TaskConfig;
import com.bcxin.ins.entity.common.ComTaskCron;
import com.bcxin.ins.entity.common.ComTaskCronStatus;
import com.bcxin.ins.task.base.service.TaskCronService;
import com.bcxin.ins.task.base.service.TaskCronStatusService;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.google.common.collect.Lists;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;

import java.util.Date;
import java.util.List;

/**
 * <b> 定时任务处理 </b>
 * @author ZXF
 * @create 2018/10/16 0016 13:43
 * @version
 * @注意事项 </b>
 */
@Controller
@RequestMapping("${systemPath}/taskCron")
public class TaskCronController extends BaseController {

    @Autowired
    private TaskCronService taskCronService;

    @Autowired
    private TaskCronStatusService taskCronStatusService;

    //list
    private static final String ADD = getViewPath("admin/task/task_cron_add");
    //view
    private static final String LIST = getViewPath("admin/task/task_cron_list");

    @RequiresPermissions("task:cron:list")
    @RequestMapping("/list")
    public String listView(Model model){
        return LIST;
    }


    @RequiresPermissions("task:cron:list")
    @RequestMapping("/query")
    @ResponseBody
    public String listData(Model model,ComTaskCron taskCron){
        Page<ComTaskCron> page =this.getPage();
        taskCron.setStatus(-1);
        if(StrUtil.isBlank(taskCron.getName())){
            taskCron.setName(null);
            taskCronService.selectPage(page,new EntityWrapper(taskCron));
        }else {
            taskCronService.selectPage(page,new EntityWrapper().like("name",taskCron.getName()));
        }
        List<ComTaskCron> list = Lists.newArrayList();
        for(ComTaskCron t:page.getRecords()){
            if(TaskConfig.getInstance().TASKS.get(t.getCom_task_cron_id())!=null){
                t.setIsStart(true);
            }else{
                t.setIsStart(false);
            }
            list.add(t);
        }
        page.setRecords(list);
        return jsonPage(page);
    }

    @RequiresPermissions("task:cron:form")
    @RequestMapping("/form")
    public String form(Model model,@RequestParam(required=false)Long id){
        String flag = this.getParameter("modify");
        if(id!=null) {
            ComTaskCron taskCron = taskCronService.selectById(id);
            model.addAttribute("taskCron", taskCron);
        }
        model.addAttribute("modify",flag);
        return ADD;
    }

    /**
     * 查看执行记录
     * @param model
     * @param taskId
     * @return
     */
    @RequiresPermissions("task:cron:status:form")
    @RequestMapping("/formStatus")
    public String formStatus(Model model,@RequestParam(required=false)Long taskId){
        ComTaskCronStatus status = new ComTaskCronStatus();
        status.setCom_task_cron_status_id(taskId);
        Page<ComTaskCronStatus> page = taskCronStatusService.selectPage(this.getPage(),new EntityWrapper<>(status));
        return jsonPage(page);
    }

    @RequiresPermissions("task:cron:edit")
    @RequestMapping("/edit")
    @ResponseBody
    public AjaxResult edit(Model model, ComTaskCron taskCron){
        /*String msg = beanValidator(taskCron);
        if(StrUtil.isNotBlank(msg)){
            return success(false,msg);
        }*/
        taskCron.setCreate_time(new Date());
        taskCron.setUpdate_time(new Date());
        taskCronService.insertOrUpdate(taskCron);
        //修改时更新cron
        TaskConfig.getInstance().resetTrigger(taskCron.getCom_task_cron_id(),taskCron.getCron_expression());
        return success(true,"操作成功");
    }

    /**
     * 批量停止
     * @return
     */
    @RequiresPermissions("task:cron:edit")
    @RequestMapping("/pause")
    @ResponseBody
    public AjaxResult pause(Model model){
        try{
            List<ComTaskCron> taskList = taskCronService.selectByMap(null);
            for (ComTaskCron taskCron:taskList) {
                TaskConfig.getInstance().stop(taskCron.getCom_task_cron_id());
            }
            return success(true,"操作成功");
        }catch (Exception e){
            return fail(false,"停止异常："+e.getMessage());
        }
    }

    /**
     * 批量启动
     * @return
     */
    @RequiresPermissions("task:cron:edit")
    @RequestMapping("/launch")
    @ResponseBody
    public AjaxResult launch(Model model){
        try{
            List<ComTaskCron> taskList = taskCronService.selectByMap(null);
            for (ComTaskCron taskCron:taskList) {
                if(!taskCron.getStatus().equals(ComTaskCron.DEL_FLAG_DELETE)){
                    TaskConfig.getInstance().start(taskCron);
                }
            }
            return success(true,"操作成功");
        }catch (Exception e){
            return fail(false,"启动异常："+e.getMessage());
        }
    }

    /**
     * 停止
     * @param model
     * @param id
     * @return
     */
    @RequiresPermissions("task:cron:edit")
    @RequestMapping("/stop/{id}")
    @ResponseBody
    public AjaxResult stop(Model model,@PathVariable Long id){
        try{
            TaskConfig.getInstance().stop(id);
            return success(true,"操作成功");
        }catch (Exception e){
            return fail(false,"停止异常："+e.getMessage());
        }
    }

    /**
     * 启动
     * @param model
     * @param id
     * @return
     */
    @RequiresPermissions("task:cron:edit")
    @RequestMapping("/start/{id}")
    @ResponseBody
    public AjaxResult start(Model model,@PathVariable Long id){
        ComTaskCron taskCron = taskCronService.selectById(id);
        if(taskCron.getStatus().equals(ComTaskCron.DEL_FLAG_DELETE)){
            return success(false,"不能启动已经失效的数据");
        }
        TaskConfig.getInstance().start(taskCron);
        return success(true,"操作成功");
    }

    /**
     * 冻结和解冻
     * @param model
     * @param id
     * @return
     */
    @RequiresPermissions("task:cron:delete")
    @RequestMapping(value = "/status/{id}",method = RequestMethod.DELETE)
    @ResponseBody
    public AjaxResult status(Model model, @PathVariable Long id,@RequestParam Integer status){
        ComTaskCron taskCron = new ComTaskCron();
        taskCron.setCom_task_cron_id(id);
        taskCron.setStatus(status);
        taskCronService.updateById(taskCron);
        if(TaskConfig.getInstance().TASKS.get(id)!=null){
            return success(false,"正在运行中的定时任务不能被删除");
        }
        return success(true,"操作成功");
    }

    /**
     * 删除任务
     * @param model
     * @param id
     * @return
     */
    @RequiresPermissions("task:cron:delete")
    @RequestMapping(value = "/delete/{id}",method = RequestMethod.DELETE)
    @ResponseBody
    public AjaxResult delete(Model model, @PathVariable Long id){
        try{
            if(TaskConfig.getInstance().TASKS.get(id)!=null){
                TaskConfig.getInstance().stop(id);
            }
            taskCronService.deleteById(id);
            return success(true,"操作成功");
        }catch (Exception e){
            return fail(false,"删除异常："+e.getMessage());
        }
    }
}
