package com.bcxin.ins.task.base.config;

import com.bcxin.ins.common.constants.GlobalConstants;
import com.bcxin.mybatisplus.mapper.EntityWrapper;
import com.bcxin.ins.entity.common.ComTaskCron;
import com.bcxin.ins.task.base.service.TaskCronService;
import com.bcxin.ins.util.toolbox.StrUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

/**
 * <b> 定时任务初始化 </b>
 * @author ZXF
 * @create 2018/10/16 0016 13:45
 * @version
 * @注意事项 </b>
 */
@Service
@Lazy(false)
@EnableScheduling
public class TaskInit implements SchedulingConfigurer {

    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    TaskCronService taskCronService;

    @Bean(destroyMethod="shutdown")
    public Executor taskScheduler() {
        return Executors.newScheduledThreadPool(StrUtil.toInteger(GlobalConstants.getConfig("task.pool")));
    }

    /**
     * 扫描初始化
     */
    public void execute(){
        //无
    }

    /**
     * 定时任务初始化 启动初始化
     * @param taskRegistrar
     */
    @Override
    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        taskRegistrar.setScheduler(taskScheduler());
        if(GlobalConstants.TRUE.equals(GlobalConstants.getConfig("task.status"))) {
            try {
                List<ComTaskCron> list = taskCronService.selectList(new EntityWrapper<>(new ComTaskCron()));
                if (list.size() > 0) {
                    TaskConfig taskConfig = TaskConfig.getInstance();
                    for (ComTaskCron t : list) {
                        taskConfig.start(t);
                    }
                }
            } catch (Exception e) {
                logger.info("定时任务初始化失败.", e);
            }
        }
    }
}
