package com.bcxin.api.test;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONException;
import com.bcxin.api.utils.MessageUtils;
import com.bcxin.common.base.web.BaseController;
import com.bcxin.common.util.jiami.ConstUtil;
import com.bcxin.common.util.jiami.HelpPassword;

/**
 * 用于处理 来自外部对 合作机构的请求
 * 
 * @author admin
 *
 */
@Controller
@RequestMapping(value = "{apiPath}/data/test/")
public class TestReqController extends BaseController {

	/**
	 * 别人来调用我们的接口
	 * @param request
	 * @param response
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "insert")
	@ResponseBody
	public String insert(HttpServletRequest request, HttpServletResponse response) throws Exception {
		String code = request.getAttribute("code").toString();// 获取过滤器返回的值
		if (code.equals(ConstProp.DIGIT_ZERO)) {
			// 验证错误 不返回值
			return TestJsonUtil.getJsonError();
		} else {
			// 验证 成功 进行数据操作
			String jsonstr = request.getParameter("data");
			AddDeclarationVo vo = MessageUtils.getObject(jsonstr, AddDeclarationVo.class, "dto");
			Long currentTime=System.currentTimeMillis();
			Map<String, Object> map = new HashMap<String, Object>();
			map.put("dto", vo);
			map.put("date", currentTime);
			map.put("token", HelpPassword.encryptionPassword(currentTime+"", ConstUtil.COINS_TOKEN));;
		
			try {
				// {"contactname":"顶戴","bank":"中国工商银行2","address":"杏花春雨斯柯达asdf","bankaccountnumber":"sadfasd","corpbcode":"小李子","hierarchy":"","name":"小李子律师事务所","oid":11567104,"contacttel":"sdaf","bankaccountname":"dsafasd","email":"85587710@qq.com"}
				// 只要code==200 就是 插入成功

				return MessageUtils.packageMap(map);
			} catch (JSONException e) {
				e.printStackTrace();
				return TestJsonUtil.getJsonError();
			} catch (Exception e) {
				e.printStackTrace();
				return TestJsonUtil.getJsonError();
			}
		}
	}

	/**
	 * 我去调用别人的接口
	 * @param request
	 * @param response
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "diaoyong")
	public String diaoyong(HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		try {
//			String result = MessageUtils.doGet("http://192.168.30.10:8080/conIns/exports/declare/test?data=" + MessageUtils.packageMap(map));
//			List<NameValuePair> formParams= new ArrayList<NameValuePair>();
//			String str=ReturnJsonUtil.getJsonSuccess().toString();
//			 formParams.add(new BasicNameValuePair("data",MessageUtils.packageString(str))); 
//			String result= MessageUtils.doPost(ConstUtil.COINS_ADDRESS, formParams);
//			System.out.println(result);
//		
		} catch (Exception e) {
		e.printStackTrace();
		}
	
		return  null;
	}
}