package com.bcxin.api.test;



import com.alibaba.fastjson.JSONObject;
import com.bcxin.api.utils.Apache64Utils;
import com.bcxin.common.util.Encodes;
import com.bcxin.common.util.jiami.ConstUtil;
import com.bcxin.common.util.jiami.HelpPassword;

/**
 *  合作机构  json 组装
 * @author admin
 *
 */
public class TestJsonUtil {
	
	/**
	 * @return
	 * @throws Exception 
	 */
	public static String   getJsonSuccess() throws Exception{
	
		JSONObject  json= new JSONObject();
		json.put("soleTabId", "");
		json.put("code", 200);
		json.put("message", "操作成功");
		JSONObject  returnjson = new JSONObject();
		Long currentTime=System.currentTimeMillis();
		returnjson.put("option", Encodes.encodeBase64(json.toString()));
		returnjson.put("date", currentTime);
		returnjson.put("token", HelpPassword.encryptionPassword(currentTime+"", ConstUtil.COINS_TOKEN));
		return returnjson.toString();
	}
	
	public static String   getJsonError() throws Exception{
		JSONObject  json= new JSONObject();
		json.put("code", 300);
		json.put("message", "保存不成功");
		JSONObject  returnjson = new JSONObject();
		Long currentTime=System.currentTimeMillis();
		returnjson.put("option", Encodes.encodeBase64(json.toString()));
		returnjson.put("date", currentTime);
		returnjson.put("token", HelpPassword.encryptionPassword(currentTime+"", ConstUtil.COINS_TOKEN));
		return returnjson.toString();
	}

	/**
	 * <b> 组装json  加密放到data里面 </b> 
	 * 
	 * @param jsonResult
	 * @return
	 * @author liyongqiang
	 * @date 2017年1月5日 上午10:18:33
	 * @注意事项 </b>
	 * <b>
	 */
	public static String getJsonToString(JSONObject jsonResult) {
		
		return Apache64Utils.base64Encode(jsonResult.toString());
	}

	/**
	 * <b>返回完整的json </b> 
	 * 
	 * @param option
	 * @return
	 * @author liyongqiang
	 * @date 2017年1月5日 上午10:18:54
	 * @注意事项 </b>
	 * <b>
	 */
	public static String getJsonToEntity(String option) {
		JSONObject  json= new JSONObject();
		
		return json.toString();
	}
	
	
}
