/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.weixin.web;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.service.SysUserService;
import com.bcxin.ins.spring.annotation.OperationLog;
import com.bcxin.ins.spring.util.JedisUtils;
import com.bcxin.ins.util.IpAddress;
import com.bcxin.ins.weixin.login.service.WeiXinLoginService;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${weixin}/login"})
public class WeiXinLoginController
extends BaseController {
    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private WeiXinLoginService weiXinLoginService;
    private static final String LOGIN_INIT = WeiXinLoginController.getViewPath((String)"weixin/login/weixin_login");
    private static final String REGISTER_INIT = WeiXinLoginController.getViewPath((String)"weixin/login/weixin_register");
    private static final String RESET_PWD_ONE = WeiXinLoginController.getViewPath((String)"weixin/login/weixin_reset_one");
    private static final String RESET_PWD_TWO = WeiXinLoginController.getViewPath((String)"weixin/login/weixin_reset_two");
    private static final String RESET_PWD_THREE = WeiXinLoginController.getViewPath((String)"weixin/login/weixin_reset_three");

    @RequestMapping(value={"/init"})
    public String loginInit(Model model, @RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        return LOGIN_INIT;
    }

    @RequestMapping(value={"/login"})
    @OperationLog(source=OperationLog.SOURCETYPE.FRONT_LOGIN_BLB_WC, title="\u3010\u8bf7\u6c42\u3011\u5fae\u4fe1-\u767b\u5f55")
    @ResponseBody
    public JSONObject login(Model model, @RequestParam Map<Object, Object> params) {
        return this.weiXinLoginService.login(params, this.getRequest(), this.getResponse());
    }

    @RequestMapping(value={"/register/init"})
    public String registerInit(Model model, @RequestParam Map<Object, Object> params) {
        return REGISTER_INIT;
    }

    @RequestMapping(value={"/register"})
    @OperationLog(source=OperationLog.SOURCETYPE.FRONT, title="\u3010\u8bf7\u6c42\u3011\u5fae\u4fe1-\u6ce8\u518c")
    @ResponseBody
    public JSONObject register(Model model, @RequestParam Map<Object, Object> params) {
        return this.weiXinLoginService.register(params, this.getRequest(), this.getResponse());
    }

    @RequestMapping(value={"/resetOne"})
    public String resetOne(Model model, @RequestParam Map<Object, Object> params) {
        return RESET_PWD_ONE;
    }

    @RequestMapping(value={"/resetTwo"})
    public String resetTwo(Model model, @RequestParam Map<Object, Object> params) {
        String email = JedisUtils.get((String)("resetPwdEmail:" + IpAddress.getIpAddress((HttpServletRequest)this.getRequest())));
        if (email == null) {
            return RESET_PWD_ONE;
        }
        model.addAttribute("email", (Object)email);
        return RESET_PWD_TWO;
    }

    @RequestMapping(value={"/resetThree"})
    public String resetThree(Model model, @RequestParam Map<Object, Object> params) {
        String email = JedisUtils.get((String)("resetPwdEmail:" + IpAddress.getIpAddress((HttpServletRequest)this.getRequest())));
        if (email == null) {
            return RESET_PWD_ONE;
        }
        return RESET_PWD_THREE;
    }

    @RequestMapping(value={"/resetPassword"})
    @ResponseBody
    public JSONObject resetPassword(HttpServletRequest request, @RequestParam Map<Object, Object> params) {
        return this.weiXinLoginService.resetPassword(request, params);
    }

    @RequestMapping(value={"/register/checkUserExist"})
    @ResponseBody
    public JSONObject checkUserExist(String email, HttpServletRequest request) {
        return this.weiXinLoginService.checkUserExist(email, request);
    }

    @RequestMapping(value={"/exit"})
    public String exit(Model model, @RequestParam Map<Object, Object> params) {
        this.getRequest().getSession().invalidate();
        return LOGIN_INIT;
    }

    @RequestMapping(value={"/register/checkCodeExist"})
    @ResponseBody
    public JSONObject checkCode(String code) {
        return this.weiXinLoginService.checkCodeExist(code, this.getRequest());
    }

    @RequestMapping(value={"/sendEmailCode"})
    @ResponseBody
    public JSONObject sendEmailCode(String email) {
        return this.weiXinLoginService.sendEmailCode(email, this.getRequest());
    }

    @RequestMapping(value={"/sendTelPhoneCode"})
    @ResponseBody
    public JSONObject sendTelPhoneCode(String tel) {
        return this.weiXinLoginService.sendTelPhoneCode(tel, this.getRequest());
    }

    @RequestMapping(value={"/sendCode"})
    @ResponseBody
    public JSONObject sendCode(String eOrT) {
        return this.weiXinLoginService.sendCode(eOrT, this.getRequest());
    }

    @RequestMapping(value={"/register/checkEmail"})
    @ResponseBody
    public JSONObject checkEmail(String email) {
        return this.weiXinLoginService.ckeckEmail(email, this.getRequest());
    }

    @RequestMapping(value={"/register/checkMobile"})
    @ResponseBody
    public JSONObject checkMobile(String tel) {
        return this.weiXinLoginService.checkMobile(tel, this.getRequest());
    }
}

