/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.weixin.web;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.weixin.util.weixin.process.WechatProcess;
import com.bcxin.ins.weixin.util.weixin.service.WeiXinService;
import com.bcxin.ins.weixin.util.weixin.util.AccessToken;
import com.bcxin.ins.weixin.util.weixin.util.ConstantWeiXin;
import com.bcxin.ins.weixin.util.weixin.util.SignUtil;
import com.bcxin.ins.weixin.util.weixin.util.WeixinUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"weixin/token"})
public class WeiXinController {
    @Autowired
    private WeiXinService weiXinService;

    @RequestMapping(value={"serial"})
    @ResponseBody
    public void serial(HttpServletRequest request, HttpServletResponse response) {
        try {
            request.setCharacterEncoding("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        response.setCharacterEncoding("UTF-8");
        String signature = request.getParameter("signature");
        String echostr = request.getParameter("echostr");
        String timestamp = request.getParameter("timestamp");
        String nonce = request.getParameter("nonce");
        if (SignUtil.checkSignature(ConstantWeiXin.TOKEN, signature, timestamp, nonce)) {
            StringBuffer sb = new StringBuffer();
            try (ServletInputStream is = request.getInputStream();
                 InputStreamReader isr = new InputStreamReader((InputStream)is, "UTF-8");){
                PrintWriter out = response.getWriter();
                BufferedReader br = new BufferedReader(isr);
                String s = "";
                while ((s = br.readLine()) != null) {
                    sb.append(s);
                }
                String xml = sb.toString();
                String result = "";
                result = echostr != null && echostr.length() > 1 ? echostr : new WechatProcess().processWechatMag(xml, this.weiXinService);
                response.setContentType("application/xml;charset=UTF-8");
                out.print(result);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @RequestMapping(value={"wechatParam"})
    @ResponseBody
    public Map<String, String> getWechatParam(String hostUrl) {
        AccessToken at = this.weiXinService.getAccessToken();
        String url = ConstantWeiXin.APITICKETURL.replace("ACCESS_TOKEN", at.getToken());
        JSONObject jsApiTicket = WeixinUtil.httpRequest(url, "GET", null);
        String ticket = jsApiTicket.getString("ticket");
        Map<String, String> wechatParam = this.makeWXTicket(ticket, hostUrl);
        System.out.printf(wechatParam.toString(), new Object[0]);
        return wechatParam;
    }

    public Map<String, String> makeWXTicket(String jsApiTicket, String url) {
        HashMap<String, String> ret = new HashMap<String, String>();
        String nonceStr = WeiXinController.createNonceStr();
        String timestamp = WeiXinController.createTimestamp();
        String signature = "";
        String string1 = "jsapi_ticket=" + jsApiTicket + "&noncestr=" + nonceStr + "&timestamp=" + timestamp + "&url=" + url;
        try {
            MessageDigest crypt = MessageDigest.getInstance("SHA-1");
            crypt.reset();
            crypt.update(string1.getBytes("UTF-8"));
            signature = WeiXinController.byteToHex(crypt.digest());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ret.put("url", url);
        ret.put("jsapi_ticket", jsApiTicket);
        ret.put("nonceStr", nonceStr);
        ret.put("timestamp", timestamp);
        ret.put("signature", signature);
        ret.put("appid", ConstantWeiXin.CORPID);
        return ret;
    }

    private static String byteToHex(byte[] hash) {
        Formatter formatter = new Formatter();
        for (byte b : hash) {
            formatter.format("%02x", b);
        }
        String result = formatter.toString();
        formatter.close();
        return result;
    }

    private static String createNonceStr() {
        return UUID.randomUUID().toString();
    }

    private static String createTimestamp() {
        return Long.toString(System.currentTimeMillis() / 1000L);
    }
}

