/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.weixin.usercenter.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.core.entity.PageResult;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.service.user.ClientUserService;
import com.bcxin.ins.util.Sha1Util;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.weixin.usercenter.dao.WeiXinUserCenterMapper;
import com.bcxin.ins.weixin.usercenter.service.WeiXinUserCenterService;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class WeiXinUserCenterServiceImpl
implements WeiXinUserCenterService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private WeiXinUserCenterMapper dao;
    @Autowired
    private ClientUserService userService;

    @Override
    public PageResult query(Map<Object, Object> p) {
        return new PageResult(Integer.valueOf(this.dao.queryCnt(p)), this.dao.query(p));
    }

    @Override
    public JSONObject savePwd(Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp, ClientUserVo weixinVo) {
        String status = "300";
        String msg = "\u65e7\u5bc6\u7801\u548c\u65b0\u5bc6\u7801\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01";
        String oldPassword = String.valueOf(params.get("old_password"));
        String newPassword = String.valueOf(params.get("new_password"));
        if (StringUtils.isEmpty((CharSequence)oldPassword) || StringUtils.isEmpty((CharSequence)newPassword)) {
            return this.returnJsonMsg(status, msg);
        }
        if (oldPassword.equals(newPassword)) {
            status = "303";
            msg = "\u65e7\u5bc6\u7801\u548c\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e00\u6837\uff01";
            return this.returnJsonMsg(status, msg);
        }
        if (!Sha1Util.validatePassword((String)oldPassword, (String)weixinVo.getPassword())) {
            status = "302";
            msg = "\u65e7\u5bc6\u7801\u9519\u8bef\uff01";
            return this.returnJsonMsg(status, msg);
        }
        if (this.userService.getUserPassword(weixinVo.getLogin_name(), newPassword)) {
            weixinVo.setPassword(Sha1Util.entryptPassword((String)newPassword));
            UserSupportUtil.setSessionWeiXinUser((ClientUserVo)weixinVo);
            status = "200";
            msg = "\u4fee\u6539\u6210\u529f";
            return this.returnJsonMsg(status, msg);
        }
        status = "500";
        msg = "\u4fee\u6539\u5931\u8d25";
        return this.returnJsonMsg(status, msg);
    }

    private JSONObject returnJsonMsg(String status, String msg) {
        JSONObject obj = new JSONObject();
        obj.put("status", (Object)status);
        obj.put("msg", (Object)msg);
        this.logger.debug("retrun,\u8fd4\u56de\u7ed9\u9875\u9762\u7684\u503c\uff1a" + JSON.toJSONString((Object)obj));
        return obj;
    }
}

