/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.supply.business.impl;

import com.bcxin.ins.entity.common.ComAreaCode;
import com.bcxin.ins.entity.common.ComRegion;
import com.bcxin.ins.service.common.ComAreaCodeAPIService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.product.InsProductRuleXWCKAPIService;
import com.bcxin.ins.supply.SupplyType;
import com.bcxin.ins.supply.business.BizInsureService;
import com.bcxin.ins.supply.business.BizStrategy;
import com.bcxin.ins.supply.business.entity.InsureCommonView;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.RegionUtils;
import com.bcxin.ins.utils.FreemarkerUtil;
import com.bcxin.ins.vo.MicroExportVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.ResultDto;
import com.bcxin.ins.vo.RoleSubjectVo;
import com.bcxin.ins.vo.RuleXWCKVo;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@SupplyType(type=SupplyType.SupplyTypeEnum.TAI_BAO)
public class BizStrategyTaiBao
implements BizStrategy {
    @Autowired
    private PolicyService policyService;
    @Autowired
    private ComAreaCodeAPIService comAreaCodeAPIService;
    @Autowired
    private InsProductRuleXWCKAPIService insProductRuleXWCKAPIService;
    @Autowired
    private BizInsureService bizInsureService;

    public BizStrategyTaiBao() {
        System.out.print("BusinessStrategyTaiBao");
    }

    @Override
    public ResultDto calcInsuranceEndDate(String startTime, Integer limitDays) {
        try {
            Date planTimeNextYear = DateUtil.convertStringToDate((String)DateUtil.dateAdd((int)1, (String)startTime, (int)1));
            int limitFinalDays = limitDays + 28;
            Date planTimeWithLimit = DateUtil.convertStringToDate((String)DateUtil.dateAdd((int)3, (String)startTime, (int)limitDays));
            Date planTimeWithFinalLimit = DateUtil.convertStringToDate((String)DateUtil.dateAdd((int)3, (String)startTime, (int)limitFinalDays));
            if (DateUtil.calculateTwoDateDvalue((Date)planTimeNextYear, (Date)planTimeWithLimit) < 0L) {
                return new ResultDto("\u4fdd\u9669\u671f\u95f4\u5927\u4e8e\u4e00\u5e74\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u6295\u6807\u6709\u6548\u671f\uff01", "300", "", "", "");
            }
            if (DateUtil.calculateTwoDateDvalue((Date)planTimeNextYear, (Date)planTimeWithFinalLimit) < 0L) {
                planTimeWithFinalLimit = DateUtil.convertStringToDate((String)DateUtil.dateAdd((int)3, (String)DateUtil.dateAdd((int)1, (String)startTime, (int)1), (int)-1));
            }
            if (planTimeWithFinalLimit != null) {
                String plannedEnd = DateUtil.convertDateToString((Date)planTimeWithFinalLimit, (String)"yyyy-MM-dd");
                return new ResultDto(plannedEnd, "200", "", "", "");
            }
            return new ResultDto("\u83b7\u53d6\u5931\u6548\u65e5\u671f\u5931\u8d25", "300", "", "", "");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResultDto("", "301", "", "", "");
        }
    }

    @Override
    public InsureCommonView getInsureCommonView(Map<String, Object> map) {
        ComRegion regionPro;
        String val2_;
        List tbpList;
        String transType = map.get("transType").toString();
        String tb_code = "";
        Long orderId = Long.parseLong(map.get("orderId").toString());
        OrderFormVo order = this.policyService.accordingToOrderIDToGetPolicyDto(orderId);
        MicroExportVo microExportVo = this.policyService.accordingToOrderIDToGetMicroExportVo(orderId);
        String cityCode = ((RoleSubjectVo)microExportVo.getRoleSubjectList().get(0)).getReg_city();
        String provinceCode = ((RoleSubjectVo)microExportVo.getRoleSubjectList().get(0)).getReg_province();
        String productId = order.getProduct_oid();
        RuleXWCKVo ruleXWCKVo = this.insProductRuleXWCKAPIService.getRuleXWCKVoByProductIDAndCity(productId, cityCode);
        ComRegion regionCity = RegionUtils.getComRegionByCode((String)cityCode);
        String val1_ = regionCity.getNamed().substring(0, regionCity.getNamed().length() - 1);
        List tbsList = this.comAreaCodeAPIService.findComAreaCodeByCode("", "", val1_);
        ComAreaCode tb = null;
        if (tbsList.size() > 0) {
            tb = (ComAreaCode)tbsList.get(0);
        }
        if (tb == null && (tbpList = this.comAreaCodeAPIService.findComAreaCodeByCode("", "", val2_ = (regionPro = RegionUtils.getComRegionByCode((String)provinceCode)).getNamed().substring(0, regionPro.getNamed().length() - 1))).size() > 0) {
            tb = (ComAreaCode)tbpList.get(0);
        }
        tb_code = tb.getCodes();
        HashMap<String, Object> mapData = new HashMap<String, Object>();
        mapData.put("order", order);
        mapData.put("policy", microExportVo);
        mapData.put("ruleXWCKVo", ruleXWCKVo);
        mapData.put("applicants", microExportVo.getRoleSubjectList().get(0));
        mapData.put("transType", transType);
        mapData.put("tb_code", tb_code);
        mapData.put("planDate", DateUtil.getThisYearLastDay());
        mapData.put("planFee", 100);
        InsureCommonView insureCommonView = this.bizInsureService.getInsureCommonView(null, orderId);
        try {
            String templateName = SupplyType.SupplyTypeEnum.TAI_BAO.getKey() + "_XWCK_120043.ftl";
            String requestXML = FreemarkerUtil.getInstance().transferMapToString(templateName, mapData);
            System.out.println(requestXML);
            FreemarkerUtil.getInstance().transferMapToFile(mapData, templateName, "D:\\template\\xml\\XWCK_120043_result.xml");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public String createRequestMessage(Map<String, Object> map, String templateName) {
        try {
            templateName = SupplyType.SupplyTypeEnum.TAI_BAO.getKey() + "_" + templateName + ".ftl";
            String transType = map.get("transType").toString();
            String tb_code = "";
            Long orderId = Long.parseLong(map.get("orderId").toString());
            InsureCommonView insureCommonView = this.bizInsureService.getInsureCommonView(null, orderId);
            HashMap data = Maps.newHashMap();
            data.put("order", insureCommonView.getOrderView());
            data.put("policy", insureCommonView.getPolicyHolderView());
            data.put("transType", transType);
            data.put("tb_code", tb_code);
            data.put("planDate", DateUtil.getThisYearLastDay());
            data.put("planFee", 100);
            String requestXML = FreemarkerUtil.getInstance().transferMapToString(templateName, data);
            FreemarkerUtil.getInstance().transferMapToFile(data, templateName, "D:\\template\\xml\\XWCK_120043_result1.xml");
            return requestXML;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u751f\u6210\u62a5\u6587\u5931\u8d25");
        }
    }
}

