/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.coninsweb.product.controller;

import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.util.SysDictUtils;
import com.bcxin.ins.dto.ResultDto;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.service.product.InsProductAPIService;
import com.bcxin.ins.service.product.ProExpCustomsCompaniesAPIService;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.util.DSUtil;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.vo.ProExpCustomsCompaniesVo;
import com.bcxin.ins.vo.ProductVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class InsuranceProduct_XYX_Controller
extends BaseController {
    @Autowired
    private InsProductAPIService insProductAPIService;
    @Autowired
    private ProductService productService;
    @Autowired
    private ProExpCustomsCompaniesAPIService proExpCustomsCompaniesAPIService;
    private static String COMLIST = "comList";
    private static String INSURANCETYPE = "insuranceType";

    @RequestMapping(value={"/insurance/customs/product/productInfo/{oid}"})
    public ModelAndView productInfo(HttpServletRequest request, @PathVariable long oid) {
        ModelAndView view = new ModelAndView();
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        ProductVo pd = this.insProductAPIService.accordingToInsProductIDToGetInsProductInProductVo(Long.valueOf(oid));
        if (!StringUtils.isNotEmpty((CharSequence)pd.getOid())) {
            return null;
        }
        view.addObject("sharePath", (Object)this.productService.setSharePath(Long.valueOf(oid), userdetail));
        if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && "XYX-DQCK".equals(pd.getProduct_code())) {
            view.setViewName("/coninsweb/insurance/customs/product/productInfo_qy");
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && "XYX-XWCK".equals(pd.getProduct_code())) {
            view.setViewName("/coninsweb/insurance/customs/product/productInfo_mi");
        }
        view.addObject("productDto", (Object)pd);
        view.addObject("userdetail", (Object)userdetail);
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"/insurance/customs/product/identityCheck/{oid}"})
    public ModelAndView identityCheckVeiw(HttpServletRequest request, @PathVariable long oid) {
        ModelAndView view = new ModelAndView("/coninsweb/insurance/customs/product/identityCheck");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            return new ModelAndView(DSUtil.operation() + "/insurance/customs/product/identityCheck/" + oid);
        }
        try {
            ProductVo pd = this.insProductAPIService.accordingToInsProductIDToGetInsProductInProductVo(Long.valueOf(oid));
            view.addObject("productDto", (Object)pd);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        view.addObject("userdetail", (Object)userdetail);
        view.addObject(COMLIST, (Object)SysDictUtils.getDictList((String)INSURANCETYPE));
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"/insurance/product/identityCheck"})
    @ResponseBody
    public ResultDto identityCheck(HttpServletRequest request, ProExpCustomsCompaniesVo vo) {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            return new ResultDto("\u767b\u5f55\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\uff01", "301", "", "", "");
        }
        ProExpCustomsCompaniesVo peccVo = null;
        try {
            peccVo = this.proExpCustomsCompaniesAPIService.findIdentity(vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (peccVo != null) {
            return new ResultDto("\u68c0\u9a8c\u6210\u529f\uff01", "200", String.valueOf(peccVo.getExport_amount()), "", "");
        }
        return new ResultDto("\u516c\u53f8\u540d\u79f0\u3001\u6d77\u5173\u4ee3\u7801\u6709\u8bef\u6216\u8be5\u4f01\u4e1a\u4e0d\u5c5e\u4e8e\u5c0f\u5fae\u4f01\u4e1a\uff0c\u8bf7\u786e\u8ba4\uff01", "300", "", "", "");
    }
}

