/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.coninsweb.product.controller;

import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.util.DSUtil;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.ProductVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class InsuranceProduct_GYX_Controller
extends BaseController {
    @Autowired
    private ProductService productService;
    @Autowired
    private PolicyService policyService;

    @RequestMapping(value={"/insurance/gyx/product/productInfo_iframe/{oid}"})
    public ModelAndView productInfo_iframe(HttpServletRequest request, @PathVariable long oid) {
        ModelAndView view = new ModelAndView("/coninsweb/api/gyx/gyx_pro_index");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        view.addObject("userdetail", (Object)userdetail);
        view.addObject("product_id", (Object)String.valueOf(oid));
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"/insurance/gyx/policy/policy_iframe/{oid}"})
    public ModelAndView policy_iframe(@PathVariable long oid) {
        ModelAndView view = new ModelAndView("/coninsweb/api/gyx/gyx_order_index");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            return new ModelAndView(DSUtil.operation() + "/insurance/gyx/policy/policy_iframe/" + oid);
        }
        view.addObject("userdetail", (Object)userdetail);
        view.addObject("order_id", (Object)String.valueOf(oid));
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"/insurance/gyx/policy/policyInit_iframe/{oid}"})
    public ModelAndView policyInit_iframe(HttpServletRequest request, @PathVariable long oid) {
        ModelAndView view = new ModelAndView("/coninsweb/api/gyx/gyx_order_init");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            return new ModelAndView(DSUtil.operation() + "/insurance/gyx/policy/policyInit_iframe/" + oid);
        }
        view.addObject("userdetail", (Object)userdetail);
        view.addObject("product_id", (Object)String.valueOf(oid));
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"/insurance/gyx/policy/payment_iframe/{oid}"})
    public ModelAndView payment_iframe(@PathVariable long oid) {
        ModelAndView view = new ModelAndView("/coninsweb/api/gyx/gyx_order_pay");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            return new ModelAndView(DSUtil.operation() + "/insurance/gyx/policy/payment_iframe/" + oid);
        }
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(oid));
        view.addObject("dto", (Object)dto);
        OrderFormVo vo = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(oid));
        view.addObject("userdetail", (Object)userdetail);
        view.addObject("payurl", (Object)vo.getShow_url());
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"/insurance/gyx/product/productInfo/{oid}"})
    public ModelAndView productInfo(HttpServletRequest request, @PathVariable long oid) {
        ModelAndView view = new ModelAndView();
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        ProductVo pd = this.productService.getProduct(oid);
        if (!StringUtils.isNotEmpty((CharSequence)pd.getOid())) {
            return null;
        }
        view.addObject("sharePath", (Object)this.productService.setSharePath(Long.valueOf(oid), userdetail));
        if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("GYX-TB")) {
            view.setViewName("/coninsweb/api/gyx/product/gyx_tb_product_info");
        }
        view.addObject("productDto", (Object)pd);
        view.addObject("userdetail", (Object)userdetail);
        this.setTokenByApi(view);
        return view;
    }
}

