/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.coninsweb.product.controller;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.entity.user.SysClientUser;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.service.product.InsProductAPIService;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.service.user.ClientUserService;
import com.bcxin.ins.spring.annotation.LoginRequired;
import com.bcxin.ins.spring.annotation.OperationLog;
import com.bcxin.ins.spring.util.JedisUtils;
import com.bcxin.ins.util.Constant;
import com.bcxin.ins.util.ErweimaUtil;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.util.MD5Util;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.vo.ProductVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class InsuranceProductController
extends BaseController {
    @Autowired
    private InsProductAPIService insProductAPIService;
    @Autowired
    private ProductService productService;
    @Autowired
    private ClientUserService userService;
    private static String PRODUCT_ID = "product_id";

    @RequestMapping(value={"/insurance/product/getQRCode"})
    @ResponseBody
    public String getQRCode() {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        JSONObject data = new JSONObject();
        try {
            String qrId = "BLB:" + MD5Util.string2MD5((String)(System.currentTimeMillis() + "QR"));
            UserSupportUtil.setQrCode((String)qrId, (String)userdetail.getOid());
            JSONObject json = new JSONObject();
            json.put("qrId", (Object)qrId);
            System.out.println(qrId);
            String lx_url = "/insurance/product/isBindThr";
            String ewmBase64 = ErweimaUtil.createErWeiMaToBase64((String)json.toJSONString());
            data.put("ret", (Object)"200");
            data.put("obj", (Object)(lx_url + "||" + GlobalResources.ESTAND_XCX_QR_CODE + "||" + ewmBase64));
        }
        catch (Exception e) {
            data.put("ret", (Object)"300");
            data.put("msg", (Object)e.getMessage());
        }
        return data.toJSONString();
    }

    @RequestMapping(value={"/insurance/product/isBindThr"})
    @ResponseBody
    public String isBindThr() {
        JSONObject data = new JSONObject();
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail != null && StringUtils.isNotEmpty((CharSequence)userdetail.getWeb_type()) && userdetail.getWeb_type().contains("ESTAND-PSS")) {
            data.put("ret", (Object)"200");
        } else {
            SysClientUser user = (SysClientUser)this.userService.selectById((Serializable)Long.valueOf(Long.parseLong(userdetail.getOid())));
            if (user != null && StringUtils.isNotEmpty((CharSequence)user.getWeb_type()) && user.getWeb_type().contains("ESTAND-PSS")) {
                userdetail.setWeb_type(user.getWeb_type());
                userdetail.setWeb_id(user.getWeb_id());
                userdetail.setWeb_user_name(user.getWeb_user_name());
                UserSupportUtil.setSessionUser((ClientUserVo)userdetail);
                data.put("ret", (Object)"200");
            } else {
                data.put("ret", (Object)"300");
            }
        }
        return data.toJSONString();
    }

    @RequestMapping(value={"/insurance/product/bindEStandUser/{qrId}"})
    @ResponseBody
    public String bindEStandUser(@PathVariable String qrId, HttpServletRequest reqeust) {
        String webType;
        String userId;
        String phone;
        String webUsername;
        String webId = reqeust.getParameter("id");
        if (this.userService.bindThrUser(webId, webUsername = reqeust.getParameter("username"), phone = reqeust.getParameter("phone"), userId = UserSupportUtil.getQrCode((String)qrId), webType = GlobalResources.IS_TEST_ENVI != false ? "ESTAND-PSS-TEST" : "ESTAND-PSS")) {
            return "1";
        }
        return "0";
    }

    @RequestMapping(value={"/insurance/product/productInfo/{oid}"})
    @OperationLog(source=OperationLog.SOURCETYPE.FRONT_PRODUCT, title="\u3010\u89c6\u56fe\u3011\u9996\u9875-\u4ea7\u54c1\u8be6\u60c5")
    public ModelAndView productInfo(HttpServletRequest request, @PathVariable long oid, @RequestParam(value="recommendCode", required=false) String recommendCode) {
        ModelAndView view = new ModelAndView();
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        ProductVo pd = this.productService.getProduct(oid);
        if (pd == null) {
            return null;
        }
        if (StringUtils.isNotEmpty((CharSequence)pd.getOid())) {
            try {
                view.addObject("sharePath", (Object)this.productService.setSharePath(Long.valueOf(oid), userdetail));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            return null;
        }
        if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && "XYX-DQCK".equals(pd.getProduct_code())) {
            view.setViewName("/coninsweb/insurance/customs/product/productInfo_qy");
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && "XYX-XWCK".equals(pd.getProduct_code())) {
            view.setViewName("/coninsweb/insurance/customs/product/productInfo_mi");
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && "BZX-TB-GCTB".equals(pd.getProduct_code())) {
            view.setViewName("/coninsweb/insurance/build/product/build_tb_product_info");
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && "BZX-YG-GCTB".equals(pd.getProduct_code())) {
            view.setViewName("/coninsweb/insurance/build/product/build_yg_product_info");
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && "BZX-DB-GCTB".equals(pd.getProduct_code())) {
            view.setViewName("/coninsweb/insurance/build/product/build_db_product_info");
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && "BZX-GCLY".equals(pd.getProduct_code())) {
            view.setViewName("/coninsweb/insurance/build/product/productInfo_ly");
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && "BZX-SSBQ".equals(pd.getProduct_code())) {
            view.setViewName("/coninsweb/insurance/lawsuit/product/productInfo");
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().indexOf("TYX") != -1) {
            if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("TYX-PAS")) {
                view.setViewName("/coninsweb/insurance/tyx/product/gmr_pn_product_info");
            } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("TYX-PAC")) {
                view.setViewName("/coninsweb/insurance/tyx/product/gmr_pnc_product_info");
            } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("TYX-TK")) {
                view.setViewName("/coninsweb/insurance/tyx/product/gmr_tk_product_info");
            } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("TYX-RB")) {
                view.setViewName("/coninsweb/insurance/tyx/product/gmr_rb_product_info");
            } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("TYX-CA")) {
                view.setViewName("/coninsweb/insurance/tyx/product/gmr_ca_product_info");
            } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("TYX-QH")) {
                view.setViewName("/coninsweb/insurance/tyx/product/gmr_qh_product_info");
            } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("TYX-HT")) {
                view.setViewName("/coninsweb/insurance/tyx/product/gmr_ht_product_info");
            }
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().indexOf("GYX-TB") != -1) {
            view.setViewName("/coninsweb/insurance/gyx/product/gyx_tb_product_info");
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().indexOf("GYX-CA") != -1) {
            view.setViewName("/coninsweb/insurance/gyx/product/gyx_ca_product_info");
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().indexOf("GZX-HT") != -1) {
            view.setViewName("/coninsweb/insurance/gzx/product/gzx_ht_product_info");
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().indexOf("GZX-PAC") != -1) {
            view.setViewName("/coninsweb/insurance/gzx/product/gzx_pac_product_info");
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().indexOf("GZX-CA") != -1) {
            view.setViewName("/coninsweb/insurance/gzx/product/gzx_ca_product_info");
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().indexOf("ZZX") != -1) {
            if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("ZZX-ZA")) {
                view.setViewName("/coninsweb/insurance/zzx/product/zzx_za_product_info");
            } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("ZZX-PAC")) {
                view.setViewName("/coninsweb/insurance/zzx/product/zzx_pac_product_info");
            } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("ZZX-YA")) {
                view.setViewName("/coninsweb/insurance/zzx/product/zzx_ya_product_info");
            } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("ZZX-CA")) {
                view.setViewName("/coninsweb/insurance/zzx/product/zzx_ca_product_info");
            } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("ZZX-HT")) {
                view.setViewName("/coninsweb/insurance/zzx/product/zzx_ht_product_info");
            }
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().indexOf("GZZRX") != -1) {
            if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("GZZRX-QH")) {
                view.setViewName("/coninsweb/insurance/gzzrx/product/gzzrx_qh_product_info");
            } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("GZZRX-RB")) {
                view.setViewName("/coninsweb/insurance/gzzrx/product/gzzrx_rb_product_info");
            } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("GZZRX-ZH")) {
                view.setViewName("/coninsweb/insurance/gzzrx/product/gzzrx_zh_product_info");
            } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("GZZRX-PAC")) {
                view.setViewName("/coninsweb/insurance/gzzrx/product/gzzrx_pac_product_info");
            } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("GZZRX-XZH")) {
                view.setViewName("/coninsweb/insurance/gzzrx/product/gzzrx_xzh_product_info");
            } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("GZZRX-TB")) {
                view.setViewName("/coninsweb/insurance/gzzrx/product/gzzrx_tb_product_info");
            } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("GZZRX-CA")) {
                if (pd.getProduct_code().contains("GZZRX-CA-DQ")) {
                    view.setViewName("/coninsweb/insurance/gzzrx/product/gzzrx_ca_dq_product_info");
                } else {
                    view.setViewName("/coninsweb/insurance/gzzrx/product/gzzrx_ca_product_info");
                }
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)recommendCode)) {
            UserSupportUtil.setRecommendCode((String)recommendCode);
        }
        UserSupportUtil.setCustomSession((String)"goToUrl", (String)(GlobalResources.WEB_PRO_URL + "/insurance/product/productInfo/" + oid));
        view.addObject("productDto", (Object)pd);
        view.addObject(PRODUCT_ID, (Object)pd.getOid());
        view.addObject("userdetail", (Object)userdetail);
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"/insurance/product/product-info-no-iframe/{oid}"})
    public ModelAndView productInfoByNoIframe(@PathVariable long oid) {
        ModelAndView view = new ModelAndView();
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        ProductVo pd = this.productService.getProduct(oid);
        if (!StringUtils.isNotEmpty((CharSequence)pd.getOid())) {
            return null;
        }
        view.addObject("sharePath", (Object)this.productService.setSharePath(Long.valueOf(oid), userdetail));
        if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("GZX-PAC")) {
            view.setViewName("/coninsweb/api/gzx/product/gzx_pac_product_info");
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("TYX-PAS")) {
            view.setViewName("/coninsweb/api/gmr/product/gmr_pn_product_info");
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("TYX-PAC")) {
            view.setViewName("/coninsweb/api/gmr/product/gmr_pnc_product_info");
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("TYX-TK")) {
            view.setViewName("/coninsweb/api/gmr/product/gmr_tk_product_info");
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("TYX-RB")) {
            view.setViewName("/coninsweb/api/gmr/product/gmr_rb_product_info");
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("TYX-CA")) {
            view.setViewName("/coninsweb/api/gmr/product/gmr_ca_product_info");
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("TYX-QH")) {
            view.setViewName("/coninsweb/api/gmr/product/gmr_qh_product_info");
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("TYX-HT")) {
            view.setViewName("/coninsweb/api/gmr/product/gmr_ht_product_info");
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("GZZRX-RB")) {
            view.setViewName("/coninsweb/api/gzzrx/product/gzzrx_rb_product_info");
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("GZZRX-ZH")) {
            view.setViewName("/coninsweb/api/gzzrx/product/gzzrx_zh_product_info");
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("GZZRX-PAC")) {
            view.setViewName("/coninsweb/api/gzzrx/product/gzzrx_pac_product_info");
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("GZZRX-XZH")) {
            view.setViewName("/coninsweb/api/gzzrx/product/gzzrx_xzh_product_info");
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("GZZRX-TB")) {
            view.setViewName("/coninsweb/api/gzzrx/product/gzzrx_tb_product_info");
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("GZZRX-CA")) {
            if (pd.getProduct_code().contains("GZZRX-CA-DQ")) {
                view.setViewName("/coninsweb/api/gzzrx/product/gzzrx_ca_dq_product_info");
            } else {
                view.setViewName("/coninsweb/api/gzzrx/product/gzzrx_ca_product_info");
            }
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("ZZX-ZA")) {
            view.setViewName("/coninsweb/api/lote/product/zzx_za_product_info");
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("ZZX-PAC")) {
            view.setViewName("/coninsweb/api/lote/product/zzx_pac_product_info");
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("ZZX-YA")) {
            view.setViewName("/coninsweb/api/lote/product/zzx_ya_product_info");
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("ZZX-HT")) {
            view.setViewName("/coninsweb/api/lote/product/zzx_ht_product_info");
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && "BZX-TB-GCTB".equals(pd.getProduct_code())) {
            view.setViewName("/coninsweb/insurance/build/product/build_tb_product_info");
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && "BZX-YG-GCTB".equals(pd.getProduct_code())) {
            view.setViewName("/coninsweb/insurance/build/product/build_yg_product_info");
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && "BZX-DB-GCTB".equals(pd.getProduct_code())) {
            view.setViewName("/coninsweb/insurance/build/product/build_db_product_info");
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && "BZX-GCLY".equals(pd.getProduct_code())) {
            view.setViewName("/coninsweb/insurance/build/product/productInfo_ly");
        }
        view.addObject("productDto", (Object)pd);
        view.addObject("userdetail", (Object)userdetail);
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"/insurance/product/sharePath/{oid}"})
    @ResponseBody
    public String productInfo(@PathVariable long oid) {
        JSONObject data = new JSONObject();
        data.put("ret", (Object)"200");
        data.put("obj", (Object)this.productService.setSharePath(Long.valueOf(oid), UserSupportUtil.getSessionUser()));
        data.put("msg", (Object)"");
        return data.toJSONString();
    }

    @RequestMapping(value={"/insurance/product/toLogin/{oid}"})
    public ModelAndView productInfo(HttpServletRequest request, @PathVariable String oid) {
        return new ModelAndView(Constant.LOGIN_URL_COM);
    }

    @RequestMapping(value={"/insurance/product/gzx-product-all"})
    public ModelAndView gzxProductAll() {
        ModelAndView view = new ModelAndView("/coninsweb/api/product/gzx_product_all");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        String[] codes = new String[]{"GZX-HT", "ZZX-HT", "TYX-HT", "TYX-QH"};
        view.addObject("listVo", this.findProByCodes(codes));
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"/insurance/product/dq-product-all"})
    public ModelAndView dqProductAll() {
        ModelAndView view = new ModelAndView("/coninsweb/api/product/dq_product_all");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        String[] codes = new String[]{"TYX-HT"};
        view.addObject("listVo", this.findProByCodes(codes));
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"/insurance/product/tx-product-all"})
    public ModelAndView txProductAll() {
        ModelAndView view = new ModelAndView("/coninsweb/api/product/tx_product_all");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        String province = "110000";
        if (userdetail != null) {
            String key = "ADDRESS-" + userdetail.getOid();
            province = JedisUtils.get((String)key);
        }
        String pCodes = (String)GlobalResources.map.get("SAAS_PRO_SORT_" + province);
        String[] codes = StringUtils.isNotEmpty((CharSequence)province) && StringUtils.isNotEmpty((CharSequence)pCodes) ? pCodes.split(",") : (StringUtils.isNotEmpty((CharSequence)(pCodes = (String)GlobalResources.map.get("SAAS_PRO_SORT_DEFAULT"))) ? pCodes.split(",") : new String[]{"GZZRX-RB", "TYX-RB", "TYX-PAS", "TYX-PAC", "TYX-TK", "GZZRX-ZH", "GZZRX-CA", "GZZRX-XZH"});
        view.addObject("listVo", this.findProByCodes(codes));
        this.setTokenByApi(view);
        return view;
    }

    private List<ProductVo> findProByCodes(String[] codeArr) {
        ArrayList list = Lists.newArrayList();
        List listVo = null;
        for (String code : codeArr) {
            listVo = this.productService.getProductsByOnLine(code);
            if (listVo == null) continue;
            list.addAll(listVo);
        }
        return list;
    }

    @RequestMapping(value={"/insurance/policy_init_iframe/{oid}"})
    @LoginRequired(methodParamKey={"1#oid"}, redirectUrl="insurance/policy_init_iframe/{oid}")
    public ModelAndView policyInitIframe(@PathVariable long oid) {
        ModelAndView view = new ModelAndView("/coninsweb/api/order/order_init");
        ProductVo pd = this.productService.getProduct(oid);
        String loadUrl = "";
        if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().indexOf("GYX") != -1) {
            loadUrl = "/api/gyx/policyInit/" + oid;
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().indexOf("TYX") != -1) {
            loadUrl = "/api/gmr/policyInit/" + oid;
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().indexOf("GZX-PAC") != -1) {
            loadUrl = "/api/gzx/policyInit/" + oid;
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().indexOf("ZZX") != -1) {
            loadUrl = "/api/lote/policyInit/" + oid;
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().indexOf("GZZRX") != -1) {
            loadUrl = "/api/gzzrx/policyInit/" + oid;
        }
        view.addObject("loadUrl", (Object)loadUrl);
        this.setTokenByApi(view);
        return view;
    }
}

